/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.model;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.w3.cv.ac.CoreBusinessType;
import eu.toop.edm.jaxb.w3.cv.bc.LegalEntityIDType;
import eu.toop.edm.jaxb.w3.cv.bc.LegalEntityLegalIDType;
import eu.toop.edm.jaxb.w3.cv.bc.LegalEntityLegalNameType;
import eu.toop.edm.model.AddressPojo;
import java.io.Serializable;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BusinessPojo {
    private final String m_sLegalID;
    private final String m_sLegalIDSchemeID;
    private final String m_sID;
    private final String m_sIDSchemeID;
    private final String m_sLegalName;
    private final AddressPojo m_aAddress;

    public BusinessPojo(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable AddressPojo addressPojo) {
        this.m_sLegalID = string;
        this.m_sLegalIDSchemeID = string2;
        this.m_sID = string3;
        this.m_sIDSchemeID = string4;
        this.m_sLegalName = string5;
        this.m_aAddress = addressPojo;
    }

    @Nullable
    public final String getLegalID() {
        return this.m_sLegalID;
    }

    @Nullable
    public final String getLegalIDSchemeID() {
        return this.m_sLegalIDSchemeID;
    }

    @Nullable
    public final String getID() {
        return this.m_sID;
    }

    @Nullable
    public final String getIDSchemeID() {
        return this.m_sIDSchemeID;
    }

    @Nullable
    public final String getLegalName() {
        return this.m_sLegalName;
    }

    @Nullable
    public final AddressPojo getAddress() {
        return this.m_aAddress;
    }

    @Nonnull
    public CoreBusinessType getAsCoreBusiness() {
        Serializable serializable;
        CoreBusinessType coreBusinessType = new CoreBusinessType();
        if (StringHelper.hasText((String)this.m_sLegalID)) {
            serializable = new LegalEntityLegalIDType();
            serializable.setValue(this.m_sLegalID);
            serializable.setSchemeID(this.m_sLegalIDSchemeID);
            coreBusinessType.addLegalEntityLegalID((LegalEntityLegalIDType)serializable);
        }
        if (StringHelper.hasText((String)this.m_sID)) {
            serializable = new LegalEntityIDType();
            serializable.setValue(this.m_sID);
            serializable.setSchemeID(this.m_sIDSchemeID);
            coreBusinessType.addLegalEntityID((LegalEntityIDType)serializable);
        }
        if (StringHelper.hasText((String)this.m_sLegalName)) {
            serializable = new LegalEntityLegalNameType();
            serializable.setValue(this.m_sLegalName);
            coreBusinessType.addLegalEntityLegalName((LegalEntityLegalNameType)serializable);
        }
        if (this.m_aAddress != null) {
            coreBusinessType.setLegalEntityCoreAddress(this.m_aAddress.getAsCoreAddress());
        }
        return coreBusinessType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BusinessPojo businessPojo = (BusinessPojo)object;
        return EqualsHelper.equals((Object)this.m_sLegalID, (Object)businessPojo.m_sLegalID) && EqualsHelper.equals((Object)this.m_sLegalIDSchemeID, (Object)businessPojo.m_sLegalIDSchemeID) && EqualsHelper.equals((Object)this.m_sID, (Object)businessPojo.m_sID) && EqualsHelper.equals((Object)this.m_sIDSchemeID, (Object)businessPojo.m_sIDSchemeID) && EqualsHelper.equals((Object)this.m_sLegalName, (Object)businessPojo.m_sLegalName) && EqualsHelper.equals((Object)this.m_aAddress, (Object)businessPojo.m_aAddress);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sLegalID).append((Object)this.m_sLegalIDSchemeID).append((Object)this.m_sID).append((Object)this.m_sIDSchemeID).append((Object)this.m_sLegalName).append((Object)this.m_aAddress).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("LegalID", (Object)this.m_sLegalID).append("LegalIDSchemeID", (Object)this.m_sLegalIDSchemeID).append("sID", (Object)this.m_sID).append("IDSchemeID", (Object)this.m_sIDSchemeID).append("LegalName", (Object)this.m_sLegalName).append("Address", (Object)this.m_aAddress).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable CoreBusinessType coreBusinessType) {
        Builder builder = new Builder();
        if (coreBusinessType != null) {
            if (coreBusinessType.hasLegalEntityLegalIDEntries()) {
                builder.legalID(coreBusinessType.getLegalEntityLegalIDAtIndex(0).getValue()).legalIDSchemeID(coreBusinessType.getLegalEntityLegalIDAtIndex(0).getSchemeID());
            }
            if (coreBusinessType.hasLegalEntityIDEntries()) {
                builder.id(coreBusinessType.getLegalEntityIDAtIndex(0).getValue()).idSchemeID(coreBusinessType.getLegalEntityIDAtIndex(0).getSchemeID());
            }
            if (coreBusinessType.hasLegalEntityLegalNameEntries()) {
                builder.legalName(coreBusinessType.getLegalEntityLegalNameAtIndex(0).getValue());
            }
            if (coreBusinessType.getLegalEntityCoreAddress() != null) {
                builder.address(AddressPojo.builder(coreBusinessType.getLegalEntityCoreAddress()));
            }
        }
        return builder;
    }

    public static class Builder {
        private String m_sLegalID;
        private String m_sLegalIDSchemeID;
        private String m_sID;
        private String m_sIDSchemeID;
        private String m_sLegalName;
        private AddressPojo m_aAddress;

        @Nonnull
        public Builder legalID(@Nullable String string) {
            this.m_sLegalID = string;
            return this;
        }

        @Nonnull
        public Builder legalIDSchemeID(@Nullable String string) {
            this.m_sLegalIDSchemeID = string;
            return this;
        }

        @Nonnull
        public Builder id(@Nullable String string) {
            this.m_sID = string;
            return this;
        }

        @Nonnull
        public Builder idSchemeID(@Nullable String string) {
            this.m_sIDSchemeID = string;
            return this;
        }

        @Nonnull
        public Builder legalName(@Nullable String string) {
            this.m_sLegalName = string;
            return this;
        }

        @Nonnull
        public Builder address(@Nullable Consumer<? super AddressPojo.Builder> consumer) {
            if (consumer != null) {
                AddressPojo.Builder builder = AddressPojo.builder();
                consumer.accept(builder);
                this.address(builder);
            }
            return this;
        }

        @Nonnull
        public Builder address(@Nullable AddressPojo.Builder builder) {
            return this.address(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder address(@Nullable AddressPojo addressPojo) {
            this.m_aAddress = addressPojo;
            return this;
        }

        @Nonnull
        public BusinessPojo build() {
            return new BusinessPojo(this.m_sLegalID, this.m_sLegalIDSchemeID, this.m_sID, this.m_sIDSchemeID, this.m_sLegalName, this.m_aAddress);
        }
    }
}

