/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.model;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.math.MathHelper;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cv.cbc.AmountType;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AmountPojo {
    private final BigDecimal m_aValue;
    private final String m_sCurrencyID;

    public AmountPojo(@Nullable BigDecimal bigDecimal, @Nullable String string) {
        this.m_aValue = bigDecimal;
        this.m_sCurrencyID = string;
    }

    @Nullable
    public final BigDecimal getValue() {
        return this.m_aValue;
    }

    @Nullable
    public final String getCurrencyID() {
        return this.m_sCurrencyID;
    }

    @Nonnull
    public AmountType getAsAmount() {
        AmountType amountType = new AmountType();
        amountType.setValue(this.m_aValue);
        amountType.setCurrencyID(this.m_sCurrencyID);
        return amountType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AmountPojo amountPojo = (AmountPojo)object;
        return EqualsHelper.equals((Object)this.m_aValue, (Object)amountPojo.m_aValue) && EqualsHelper.equals((Object)this.m_sCurrencyID, (Object)amountPojo.m_sCurrencyID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aValue).append((Object)this.m_sCurrencyID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Value", (Object)this.m_aValue).append("CurrencyID", (Object)this.m_sCurrencyID).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable AmountType amountType) {
        Builder builder = new Builder();
        if (amountType != null) {
            builder.value(amountType.getValue()).currency(amountType.getCurrencyID());
        }
        return builder;
    }

    public static class Builder {
        private BigDecimal m_aValue;
        private String m_sCurrencyID;

        @Nonnull
        public Builder value(@Nonnull long l) {
            return this.value(MathHelper.toBigDecimal((long)l));
        }

        @Nonnull
        public Builder value(@Nonnull double d) {
            return this.value(MathHelper.toBigDecimal((double)d));
        }

        @Nonnull
        public Builder value(@Nullable BigDecimal bigDecimal) {
            this.m_aValue = bigDecimal;
            return this;
        }

        @Nonnull
        public Builder currency(@Nullable String string) {
            this.m_sCurrencyID = string;
            return this;
        }

        @Nonnull
        public AmountPojo build() {
            return new AmountPojo(this.m_aValue, this.m_sCurrencyID);
        }
    }
}

