/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.error;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.util.PDTXMLConverter;
import eu.toop.edm.error.EEDMExceptionType;
import eu.toop.edm.error.EToopErrorOrigin;
import eu.toop.edm.error.EToopErrorSeverity;
import eu.toop.edm.error.IToopErrorCode;
import eu.toop.edm.slot.SlotErrorOrigin;
import eu.toop.edm.slot.SlotTimestamp;
import eu.toop.regrep.rim.DateTimeValueType;
import eu.toop.regrep.rim.SlotType;
import eu.toop.regrep.rim.StringValueType;
import eu.toop.regrep.rim.ValueType;
import eu.toop.regrep.rs.RegistryExceptionType;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.datatype.XMLGregorianCalendar;

public class EDMExceptionPojo {
    private final EEDMExceptionType m_eExceptionType;
    private final EToopErrorSeverity m_eSeverity;
    private final String m_sErrorMessage;
    private final String m_sErrorDetail;
    private final String m_sErrorCode;
    private final LocalDateTime m_aTimestamp;
    private final String m_sErrorOrigin;

    protected EDMExceptionPojo(@Nonnull EEDMExceptionType eEDMExceptionType, @Nonnull EToopErrorSeverity eToopErrorSeverity, @Nonnull String string, @Nullable String string2, @Nullable String string3, @Nonnull LocalDateTime localDateTime, @Nullable String string4) {
        ValueEnforcer.notNull((Object)((Object)eEDMExceptionType), (String)"ExceptionType");
        ValueEnforcer.notNull((Object)((Object)eToopErrorSeverity), (String)"Severity");
        ValueEnforcer.notNull((Object)string, (String)"ErrorMessage");
        ValueEnforcer.notNull((Object)localDateTime, (String)"Timestamp");
        this.m_eExceptionType = eEDMExceptionType;
        this.m_eSeverity = eToopErrorSeverity;
        this.m_sErrorMessage = string;
        this.m_sErrorDetail = string2;
        this.m_sErrorCode = string3;
        this.m_aTimestamp = localDateTime;
        this.m_sErrorOrigin = string4;
    }

    @Nonnull
    public final EEDMExceptionType getExceptionType() {
        return this.m_eExceptionType;
    }

    @Nonnull
    public final EToopErrorSeverity getSeverity() {
        return this.m_eSeverity;
    }

    @Nonnull
    public final String getErrorMessage() {
        return this.m_sErrorMessage;
    }

    @Nullable
    public final String getErrorDetails() {
        return this.m_sErrorDetail;
    }

    @Nullable
    public final String getErrorCode() {
        return this.m_sErrorCode;
    }

    @Nonnull
    public final LocalDateTime getTimestamp() {
        return this.m_aTimestamp;
    }

    @Nullable
    public final String getErrorOrigin() {
        return this.m_sErrorOrigin;
    }

    @Nonnull
    public RegistryExceptionType getAsRegistryException() {
        RegistryExceptionType registryExceptionType = this.m_eExceptionType.invoke();
        registryExceptionType.setSeverity(this.m_eSeverity.getID());
        registryExceptionType.setMessage(this.m_sErrorMessage);
        registryExceptionType.setDetail(this.m_sErrorDetail);
        registryExceptionType.setCode(this.m_sErrorCode);
        if (this.m_aTimestamp != null) {
            registryExceptionType.addSlot(new SlotTimestamp(this.m_aTimestamp).createSlot());
        }
        if (StringHelper.hasText((String)this.m_sErrorOrigin)) {
            registryExceptionType.addSlot(new SlotErrorOrigin(this.m_sErrorOrigin).createSlot());
        }
        return registryExceptionType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EDMExceptionPojo eDMExceptionPojo = (EDMExceptionPojo)object;
        return EqualsHelper.equals((Object)((Object)this.m_eExceptionType), (Object)((Object)eDMExceptionPojo.m_eExceptionType)) && EqualsHelper.equals((Object)((Object)this.m_eSeverity), (Object)((Object)eDMExceptionPojo.m_eSeverity)) && EqualsHelper.equals((Object)this.m_sErrorMessage, (Object)eDMExceptionPojo.m_sErrorMessage) && EqualsHelper.equals((Object)this.m_sErrorDetail, (Object)eDMExceptionPojo.m_sErrorDetail) && EqualsHelper.equals((Object)this.m_sErrorCode, (Object)eDMExceptionPojo.m_sErrorCode) && EqualsHelper.equals((Object)this.m_aTimestamp, (Object)eDMExceptionPojo.m_aTimestamp) && EqualsHelper.equals((Object)this.m_sErrorOrigin, (Object)eDMExceptionPojo.m_sErrorOrigin);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eExceptionType).append((Enum)this.m_eSeverity).append((Object)this.m_sErrorMessage).append((Object)this.m_sErrorDetail).append((Object)this.m_sErrorCode).append((Object)this.m_aTimestamp).append((Object)this.m_sErrorOrigin).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ExceptionType", (Enum)this.m_eExceptionType).append("Severity", (Enum)this.m_eSeverity).append("ErrorMessage", (Object)this.m_sErrorMessage).append("ErrorDetail", (Object)this.m_sErrorDetail).append("ErrorCode", (Object)this.m_sErrorCode).append("Timestamp", (Object)this.m_aTimestamp).append("ErrorOrigin", (Object)this.m_sErrorOrigin).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static void _applySlots(@Nonnull SlotType slotType, @Nonnull Builder builder) {
        String string = slotType.getName();
        ValueType valueType = slotType.getSlotValue();
        switch (string) {
            case "Timestamp": {
                if (!(valueType instanceof DateTimeValueType)) break;
                XMLGregorianCalendar xMLGregorianCalendar = ((DateTimeValueType)valueType).getValue();
                builder.timestamp(xMLGregorianCalendar);
                break;
            }
            case "ErrorOrigin": {
                if (!(valueType instanceof StringValueType)) break;
                String string2 = ((StringValueType)valueType).getValue();
                builder.errorOrigin(string2);
                break;
            }
            default: {
                throw new IllegalStateException("Found unsupported slot '" + string + "'");
            }
        }
    }

    @Nonnull
    public static Builder builder(@Nullable RegistryExceptionType registryExceptionType) {
        Builder builder = new Builder();
        if (registryExceptionType != null) {
            builder.exceptionType(registryExceptionType.getClass()).severity(EToopErrorSeverity.getFromIDOrNull(registryExceptionType.getSeverity())).errorMessage(registryExceptionType.getMessage()).errorDetail(registryExceptionType.getDetail()).errorCode(registryExceptionType.getCode());
            for (SlotType slotType : registryExceptionType.getSlot()) {
                EDMExceptionPojo._applySlots(slotType, builder);
            }
        }
        return builder;
    }

    public static class Builder {
        private EEDMExceptionType m_eExceptionType;
        private EToopErrorSeverity m_eSeverity;
        private String m_sErrorMessage;
        private String m_sErrorDetail;
        private String m_sErrorCode;
        private LocalDateTime m_aTimestamp;
        private String m_sErrorOrigin;

        protected Builder() {
        }

        @Nonnull
        public Builder exceptionType(@Nullable Class<? extends RegistryExceptionType> clazz) {
            return this.exceptionType(clazz == null ? null : EEDMExceptionType.getFromClassOrNull(clazz));
        }

        @Nonnull
        public Builder exceptionType(@Nullable EEDMExceptionType eEDMExceptionType) {
            this.m_eExceptionType = eEDMExceptionType;
            return this;
        }

        @Nonnull
        public Builder severityFailure() {
            return this.severity(EToopErrorSeverity.FAILURE);
        }

        @Nonnull
        public Builder severity(@Nullable EToopErrorSeverity eToopErrorSeverity) {
            this.m_eSeverity = eToopErrorSeverity;
            return this;
        }

        @Nonnull
        public Builder errorMessage(@Nullable String string) {
            this.m_sErrorMessage = string;
            return this;
        }

        @Nonnull
        public Builder errorDetail(@Nullable String string) {
            this.m_sErrorDetail = string;
            return this;
        }

        @Nonnull
        public Builder errorCode(@Nullable IToopErrorCode iToopErrorCode) {
            return this.errorCode(iToopErrorCode == null ? null : (String)iToopErrorCode.getID());
        }

        @Nonnull
        public Builder errorCode(@Nullable String string) {
            this.m_sErrorCode = string;
            return this;
        }

        @Nonnull
        public Builder timestampNow() {
            return this.timestamp(PDTFactory.getCurrentLocalDateTime());
        }

        @Nonnull
        public Builder timestamp(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.timestamp(PDTXMLConverter.getLocalDateTime((XMLGregorianCalendar)xMLGregorianCalendar));
        }

        @Nonnull
        public Builder timestamp(@Nullable LocalDateTime localDateTime) {
            this.m_aTimestamp = localDateTime == null ? null : localDateTime.truncatedTo(ChronoUnit.MILLIS);
            return this;
        }

        @Nonnull
        public Builder errorOrigin(@Nullable EToopErrorOrigin eToopErrorOrigin) {
            return this.errorOrigin(eToopErrorOrigin == null ? null : eToopErrorOrigin.getID());
        }

        @Nonnull
        public Builder errorOrigin(@Nullable String string) {
            this.m_sErrorOrigin = string;
            return this;
        }

        public void checkConsistency() {
            if (this.m_eExceptionType == null) {
                throw new IllegalStateException("Exception Type must be provided");
            }
            if (this.m_eSeverity == null) {
                throw new IllegalStateException("Error Severity must be provided");
            }
            if (StringHelper.hasNoText((String)this.m_sErrorMessage)) {
                throw new IllegalStateException("Error Message must be provided");
            }
            if (this.m_aTimestamp == null) {
                throw new IllegalStateException("Timestamp must be provided");
            }
        }

        @Nonnull
        public EDMExceptionPojo build() {
            this.checkConsistency();
            return new EDMExceptionPojo(this.m_eExceptionType, this.m_eSeverity, this.m_sErrorMessage, this.m_sErrorDetail, this.m_sErrorCode, this.m_aTimestamp, this.m_sErrorOrigin);
        }
    }
}

