/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.datetime.util.PDTXMLConverter;
import com.helger.jaxb.IJAXBReader;
import com.helger.jaxb.IJAXBWriter;
import eu.toop.edm.IEDMTopLevelObject;
import eu.toop.edm.jaxb.cccev.CCCEVConceptType;
import eu.toop.edm.jaxb.cccev.CCCEVRequirementType;
import eu.toop.edm.jaxb.cv.agent.AgentType;
import eu.toop.edm.jaxb.dcatap.DCatAPDistributionType;
import eu.toop.edm.jaxb.w3.cv.ac.CoreBusinessType;
import eu.toop.edm.jaxb.w3.cv.ac.CorePersonType;
import eu.toop.edm.model.AgentPojo;
import eu.toop.edm.model.BusinessPojo;
import eu.toop.edm.model.ConceptPojo;
import eu.toop.edm.model.DistributionPojo;
import eu.toop.edm.model.EQueryDefinitionType;
import eu.toop.edm.model.EResponseOptionType;
import eu.toop.edm.model.PersonPojo;
import eu.toop.edm.request.EDMRequestPayloadConcepts;
import eu.toop.edm.request.EDMRequestPayloadDistribution;
import eu.toop.edm.request.EDMRequestPayloadDocumentID;
import eu.toop.edm.request.IEDMRequestPayloadProvider;
import eu.toop.edm.slot.SlotAuthorizedRepresentative;
import eu.toop.edm.slot.SlotConsentToken;
import eu.toop.edm.slot.SlotDataConsumer;
import eu.toop.edm.slot.SlotDataSubjectLegalPerson;
import eu.toop.edm.slot.SlotDataSubjectNaturalPerson;
import eu.toop.edm.slot.SlotDatasetIdentifier;
import eu.toop.edm.slot.SlotFullfillingRequirements;
import eu.toop.edm.slot.SlotIssueDateTime;
import eu.toop.edm.slot.SlotProcedure;
import eu.toop.edm.slot.SlotSpecificationIdentifier;
import eu.toop.edm.xml.IJAXBVersatileReader;
import eu.toop.edm.xml.IVersatileWriter;
import eu.toop.edm.xml.JAXBVersatileReader;
import eu.toop.edm.xml.JAXBVersatileWriter;
import eu.toop.edm.xml.cagv.AgentMarshaller;
import eu.toop.edm.xml.cagv.CCAGV;
import eu.toop.edm.xml.cccev.ConceptMarshaller;
import eu.toop.edm.xml.cccev.RequirementMarshaller;
import eu.toop.edm.xml.cv.BusinessMarshaller;
import eu.toop.edm.xml.cv.PersonMarshaller;
import eu.toop.edm.xml.dcatap.DistributionMarshaller;
import eu.toop.regrep.RegRep4Reader;
import eu.toop.regrep.RegRep4Writer;
import eu.toop.regrep.RegRepHelper;
import eu.toop.regrep.query.QueryRequest;
import eu.toop.regrep.rim.AnyValueType;
import eu.toop.regrep.rim.CollectionValueType;
import eu.toop.regrep.rim.DateTimeValueType;
import eu.toop.regrep.rim.InternationalStringType;
import eu.toop.regrep.rim.InternationalStringValueType;
import eu.toop.regrep.rim.LocalizedStringType;
import eu.toop.regrep.rim.QueryType;
import eu.toop.regrep.rim.SlotType;
import eu.toop.regrep.rim.StringValueType;
import eu.toop.regrep.rim.ValueType;
import eu.toop.regrep.slot.ISlotProvider;
import eu.toop.regrep.slot.SlotHelper;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.Node;

public class EDMRequest
implements IEDMTopLevelObject {
    private static final ICommonsOrderedSet<String> TOP_LEVEL_SLOTS = new CommonsLinkedHashSet((Object[])new String[]{"SpecificationIdentifier", "IssueDateTime", "Procedure", "FullfillingRequirement", "ConsentToken", "DatasetIdentifier", "DataConsumer"});
    private final EQueryDefinitionType m_eQueryDefinition;
    private final String m_sRequestID;
    private final EResponseOptionType m_eResponseOption;
    private final String m_sSpecificationIdentifier;
    private final LocalDateTime m_aIssueDateTime;
    private final InternationalStringType m_aProcedure;
    private final ICommonsList<CCCEVRequirementType> m_aFullfillingRequirements = new CommonsArrayList();
    private final AgentPojo m_aDataConsumer;
    private final String m_sConsentToken;
    private final String m_sDatasetIdentifier;
    private final BusinessPojo m_aDataSubjectLegalPerson;
    private final PersonPojo m_aDataSubjectNaturalPerson;
    private final PersonPojo m_aAuthorizedRepresentative;
    private final IEDMRequestPayloadProvider m_aPayloadProvider;

    protected EDMRequest(@Nonnull EQueryDefinitionType eQueryDefinitionType, @Nonnull @Nonempty String string, @Nonnull EResponseOptionType eResponseOptionType, @Nonnull @Nonempty String string2, @Nonnull LocalDateTime localDateTime, @Nullable InternationalStringType internationalStringType, @Nullable ICommonsList<CCCEVRequirementType> iCommonsList, @Nonnull AgentPojo agentPojo, @Nullable String string3, @Nullable String string4, @Nullable BusinessPojo businessPojo, @Nullable PersonPojo personPojo, @Nullable PersonPojo personPojo2, @Nonnull IEDMRequestPayloadProvider iEDMRequestPayloadProvider) {
        ValueEnforcer.notNull((Object)((Object)eQueryDefinitionType), (String)"QueryDefinition");
        ValueEnforcer.notNull((Object)((Object)eResponseOptionType), (String)"ResponseOption");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"RequestID");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"SpecificationIdentifier");
        ValueEnforcer.notNull((Object)localDateTime, (String)"IssueDateTime");
        ValueEnforcer.noNullValue(iCommonsList, (String)"FullfillingRequirements");
        ValueEnforcer.notNull((Object)agentPojo, (String)"DataConsumer");
        ValueEnforcer.isFalse((businessPojo == null && personPojo == null || businessPojo != null && personPojo != null ? 1 : 0) != 0, (String)"Exactly one DataSubject must be set");
        ValueEnforcer.notNull((Object)iEDMRequestPayloadProvider, (String)"RequestPayloadProvider");
        this.m_eQueryDefinition = eQueryDefinitionType;
        this.m_sRequestID = string;
        this.m_eResponseOption = eResponseOptionType;
        this.m_sSpecificationIdentifier = string2;
        this.m_aIssueDateTime = localDateTime;
        this.m_aProcedure = internationalStringType;
        if (iCommonsList != null) {
            this.m_aFullfillingRequirements.addAll(iCommonsList);
        }
        this.m_aDataConsumer = agentPojo;
        this.m_sConsentToken = string3;
        this.m_sDatasetIdentifier = string4;
        this.m_aDataSubjectLegalPerson = businessPojo;
        this.m_aDataSubjectNaturalPerson = personPojo;
        this.m_aAuthorizedRepresentative = personPojo2;
        this.m_aPayloadProvider = iEDMRequestPayloadProvider;
    }

    @Nonnull
    public final EQueryDefinitionType getQueryDefinition() {
        return this.m_eQueryDefinition;
    }

    @Nonnull
    @Nonempty
    public final String getRequestID() {
        return this.m_sRequestID;
    }

    @Nonnull
    public final EResponseOptionType getResponseOption() {
        return this.m_eResponseOption;
    }

    @Nonnull
    @Nonempty
    public final String getSpecificationIdentifier() {
        return this.m_sSpecificationIdentifier;
    }

    @Nonnull
    public final LocalDateTime getIssueDateTime() {
        return this.m_aIssueDateTime;
    }

    @Nullable
    public final InternationalStringType getProcedure() {
        return this.m_aProcedure;
    }

    @Nonnull
    @ReturnsMutableObject
    public final List<CCCEVRequirementType> fullfillingRequirements() {
        return this.m_aFullfillingRequirements;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final List<CCCEVRequirementType> getAllFullfillingRequirements() {
        return (List)this.m_aFullfillingRequirements.getClone();
    }

    @Nonnull
    public final AgentPojo getDataConsumer() {
        return this.m_aDataConsumer;
    }

    @Nullable
    public final String getConsentToken() {
        return this.m_sConsentToken;
    }

    @Nullable
    public final String getDatasetIdentifier() {
        return this.m_sDatasetIdentifier;
    }

    @Nullable
    public final BusinessPojo getDataSubjectLegalPerson() {
        return this.m_aDataSubjectLegalPerson;
    }

    @Nullable
    public final PersonPojo getDataSubjectNaturalPerson() {
        return this.m_aDataSubjectNaturalPerson;
    }

    @Nullable
    public final PersonPojo getAuthorizedRepresentative() {
        return this.m_aAuthorizedRepresentative;
    }

    @Nonnull
    public final IEDMRequestPayloadProvider getPayloadProvider() {
        return this.m_aPayloadProvider;
    }

    @Nonnull
    private QueryRequest _createQueryRequest(@Nonnull ICommonsList<ISlotProvider> iCommonsList) {
        Object object2;
        ValueEnforcer.notNull((Object)((Object)this.m_eQueryDefinition), (String)"QueryDefinition");
        ValueEnforcer.notEmpty((CharSequence)this.m_sRequestID, (String)"RequestID");
        ValueEnforcer.noNullValue(iCommonsList, (String)"Providers");
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Object object2 : iCommonsList) {
            Object object3 = object2.getName();
            if (commonsLinkedHashMap.containsKey(object3)) {
                throw new IllegalArgumentException("A slot provider for name '" + (String)object3 + "' is already present");
            }
            commonsLinkedHashMap.put(object3, object2);
        }
        Iterator iterator = RegRepHelper.createEmptyQueryRequest();
        iterator.setId(this.m_sRequestID);
        iterator.getResponseOption().setReturnType(this.m_eResponseOption.getID());
        for (Object object3 : TOP_LEVEL_SLOTS) {
            Object object4 = (ISlotProvider)commonsLinkedHashMap.get(object3);
            if (object4 == null) continue;
            iterator.addSlot(object4.createSlot());
        }
        object2 = new QueryType();
        object2.setQueryDefinition(this.m_eQueryDefinition.getID());
        for (Object object4 : commonsLinkedHashMap.entrySet()) {
            if (TOP_LEVEL_SLOTS.contains(object4.getKey())) continue;
            object2.addSlot(((ISlotProvider)object4.getValue()).createSlot());
        }
        iterator.setQuery((QueryType)object2);
        return iterator;
    }

    @Nonnull
    public QueryRequest getAsQueryRequest() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (this.m_sSpecificationIdentifier != null) {
            commonsArrayList.add((Object)new SlotSpecificationIdentifier(this.m_sSpecificationIdentifier));
        }
        if (this.m_aIssueDateTime != null) {
            commonsArrayList.add((Object)new SlotIssueDateTime(this.m_aIssueDateTime));
        }
        if (this.m_aProcedure != null) {
            commonsArrayList.add((Object)new SlotProcedure(this.m_aProcedure));
        }
        if (this.m_aFullfillingRequirements.isNotEmpty()) {
            commonsArrayList.add((Object)new SlotFullfillingRequirements((List<CCCEVRequirementType>)this.m_aFullfillingRequirements));
        }
        if (this.m_sConsentToken != null) {
            commonsArrayList.add((Object)new SlotConsentToken(this.m_sConsentToken));
        }
        if (this.m_sDatasetIdentifier != null) {
            commonsArrayList.add((Object)new SlotDatasetIdentifier(this.m_sDatasetIdentifier));
        }
        if (this.m_aDataConsumer != null) {
            commonsArrayList.add((Object)new SlotDataConsumer(this.m_aDataConsumer));
        }
        if (this.m_aDataSubjectLegalPerson != null) {
            commonsArrayList.add((Object)new SlotDataSubjectLegalPerson(this.m_aDataSubjectLegalPerson));
        }
        if (this.m_aDataSubjectNaturalPerson != null) {
            commonsArrayList.add((Object)new SlotDataSubjectNaturalPerson(this.m_aDataSubjectNaturalPerson));
        }
        if (this.m_aAuthorizedRepresentative != null) {
            commonsArrayList.add((Object)new SlotAuthorizedRepresentative(this.m_aAuthorizedRepresentative));
        }
        commonsArrayList.add((Object)this.m_aPayloadProvider.getAsSlotProvider());
        return this._createQueryRequest((ICommonsList<ISlotProvider>)commonsArrayList);
    }

    @Nonnull
    public IVersatileWriter<QueryRequest> getWriter() {
        return new JAXBVersatileWriter<QueryRequest>(this.getAsQueryRequest(), (IJAXBWriter<QueryRequest>)RegRep4Writer.queryRequest(CCAGV.XSDS).setFormattedOutput(true));
    }

    @Nonnull
    public static IJAXBVersatileReader<EDMRequest> reader() {
        return new JAXBVersatileReader<QueryRequest, EDMRequest>((IJAXBReader<QueryRequest>)RegRep4Reader.queryRequest(CCAGV.XSDS), EDMRequest::create);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EDMRequest eDMRequest = (EDMRequest)object;
        return EqualsHelper.equals((Object)((Object)this.m_eQueryDefinition), (Object)((Object)eDMRequest.m_eQueryDefinition)) && EqualsHelper.equals((Object)((Object)this.m_eResponseOption), (Object)((Object)eDMRequest.m_eResponseOption)) && EqualsHelper.equals((Object)this.m_sRequestID, (Object)eDMRequest.m_sRequestID) && EqualsHelper.equals((Object)this.m_sSpecificationIdentifier, (Object)eDMRequest.m_sSpecificationIdentifier) && EqualsHelper.equals((Object)this.m_aIssueDateTime, (Object)eDMRequest.m_aIssueDateTime) && EqualsHelper.equals((Object)this.m_aProcedure, (Object)eDMRequest.m_aProcedure) && EqualsHelper.equals(this.m_aFullfillingRequirements, eDMRequest.m_aFullfillingRequirements) && EqualsHelper.equals((Object)this.m_aDataConsumer, (Object)eDMRequest.m_aDataConsumer) && EqualsHelper.equals((Object)this.m_sConsentToken, (Object)eDMRequest.m_sConsentToken) && EqualsHelper.equals((Object)this.m_sDatasetIdentifier, (Object)eDMRequest.m_sDatasetIdentifier) && EqualsHelper.equals((Object)this.m_aDataSubjectLegalPerson, (Object)eDMRequest.m_aDataSubjectLegalPerson) && EqualsHelper.equals((Object)this.m_aDataSubjectNaturalPerson, (Object)eDMRequest.m_aDataSubjectNaturalPerson) && EqualsHelper.equals((Object)this.m_aAuthorizedRepresentative, (Object)eDMRequest.m_aAuthorizedRepresentative) && EqualsHelper.equals((Object)this.m_aPayloadProvider, (Object)eDMRequest.m_aPayloadProvider);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eQueryDefinition).append((Enum)this.m_eResponseOption).append((Object)this.m_sRequestID).append((Object)this.m_sSpecificationIdentifier).append((Object)this.m_aIssueDateTime).append((Object)this.m_aProcedure).append(this.m_aFullfillingRequirements).append((Object)this.m_aDataConsumer).append((Object)this.m_sConsentToken).append((Object)this.m_sDatasetIdentifier).append((Object)this.m_aDataSubjectLegalPerson).append((Object)this.m_aDataSubjectNaturalPerson).append((Object)this.m_aAuthorizedRepresentative).append((Object)this.m_aPayloadProvider).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("QueryDefinition", (Enum)this.m_eQueryDefinition).append("ResponseOption", (Enum)this.m_eResponseOption).append("RequestID", (Object)this.m_sRequestID).append("SpecificationIdentifier", (Object)this.m_sSpecificationIdentifier).append("IssueDateTime", (Object)this.m_aIssueDateTime).append("Procedure", (Object)this.m_aProcedure).append("FullfillingRequirements", this.m_aFullfillingRequirements).append("DataConsumer", (Object)this.m_aDataConsumer).append("ConsentToken", (Object)this.m_sConsentToken).append("DatasetIdentifier", (Object)this.m_sDatasetIdentifier).append("DataSubjectLegalPerson", (Object)this.m_aDataSubjectLegalPerson).append("DataSubjectNaturalPerson", (Object)this.m_aDataSubjectNaturalPerson).append("AuthorizedRepresentative", (Object)this.m_aAuthorizedRepresentative).append("RequestPayloadProvider", (Object)this.m_aPayloadProvider).getToString();
    }

    @Nonnull
    public static BuilderConcept builderConcept() {
        return (BuilderConcept)((BuilderConcept)new BuilderConcept().specificationIdentifier("toop-edm:v2.0")).responseOption(EResponseOptionType.INLINE);
    }

    @Nonnull
    public static BuilderDocumentsByDistribution builderDocumentsByDistribution() {
        return (BuilderDocumentsByDistribution)((BuilderDocumentsByDistribution)new BuilderDocumentsByDistribution().specificationIdentifier("toop-edm:v2.0")).responseOption(EResponseOptionType.INLINE);
    }

    @Nonnull
    public static BuilderDocumentsByDistribution builderDocumentReferencesByDistribution() {
        return (BuilderDocumentsByDistribution)((BuilderDocumentsByDistribution)new BuilderDocumentsByDistribution().specificationIdentifier("toop-edm:v2.0")).responseOption(EResponseOptionType.REFERENCE);
    }

    @Nonnull
    public static BuilderDocumentByID builderDocumentByID() {
        return (BuilderDocumentByID)((BuilderDocumentByID)new BuilderDocumentByID().specificationIdentifier("toop-edm:v2.0")).responseOption(EResponseOptionType.INLINE);
    }

    private static void _applySlots(@Nonnull SlotType slotType, @Nonnull AbstractBuilder<?> abstractBuilder) {
        String string = slotType.getName();
        ValueType valueType = slotType.getSlotValue();
        switch (string) {
            case "SpecificationIdentifier": {
                if (!(valueType instanceof StringValueType)) break;
                String string2 = ((StringValueType)valueType).getValue();
                abstractBuilder.specificationIdentifier(string2);
                break;
            }
            case "IssueDateTime": {
                if (!(valueType instanceof DateTimeValueType)) break;
                XMLGregorianCalendar xMLGregorianCalendar = ((DateTimeValueType)valueType).getValue();
                abstractBuilder.issueDateTime(PDTXMLConverter.getLocalDateTime((XMLGregorianCalendar)xMLGregorianCalendar));
                break;
            }
            case "Procedure": {
                if (!(valueType instanceof InternationalStringValueType)) break;
                InternationalStringType internationalStringType = ((InternationalStringValueType)valueType).getValue();
                abstractBuilder.procedure(internationalStringType);
                break;
            }
            case "FullfillingRequirement": {
                if (!(valueType instanceof CollectionValueType)) break;
                List list = ((CollectionValueType)valueType).getElement();
                for (ValueType valueType2 : list) {
                    Object object;
                    if (!(valueType2 instanceof AnyValueType) || !((object = ((AnyValueType)valueType2).getAny()) instanceof Node)) continue;
                    abstractBuilder.addFullfillingRequirement((CCCEVRequirementType)new RequirementMarshaller().read((Node)object));
                }
                break;
            }
            case "ConsentToken": {
                if (!(valueType instanceof StringValueType)) break;
                String string3 = ((StringValueType)valueType).getValue();
                abstractBuilder.consentToken(string3);
                break;
            }
            case "DatasetIdentifier": {
                if (!(valueType instanceof StringValueType)) break;
                String string4 = ((StringValueType)valueType).getValue();
                abstractBuilder.datasetIdentifier(string4);
                break;
            }
            case "DataConsumer": {
                if (!(valueType instanceof AnyValueType)) break;
                Node node = (Node)((AnyValueType)valueType).getAny();
                abstractBuilder.dataConsumer(AgentPojo.builder((AgentType)new AgentMarshaller().read(node)));
                break;
            }
            case "LegalPerson": {
                if (!(valueType instanceof AnyValueType)) break;
                Node node = (Node)((AnyValueType)valueType).getAny();
                abstractBuilder.dataSubject(BusinessPojo.builder((CoreBusinessType)new BusinessMarshaller().read(node)));
                break;
            }
            case "NaturalPerson": {
                if (!(valueType instanceof AnyValueType)) break;
                Node node = (Node)((AnyValueType)valueType).getAny();
                abstractBuilder.dataSubject(PersonPojo.builder((CorePersonType)new PersonMarshaller().read(node)));
                break;
            }
            case "AuthorizedRepresentative": {
                if (!(valueType instanceof AnyValueType)) break;
                Node node = (Node)((AnyValueType)valueType).getAny();
                abstractBuilder.authorizedRepresentative(PersonPojo.builder((CorePersonType)new PersonMarshaller().read(node)));
                break;
            }
            case "ConceptRequestList": {
                List list;
                if (!(valueType instanceof CollectionValueType) || (list = ((CollectionValueType)valueType).getElement()).isEmpty()) break;
                for (ValueType valueType3 : list) {
                    Object object;
                    if (!(valueType3 instanceof AnyValueType) || !((object = ((AnyValueType)valueType3).getAny()) instanceof Node)) continue;
                    ((BuilderConcept)abstractBuilder).addConcept((CCCEVConceptType)new ConceptMarshaller().read((Node)object));
                }
                break;
            }
            case "DistributionRequestList": {
                List list;
                if (!(valueType instanceof CollectionValueType) || (list = ((CollectionValueType)valueType).getElement()).isEmpty()) break;
                for (ValueType valueType4 : list) {
                    Object object;
                    if (!(valueType4 instanceof AnyValueType) || !((object = ((AnyValueType)valueType4).getAny()) instanceof Node)) continue;
                    ((BuilderDocumentsByDistribution)abstractBuilder).addDistribution((DCatAPDistributionType)new DistributionMarshaller().read((Node)object));
                }
                break;
            }
            case "id": {
                if (!(valueType instanceof StringValueType)) break;
                String string5 = ((StringValueType)valueType).getValue();
                ((BuilderDocumentByID)abstractBuilder).documentID(string5);
                break;
            }
            default: {
                throw new IllegalStateException("Found unsupported slot '" + string + "'");
            }
        }
    }

    @Nonnull
    public static EDMRequest create(@Nonnull QueryRequest queryRequest) {
        SlotType slotType2;
        AbstractBuilder abstractBuilder;
        ValueEnforcer.notNull((Object)queryRequest, (String)"QueryRequest");
        QueryType queryType = queryRequest.getQuery();
        ValueEnforcer.notNull((Object)queryType, (String)"QueryRequest.Query");
        CommonsHashSet commonsHashSet = new CommonsHashSet((Collection)queryType.getSlot(), SlotType::getName);
        if (commonsHashSet.contains((Object)"ConceptRequestList")) {
            abstractBuilder = EDMRequest.builderConcept();
        } else if (commonsHashSet.contains((Object)"DistributionRequestList")) {
            abstractBuilder = EDMRequest.builderDocumentsByDistribution();
        } else if (commonsHashSet.contains((Object)"id")) {
            abstractBuilder = EDMRequest.builderDocumentByID();
        } else {
            throw new IllegalStateException("Cannot read this QueryRequest as a TOOP EDM request");
        }
        abstractBuilder.id(queryRequest.getId());
        for (SlotType slotType2 : queryRequest.getSlot()) {
            EDMRequest._applySlots(slotType2, abstractBuilder);
        }
        for (SlotType slotType2 : queryType.getSlot()) {
            if (slotType2 == null) continue;
            EDMRequest._applySlots(slotType2, abstractBuilder);
        }
        Object object = null;
        slotType2 = queryRequest.getResponseOption();
        if (slotType2 != null && slotType2.getReturnType() != null) {
            object = EResponseOptionType.getFromIDOrNull(slotType2.getReturnType());
        }
        abstractBuilder.responseOption((EResponseOptionType)((Object)(object != null ? object : EResponseOptionType.INLINE)));
        return abstractBuilder.build();
    }

    public static class BuilderDocumentByID
    extends AbstractBuilder<BuilderDocumentByID> {
        private String m_sDocumentID;

        protected BuilderDocumentByID() {
            super(EQueryDefinitionType.DOCUMENT_BY_ID);
        }

        @Nonnull
        public BuilderDocumentByID documentID(@Nullable String string) {
            this.m_sDocumentID = string;
            return this;
        }

        @Override
        public void checkConsistency() {
            super.checkConsistency();
            if (this.m_sDocumentID == null) {
                throw new IllegalStateException("A Query Definition of type 'GetObjectByID' must contain a Document ID");
            }
        }

        @Override
        @Nonnull
        public EDMRequest build() {
            this.checkConsistency();
            return new EDMRequest(this.m_eQueryDefinition, this.m_sRequestID, this.m_eResponseOption, this.m_sSpecificationIdentifier, this.m_aIssueDateTime, this.m_aProcedure, (ICommonsList<CCCEVRequirementType>)this.m_aFullfillingRequirements, this.m_aDataConsumer, this.m_sConsentToken, this.m_sDatasetIdentifier, this.m_aDataSubjectLegalPerson, this.m_aDataSubjectNaturalPerson, this.m_aAuthorizedRepresentative, new EDMRequestPayloadDocumentID(this.m_sDocumentID));
        }
    }

    public static class BuilderDocumentsByDistribution
    extends AbstractBuilder<BuilderDocumentsByDistribution> {
        private final ICommonsList<DistributionPojo> m_aDistributions = new CommonsArrayList();

        protected BuilderDocumentsByDistribution() {
            super(EQueryDefinitionType.DOCUMENT_BY_DISTRIBUTION);
        }

        @Nonnull
        public final BuilderDocumentsByDistribution addDistribution(@Nullable Consumer<? super DistributionPojo.Builder> consumer) {
            if (consumer != null) {
                DistributionPojo.Builder builder = DistributionPojo.builder();
                consumer.accept(builder);
                this.addDistribution(builder.build());
            }
            return this;
        }

        @Nonnull
        public BuilderDocumentsByDistribution addDistribution(@Nullable DCatAPDistributionType dCatAPDistributionType) {
            return this.addDistribution(dCatAPDistributionType == null ? null : DistributionPojo.builder(dCatAPDistributionType));
        }

        @Nonnull
        public BuilderDocumentsByDistribution addDistribution(@Nullable DistributionPojo.Builder builder) {
            return this.addDistribution(builder == null ? null : builder.build());
        }

        @Nonnull
        public BuilderDocumentsByDistribution addDistribution(@Nullable DistributionPojo distributionPojo) {
            if (distributionPojo != null) {
                this.m_aDistributions.add((Object)distributionPojo);
            }
            return this;
        }

        @Nonnull
        public final BuilderDocumentsByDistribution distribution(@Nullable Consumer<? super DistributionPojo.Builder> consumer) {
            if (consumer != null) {
                DistributionPojo.Builder builder = DistributionPojo.builder();
                consumer.accept(builder);
                this.distribution(builder.build());
            }
            return this;
        }

        @Nonnull
        public BuilderDocumentsByDistribution distribution(@Nullable DCatAPDistributionType dCatAPDistributionType) {
            return this.distribution(dCatAPDistributionType == null ? null : DistributionPojo.builder(dCatAPDistributionType));
        }

        @Nonnull
        public BuilderDocumentsByDistribution distribution(@Nullable DistributionPojo.Builder builder) {
            return this.distribution(builder == null ? null : builder.build());
        }

        @Nonnull
        public BuilderDocumentsByDistribution distribution(@Nullable DistributionPojo distributionPojo) {
            if (distributionPojo != null) {
                this.m_aDistributions.set((Object)distributionPojo);
            } else {
                this.m_aDistributions.clear();
            }
            return this;
        }

        @Nonnull
        public BuilderDocumentsByDistribution distributions(DistributionPojo ... distributionPojoArray) {
            this.m_aDistributions.setAll((Object[])distributionPojoArray);
            return this;
        }

        @Nonnull
        public BuilderDocumentsByDistribution distributions(@Nullable Iterable<DistributionPojo> iterable) {
            this.m_aDistributions.setAll(iterable);
            return this;
        }

        @Override
        public void checkConsistency() {
            super.checkConsistency();
            if (this.m_aDistributions.isEmpty()) {
                throw new IllegalStateException("A Query Definition of type 'Document' must contain a Distribution");
            }
        }

        @Override
        @Nonnull
        public EDMRequest build() {
            this.checkConsistency();
            return new EDMRequest(this.m_eQueryDefinition, this.m_sRequestID, this.m_eResponseOption, this.m_sSpecificationIdentifier, this.m_aIssueDateTime, this.m_aProcedure, (ICommonsList<CCCEVRequirementType>)this.m_aFullfillingRequirements, this.m_aDataConsumer, this.m_sConsentToken, this.m_sDatasetIdentifier, this.m_aDataSubjectLegalPerson, this.m_aDataSubjectNaturalPerson, this.m_aAuthorizedRepresentative, new EDMRequestPayloadDistribution(this.m_aDistributions));
        }
    }

    public static class BuilderConcept
    extends AbstractBuilder<BuilderConcept> {
        private final ICommonsList<ConceptPojo> m_aConcepts = new CommonsArrayList();

        protected BuilderConcept() {
            super(EQueryDefinitionType.CONCEPT);
        }

        @Nonnull
        public final BuilderConcept addConcept(@Nullable Consumer<? super ConceptPojo.Builder> consumer) {
            if (consumer != null) {
                ConceptPojo.Builder builder = ConceptPojo.builder();
                consumer.accept(builder);
                this.addConcept(builder.build());
            }
            return this;
        }

        @Nonnull
        public BuilderConcept addConcept(@Nullable CCCEVConceptType cCCEVConceptType) {
            return this.addConcept(cCCEVConceptType == null ? null : ConceptPojo.builder(cCCEVConceptType));
        }

        @Nonnull
        public BuilderConcept addConcept(@Nullable ConceptPojo.Builder builder) {
            return this.addConcept(builder == null ? null : builder.build());
        }

        @Nonnull
        public BuilderConcept addConcept(@Nullable ConceptPojo conceptPojo) {
            if (conceptPojo != null) {
                this.m_aConcepts.add((Object)conceptPojo);
            }
            return this;
        }

        @Nonnull
        public final BuilderConcept concept(@Nullable Consumer<? super ConceptPojo.Builder> consumer) {
            if (consumer != null) {
                ConceptPojo.Builder builder = ConceptPojo.builder();
                consumer.accept(builder);
                this.concept(builder.build());
            }
            return this;
        }

        @Nonnull
        public BuilderConcept concept(@Nullable CCCEVConceptType cCCEVConceptType) {
            return this.concept(cCCEVConceptType == null ? null : ConceptPojo.builder(cCCEVConceptType));
        }

        @Nonnull
        public BuilderConcept concept(@Nullable ConceptPojo.Builder builder) {
            return this.concept(builder == null ? null : builder.build());
        }

        @Nonnull
        public BuilderConcept concept(@Nullable ConceptPojo conceptPojo) {
            if (conceptPojo != null) {
                this.m_aConcepts.set((Object)conceptPojo);
            } else {
                this.m_aConcepts.clear();
            }
            return this;
        }

        @Nonnull
        public BuilderConcept concepts(ConceptPojo ... conceptPojoArray) {
            this.m_aConcepts.setAll((Object[])conceptPojoArray);
            return this;
        }

        @Nonnull
        public BuilderConcept concepts(@Nullable Iterable<ConceptPojo> iterable) {
            this.m_aConcepts.setAll(iterable);
            return this;
        }

        @Override
        public void checkConsistency() {
            super.checkConsistency();
            if (this.m_aConcepts.isEmpty()) {
                throw new IllegalStateException("A Query Definition of type 'Concept' must contain a Concept");
            }
        }

        @Override
        @Nonnull
        public EDMRequest build() {
            this.checkConsistency();
            return new EDMRequest(this.m_eQueryDefinition, this.m_sRequestID, this.m_eResponseOption, this.m_sSpecificationIdentifier, this.m_aIssueDateTime, this.m_aProcedure, (ICommonsList<CCCEVRequirementType>)this.m_aFullfillingRequirements, this.m_aDataConsumer, this.m_sConsentToken, this.m_sDatasetIdentifier, this.m_aDataSubjectLegalPerson, this.m_aDataSubjectNaturalPerson, this.m_aAuthorizedRepresentative, new EDMRequestPayloadConcepts(this.m_aConcepts));
        }
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
    implements IGenericImplTrait<T> {
        protected final EQueryDefinitionType m_eQueryDefinition;
        protected String m_sRequestID;
        protected EResponseOptionType m_eResponseOption;
        protected String m_sSpecificationIdentifier;
        protected LocalDateTime m_aIssueDateTime;
        protected InternationalStringType m_aProcedure;
        protected final ICommonsList<CCCEVRequirementType> m_aFullfillingRequirements = new CommonsArrayList();
        protected AgentPojo m_aDataConsumer;
        protected String m_sConsentToken;
        protected String m_sDatasetIdentifier;
        protected BusinessPojo m_aDataSubjectLegalPerson;
        protected PersonPojo m_aDataSubjectNaturalPerson;
        protected PersonPojo m_aAuthorizedRepresentative;

        protected AbstractBuilder(@Nonnull EQueryDefinitionType eQueryDefinitionType) {
            ValueEnforcer.notNull((Object)((Object)eQueryDefinitionType), (String)"QueryDefinitionType");
            this.m_eQueryDefinition = eQueryDefinitionType;
        }

        @Nonnull
        public final T randomID() {
            return this.id(UUID.randomUUID());
        }

        @Nonnull
        public final T responseOption(@Nullable EResponseOptionType eResponseOptionType) {
            this.m_eResponseOption = eResponseOptionType;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T id(@Nullable UUID uUID) {
            return this.id(uUID == null ? null : uUID.toString());
        }

        @Nonnull
        public final T id(@Nullable String string) {
            this.m_sRequestID = string;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T specificationIdentifier(@Nullable String string) {
            this.m_sSpecificationIdentifier = string;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T issueDateTimeNow() {
            return this.issueDateTime(PDTFactory.getCurrentLocalDateTime());
        }

        @Nonnull
        public final T issueDateTime(@Nullable LocalDateTime localDateTime) {
            this.m_aIssueDateTime = localDateTime == null ? null : localDateTime.truncatedTo(ChronoUnit.MILLIS);
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T procedure(LocalizedStringType ... localizedStringTypeArray) {
            return this.procedure(localizedStringTypeArray == null ? null : SlotHelper.createInternationalStringType((LocalizedStringType[])localizedStringTypeArray));
        }

        @Nonnull
        public final T procedure(@Nonnull Locale locale, @Nonnull String string) {
            return this.procedure(SlotHelper.createLocalizedString((Locale)locale, (String)string));
        }

        @Nonnull
        public final T procedure(@Nullable Map<Locale, String> map) {
            return this.procedure(map == null ? null : SlotHelper.createInternationalStringType(map));
        }

        @Nonnull
        public final T procedure(@Nullable InternationalStringType internationalStringType) {
            this.m_aProcedure = internationalStringType;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T addFullfillingRequirement(@Nullable CCCEVRequirementType cCCEVRequirementType) {
            if (cCCEVRequirementType != null) {
                this.m_aFullfillingRequirements.add((Object)cCCEVRequirementType);
            }
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T fullfillingRequirement(@Nullable CCCEVRequirementType cCCEVRequirementType) {
            if (cCCEVRequirementType != null) {
                this.m_aFullfillingRequirements.set((Object)cCCEVRequirementType);
            } else {
                this.m_aFullfillingRequirements.clear();
            }
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T fullfillingRequirements(CCCEVRequirementType ... cCCEVRequirementTypeArray) {
            this.m_aFullfillingRequirements.setAll((Object[])cCCEVRequirementTypeArray);
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T fullfillingRequirements(@Nullable Iterable<? extends CCCEVRequirementType> iterable) {
            this.m_aFullfillingRequirements.setAll(iterable);
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T consentToken(@Nullable String string) {
            this.m_sConsentToken = string;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T datasetIdentifier(@Nullable String string) {
            this.m_sDatasetIdentifier = string;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T dataConsumer(@Nullable Consumer<? super AgentPojo.Builder> consumer) {
            if (consumer != null) {
                AgentPojo.Builder builder = AgentPojo.builder();
                consumer.accept(builder);
                this.dataConsumer(builder.build());
            }
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T dataConsumer(@Nullable AgentType agentType) {
            return this.dataConsumer(agentType == null ? null : AgentPojo.builder(agentType));
        }

        @Nonnull
        public final T dataConsumer(@Nullable AgentPojo.Builder builder) {
            return this.dataConsumer(builder == null ? null : builder.build());
        }

        @Nonnull
        public final T dataConsumer(@Nullable AgentPojo agentPojo) {
            this.m_aDataConsumer = agentPojo;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T dataSubjectBusiness(@Nullable Consumer<? super BusinessPojo.Builder> consumer) {
            if (consumer != null) {
                BusinessPojo.Builder builder = BusinessPojo.builder();
                consumer.accept(builder);
                this.dataSubject(builder.build());
            }
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T dataSubject(@Nullable CoreBusinessType coreBusinessType) {
            return this.dataSubject(coreBusinessType == null ? null : BusinessPojo.builder(coreBusinessType));
        }

        @Nonnull
        public final T dataSubject(@Nullable BusinessPojo.Builder builder) {
            return this.dataSubject(builder == null ? null : builder.build());
        }

        @Nonnull
        public final T dataSubject(@Nullable BusinessPojo businessPojo) {
            this.m_aDataSubjectLegalPerson = businessPojo;
            this.m_aDataSubjectNaturalPerson = null;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T dataSubjectPerson(@Nullable Consumer<? super PersonPojo.Builder> consumer) {
            if (consumer != null) {
                PersonPojo.Builder builder = PersonPojo.builder();
                consumer.accept(builder);
                this.dataSubject(builder.build());
            }
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T dataSubject(@Nullable CorePersonType corePersonType) {
            return this.dataSubject(corePersonType == null ? null : PersonPojo.builder(corePersonType));
        }

        @Nonnull
        public final T dataSubject(@Nullable PersonPojo.Builder builder) {
            return this.dataSubject(builder == null ? null : builder.build());
        }

        @Nonnull
        public final T dataSubject(@Nullable PersonPojo personPojo) {
            this.m_aDataSubjectLegalPerson = null;
            this.m_aDataSubjectNaturalPerson = personPojo;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T authorizedRepresentative(@Nullable Consumer<? super PersonPojo.Builder> consumer) {
            if (consumer != null) {
                PersonPojo.Builder builder = PersonPojo.builder();
                consumer.accept(builder);
                this.authorizedRepresentative(builder.build());
            }
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T authorizedRepresentative(@Nullable CorePersonType corePersonType) {
            return this.authorizedRepresentative(corePersonType == null ? null : PersonPojo.builder(corePersonType));
        }

        @Nonnull
        public final T authorizedRepresentative(@Nullable PersonPojo.Builder builder) {
            return this.authorizedRepresentative(builder == null ? null : builder.build());
        }

        @Nonnull
        public final T authorizedRepresentative(@Nullable PersonPojo personPojo) {
            this.m_aAuthorizedRepresentative = personPojo;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @OverridingMethodsMustInvokeSuper
        public void checkConsistency() {
            if (this.m_eQueryDefinition == null) {
                throw new IllegalStateException("Query Definition must be present");
            }
            if (StringHelper.hasNoText((String)this.m_sRequestID)) {
                throw new IllegalStateException("ID must be present");
            }
            if (this.m_eResponseOption == null) {
                throw new IllegalStateException("Response Option must be present");
            }
            if (StringHelper.hasNoText((String)this.m_sSpecificationIdentifier)) {
                throw new IllegalStateException("SpecificationIdentifier must be present");
            }
            if (this.m_aIssueDateTime == null) {
                throw new IllegalStateException("Issue Date Time must be present");
            }
            if (this.m_aDataConsumer == null) {
                throw new IllegalStateException("Cata Consumer must be present");
            }
            if (this.m_aDataSubjectLegalPerson == null && this.m_aDataSubjectNaturalPerson == null) {
                throw new IllegalStateException("Data Subject must be present");
            }
            if (this.m_aDataSubjectLegalPerson != null && this.m_aDataSubjectNaturalPerson != null) {
                throw new IllegalStateException("Data Subject MUST be either legal person OR natural person");
            }
        }

        @Nonnull
        public abstract EDMRequest build();
    }
}

