/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.IJAXBReader;
import com.helger.jaxb.IJAXBWriter;
import eu.toop.edm.IEDMTopLevelObject;
import eu.toop.edm.error.EDMExceptionPojo;
import eu.toop.edm.jaxb.cv.agent.AgentType;
import eu.toop.edm.model.AgentPojo;
import eu.toop.edm.slot.SlotErrorProvider;
import eu.toop.edm.slot.SlotSpecificationIdentifier;
import eu.toop.edm.xml.IJAXBVersatileReader;
import eu.toop.edm.xml.IVersatileWriter;
import eu.toop.edm.xml.JAXBVersatileReader;
import eu.toop.edm.xml.JAXBVersatileWriter;
import eu.toop.edm.xml.cagv.AgentMarshaller;
import eu.toop.regrep.ERegRepResponseStatus;
import eu.toop.regrep.RegRep4Reader;
import eu.toop.regrep.RegRep4Writer;
import eu.toop.regrep.RegRepHelper;
import eu.toop.regrep.query.QueryResponse;
import eu.toop.regrep.rim.AnyValueType;
import eu.toop.regrep.rim.SlotType;
import eu.toop.regrep.rim.StringValueType;
import eu.toop.regrep.rim.ValueType;
import eu.toop.regrep.rs.RegistryExceptionType;
import eu.toop.regrep.slot.ISlotProvider;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.Node;

public class EDMErrorResponse
implements IEDMTopLevelObject {
    private static final ICommonsOrderedSet<String> TOP_LEVEL_SLOTS = new CommonsLinkedHashSet((Object[])new String[]{"SpecificationIdentifier", "ErrorProvider"});
    private final ERegRepResponseStatus m_eResponseStatus;
    private final String m_sRequestID;
    private final String m_sSpecificationIdentifier;
    private final AgentType m_aErrorProvider;
    private final ICommonsList<EDMExceptionPojo> m_aExceptions = new CommonsArrayList();

    protected EDMErrorResponse(@Nonnull ERegRepResponseStatus eRegRepResponseStatus, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable AgentType agentType, @Nonnull @Nonempty ICommonsList<EDMExceptionPojo> iCommonsList) {
        ValueEnforcer.notNull((Object)eRegRepResponseStatus, (String)"ResponseStatus");
        ValueEnforcer.isTrue((eRegRepResponseStatus == ERegRepResponseStatus.SUCCESS || eRegRepResponseStatus == ERegRepResponseStatus.FAILURE ? 1 : 0) != 0, (String)"Only SUCCESS and FAILURE are supported");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"RequestID");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"SpecificationIdentifier");
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, (String)"Exceptions");
        this.m_eResponseStatus = eRegRepResponseStatus;
        this.m_sRequestID = string;
        this.m_sSpecificationIdentifier = string2;
        this.m_aErrorProvider = agentType;
        this.m_aExceptions.addAll(iCommonsList);
    }

    @Nonnull
    public final ERegRepResponseStatus getResponseStatus() {
        return this.m_eResponseStatus;
    }

    @Nonnull
    @Nonempty
    public final String getRequestID() {
        return this.m_sRequestID;
    }

    @Nonnull
    @Nonempty
    public final String getSpecificationIdentifier() {
        return this.m_sSpecificationIdentifier;
    }

    @Nullable
    public final AgentType getErrorProvider() {
        return this.m_aErrorProvider;
    }

    @Nonnull
    @Nonempty
    public final List<EDMExceptionPojo> exceptions() {
        return this.m_aExceptions;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public final List<EDMExceptionPojo> getAllExceptions() {
        return (List)this.m_aExceptions.getClone();
    }

    @Nonnull
    private QueryResponse _createQueryResponse(@Nonnull ICommonsList<ISlotProvider> iCommonsList) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Object object : iCommonsList) {
            Object object2 = object.getName();
            if (commonsLinkedHashMap.containsKey(object2)) {
                throw new IllegalArgumentException("A slot provider for name '" + (String)object2 + "' is already present");
            }
            commonsLinkedHashMap.put(object2, object);
        }
        Iterator iterator = RegRepHelper.createEmptyQueryResponse((ERegRepResponseStatus)this.m_eResponseStatus);
        iterator.setRequestId(this.m_sRequestID);
        for (Object object2 : TOP_LEVEL_SLOTS) {
            ISlotProvider iSlotProvider = (ISlotProvider)commonsLinkedHashMap.get(object2);
            if (iSlotProvider == null) continue;
            iterator.addSlot(iSlotProvider.createSlot());
        }
        for (Object object2 : this.m_aExceptions) {
            iterator.addException(((EDMExceptionPojo)object2).getAsRegistryException());
        }
        return iterator;
    }

    @Nonnull
    public QueryResponse getAsErrorResponse() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (this.m_sSpecificationIdentifier != null) {
            commonsArrayList.add((Object)new SlotSpecificationIdentifier(this.m_sSpecificationIdentifier));
        }
        if (this.m_aErrorProvider != null) {
            commonsArrayList.add((Object)new SlotErrorProvider(this.m_aErrorProvider));
        }
        return this._createQueryResponse((ICommonsList<ISlotProvider>)commonsArrayList);
    }

    @Nonnull
    public IVersatileWriter<QueryResponse> getWriter() {
        return new JAXBVersatileWriter<QueryResponse>(this.getAsErrorResponse(), (IJAXBWriter<QueryResponse>)RegRep4Writer.queryResponse().setFormattedOutput(true));
    }

    @Nonnull
    public static IJAXBVersatileReader<EDMErrorResponse> reader() {
        return new JAXBVersatileReader<QueryResponse, EDMErrorResponse>((IJAXBReader<QueryResponse>)RegRep4Reader.queryResponse(), EDMErrorResponse::create);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EDMErrorResponse eDMErrorResponse = (EDMErrorResponse)object;
        return EqualsHelper.equals((Object)this.m_eResponseStatus, (Object)eDMErrorResponse.m_eResponseStatus) && EqualsHelper.equals((Object)this.m_sRequestID, (Object)eDMErrorResponse.m_sRequestID) && EqualsHelper.equals((Object)this.m_sSpecificationIdentifier, (Object)eDMErrorResponse.m_sSpecificationIdentifier) && EqualsHelper.equals((Object)this.m_aErrorProvider, (Object)eDMErrorResponse.m_aErrorProvider) && EqualsHelper.equals(this.m_aExceptions, eDMErrorResponse.m_aExceptions);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eResponseStatus).append((Object)this.m_sRequestID).append((Object)this.m_sSpecificationIdentifier).append((Object)this.m_aErrorProvider).append(this.m_aExceptions).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("RequestID", (Object)this.m_sRequestID).append("ResponseStatus", (Enum)this.m_eResponseStatus).append("SpecificationIdentifier", (Object)this.m_sSpecificationIdentifier).append("ErrorProvider", (Object)this.m_aErrorProvider).append("Exceptions", this.m_aExceptions).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder().specificationIdentifier("toop-edm:v2.0").responseStatus(ERegRepResponseStatus.FAILURE);
    }

    private static void _applySlots(@Nonnull SlotType slotType, @Nonnull Builder builder) {
        String string = slotType.getName();
        ValueType valueType = slotType.getSlotValue();
        switch (string) {
            case "SpecificationIdentifier": {
                if (!(valueType instanceof StringValueType)) break;
                String string2 = ((StringValueType)valueType).getValue();
                builder.specificationIdentifier(string2);
                break;
            }
            case "ErrorProvider": {
                if (!(valueType instanceof AnyValueType)) break;
                Node node = (Node)((AnyValueType)valueType).getAny();
                builder.errorProvider(AgentPojo.builder((AgentType)new AgentMarshaller().read(node)));
                break;
            }
            default: {
                throw new IllegalStateException("Found unsupported slot '" + string + "'");
            }
        }
    }

    @Nonnull
    public static EDMErrorResponse create(@Nonnull QueryResponse queryResponse) {
        Builder builder = EDMErrorResponse.builder().responseStatus(ERegRepResponseStatus.getFromIDOrNull((String)queryResponse.getStatus())).requestID(queryResponse.getRequestId());
        for (SlotType slotType : queryResponse.getSlot()) {
            EDMErrorResponse._applySlots(slotType, builder);
        }
        for (SlotType slotType : queryResponse.getException()) {
            builder.addException((RegistryExceptionType)slotType);
        }
        return builder.build();
    }

    public static class Builder {
        private ERegRepResponseStatus m_eResponseStatus;
        private String m_sRequestID;
        private String m_sSpecificationIdentifier;
        private AgentType m_aErrorProvider;
        private final ICommonsList<EDMExceptionPojo> m_aExceptions = new CommonsArrayList();

        @Nonnull
        public Builder responseStatus(@Nullable ERegRepResponseStatus eRegRepResponseStatus) {
            this.m_eResponseStatus = eRegRepResponseStatus;
            return this;
        }

        @Nonnull
        public Builder requestID(@Nullable String string) {
            this.m_sRequestID = string;
            return this;
        }

        @Nonnull
        public Builder specificationIdentifier(@Nullable String string) {
            this.m_sSpecificationIdentifier = string;
            return this;
        }

        @Nonnull
        public final Builder errorProvider(@Nullable Consumer<? super AgentPojo.Builder> consumer) {
            if (consumer != null) {
                AgentPojo.Builder builder = AgentPojo.builder();
                consumer.accept(builder);
                this.errorProvider(builder.build());
            }
            return this;
        }

        @Nonnull
        public Builder errorProvider(@Nullable AgentPojo.Builder builder) {
            return this.errorProvider(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder errorProvider(@Nullable AgentPojo agentPojo) {
            return this.errorProvider(agentPojo == null ? null : agentPojo.getAsAgent());
        }

        @Nonnull
        public Builder errorProvider(@Nullable AgentType agentType) {
            this.m_aErrorProvider = agentType;
            return this;
        }

        @Nonnull
        public final Builder addException(@Nullable Consumer<? super EDMExceptionPojo.Builder> consumer) {
            if (consumer != null) {
                EDMExceptionPojo.Builder builder = EDMExceptionPojo.builder();
                consumer.accept(builder);
                this.addException(builder.build());
            }
            return this;
        }

        @Nonnull
        public Builder addException(@Nullable RegistryExceptionType registryExceptionType) {
            return this.addException(registryExceptionType == null ? null : EDMExceptionPojo.builder(registryExceptionType));
        }

        @Nonnull
        public Builder addException(@Nullable EDMExceptionPojo.Builder builder) {
            return this.addException(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder addException(@Nullable EDMExceptionPojo eDMExceptionPojo) {
            if (eDMExceptionPojo != null) {
                this.m_aExceptions.add((Object)eDMExceptionPojo);
            }
            return this;
        }

        @Nonnull
        public final Builder exception(@Nullable Consumer<? super EDMExceptionPojo.Builder> consumer) {
            if (consumer != null) {
                EDMExceptionPojo.Builder builder = EDMExceptionPojo.builder();
                consumer.accept(builder);
                this.exception(builder.build());
            }
            return this;
        }

        @Nonnull
        public Builder exception(@Nullable EDMExceptionPojo.Builder builder) {
            return this.exception(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder exception(@Nullable RegistryExceptionType registryExceptionType) {
            return this.exception(registryExceptionType == null ? null : EDMExceptionPojo.builder(registryExceptionType));
        }

        @Nonnull
        public Builder exception(@Nullable EDMExceptionPojo eDMExceptionPojo) {
            if (eDMExceptionPojo != null) {
                this.m_aExceptions.set((Object)eDMExceptionPojo);
            } else {
                this.m_aExceptions.clear();
            }
            return this;
        }

        @Nonnull
        public Builder exceptions(EDMExceptionPojo ... eDMExceptionPojoArray) {
            this.m_aExceptions.setAll((Object[])eDMExceptionPojoArray);
            return this;
        }

        @Nonnull
        public Builder exceptions(@Nullable Iterable<? extends EDMExceptionPojo> iterable) {
            this.m_aExceptions.setAll(iterable);
            return this;
        }

        public void checkConsistency() {
            if (this.m_eResponseStatus == null) {
                throw new IllegalStateException("Response Status must be present");
            }
            if (this.m_eResponseStatus != ERegRepResponseStatus.SUCCESS && this.m_eResponseStatus != ERegRepResponseStatus.FAILURE) {
                throw new IllegalStateException("Response Status must be SUCCESS or FAILURE");
            }
            if (StringHelper.hasNoText((String)this.m_sRequestID)) {
                throw new IllegalStateException("Request ID must be present");
            }
            if (StringHelper.hasNoText((String)this.m_sSpecificationIdentifier)) {
                throw new IllegalStateException("SpecificationIdentifier must be present");
            }
            if (this.m_aExceptions.isEmpty()) {
                throw new IllegalStateException("At least one Exception must be present");
            }
        }

        @Nonnull
        public EDMErrorResponse build() {
            this.checkConsistency();
            return new EDMErrorResponse(this.m_eResponseStatus, this.m_sRequestID, this.m_sSpecificationIdentifier, this.m_aErrorProvider, this.m_aExceptions);
        }
    }
}

