
package eu.toop.edm.jaxb.w3.cv.ac;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.w3.cv.bc.AddressAddressAreaType;
import eu.toop.edm.jaxb.w3.cv.bc.AddressAdminUnitLocationOneType;
import eu.toop.edm.jaxb.w3.cv.bc.AddressAdminUnitLocationTwoType;
import eu.toop.edm.jaxb.w3.cv.bc.AddressFullAddressType;
import eu.toop.edm.jaxb.w3.cv.bc.AddressIDType;
import eu.toop.edm.jaxb.w3.cv.bc.AddressLocatorDesignatorType;
import eu.toop.edm.jaxb.w3.cv.bc.AddressLocatorNameType;
import eu.toop.edm.jaxb.w3.cv.bc.AddressPostCodeType;
import eu.toop.edm.jaxb.w3.cv.bc.AddressPostNameType;
import eu.toop.edm.jaxb.w3.cv.bc.AddressPostOfficeBoxType;
import eu.toop.edm.jaxb.w3.cv.bc.AddressThoroughfareType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ABIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Address. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An address representing a location.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Core Address&lt;/ccts:ObjectClass&gt;&lt;/ccts:Component&gt;
 * </pre>
 * 
 * 
 * <p>Java class for CoreAddressType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="CoreAddressType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}AddressFullAddress" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}AddressPostOfficeBox" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}AddressThoroughfare" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}AddressLocatorDesignator" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}AddressLocatorName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}AddressAddressArea" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}AddressPostName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}AddressAdminUnitLocationTwo" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}AddressAdminUnitLocationOne" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}AddressPostCode" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}AddressID" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CoreAddressType", propOrder = {
    "addressFullAddress",
    "addressPostOfficeBox",
    "addressThoroughfare",
    "addressLocatorDesignator",
    "addressLocatorName",
    "addressAddressArea",
    "addressPostName",
    "addressAdminUnitLocationTwo",
    "addressAdminUnitLocationOne",
    "addressPostCode",
    "addressID"
})
@CodingStyleguideUnaware
public class CoreAddressType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "AddressFullAddress", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<AddressFullAddressType> addressFullAddress;
    @XmlElement(name = "AddressPostOfficeBox", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<AddressPostOfficeBoxType> addressPostOfficeBox;
    @XmlElement(name = "AddressThoroughfare", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<AddressThoroughfareType> addressThoroughfare;
    @XmlElement(name = "AddressLocatorDesignator", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<AddressLocatorDesignatorType> addressLocatorDesignator;
    @XmlElement(name = "AddressLocatorName", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<AddressLocatorNameType> addressLocatorName;
    @XmlElement(name = "AddressAddressArea", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<AddressAddressAreaType> addressAddressArea;
    @XmlElement(name = "AddressPostName", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<AddressPostNameType> addressPostName;
    @XmlElement(name = "AddressAdminUnitLocationTwo", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<AddressAdminUnitLocationTwoType> addressAdminUnitLocationTwo;
    @XmlElement(name = "AddressAdminUnitLocationOne", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<AddressAdminUnitLocationOneType> addressAdminUnitLocationOne;
    @XmlElement(name = "AddressPostCode", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<AddressPostCodeType> addressPostCode;
    @XmlElement(name = "AddressID", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<AddressIDType> addressID;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CoreAddressType() {
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Address. Address_ Full Address. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The complete address with or without formatting.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Address&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Address&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Full Address&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the addressFullAddress property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the addressFullAddress property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAddressFullAddress().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressFullAddressType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AddressFullAddressType> getAddressFullAddress() {
        if (addressFullAddress == null) {
            addressFullAddress = new ArrayList<AddressFullAddressType>();
        }
        return this.addressFullAddress;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Address. Address_ Post Office Box. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The Post Office Box number.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Address&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Address&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Post Office Box&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the addressPostOfficeBox property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the addressPostOfficeBox property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAddressPostOfficeBox().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressPostOfficeBoxType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AddressPostOfficeBoxType> getAddressPostOfficeBox() {
        if (addressPostOfficeBox == null) {
            addressPostOfficeBox = new ArrayList<AddressPostOfficeBoxType>();
        }
        return this.addressPostOfficeBox;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Address. Address_ Thoroughfare. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The name of a passage or way through from one location to another.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Address&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Address&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Thoroughfare&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the addressThoroughfare property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the addressThoroughfare property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAddressThoroughfare().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressThoroughfareType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AddressThoroughfareType> getAddressThoroughfare() {
        if (addressThoroughfare == null) {
            addressThoroughfare = new ArrayList<AddressThoroughfareType>();
        }
        return this.addressThoroughfare;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Address. Address_ Locator Designator. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A number or a sequence of characters that uniquely identifies the locator within the relevant scope.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Address&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Address&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Locator Designator&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the addressLocatorDesignator property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the addressLocatorDesignator property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAddressLocatorDesignator().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressLocatorDesignatorType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AddressLocatorDesignatorType> getAddressLocatorDesignator() {
        if (addressLocatorDesignator == null) {
            addressLocatorDesignator = new ArrayList<AddressLocatorDesignatorType>();
        }
        return this.addressLocatorDesignator;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Address. Address_ Locator Name. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A proper noun applied to the real world entity identified by the address.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Address&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Address&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Locator Name&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the addressLocatorName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the addressLocatorName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAddressLocatorName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressLocatorNameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AddressLocatorNameType> getAddressLocatorName() {
        if (addressLocatorName == null) {
            addressLocatorName = new ArrayList<AddressLocatorNameType>();
        }
        return this.addressLocatorName;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Address. Address_ Address Area. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The name of a geographic area or locality that groups a number of addressable objects for addressing purposes, without being an administrative unit.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Address&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Address&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Address Area&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the addressAddressArea property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the addressAddressArea property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAddressAddressArea().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressAddressAreaType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AddressAddressAreaType> getAddressAddressArea() {
        if (addressAddressArea == null) {
            addressAddressArea = new ArrayList<AddressAddressAreaType>();
        }
        return this.addressAddressArea;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Address. Address_ Post Name. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The key postal division of the address, usually the city.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Address&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Address&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Post Name&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the addressPostName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the addressPostName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAddressPostName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressPostNameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AddressPostNameType> getAddressPostName() {
        if (addressPostName == null) {
            addressPostName = new ArrayList<AddressPostNameType>();
        }
        return this.addressPostName;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Address. Address_ Admin Unit Location Two. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The region of the address, usually a county, state or other such area that typically encompasses several localities.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Address&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Address&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Admin Unit Location Two&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the addressAdminUnitLocationTwo property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the addressAdminUnitLocationTwo property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAddressAdminUnitLocationTwo().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressAdminUnitLocationTwoType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AddressAdminUnitLocationTwoType> getAddressAdminUnitLocationTwo() {
        if (addressAdminUnitLocationTwo == null) {
            addressAdminUnitLocationTwo = new ArrayList<AddressAdminUnitLocationTwoType>();
        }
        return this.addressAdminUnitLocationTwo;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Address. Address_ Admin Unit Location One. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The uppermost administrative unit for the address, almost always a country.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Address&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Address&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Admin Unit Location One&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the addressAdminUnitLocationOne property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the addressAdminUnitLocationOne property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAddressAdminUnitLocationOne().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressAdminUnitLocationOneType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AddressAdminUnitLocationOneType> getAddressAdminUnitLocationOne() {
        if (addressAdminUnitLocationOne == null) {
            addressAdminUnitLocationOne = new ArrayList<AddressAdminUnitLocationOneType>();
        }
        return this.addressAdminUnitLocationOne;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Address. Address_ Post Code. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The post code, a.k.a. postal code, ZIP code, etc.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Address&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Address&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Post Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the addressPostCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the addressPostCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAddressPostCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressPostCodeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AddressPostCodeType> getAddressPostCode() {
        if (addressPostCode == null) {
            addressPostCode = new ArrayList<AddressPostCodeType>();
        }
        return this.addressPostCode;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Address. Address_ Identifier. Identifier&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A globally unique identifier for this instance of the address.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Address&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Address&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Identifier&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Identifier&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Identifier. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the addressID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the addressID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAddressID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressIDType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AddressIDType> getAddressID() {
        if (addressID == null) {
            addressID = new ArrayList<AddressIDType>();
        }
        return this.addressID;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final CoreAddressType rhs = ((CoreAddressType) o);
        if (!EqualsHelper.equalsCollection(addressAddressArea, rhs.addressAddressArea)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(addressAdminUnitLocationOne, rhs.addressAdminUnitLocationOne)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(addressAdminUnitLocationTwo, rhs.addressAdminUnitLocationTwo)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(addressFullAddress, rhs.addressFullAddress)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(addressID, rhs.addressID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(addressLocatorDesignator, rhs.addressLocatorDesignator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(addressLocatorName, rhs.addressLocatorName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(addressPostCode, rhs.addressPostCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(addressPostName, rhs.addressPostName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(addressPostOfficeBox, rhs.addressPostOfficeBox)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(addressThoroughfare, rhs.addressThoroughfare)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(addressAddressArea).append(addressAdminUnitLocationOne).append(addressAdminUnitLocationTwo).append(addressFullAddress).append(addressID).append(addressLocatorDesignator).append(addressLocatorName).append(addressPostCode).append(addressPostName).append(addressPostOfficeBox).append(addressThoroughfare).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("addressAddressArea", addressAddressArea).append("addressAdminUnitLocationOne", addressAdminUnitLocationOne).append("addressAdminUnitLocationTwo", addressAdminUnitLocationTwo).append("addressFullAddress", addressFullAddress).append("addressID", addressID).append("addressLocatorDesignator", addressLocatorDesignator).append("addressLocatorName", addressLocatorName).append("addressPostCode", addressPostCode).append("addressPostName", addressPostName).append("addressPostOfficeBox", addressPostOfficeBox).append("addressThoroughfare", addressThoroughfare).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAddressFullAddress(
        @Nullable
        final List<AddressFullAddressType> aList) {
        addressFullAddress = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAddressPostOfficeBox(
        @Nullable
        final List<AddressPostOfficeBoxType> aList) {
        addressPostOfficeBox = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAddressThoroughfare(
        @Nullable
        final List<AddressThoroughfareType> aList) {
        addressThoroughfare = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAddressLocatorDesignator(
        @Nullable
        final List<AddressLocatorDesignatorType> aList) {
        addressLocatorDesignator = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAddressLocatorName(
        @Nullable
        final List<AddressLocatorNameType> aList) {
        addressLocatorName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAddressAddressArea(
        @Nullable
        final List<AddressAddressAreaType> aList) {
        addressAddressArea = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAddressPostName(
        @Nullable
        final List<AddressPostNameType> aList) {
        addressPostName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAddressAdminUnitLocationTwo(
        @Nullable
        final List<AddressAdminUnitLocationTwoType> aList) {
        addressAdminUnitLocationTwo = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAddressAdminUnitLocationOne(
        @Nullable
        final List<AddressAdminUnitLocationOneType> aList) {
        addressAdminUnitLocationOne = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAddressPostCode(
        @Nullable
        final List<AddressPostCodeType> aList) {
        addressPostCode = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAddressID(
        @Nullable
        final List<AddressIDType> aList) {
        addressID = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAddressFullAddressEntries() {
        return (!getAddressFullAddress().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAddressFullAddressEntries() {
        return getAddressFullAddress().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAddressFullAddressCount() {
        return getAddressFullAddress().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AddressFullAddressType getAddressFullAddressAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAddressFullAddress().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAddressFullAddress(
        @Nonnull
        final AddressFullAddressType elem) {
        getAddressFullAddress().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAddressPostOfficeBoxEntries() {
        return (!getAddressPostOfficeBox().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAddressPostOfficeBoxEntries() {
        return getAddressPostOfficeBox().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAddressPostOfficeBoxCount() {
        return getAddressPostOfficeBox().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AddressPostOfficeBoxType getAddressPostOfficeBoxAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAddressPostOfficeBox().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAddressPostOfficeBox(
        @Nonnull
        final AddressPostOfficeBoxType elem) {
        getAddressPostOfficeBox().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAddressThoroughfareEntries() {
        return (!getAddressThoroughfare().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAddressThoroughfareEntries() {
        return getAddressThoroughfare().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAddressThoroughfareCount() {
        return getAddressThoroughfare().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AddressThoroughfareType getAddressThoroughfareAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAddressThoroughfare().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAddressThoroughfare(
        @Nonnull
        final AddressThoroughfareType elem) {
        getAddressThoroughfare().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAddressLocatorDesignatorEntries() {
        return (!getAddressLocatorDesignator().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAddressLocatorDesignatorEntries() {
        return getAddressLocatorDesignator().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAddressLocatorDesignatorCount() {
        return getAddressLocatorDesignator().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AddressLocatorDesignatorType getAddressLocatorDesignatorAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAddressLocatorDesignator().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAddressLocatorDesignator(
        @Nonnull
        final AddressLocatorDesignatorType elem) {
        getAddressLocatorDesignator().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAddressLocatorNameEntries() {
        return (!getAddressLocatorName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAddressLocatorNameEntries() {
        return getAddressLocatorName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAddressLocatorNameCount() {
        return getAddressLocatorName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AddressLocatorNameType getAddressLocatorNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAddressLocatorName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAddressLocatorName(
        @Nonnull
        final AddressLocatorNameType elem) {
        getAddressLocatorName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAddressAddressAreaEntries() {
        return (!getAddressAddressArea().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAddressAddressAreaEntries() {
        return getAddressAddressArea().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAddressAddressAreaCount() {
        return getAddressAddressArea().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AddressAddressAreaType getAddressAddressAreaAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAddressAddressArea().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAddressAddressArea(
        @Nonnull
        final AddressAddressAreaType elem) {
        getAddressAddressArea().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAddressPostNameEntries() {
        return (!getAddressPostName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAddressPostNameEntries() {
        return getAddressPostName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAddressPostNameCount() {
        return getAddressPostName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AddressPostNameType getAddressPostNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAddressPostName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAddressPostName(
        @Nonnull
        final AddressPostNameType elem) {
        getAddressPostName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAddressAdminUnitLocationTwoEntries() {
        return (!getAddressAdminUnitLocationTwo().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAddressAdminUnitLocationTwoEntries() {
        return getAddressAdminUnitLocationTwo().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAddressAdminUnitLocationTwoCount() {
        return getAddressAdminUnitLocationTwo().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AddressAdminUnitLocationTwoType getAddressAdminUnitLocationTwoAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAddressAdminUnitLocationTwo().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAddressAdminUnitLocationTwo(
        @Nonnull
        final AddressAdminUnitLocationTwoType elem) {
        getAddressAdminUnitLocationTwo().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAddressAdminUnitLocationOneEntries() {
        return (!getAddressAdminUnitLocationOne().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAddressAdminUnitLocationOneEntries() {
        return getAddressAdminUnitLocationOne().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAddressAdminUnitLocationOneCount() {
        return getAddressAdminUnitLocationOne().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AddressAdminUnitLocationOneType getAddressAdminUnitLocationOneAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAddressAdminUnitLocationOne().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAddressAdminUnitLocationOne(
        @Nonnull
        final AddressAdminUnitLocationOneType elem) {
        getAddressAdminUnitLocationOne().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAddressPostCodeEntries() {
        return (!getAddressPostCode().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAddressPostCodeEntries() {
        return getAddressPostCode().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAddressPostCodeCount() {
        return getAddressPostCode().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AddressPostCodeType getAddressPostCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAddressPostCode().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAddressPostCode(
        @Nonnull
        final AddressPostCodeType elem) {
        getAddressPostCode().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAddressIDEntries() {
        return (!getAddressID().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAddressIDEntries() {
        return getAddressID().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAddressIDCount() {
        return getAddressID().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AddressIDType getAddressIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAddressID().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAddressID(
        @Nonnull
        final AddressIDType elem) {
        getAddressID().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CoreAddressType ret) {
        if (addressAddressArea == null) {
            ret.addressAddressArea = null;
        } else {
            List<AddressAddressAreaType> retAddressAddressArea = new ArrayList<AddressAddressAreaType>();
            for (AddressAddressAreaType aItem: getAddressAddressArea()) {
                retAddressAddressArea.add(((aItem == null)?null:aItem.clone()));
            }
            ret.addressAddressArea = retAddressAddressArea;
        }
        if (addressAdminUnitLocationOne == null) {
            ret.addressAdminUnitLocationOne = null;
        } else {
            List<AddressAdminUnitLocationOneType> retAddressAdminUnitLocationOne = new ArrayList<AddressAdminUnitLocationOneType>();
            for (AddressAdminUnitLocationOneType aItem: getAddressAdminUnitLocationOne()) {
                retAddressAdminUnitLocationOne.add(((aItem == null)?null:aItem.clone()));
            }
            ret.addressAdminUnitLocationOne = retAddressAdminUnitLocationOne;
        }
        if (addressAdminUnitLocationTwo == null) {
            ret.addressAdminUnitLocationTwo = null;
        } else {
            List<AddressAdminUnitLocationTwoType> retAddressAdminUnitLocationTwo = new ArrayList<AddressAdminUnitLocationTwoType>();
            for (AddressAdminUnitLocationTwoType aItem: getAddressAdminUnitLocationTwo()) {
                retAddressAdminUnitLocationTwo.add(((aItem == null)?null:aItem.clone()));
            }
            ret.addressAdminUnitLocationTwo = retAddressAdminUnitLocationTwo;
        }
        if (addressFullAddress == null) {
            ret.addressFullAddress = null;
        } else {
            List<AddressFullAddressType> retAddressFullAddress = new ArrayList<AddressFullAddressType>();
            for (AddressFullAddressType aItem: getAddressFullAddress()) {
                retAddressFullAddress.add(((aItem == null)?null:aItem.clone()));
            }
            ret.addressFullAddress = retAddressFullAddress;
        }
        if (addressID == null) {
            ret.addressID = null;
        } else {
            List<AddressIDType> retAddressID = new ArrayList<AddressIDType>();
            for (AddressIDType aItem: getAddressID()) {
                retAddressID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.addressID = retAddressID;
        }
        if (addressLocatorDesignator == null) {
            ret.addressLocatorDesignator = null;
        } else {
            List<AddressLocatorDesignatorType> retAddressLocatorDesignator = new ArrayList<AddressLocatorDesignatorType>();
            for (AddressLocatorDesignatorType aItem: getAddressLocatorDesignator()) {
                retAddressLocatorDesignator.add(((aItem == null)?null:aItem.clone()));
            }
            ret.addressLocatorDesignator = retAddressLocatorDesignator;
        }
        if (addressLocatorName == null) {
            ret.addressLocatorName = null;
        } else {
            List<AddressLocatorNameType> retAddressLocatorName = new ArrayList<AddressLocatorNameType>();
            for (AddressLocatorNameType aItem: getAddressLocatorName()) {
                retAddressLocatorName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.addressLocatorName = retAddressLocatorName;
        }
        if (addressPostCode == null) {
            ret.addressPostCode = null;
        } else {
            List<AddressPostCodeType> retAddressPostCode = new ArrayList<AddressPostCodeType>();
            for (AddressPostCodeType aItem: getAddressPostCode()) {
                retAddressPostCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.addressPostCode = retAddressPostCode;
        }
        if (addressPostName == null) {
            ret.addressPostName = null;
        } else {
            List<AddressPostNameType> retAddressPostName = new ArrayList<AddressPostNameType>();
            for (AddressPostNameType aItem: getAddressPostName()) {
                retAddressPostName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.addressPostName = retAddressPostName;
        }
        if (addressPostOfficeBox == null) {
            ret.addressPostOfficeBox = null;
        } else {
            List<AddressPostOfficeBoxType> retAddressPostOfficeBox = new ArrayList<AddressPostOfficeBoxType>();
            for (AddressPostOfficeBoxType aItem: getAddressPostOfficeBox()) {
                retAddressPostOfficeBox.add(((aItem == null)?null:aItem.clone()));
            }
            ret.addressPostOfficeBox = retAddressPostOfficeBox;
        }
        if (addressThoroughfare == null) {
            ret.addressThoroughfare = null;
        } else {
            List<AddressThoroughfareType> retAddressThoroughfare = new ArrayList<AddressThoroughfareType>();
            for (AddressThoroughfareType aItem: getAddressThoroughfare()) {
                retAddressThoroughfare.add(((aItem == null)?null:aItem.clone()));
            }
            ret.addressThoroughfare = retAddressThoroughfare;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CoreAddressType clone() {
        CoreAddressType ret = new CoreAddressType();
        cloneTo(ret);
        return ret;
    }

}
