
package eu.toop.edm.jaxb.vcard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xsds.xlink.XLinkActuateType;
import com.helger.xsds.xlink.XLinkShowType;
import com.helger.xsds.xlink.XLinkTypeType;


/**
 * <p>Java class for VCARDType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="VCARDType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="VCARD"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;any namespace='http://www.w3.org/2001/vcard-rdf/3.0#' maxOccurs="unbounded" minOccurs="0"/&gt;
 *                 &lt;/sequence&gt;
 *                 &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="FN" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement"/&gt;
 *         &lt;element name="NICKNAME" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement"/&gt;
 *         &lt;element name="BDAY" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement"/&gt;
 *         &lt;element name="MAILER" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement"/&gt;
 *         &lt;element name="GEO" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement"/&gt;
 *         &lt;element name="TITLE" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement"/&gt;
 *         &lt;element name="ROLE" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement"/&gt;
 *         &lt;element name="CATEGORIES" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement"/&gt;
 *         &lt;element name="NAME" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement"/&gt;
 *         &lt;element name="SOURCE" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement"/&gt;
 *         &lt;element name="NOTE" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement"/&gt;
 *         &lt;element name="PRODID" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement"/&gt;
 *         &lt;element name="REV" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement"/&gt;
 *         &lt;element name="SORT-STRING" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement"/&gt;
 *         &lt;element name="CLASS" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement"/&gt;
 *         &lt;element name="TEL"&gt;
 *           &lt;complexType&gt;
 *             &lt;simpleContent&gt;
 *               &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema&gt;string"&gt;
 *                 &lt;attribute name="TYPE" default="voice"&gt;
 *                   &lt;simpleType&gt;
 *                     &lt;list&gt;
 *                       &lt;simpleType&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *                           &lt;enumeration value="home"/&gt;
 *                           &lt;enumeration value="msg"/&gt;
 *                           &lt;enumeration value="work"/&gt;
 *                           &lt;enumeration value="pref"/&gt;
 *                           &lt;enumeration value="voice"/&gt;
 *                           &lt;enumeration value="fax"/&gt;
 *                           &lt;enumeration value="cell"/&gt;
 *                           &lt;enumeration value="video"/&gt;
 *                           &lt;enumeration value="pager"/&gt;
 *                           &lt;enumeration value="bbs"/&gt;
 *                           &lt;enumeration value="modem"/&gt;
 *                           &lt;enumeration value="car"/&gt;
 *                           &lt;enumeration value="isdn"/&gt;
 *                           &lt;enumeration value="pcs"/&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/simpleType&gt;
 *                     &lt;/list&gt;
 *                   &lt;/simpleType&gt;
 *                 &lt;/attribute&gt;
 *                 &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
 *               &lt;/extension&gt;
 *             &lt;/simpleContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="EMAIL"&gt;
 *           &lt;complexType&gt;
 *             &lt;simpleContent&gt;
 *               &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema&gt;string"&gt;
 *                 &lt;attribute name="TYPE" default="internet"&gt;
 *                   &lt;simpleType&gt;
 *                     &lt;list&gt;
 *                       &lt;simpleType&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *                           &lt;enumeration value="internet"/&gt;
 *                           &lt;enumeration value="x400"/&gt;
 *                           &lt;enumeration value="pref"/&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/simpleType&gt;
 *                     &lt;/list&gt;
 *                   &lt;/simpleType&gt;
 *                 &lt;/attribute&gt;
 *                 &lt;attribute name="OTHERTYPE" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *                 &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
 *               &lt;/extension&gt;
 *             &lt;/simpleContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="ADR"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element name="Pobox" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
 *                   &lt;element name="Extadd" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
 *                   &lt;element name="Street" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
 *                   &lt;element name="Locality" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
 *                   &lt;element name="Region" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
 *                   &lt;element name="Pcode" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
 *                   &lt;element name="Country" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
 *                 &lt;/sequence&gt;
 *                 &lt;attribute name="TYPE" default="intl postal parcel work"&gt;
 *                   &lt;simpleType&gt;
 *                     &lt;list&gt;
 *                       &lt;simpleType&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *                           &lt;enumeration value="dom"/&gt;
 *                           &lt;enumeration value="intl"/&gt;
 *                           &lt;enumeration value="postal"/&gt;
 *                           &lt;enumeration value="parcel"/&gt;
 *                           &lt;enumeration value="home"/&gt;
 *                           &lt;enumeration value="work"/&gt;
 *                           &lt;enumeration value="pref"/&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/simpleType&gt;
 *                     &lt;/list&gt;
 *                   &lt;/simpleType&gt;
 *                 &lt;/attribute&gt;
 *                 &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="ORG"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element name="Orgname" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
 *                   &lt;element name="Orgunit" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
 *                 &lt;/sequence&gt;
 *                 &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="N"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element name="Family" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
 *                   &lt;element name="Given" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
 *                   &lt;element name="Other" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
 *                   &lt;element name="Prefix" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
 *                   &lt;element name="Suffix" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
 *                 &lt;/sequence&gt;
 *                 &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="LABEL"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;any processContents='lax' maxOccurs="0" minOccurs="0"/&gt;
 *                 &lt;/sequence&gt;
 *                 &lt;attribute name="TYPE" default="intl postal parcel work"&gt;
 *                   &lt;simpleType&gt;
 *                     &lt;list&gt;
 *                       &lt;simpleType&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *                           &lt;enumeration value="dom"/&gt;
 *                           &lt;enumeration value="intl"/&gt;
 *                           &lt;enumeration value="postal"/&gt;
 *                           &lt;enumeration value="parcel"/&gt;
 *                           &lt;enumeration value="home"/&gt;
 *                           &lt;enumeration value="work"/&gt;
 *                           &lt;enumeration value="pref"/&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/simpleType&gt;
 *                     &lt;/list&gt;
 *                   &lt;/simpleType&gt;
 *                 &lt;/attribute&gt;
 *                 &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="TZ"&gt;
 *           &lt;complexType&gt;
 *             &lt;simpleContent&gt;
 *               &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema&gt;string"&gt;
 *                 &lt;attribute name="TYPE"&gt;
 *                   &lt;simpleType&gt;
 *                     &lt;list&gt;
 *                       &lt;simpleType&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *                           &lt;enumeration value="text"/&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/simpleType&gt;
 *                     &lt;/list&gt;
 *                   &lt;/simpleType&gt;
 *                 &lt;/attribute&gt;
 *                 &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
 *               &lt;/extension&gt;
 *             &lt;/simpleContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="UID"&gt;
 *           &lt;complexType&gt;
 *             &lt;simpleContent&gt;
 *               &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema&gt;string"&gt;
 *                 &lt;attribute name="TYPE" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *                 &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
 *               &lt;/extension&gt;
 *             &lt;/simpleContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="PHOTO" type="{http://www.w3.org/2001/vcard-rdf/3.0#}binaryElement"/&gt;
 *         &lt;element name="LOGO" type="{http://www.w3.org/2001/vcard-rdf/3.0#}binaryElement"/&gt;
 *         &lt;element name="SOUND" type="{http://www.w3.org/2001/vcard-rdf/3.0#}binaryElement"/&gt;
 *         &lt;element name="KEY" type="{http://www.w3.org/2001/vcard-rdf/3.0#}binaryElement"/&gt;
 *         &lt;element name="AGENT"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;any namespace='http://www.w3.org/2001/vcard-rdf/3.0#' maxOccurs="unbounded" minOccurs="0"/&gt;
 *                 &lt;/sequence&gt;
 *                 &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="GROUP"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;any namespace='http://www.w3.org/2001/vcard-rdf/3.0#' maxOccurs="unbounded" minOccurs="0"/&gt;
 *                 &lt;/sequence&gt;
 *                 &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="URL"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;attGroup ref="{http://www.w3.org/1999/xlink}simpleAttrs"/&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "VCARDType", propOrder = {
    "vcard",
    "fn",
    "nickname",
    "bday",
    "mailer",
    "geo",
    "title",
    "role",
    "categories",
    "name",
    "source",
    "note",
    "prodid",
    "rev",
    "sortstring",
    "_class",
    "tel",
    "email",
    "adr",
    "org",
    "n",
    "label",
    "tz",
    "uid",
    "photo",
    "logo",
    "sound",
    "key",
    "agent",
    "group",
    "url"
})
@CodingStyleguideUnaware
public class VCARDType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "VCARD", required = true)
    private VCARDType.VCARD vcard;
    @XmlElement(name = "FN", required = true)
    private SimpleElement fn;
    @XmlElement(name = "NICKNAME", required = true)
    private SimpleElement nickname;
    @XmlElement(name = "BDAY", required = true)
    private SimpleElement bday;
    @XmlElement(name = "MAILER", required = true)
    private SimpleElement mailer;
    @XmlElement(name = "GEO", required = true)
    private SimpleElement geo;
    @XmlElement(name = "TITLE", required = true)
    private SimpleElement title;
    @XmlElement(name = "ROLE", required = true)
    private SimpleElement role;
    @XmlElement(name = "CATEGORIES", required = true)
    private SimpleElement categories;
    @XmlElement(name = "NAME", required = true)
    private SimpleElement name;
    @XmlElement(name = "SOURCE", required = true)
    private SimpleElement source;
    @XmlElement(name = "NOTE", required = true)
    private SimpleElement note;
    @XmlElement(name = "PRODID", required = true)
    private SimpleElement prodid;
    @XmlElement(name = "REV", required = true)
    private SimpleElement rev;
    @XmlElement(name = "SORT-STRING", required = true)
    private SimpleElement sortstring;
    @XmlElement(name = "CLASS", required = true)
    private SimpleElement _class;
    @XmlElement(name = "TEL", required = true)
    private VCARDType.TEL tel;
    @XmlElement(name = "EMAIL", required = true)
    private VCARDType.EMAIL email;
    @XmlElement(name = "ADR", required = true)
    private VCARDType.ADR adr;
    @XmlElement(name = "ORG", required = true)
    private VCARDType.ORG org;
    @XmlElement(name = "N", required = true)
    private VCARDType.N n;
    @XmlElement(name = "LABEL", required = true)
    private VCARDType.LABEL label;
    @XmlElement(name = "TZ", required = true)
    private VCARDType.TZ tz;
    @XmlElement(name = "UID", required = true)
    private VCARDType.UID uid;
    @XmlElement(name = "PHOTO", required = true)
    private BinaryElement photo;
    @XmlElement(name = "LOGO", required = true)
    private BinaryElement logo;
    @XmlElement(name = "SOUND", required = true)
    private BinaryElement sound;
    @XmlElement(name = "KEY", required = true)
    private BinaryElement key;
    @XmlElement(name = "AGENT", required = true)
    private VCARDType.AGENT agent;
    @XmlElement(name = "GROUP", required = true)
    private VCARDType.GROUP group;
    @XmlElement(name = "URL", required = true)
    private VCARDType.URL url;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public VCARDType() {
    }

    /**
     * Gets the value of the vcard property.
     * 
     * @return
     *     possible object is
     *     {@link VCARDType.VCARD }
     *     
     */
    @Nullable
    public VCARDType.VCARD getVCARD() {
        return vcard;
    }

    /**
     * Sets the value of the vcard property.
     * 
     * @param value
     *     allowed object is
     *     {@link VCARDType.VCARD }
     *     
     */
    public void setVCARD(
        @Nullable
        VCARDType.VCARD value) {
        this.vcard = value;
    }

    /**
     * Gets the value of the fn property.
     * 
     * @return
     *     possible object is
     *     {@link SimpleElement }
     *     
     */
    @Nullable
    public SimpleElement getFN() {
        return fn;
    }

    /**
     * Sets the value of the fn property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimpleElement }
     *     
     */
    public void setFN(
        @Nullable
        SimpleElement value) {
        this.fn = value;
    }

    /**
     * Gets the value of the nickname property.
     * 
     * @return
     *     possible object is
     *     {@link SimpleElement }
     *     
     */
    @Nullable
    public SimpleElement getNICKNAME() {
        return nickname;
    }

    /**
     * Sets the value of the nickname property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimpleElement }
     *     
     */
    public void setNICKNAME(
        @Nullable
        SimpleElement value) {
        this.nickname = value;
    }

    /**
     * Gets the value of the bday property.
     * 
     * @return
     *     possible object is
     *     {@link SimpleElement }
     *     
     */
    @Nullable
    public SimpleElement getBDAY() {
        return bday;
    }

    /**
     * Sets the value of the bday property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimpleElement }
     *     
     */
    public void setBDAY(
        @Nullable
        SimpleElement value) {
        this.bday = value;
    }

    /**
     * Gets the value of the mailer property.
     * 
     * @return
     *     possible object is
     *     {@link SimpleElement }
     *     
     */
    @Nullable
    public SimpleElement getMAILER() {
        return mailer;
    }

    /**
     * Sets the value of the mailer property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimpleElement }
     *     
     */
    public void setMAILER(
        @Nullable
        SimpleElement value) {
        this.mailer = value;
    }

    /**
     * Gets the value of the geo property.
     * 
     * @return
     *     possible object is
     *     {@link SimpleElement }
     *     
     */
    @Nullable
    public SimpleElement getGEO() {
        return geo;
    }

    /**
     * Sets the value of the geo property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimpleElement }
     *     
     */
    public void setGEO(
        @Nullable
        SimpleElement value) {
        this.geo = value;
    }

    /**
     * Gets the value of the title property.
     * 
     * @return
     *     possible object is
     *     {@link SimpleElement }
     *     
     */
    @Nullable
    public SimpleElement getTITLE() {
        return title;
    }

    /**
     * Sets the value of the title property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimpleElement }
     *     
     */
    public void setTITLE(
        @Nullable
        SimpleElement value) {
        this.title = value;
    }

    /**
     * Gets the value of the role property.
     * 
     * @return
     *     possible object is
     *     {@link SimpleElement }
     *     
     */
    @Nullable
    public SimpleElement getROLE() {
        return role;
    }

    /**
     * Sets the value of the role property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimpleElement }
     *     
     */
    public void setROLE(
        @Nullable
        SimpleElement value) {
        this.role = value;
    }

    /**
     * Gets the value of the categories property.
     * 
     * @return
     *     possible object is
     *     {@link SimpleElement }
     *     
     */
    @Nullable
    public SimpleElement getCATEGORIES() {
        return categories;
    }

    /**
     * Sets the value of the categories property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimpleElement }
     *     
     */
    public void setCATEGORIES(
        @Nullable
        SimpleElement value) {
        this.categories = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link SimpleElement }
     *     
     */
    @Nullable
    public SimpleElement getNAME() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimpleElement }
     *     
     */
    public void setNAME(
        @Nullable
        SimpleElement value) {
        this.name = value;
    }

    /**
     * Gets the value of the source property.
     * 
     * @return
     *     possible object is
     *     {@link SimpleElement }
     *     
     */
    @Nullable
    public SimpleElement getSOURCE() {
        return source;
    }

    /**
     * Sets the value of the source property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimpleElement }
     *     
     */
    public void setSOURCE(
        @Nullable
        SimpleElement value) {
        this.source = value;
    }

    /**
     * Gets the value of the note property.
     * 
     * @return
     *     possible object is
     *     {@link SimpleElement }
     *     
     */
    @Nullable
    public SimpleElement getNOTE() {
        return note;
    }

    /**
     * Sets the value of the note property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimpleElement }
     *     
     */
    public void setNOTE(
        @Nullable
        SimpleElement value) {
        this.note = value;
    }

    /**
     * Gets the value of the prodid property.
     * 
     * @return
     *     possible object is
     *     {@link SimpleElement }
     *     
     */
    @Nullable
    public SimpleElement getPRODID() {
        return prodid;
    }

    /**
     * Sets the value of the prodid property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimpleElement }
     *     
     */
    public void setPRODID(
        @Nullable
        SimpleElement value) {
        this.prodid = value;
    }

    /**
     * Gets the value of the rev property.
     * 
     * @return
     *     possible object is
     *     {@link SimpleElement }
     *     
     */
    @Nullable
    public SimpleElement getREV() {
        return rev;
    }

    /**
     * Sets the value of the rev property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimpleElement }
     *     
     */
    public void setREV(
        @Nullable
        SimpleElement value) {
        this.rev = value;
    }

    /**
     * Gets the value of the sortstring property.
     * 
     * @return
     *     possible object is
     *     {@link SimpleElement }
     *     
     */
    @Nullable
    public SimpleElement getSORTSTRING() {
        return sortstring;
    }

    /**
     * Sets the value of the sortstring property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimpleElement }
     *     
     */
    public void setSORTSTRING(
        @Nullable
        SimpleElement value) {
        this.sortstring = value;
    }

    /**
     * Gets the value of the class property.
     * 
     * @return
     *     possible object is
     *     {@link SimpleElement }
     *     
     */
    @Nullable
    public SimpleElement getCLASS() {
        return _class;
    }

    /**
     * Sets the value of the class property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimpleElement }
     *     
     */
    public void setCLASS(
        @Nullable
        SimpleElement value) {
        this._class = value;
    }

    /**
     * Gets the value of the tel property.
     * 
     * @return
     *     possible object is
     *     {@link VCARDType.TEL }
     *     
     */
    @Nullable
    public VCARDType.TEL getTEL() {
        return tel;
    }

    /**
     * Sets the value of the tel property.
     * 
     * @param value
     *     allowed object is
     *     {@link VCARDType.TEL }
     *     
     */
    public void setTEL(
        @Nullable
        VCARDType.TEL value) {
        this.tel = value;
    }

    /**
     * Gets the value of the email property.
     * 
     * @return
     *     possible object is
     *     {@link VCARDType.EMAIL }
     *     
     */
    @Nullable
    public VCARDType.EMAIL getEMAIL() {
        return email;
    }

    /**
     * Sets the value of the email property.
     * 
     * @param value
     *     allowed object is
     *     {@link VCARDType.EMAIL }
     *     
     */
    public void setEMAIL(
        @Nullable
        VCARDType.EMAIL value) {
        this.email = value;
    }

    /**
     * Gets the value of the adr property.
     * 
     * @return
     *     possible object is
     *     {@link VCARDType.ADR }
     *     
     */
    @Nullable
    public VCARDType.ADR getADR() {
        return adr;
    }

    /**
     * Sets the value of the adr property.
     * 
     * @param value
     *     allowed object is
     *     {@link VCARDType.ADR }
     *     
     */
    public void setADR(
        @Nullable
        VCARDType.ADR value) {
        this.adr = value;
    }

    /**
     * Gets the value of the org property.
     * 
     * @return
     *     possible object is
     *     {@link VCARDType.ORG }
     *     
     */
    @Nullable
    public VCARDType.ORG getORG() {
        return org;
    }

    /**
     * Sets the value of the org property.
     * 
     * @param value
     *     allowed object is
     *     {@link VCARDType.ORG }
     *     
     */
    public void setORG(
        @Nullable
        VCARDType.ORG value) {
        this.org = value;
    }

    /**
     * Gets the value of the n property.
     * 
     * @return
     *     possible object is
     *     {@link VCARDType.N }
     *     
     */
    @Nullable
    public VCARDType.N getN() {
        return n;
    }

    /**
     * Sets the value of the n property.
     * 
     * @param value
     *     allowed object is
     *     {@link VCARDType.N }
     *     
     */
    public void setN(
        @Nullable
        VCARDType.N value) {
        this.n = value;
    }

    /**
     * Gets the value of the label property.
     * 
     * @return
     *     possible object is
     *     {@link VCARDType.LABEL }
     *     
     */
    @Nullable
    public VCARDType.LABEL getLABEL() {
        return label;
    }

    /**
     * Sets the value of the label property.
     * 
     * @param value
     *     allowed object is
     *     {@link VCARDType.LABEL }
     *     
     */
    public void setLABEL(
        @Nullable
        VCARDType.LABEL value) {
        this.label = value;
    }

    /**
     * Gets the value of the tz property.
     * 
     * @return
     *     possible object is
     *     {@link VCARDType.TZ }
     *     
     */
    @Nullable
    public VCARDType.TZ getTZ() {
        return tz;
    }

    /**
     * Sets the value of the tz property.
     * 
     * @param value
     *     allowed object is
     *     {@link VCARDType.TZ }
     *     
     */
    public void setTZ(
        @Nullable
        VCARDType.TZ value) {
        this.tz = value;
    }

    /**
     * Gets the value of the uid property.
     * 
     * @return
     *     possible object is
     *     {@link VCARDType.UID }
     *     
     */
    @Nullable
    public VCARDType.UID getUID() {
        return uid;
    }

    /**
     * Sets the value of the uid property.
     * 
     * @param value
     *     allowed object is
     *     {@link VCARDType.UID }
     *     
     */
    public void setUID(
        @Nullable
        VCARDType.UID value) {
        this.uid = value;
    }

    /**
     * Gets the value of the photo property.
     * 
     * @return
     *     possible object is
     *     {@link BinaryElement }
     *     
     */
    @Nullable
    public BinaryElement getPHOTO() {
        return photo;
    }

    /**
     * Sets the value of the photo property.
     * 
     * @param value
     *     allowed object is
     *     {@link BinaryElement }
     *     
     */
    public void setPHOTO(
        @Nullable
        BinaryElement value) {
        this.photo = value;
    }

    /**
     * Gets the value of the logo property.
     * 
     * @return
     *     possible object is
     *     {@link BinaryElement }
     *     
     */
    @Nullable
    public BinaryElement getLOGO() {
        return logo;
    }

    /**
     * Sets the value of the logo property.
     * 
     * @param value
     *     allowed object is
     *     {@link BinaryElement }
     *     
     */
    public void setLOGO(
        @Nullable
        BinaryElement value) {
        this.logo = value;
    }

    /**
     * Gets the value of the sound property.
     * 
     * @return
     *     possible object is
     *     {@link BinaryElement }
     *     
     */
    @Nullable
    public BinaryElement getSOUND() {
        return sound;
    }

    /**
     * Sets the value of the sound property.
     * 
     * @param value
     *     allowed object is
     *     {@link BinaryElement }
     *     
     */
    public void setSOUND(
        @Nullable
        BinaryElement value) {
        this.sound = value;
    }

    /**
     * Gets the value of the key property.
     * 
     * @return
     *     possible object is
     *     {@link BinaryElement }
     *     
     */
    @Nullable
    public BinaryElement getKEY() {
        return key;
    }

    /**
     * Sets the value of the key property.
     * 
     * @param value
     *     allowed object is
     *     {@link BinaryElement }
     *     
     */
    public void setKEY(
        @Nullable
        BinaryElement value) {
        this.key = value;
    }

    /**
     * Gets the value of the agent property.
     * 
     * @return
     *     possible object is
     *     {@link VCARDType.AGENT }
     *     
     */
    @Nullable
    public VCARDType.AGENT getAGENT() {
        return agent;
    }

    /**
     * Sets the value of the agent property.
     * 
     * @param value
     *     allowed object is
     *     {@link VCARDType.AGENT }
     *     
     */
    public void setAGENT(
        @Nullable
        VCARDType.AGENT value) {
        this.agent = value;
    }

    /**
     * Gets the value of the group property.
     * 
     * @return
     *     possible object is
     *     {@link VCARDType.GROUP }
     *     
     */
    @Nullable
    public VCARDType.GROUP getGROUP() {
        return group;
    }

    /**
     * Sets the value of the group property.
     * 
     * @param value
     *     allowed object is
     *     {@link VCARDType.GROUP }
     *     
     */
    public void setGROUP(
        @Nullable
        VCARDType.GROUP value) {
        this.group = value;
    }

    /**
     * Gets the value of the url property.
     * 
     * @return
     *     possible object is
     *     {@link VCARDType.URL }
     *     
     */
    @Nullable
    public VCARDType.URL getURL() {
        return url;
    }

    /**
     * Sets the value of the url property.
     * 
     * @param value
     *     allowed object is
     *     {@link VCARDType.URL }
     *     
     */
    public void setURL(
        @Nullable
        VCARDType.URL value) {
        this.url = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final VCARDType rhs = ((VCARDType) o);
        if (!EqualsHelper.equals(_class, rhs._class)) {
            return false;
        }
        if (!EqualsHelper.equals(adr, rhs.adr)) {
            return false;
        }
        if (!EqualsHelper.equals(agent, rhs.agent)) {
            return false;
        }
        if (!EqualsHelper.equals(bday, rhs.bday)) {
            return false;
        }
        if (!EqualsHelper.equals(categories, rhs.categories)) {
            return false;
        }
        if (!EqualsHelper.equals(email, rhs.email)) {
            return false;
        }
        if (!EqualsHelper.equals(fn, rhs.fn)) {
            return false;
        }
        if (!EqualsHelper.equals(geo, rhs.geo)) {
            return false;
        }
        if (!EqualsHelper.equals(group, rhs.group)) {
            return false;
        }
        if (!EqualsHelper.equals(key, rhs.key)) {
            return false;
        }
        if (!EqualsHelper.equals(label, rhs.label)) {
            return false;
        }
        if (!EqualsHelper.equals(logo, rhs.logo)) {
            return false;
        }
        if (!EqualsHelper.equals(mailer, rhs.mailer)) {
            return false;
        }
        if (!EqualsHelper.equals(n, rhs.n)) {
            return false;
        }
        if (!EqualsHelper.equals(name, rhs.name)) {
            return false;
        }
        if (!EqualsHelper.equals(nickname, rhs.nickname)) {
            return false;
        }
        if (!EqualsHelper.equals(note, rhs.note)) {
            return false;
        }
        if (!EqualsHelper.equals(org, rhs.org)) {
            return false;
        }
        if (!EqualsHelper.equals(photo, rhs.photo)) {
            return false;
        }
        if (!EqualsHelper.equals(prodid, rhs.prodid)) {
            return false;
        }
        if (!EqualsHelper.equals(rev, rhs.rev)) {
            return false;
        }
        if (!EqualsHelper.equals(role, rhs.role)) {
            return false;
        }
        if (!EqualsHelper.equals(sortstring, rhs.sortstring)) {
            return false;
        }
        if (!EqualsHelper.equals(sound, rhs.sound)) {
            return false;
        }
        if (!EqualsHelper.equals(source, rhs.source)) {
            return false;
        }
        if (!EqualsHelper.equals(tel, rhs.tel)) {
            return false;
        }
        if (!EqualsHelper.equals(title, rhs.title)) {
            return false;
        }
        if (!EqualsHelper.equals(tz, rhs.tz)) {
            return false;
        }
        if (!EqualsHelper.equals(uid, rhs.uid)) {
            return false;
        }
        if (!EqualsHelper.equals(url, rhs.url)) {
            return false;
        }
        if (!EqualsHelper.equals(vcard, rhs.vcard)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(_class).append(adr).append(agent).append(bday).append(categories).append(email).append(fn).append(geo).append(group).append(key).append(label).append(logo).append(mailer).append(n).append(name).append(nickname).append(note).append(org).append(photo).append(prodid).append(rev).append(role).append(sortstring).append(sound).append(source).append(tel).append(title).append(tz).append(uid).append(url).append(vcard).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("_class", _class).append("adr", adr).append("agent", agent).append("bday", bday).append("categories", categories).append("email", email).append("fn", fn).append("geo", geo).append("group", group).append("key", key).append("label", label).append("logo", logo).append("mailer", mailer).append("n", n).append("name", name).append("nickname", nickname).append("note", note).append("org", org).append("photo", photo).append("prodid", prodid).append("rev", rev).append("role", role).append("sortstring", sortstring).append("sound", sound).append("source", source).append("tel", tel).append("title", title).append("tz", tz).append("uid", uid).append("url", url).append("vcard", vcard).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        VCARDType ret) {
        ret._class = ((_class == null)?null:_class.clone());
        ret.adr = ((adr == null)?null:adr.clone());
        ret.agent = ((agent == null)?null:agent.clone());
        ret.bday = ((bday == null)?null:bday.clone());
        ret.categories = ((categories == null)?null:categories.clone());
        ret.email = ((email == null)?null:email.clone());
        ret.fn = ((fn == null)?null:fn.clone());
        ret.geo = ((geo == null)?null:geo.clone());
        ret.group = ((group == null)?null:group.clone());
        ret.key = ((key == null)?null:key.clone());
        ret.label = ((label == null)?null:label.clone());
        ret.logo = ((logo == null)?null:logo.clone());
        ret.mailer = ((mailer == null)?null:mailer.clone());
        ret.n = ((n == null)?null:n.clone());
        ret.name = ((name == null)?null:name.clone());
        ret.nickname = ((nickname == null)?null:nickname.clone());
        ret.note = ((note == null)?null:note.clone());
        ret.org = ((org == null)?null:org.clone());
        ret.photo = ((photo == null)?null:photo.clone());
        ret.prodid = ((prodid == null)?null:prodid.clone());
        ret.rev = ((rev == null)?null:rev.clone());
        ret.role = ((role == null)?null:role.clone());
        ret.sortstring = ((sortstring == null)?null:sortstring.clone());
        ret.sound = ((sound == null)?null:sound.clone());
        ret.source = ((source == null)?null:source.clone());
        ret.tel = ((tel == null)?null:tel.clone());
        ret.title = ((title == null)?null:title.clone());
        ret.tz = ((tz == null)?null:tz.clone());
        ret.uid = ((uid == null)?null:uid.clone());
        ret.url = ((url == null)?null:url.clone());
        ret.vcard = ((vcard == null)?null:vcard.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public VCARDType clone() {
        VCARDType ret = new VCARDType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SimpleElement and never <code>null</code>
     */
    @Nonnull
    public SimpleElement setFN(
        @Nullable
        final String valueParam) {
        SimpleElement aObj = getFN();
        if (aObj == null) {
            aObj = new SimpleElement(valueParam);
            setFN(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SimpleElement and never <code>null</code>
     */
    @Nonnull
    public SimpleElement setNICKNAME(
        @Nullable
        final String valueParam) {
        SimpleElement aObj = getNICKNAME();
        if (aObj == null) {
            aObj = new SimpleElement(valueParam);
            setNICKNAME(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SimpleElement and never <code>null</code>
     */
    @Nonnull
    public SimpleElement setBDAY(
        @Nullable
        final String valueParam) {
        SimpleElement aObj = getBDAY();
        if (aObj == null) {
            aObj = new SimpleElement(valueParam);
            setBDAY(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SimpleElement and never <code>null</code>
     */
    @Nonnull
    public SimpleElement setMAILER(
        @Nullable
        final String valueParam) {
        SimpleElement aObj = getMAILER();
        if (aObj == null) {
            aObj = new SimpleElement(valueParam);
            setMAILER(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SimpleElement and never <code>null</code>
     */
    @Nonnull
    public SimpleElement setGEO(
        @Nullable
        final String valueParam) {
        SimpleElement aObj = getGEO();
        if (aObj == null) {
            aObj = new SimpleElement(valueParam);
            setGEO(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SimpleElement and never <code>null</code>
     */
    @Nonnull
    public SimpleElement setTITLE(
        @Nullable
        final String valueParam) {
        SimpleElement aObj = getTITLE();
        if (aObj == null) {
            aObj = new SimpleElement(valueParam);
            setTITLE(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SimpleElement and never <code>null</code>
     */
    @Nonnull
    public SimpleElement setROLE(
        @Nullable
        final String valueParam) {
        SimpleElement aObj = getROLE();
        if (aObj == null) {
            aObj = new SimpleElement(valueParam);
            setROLE(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SimpleElement and never <code>null</code>
     */
    @Nonnull
    public SimpleElement setCATEGORIES(
        @Nullable
        final String valueParam) {
        SimpleElement aObj = getCATEGORIES();
        if (aObj == null) {
            aObj = new SimpleElement(valueParam);
            setCATEGORIES(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SimpleElement and never <code>null</code>
     */
    @Nonnull
    public SimpleElement setNAME(
        @Nullable
        final String valueParam) {
        SimpleElement aObj = getNAME();
        if (aObj == null) {
            aObj = new SimpleElement(valueParam);
            setNAME(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SimpleElement and never <code>null</code>
     */
    @Nonnull
    public SimpleElement setSOURCE(
        @Nullable
        final String valueParam) {
        SimpleElement aObj = getSOURCE();
        if (aObj == null) {
            aObj = new SimpleElement(valueParam);
            setSOURCE(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SimpleElement and never <code>null</code>
     */
    @Nonnull
    public SimpleElement setNOTE(
        @Nullable
        final String valueParam) {
        SimpleElement aObj = getNOTE();
        if (aObj == null) {
            aObj = new SimpleElement(valueParam);
            setNOTE(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SimpleElement and never <code>null</code>
     */
    @Nonnull
    public SimpleElement setPRODID(
        @Nullable
        final String valueParam) {
        SimpleElement aObj = getPRODID();
        if (aObj == null) {
            aObj = new SimpleElement(valueParam);
            setPRODID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SimpleElement and never <code>null</code>
     */
    @Nonnull
    public SimpleElement setREV(
        @Nullable
        final String valueParam) {
        SimpleElement aObj = getREV();
        if (aObj == null) {
            aObj = new SimpleElement(valueParam);
            setREV(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SimpleElement and never <code>null</code>
     */
    @Nonnull
    public SimpleElement setSORTSTRING(
        @Nullable
        final String valueParam) {
        SimpleElement aObj = getSORTSTRING();
        if (aObj == null) {
            aObj = new SimpleElement(valueParam);
            setSORTSTRING(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SimpleElement and never <code>null</code>
     */
    @Nonnull
    public SimpleElement setCLASS(
        @Nullable
        final String valueParam) {
        SimpleElement aObj = getCLASS();
        if (aObj == null) {
            aObj = new SimpleElement(valueParam);
            setCLASS(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type byte[]<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type BinaryElement and never <code>null</code>
     */
    @Nonnull
    public BinaryElement setPHOTO(
        @Nullable
        final byte[] valueParam) {
        BinaryElement aObj = getPHOTO();
        if (aObj == null) {
            aObj = new BinaryElement(valueParam);
            setPHOTO(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type byte[]<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type BinaryElement and never <code>null</code>
     */
    @Nonnull
    public BinaryElement setLOGO(
        @Nullable
        final byte[] valueParam) {
        BinaryElement aObj = getLOGO();
        if (aObj == null) {
            aObj = new BinaryElement(valueParam);
            setLOGO(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type byte[]<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type BinaryElement and never <code>null</code>
     */
    @Nonnull
    public BinaryElement setSOUND(
        @Nullable
        final byte[] valueParam) {
        BinaryElement aObj = getSOUND();
        if (aObj == null) {
            aObj = new BinaryElement(valueParam);
            setSOUND(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type byte[]<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type BinaryElement and never <code>null</code>
     */
    @Nonnull
    public BinaryElement setKEY(
        @Nullable
        final byte[] valueParam) {
        BinaryElement aObj = getKEY();
        if (aObj == null) {
            aObj = new BinaryElement(valueParam);
            setKEY(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TEL and never <code>null</code>
     */
    @Nonnull
    public VCARDType.TEL setTEL(
        @Nullable
        final String valueParam) {
        VCARDType.TEL aObj = getTEL();
        if (aObj == null) {
            aObj = new VCARDType.TEL(valueParam);
            setTEL(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EMAIL and never <code>null</code>
     */
    @Nonnull
    public VCARDType.EMAIL setEMAIL(
        @Nullable
        final String valueParam) {
        VCARDType.EMAIL aObj = getEMAIL();
        if (aObj == null) {
            aObj = new VCARDType.EMAIL(valueParam);
            setEMAIL(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TZ and never <code>null</code>
     */
    @Nonnull
    public VCARDType.TZ setTZ(
        @Nullable
        final String valueParam) {
        VCARDType.TZ aObj = getTZ();
        if (aObj == null) {
            aObj = new VCARDType.TZ(valueParam);
            setTZ(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type UID and never <code>null</code>
     */
    @Nonnull
    public VCARDType.UID setUID(
        @Nullable
        final String valueParam) {
        VCARDType.UID aObj = getUID();
        if (aObj == null) {
            aObj = new VCARDType.UID(valueParam);
            setUID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained SimpleElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SimpleElement object or <code>null</code>
     */
    @Nullable
    public String getFNValue() {
        SimpleElement aObj = getFN();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained SimpleElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SimpleElement object or <code>null</code>
     */
    @Nullable
    public String getNICKNAMEValue() {
        SimpleElement aObj = getNICKNAME();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained SimpleElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SimpleElement object or <code>null</code>
     */
    @Nullable
    public String getBDAYValue() {
        SimpleElement aObj = getBDAY();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained SimpleElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SimpleElement object or <code>null</code>
     */
    @Nullable
    public String getMAILERValue() {
        SimpleElement aObj = getMAILER();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained SimpleElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SimpleElement object or <code>null</code>
     */
    @Nullable
    public String getGEOValue() {
        SimpleElement aObj = getGEO();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained SimpleElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SimpleElement object or <code>null</code>
     */
    @Nullable
    public String getTITLEValue() {
        SimpleElement aObj = getTITLE();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained SimpleElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SimpleElement object or <code>null</code>
     */
    @Nullable
    public String getROLEValue() {
        SimpleElement aObj = getROLE();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained SimpleElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SimpleElement object or <code>null</code>
     */
    @Nullable
    public String getCATEGORIESValue() {
        SimpleElement aObj = getCATEGORIES();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained SimpleElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SimpleElement object or <code>null</code>
     */
    @Nullable
    public String getNAMEValue() {
        SimpleElement aObj = getNAME();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained SimpleElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SimpleElement object or <code>null</code>
     */
    @Nullable
    public String getSOURCEValue() {
        SimpleElement aObj = getSOURCE();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained SimpleElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SimpleElement object or <code>null</code>
     */
    @Nullable
    public String getNOTEValue() {
        SimpleElement aObj = getNOTE();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained SimpleElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SimpleElement object or <code>null</code>
     */
    @Nullable
    public String getPRODIDValue() {
        SimpleElement aObj = getPRODID();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained SimpleElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SimpleElement object or <code>null</code>
     */
    @Nullable
    public String getREVValue() {
        SimpleElement aObj = getREV();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained SimpleElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SimpleElement object or <code>null</code>
     */
    @Nullable
    public String getSORTSTRINGValue() {
        SimpleElement aObj = getSORTSTRING();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained SimpleElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SimpleElement object or <code>null</code>
     */
    @Nullable
    public String getCLASSValue() {
        SimpleElement aObj = getCLASS();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TEL object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TEL object or <code>null</code>
     */
    @Nullable
    public String getTELValue() {
        VCARDType.TEL aObj = getTEL();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained EMAIL object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EMAIL object or <code>null</code>
     */
    @Nullable
    public String getEMAILValue() {
        VCARDType.EMAIL aObj = getEMAIL();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TZ object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TZ object or <code>null</code>
     */
    @Nullable
    public String getTZValue() {
        VCARDType.TZ aObj = getTZ();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained UID object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained UID object or <code>null</code>
     */
    @Nullable
    public String getUIDValue() {
        VCARDType.UID aObj = getUID();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained BinaryElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained BinaryElement object or <code>null</code>
     */
    @Nullable
    public byte[] getPHOTOValue() {
        BinaryElement aObj = getPHOTO();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained BinaryElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained BinaryElement object or <code>null</code>
     */
    @Nullable
    public byte[] getLOGOValue() {
        BinaryElement aObj = getLOGO();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained BinaryElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained BinaryElement object or <code>null</code>
     */
    @Nullable
    public byte[] getSOUNDValue() {
        BinaryElement aObj = getSOUND();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained BinaryElement object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained BinaryElement object or <code>null</code>
     */
    @Nullable
    public byte[] getKEYValue() {
        BinaryElement aObj = getKEY();
        return ((aObj == null)?null:aObj.getValue());
    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;element name="Pobox" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
     *         &lt;element name="Extadd" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
     *         &lt;element name="Street" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
     *         &lt;element name="Locality" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
     *         &lt;element name="Region" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
     *         &lt;element name="Pcode" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
     *         &lt;element name="Country" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
     *       &lt;/sequence&gt;
     *       &lt;attribute name="TYPE" default="intl postal parcel work"&gt;
     *         &lt;simpleType&gt;
     *           &lt;list&gt;
     *             &lt;simpleType&gt;
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
     *                 &lt;enumeration value="dom"/&gt;
     *                 &lt;enumeration value="intl"/&gt;
     *                 &lt;enumeration value="postal"/&gt;
     *                 &lt;enumeration value="parcel"/&gt;
     *                 &lt;enumeration value="home"/&gt;
     *                 &lt;enumeration value="work"/&gt;
     *                 &lt;enumeration value="pref"/&gt;
     *               &lt;/restriction&gt;
     *             &lt;/simpleType&gt;
     *           &lt;/list&gt;
     *         &lt;/simpleType&gt;
     *       &lt;/attribute&gt;
     *       &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "pobox",
        "extadd",
        "street",
        "locality",
        "region",
        "pcode",
        "country"
    })
    @CodingStyleguideUnaware
    public static class ADR implements Serializable, IExplicitlyCloneable
    {

        @XmlElement(name = "Pobox")
        private List<SimpleElement> pobox;
        @XmlElement(name = "Extadd")
        private List<SimpleElement> extadd;
        @XmlElement(name = "Street")
        private List<SimpleElement> street;
        @XmlElement(name = "Locality")
        private List<SimpleElement> locality;
        @XmlElement(name = "Region")
        private List<SimpleElement> region;
        @XmlElement(name = "Pcode")
        private List<SimpleElement> pcode;
        @XmlElement(name = "Country")
        private List<SimpleElement> country;
        @XmlAttribute(name = "TYPE", namespace = "http://www.w3.org/2001/vcard-rdf/3.0#")
        private List<String> type;
        @XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
        private String lang;

        /**
         * Default constructor<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public ADR() {
        }

        /**
         * Gets the value of the pobox property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the pobox property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getPobox().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link SimpleElement }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<SimpleElement> getPobox() {
            if (pobox == null) {
                pobox = new ArrayList<SimpleElement>();
            }
            return this.pobox;
        }

        /**
         * Gets the value of the extadd property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the extadd property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getExtadd().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link SimpleElement }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<SimpleElement> getExtadd() {
            if (extadd == null) {
                extadd = new ArrayList<SimpleElement>();
            }
            return this.extadd;
        }

        /**
         * Gets the value of the street property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the street property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getStreet().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link SimpleElement }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<SimpleElement> getStreet() {
            if (street == null) {
                street = new ArrayList<SimpleElement>();
            }
            return this.street;
        }

        /**
         * Gets the value of the locality property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the locality property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getLocality().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link SimpleElement }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<SimpleElement> getLocality() {
            if (locality == null) {
                locality = new ArrayList<SimpleElement>();
            }
            return this.locality;
        }

        /**
         * Gets the value of the region property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the region property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getRegion().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link SimpleElement }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<SimpleElement> getRegion() {
            if (region == null) {
                region = new ArrayList<SimpleElement>();
            }
            return this.region;
        }

        /**
         * Gets the value of the pcode property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the pcode property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getPcode().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link SimpleElement }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<SimpleElement> getPcode() {
            if (pcode == null) {
                pcode = new ArrayList<SimpleElement>();
            }
            return this.pcode;
        }

        /**
         * Gets the value of the country property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the country property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getCountry().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link SimpleElement }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<SimpleElement> getCountry() {
            if (country == null) {
                country = new ArrayList<SimpleElement>();
            }
            return this.country;
        }

        /**
         * Gets the value of the type property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the type property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getTYPE().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link String }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<String> getTYPE() {
            if (type == null) {
                type = new ArrayList<String>();
            }
            return this.type;
        }

        /**
         * Gets the value of the lang property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getLang() {
            return lang;
        }

        /**
         * Sets the value of the lang property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setLang(
            @Nullable
            String value) {
            this.lang = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if ((o == null)||(!getClass().equals(o.getClass()))) {
                return false;
            }
            final VCARDType.ADR rhs = ((VCARDType.ADR) o);
            if (!EqualsHelper.equalsCollection(country, rhs.country)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(extadd, rhs.extadd)) {
                return false;
            }
            if (!EqualsHelper.equals(lang, rhs.lang)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(locality, rhs.locality)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(pcode, rhs.pcode)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(pobox, rhs.pobox)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(region, rhs.region)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(street, rhs.street)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(type, rhs.type)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return new HashCodeGenerator(this).append(country).append(extadd).append(lang).append(locality).append(pcode).append(pobox).append(region).append(street).append(type).getHashCode();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return new ToStringGenerator(this).append("country", country).append("extadd", extadd).append("lang", lang).append("locality", locality).append("pcode", pcode).append("pobox", pobox).append("region", region).append("street", street).append("type", type).getToString();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setPobox(
            @Nullable
            final List<SimpleElement> aList) {
            pobox = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setExtadd(
            @Nullable
            final List<SimpleElement> aList) {
            extadd = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setStreet(
            @Nullable
            final List<SimpleElement> aList) {
            street = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setLocality(
            @Nullable
            final List<SimpleElement> aList) {
            locality = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setRegion(
            @Nullable
            final List<SimpleElement> aList) {
            region = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setPcode(
            @Nullable
            final List<SimpleElement> aList) {
            pcode = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setCountry(
            @Nullable
            final List<SimpleElement> aList) {
            country = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setTYPE(
            @Nullable
            final List<String> aList) {
            type = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasPoboxEntries() {
            return (!getPobox().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoPoboxEntries() {
            return getPobox().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getPoboxCount() {
            return getPobox().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public SimpleElement getPoboxAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getPobox().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addPobox(
            @Nonnull
            final SimpleElement elem) {
            getPobox().add(elem);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasExtaddEntries() {
            return (!getExtadd().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoExtaddEntries() {
            return getExtadd().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getExtaddCount() {
            return getExtadd().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public SimpleElement getExtaddAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getExtadd().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addExtadd(
            @Nonnull
            final SimpleElement elem) {
            getExtadd().add(elem);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasStreetEntries() {
            return (!getStreet().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoStreetEntries() {
            return getStreet().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getStreetCount() {
            return getStreet().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public SimpleElement getStreetAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getStreet().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addStreet(
            @Nonnull
            final SimpleElement elem) {
            getStreet().add(elem);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasLocalityEntries() {
            return (!getLocality().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoLocalityEntries() {
            return getLocality().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getLocalityCount() {
            return getLocality().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public SimpleElement getLocalityAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getLocality().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addLocality(
            @Nonnull
            final SimpleElement elem) {
            getLocality().add(elem);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasRegionEntries() {
            return (!getRegion().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoRegionEntries() {
            return getRegion().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getRegionCount() {
            return getRegion().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public SimpleElement getRegionAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getRegion().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addRegion(
            @Nonnull
            final SimpleElement elem) {
            getRegion().add(elem);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasPcodeEntries() {
            return (!getPcode().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoPcodeEntries() {
            return getPcode().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getPcodeCount() {
            return getPcode().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public SimpleElement getPcodeAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getPcode().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addPcode(
            @Nonnull
            final SimpleElement elem) {
            getPcode().add(elem);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasCountryEntries() {
            return (!getCountry().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoCountryEntries() {
            return getCountry().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getCountryCount() {
            return getCountry().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public SimpleElement getCountryAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getCountry().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addCountry(
            @Nonnull
            final SimpleElement elem) {
            getCountry().add(elem);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasTYPEEntries() {
            return (!getTYPE().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoTYPEEntries() {
            return getTYPE().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getTYPECount() {
            return getTYPE().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public String getTYPEAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getTYPE().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addTYPE(
            @Nonnull
            final String elem) {
            getTYPE().add(elem);
        }

        /**
         * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be <code>null</code>.
         */
        public void cloneTo(
            @Nonnull
            VCARDType.ADR ret) {
            if (country == null) {
                ret.country = null;
            } else {
                List<SimpleElement> retCountry = new ArrayList<SimpleElement>();
                for (SimpleElement aItem: getCountry()) {
                    retCountry.add(((aItem == null)?null:aItem.clone()));
                }
                ret.country = retCountry;
            }
            if (extadd == null) {
                ret.extadd = null;
            } else {
                List<SimpleElement> retExtadd = new ArrayList<SimpleElement>();
                for (SimpleElement aItem: getExtadd()) {
                    retExtadd.add(((aItem == null)?null:aItem.clone()));
                }
                ret.extadd = retExtadd;
            }
            ret.lang = lang;
            if (locality == null) {
                ret.locality = null;
            } else {
                List<SimpleElement> retLocality = new ArrayList<SimpleElement>();
                for (SimpleElement aItem: getLocality()) {
                    retLocality.add(((aItem == null)?null:aItem.clone()));
                }
                ret.locality = retLocality;
            }
            if (pcode == null) {
                ret.pcode = null;
            } else {
                List<SimpleElement> retPcode = new ArrayList<SimpleElement>();
                for (SimpleElement aItem: getPcode()) {
                    retPcode.add(((aItem == null)?null:aItem.clone()));
                }
                ret.pcode = retPcode;
            }
            if (pobox == null) {
                ret.pobox = null;
            } else {
                List<SimpleElement> retPobox = new ArrayList<SimpleElement>();
                for (SimpleElement aItem: getPobox()) {
                    retPobox.add(((aItem == null)?null:aItem.clone()));
                }
                ret.pobox = retPobox;
            }
            if (region == null) {
                ret.region = null;
            } else {
                List<SimpleElement> retRegion = new ArrayList<SimpleElement>();
                for (SimpleElement aItem: getRegion()) {
                    retRegion.add(((aItem == null)?null:aItem.clone()));
                }
                ret.region = retRegion;
            }
            if (street == null) {
                ret.street = null;
            } else {
                List<SimpleElement> retStreet = new ArrayList<SimpleElement>();
                for (SimpleElement aItem: getStreet()) {
                    retStreet.add(((aItem == null)?null:aItem.clone()));
                }
                ret.street = retStreet;
            }
            if (type == null) {
                ret.type = null;
            } else {
                List<String> retTYPE = new ArrayList<String>();
                for (String aItem: getTYPE()) {
                    retTYPE.add(aItem);
                }
                ret.type = retTYPE;
            }
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never <code>null</code>.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public VCARDType.ADR clone() {
            VCARDType.ADR ret = new VCARDType.ADR();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;any namespace='http://www.w3.org/2001/vcard-rdf/3.0#' maxOccurs="unbounded" minOccurs="0"/&gt;
     *       &lt;/sequence&gt;
     *       &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "any"
    })
    @CodingStyleguideUnaware
    public static class AGENT implements Serializable, IExplicitlyCloneable
    {

        @XmlAnyElement(lax = true)
        private List<Object> any;
        @XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
        private String lang;

        /**
         * Default constructor<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public AGENT() {
        }

        /**
         * Gets the value of the any property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the any property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getAny().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link Object }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<Object> getAny() {
            if (any == null) {
                any = new ArrayList<Object>();
            }
            return this.any;
        }

        /**
         * Gets the value of the lang property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getLang() {
            return lang;
        }

        /**
         * Sets the value of the lang property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setLang(
            @Nullable
            String value) {
            this.lang = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if ((o == null)||(!getClass().equals(o.getClass()))) {
                return false;
            }
            final VCARDType.AGENT rhs = ((VCARDType.AGENT) o);
            if (!EqualsHelper.equalsCollection(any, rhs.any)) {
                return false;
            }
            if (!EqualsHelper.equals(lang, rhs.lang)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return new HashCodeGenerator(this).append(any).append(lang).getHashCode();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return new ToStringGenerator(this).append("any", any).append("lang", lang).getToString();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setAny(
            @Nullable
            final List<Object> aList) {
            any = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasAnyEntries() {
            return (!getAny().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoAnyEntries() {
            return getAny().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getAnyCount() {
            return getAny().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public Object getAnyAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getAny().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addAny(
            @Nonnull
            final Object elem) {
            getAny().add(elem);
        }

        /**
         * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be <code>null</code>.
         */
        public void cloneTo(
            @Nonnull
            VCARDType.AGENT ret) {
            if (any == null) {
                ret.any = null;
            } else {
                List<Object> retAny = new ArrayList<Object>();
                for (Object aItem: getAny()) {
                    retAny.add(aItem);
                }
                ret.any = retAny;
            }
            ret.lang = lang;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never <code>null</code>.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public VCARDType.AGENT clone() {
            VCARDType.AGENT ret = new VCARDType.AGENT();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType&gt;
     *   &lt;simpleContent&gt;
     *     &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema&gt;string"&gt;
     *       &lt;attribute name="TYPE" default="internet"&gt;
     *         &lt;simpleType&gt;
     *           &lt;list&gt;
     *             &lt;simpleType&gt;
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
     *                 &lt;enumeration value="internet"/&gt;
     *                 &lt;enumeration value="x400"/&gt;
     *                 &lt;enumeration value="pref"/&gt;
     *               &lt;/restriction&gt;
     *             &lt;/simpleType&gt;
     *           &lt;/list&gt;
     *         &lt;/simpleType&gt;
     *       &lt;/attribute&gt;
     *       &lt;attribute name="OTHERTYPE" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
     *       &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
     *     &lt;/extension&gt;
     *   &lt;/simpleContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    @CodingStyleguideUnaware
    public static class EMAIL implements Serializable, IExplicitlyCloneable
    {

        @XmlValue
        private String value;
        @XmlAttribute(name = "TYPE", namespace = "http://www.w3.org/2001/vcard-rdf/3.0#")
        private List<String> type;
        @XmlAttribute(name = "OTHERTYPE", namespace = "http://www.w3.org/2001/vcard-rdf/3.0#")
        private String othertype;
        @XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
        private String lang;

        /**
         * Default constructor<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public EMAIL() {
        }

        /**
         * Constructor for value of type String<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         * @param valueParam
         *     The value to be set. May be <code>null</code>.
         */
        public EMAIL(
            @Nullable
            final String valueParam) {
            setValue(valueParam);
        }

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setValue(
            @Nullable
            String value) {
            this.value = value;
        }

        /**
         * Gets the value of the type property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the type property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getTYPE().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link String }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<String> getTYPE() {
            if (type == null) {
                type = new ArrayList<String>();
            }
            return this.type;
        }

        /**
         * Gets the value of the othertype property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getOTHERTYPE() {
            return othertype;
        }

        /**
         * Sets the value of the othertype property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setOTHERTYPE(
            @Nullable
            String value) {
            this.othertype = value;
        }

        /**
         * Gets the value of the lang property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getLang() {
            return lang;
        }

        /**
         * Sets the value of the lang property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setLang(
            @Nullable
            String value) {
            this.lang = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if ((o == null)||(!getClass().equals(o.getClass()))) {
                return false;
            }
            final VCARDType.EMAIL rhs = ((VCARDType.EMAIL) o);
            if (!EqualsHelper.equals(lang, rhs.lang)) {
                return false;
            }
            if (!EqualsHelper.equals(othertype, rhs.othertype)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(type, rhs.type)) {
                return false;
            }
            if (!EqualsHelper.equals(value, rhs.value)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return new HashCodeGenerator(this).append(lang).append(othertype).append(type).append(value).getHashCode();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return new ToStringGenerator(this).append("lang", lang).append("othertype", othertype).append("type", type).append("value", value).getToString();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setTYPE(
            @Nullable
            final List<String> aList) {
            type = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasTYPEEntries() {
            return (!getTYPE().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoTYPEEntries() {
            return getTYPE().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getTYPECount() {
            return getTYPE().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public String getTYPEAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getTYPE().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addTYPE(
            @Nonnull
            final String elem) {
            getTYPE().add(elem);
        }

        /**
         * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be <code>null</code>.
         */
        public void cloneTo(
            @Nonnull
            VCARDType.EMAIL ret) {
            ret.lang = lang;
            ret.othertype = othertype;
            if (type == null) {
                ret.type = null;
            } else {
                List<String> retTYPE = new ArrayList<String>();
                for (String aItem: getTYPE()) {
                    retTYPE.add(aItem);
                }
                ret.type = retTYPE;
            }
            ret.value = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never <code>null</code>.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public VCARDType.EMAIL clone() {
            VCARDType.EMAIL ret = new VCARDType.EMAIL();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;any namespace='http://www.w3.org/2001/vcard-rdf/3.0#' maxOccurs="unbounded" minOccurs="0"/&gt;
     *       &lt;/sequence&gt;
     *       &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "any"
    })
    @CodingStyleguideUnaware
    public static class GROUP implements Serializable, IExplicitlyCloneable
    {

        @XmlAnyElement(lax = true)
        private List<Object> any;
        @XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
        private String lang;

        /**
         * Default constructor<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public GROUP() {
        }

        /**
         * Gets the value of the any property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the any property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getAny().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link Object }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<Object> getAny() {
            if (any == null) {
                any = new ArrayList<Object>();
            }
            return this.any;
        }

        /**
         * Gets the value of the lang property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getLang() {
            return lang;
        }

        /**
         * Sets the value of the lang property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setLang(
            @Nullable
            String value) {
            this.lang = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if ((o == null)||(!getClass().equals(o.getClass()))) {
                return false;
            }
            final VCARDType.GROUP rhs = ((VCARDType.GROUP) o);
            if (!EqualsHelper.equalsCollection(any, rhs.any)) {
                return false;
            }
            if (!EqualsHelper.equals(lang, rhs.lang)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return new HashCodeGenerator(this).append(any).append(lang).getHashCode();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return new ToStringGenerator(this).append("any", any).append("lang", lang).getToString();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setAny(
            @Nullable
            final List<Object> aList) {
            any = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasAnyEntries() {
            return (!getAny().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoAnyEntries() {
            return getAny().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getAnyCount() {
            return getAny().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public Object getAnyAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getAny().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addAny(
            @Nonnull
            final Object elem) {
            getAny().add(elem);
        }

        /**
         * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be <code>null</code>.
         */
        public void cloneTo(
            @Nonnull
            VCARDType.GROUP ret) {
            if (any == null) {
                ret.any = null;
            } else {
                List<Object> retAny = new ArrayList<Object>();
                for (Object aItem: getAny()) {
                    retAny.add(aItem);
                }
                ret.any = retAny;
            }
            ret.lang = lang;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never <code>null</code>.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public VCARDType.GROUP clone() {
            VCARDType.GROUP ret = new VCARDType.GROUP();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;any processContents='lax' maxOccurs="0" minOccurs="0"/&gt;
     *       &lt;/sequence&gt;
     *       &lt;attribute name="TYPE" default="intl postal parcel work"&gt;
     *         &lt;simpleType&gt;
     *           &lt;list&gt;
     *             &lt;simpleType&gt;
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
     *                 &lt;enumeration value="dom"/&gt;
     *                 &lt;enumeration value="intl"/&gt;
     *                 &lt;enumeration value="postal"/&gt;
     *                 &lt;enumeration value="parcel"/&gt;
     *                 &lt;enumeration value="home"/&gt;
     *                 &lt;enumeration value="work"/&gt;
     *                 &lt;enumeration value="pref"/&gt;
     *               &lt;/restriction&gt;
     *             &lt;/simpleType&gt;
     *           &lt;/list&gt;
     *         &lt;/simpleType&gt;
     *       &lt;/attribute&gt;
     *       &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "content"
    })
    @CodingStyleguideUnaware
    public static class LABEL implements Serializable, IExplicitlyCloneable
    {

        @XmlMixed
        private List<String> content;
        @XmlAttribute(name = "TYPE", namespace = "http://www.w3.org/2001/vcard-rdf/3.0#")
        private List<String> type;
        @XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
        private String lang;

        /**
         * Default constructor<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public LABEL() {
        }

        /**
         * Gets the value of the content property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the content property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getContent().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link String }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<String> getContent() {
            if (content == null) {
                content = new ArrayList<String>();
            }
            return this.content;
        }

        /**
         * Gets the value of the type property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the type property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getTYPE().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link String }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<String> getTYPE() {
            if (type == null) {
                type = new ArrayList<String>();
            }
            return this.type;
        }

        /**
         * Gets the value of the lang property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getLang() {
            return lang;
        }

        /**
         * Sets the value of the lang property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setLang(
            @Nullable
            String value) {
            this.lang = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if ((o == null)||(!getClass().equals(o.getClass()))) {
                return false;
            }
            final VCARDType.LABEL rhs = ((VCARDType.LABEL) o);
            if (!EqualsHelper.equalsCollection(content, rhs.content)) {
                return false;
            }
            if (!EqualsHelper.equals(lang, rhs.lang)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(type, rhs.type)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return new HashCodeGenerator(this).append(content).append(lang).append(type).getHashCode();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return new ToStringGenerator(this).append("content", content).append("lang", lang).append("type", type).getToString();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setContent(
            @Nullable
            final List<String> aList) {
            content = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setTYPE(
            @Nullable
            final List<String> aList) {
            type = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasContentEntries() {
            return (!getContent().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoContentEntries() {
            return getContent().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getContentCount() {
            return getContent().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public String getContentAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getContent().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addContent(
            @Nonnull
            final String elem) {
            getContent().add(elem);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasTYPEEntries() {
            return (!getTYPE().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoTYPEEntries() {
            return getTYPE().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getTYPECount() {
            return getTYPE().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public String getTYPEAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getTYPE().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addTYPE(
            @Nonnull
            final String elem) {
            getTYPE().add(elem);
        }

        /**
         * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be <code>null</code>.
         */
        public void cloneTo(
            @Nonnull
            VCARDType.LABEL ret) {
            if (content == null) {
                ret.content = null;
            } else {
                List<String> retContent = new ArrayList<String>();
                for (String aItem: getContent()) {
                    retContent.add(aItem);
                }
                ret.content = retContent;
            }
            ret.lang = lang;
            if (type == null) {
                ret.type = null;
            } else {
                List<String> retTYPE = new ArrayList<String>();
                for (String aItem: getTYPE()) {
                    retTYPE.add(aItem);
                }
                ret.type = retTYPE;
            }
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never <code>null</code>.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public VCARDType.LABEL clone() {
            VCARDType.LABEL ret = new VCARDType.LABEL();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;element name="Family" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
     *         &lt;element name="Given" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
     *         &lt;element name="Other" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
     *         &lt;element name="Prefix" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
     *         &lt;element name="Suffix" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
     *       &lt;/sequence&gt;
     *       &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "family",
        "given",
        "other",
        "prefix",
        "suffix"
    })
    @CodingStyleguideUnaware
    public static class N implements Serializable, IExplicitlyCloneable
    {

        @XmlElement(name = "Family")
        private List<SimpleElement> family;
        @XmlElement(name = "Given")
        private List<SimpleElement> given;
        @XmlElement(name = "Other")
        private List<SimpleElement> other;
        @XmlElement(name = "Prefix")
        private List<SimpleElement> prefix;
        @XmlElement(name = "Suffix")
        private List<SimpleElement> suffix;
        @XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
        private String lang;

        /**
         * Default constructor<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public N() {
        }

        /**
         * Gets the value of the family property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the family property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getFamily().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link SimpleElement }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<SimpleElement> getFamily() {
            if (family == null) {
                family = new ArrayList<SimpleElement>();
            }
            return this.family;
        }

        /**
         * Gets the value of the given property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the given property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getGiven().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link SimpleElement }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<SimpleElement> getGiven() {
            if (given == null) {
                given = new ArrayList<SimpleElement>();
            }
            return this.given;
        }

        /**
         * Gets the value of the other property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the other property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getOther().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link SimpleElement }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<SimpleElement> getOther() {
            if (other == null) {
                other = new ArrayList<SimpleElement>();
            }
            return this.other;
        }

        /**
         * Gets the value of the prefix property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the prefix property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getPrefix().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link SimpleElement }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<SimpleElement> getPrefix() {
            if (prefix == null) {
                prefix = new ArrayList<SimpleElement>();
            }
            return this.prefix;
        }

        /**
         * Gets the value of the suffix property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the suffix property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getSuffix().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link SimpleElement }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<SimpleElement> getSuffix() {
            if (suffix == null) {
                suffix = new ArrayList<SimpleElement>();
            }
            return this.suffix;
        }

        /**
         * Gets the value of the lang property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getLang() {
            return lang;
        }

        /**
         * Sets the value of the lang property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setLang(
            @Nullable
            String value) {
            this.lang = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if ((o == null)||(!getClass().equals(o.getClass()))) {
                return false;
            }
            final VCARDType.N rhs = ((VCARDType.N) o);
            if (!EqualsHelper.equalsCollection(family, rhs.family)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(given, rhs.given)) {
                return false;
            }
            if (!EqualsHelper.equals(lang, rhs.lang)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(other, rhs.other)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(prefix, rhs.prefix)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(suffix, rhs.suffix)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return new HashCodeGenerator(this).append(family).append(given).append(lang).append(other).append(prefix).append(suffix).getHashCode();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return new ToStringGenerator(this).append("family", family).append("given", given).append("lang", lang).append("other", other).append("prefix", prefix).append("suffix", suffix).getToString();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setFamily(
            @Nullable
            final List<SimpleElement> aList) {
            family = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setGiven(
            @Nullable
            final List<SimpleElement> aList) {
            given = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setOther(
            @Nullable
            final List<SimpleElement> aList) {
            other = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setPrefix(
            @Nullable
            final List<SimpleElement> aList) {
            prefix = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setSuffix(
            @Nullable
            final List<SimpleElement> aList) {
            suffix = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasFamilyEntries() {
            return (!getFamily().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoFamilyEntries() {
            return getFamily().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getFamilyCount() {
            return getFamily().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public SimpleElement getFamilyAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getFamily().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addFamily(
            @Nonnull
            final SimpleElement elem) {
            getFamily().add(elem);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasGivenEntries() {
            return (!getGiven().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoGivenEntries() {
            return getGiven().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getGivenCount() {
            return getGiven().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public SimpleElement getGivenAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getGiven().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addGiven(
            @Nonnull
            final SimpleElement elem) {
            getGiven().add(elem);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasOtherEntries() {
            return (!getOther().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoOtherEntries() {
            return getOther().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getOtherCount() {
            return getOther().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public SimpleElement getOtherAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getOther().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addOther(
            @Nonnull
            final SimpleElement elem) {
            getOther().add(elem);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasPrefixEntries() {
            return (!getPrefix().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoPrefixEntries() {
            return getPrefix().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getPrefixCount() {
            return getPrefix().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public SimpleElement getPrefixAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getPrefix().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addPrefix(
            @Nonnull
            final SimpleElement elem) {
            getPrefix().add(elem);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasSuffixEntries() {
            return (!getSuffix().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoSuffixEntries() {
            return getSuffix().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getSuffixCount() {
            return getSuffix().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public SimpleElement getSuffixAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getSuffix().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addSuffix(
            @Nonnull
            final SimpleElement elem) {
            getSuffix().add(elem);
        }

        /**
         * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be <code>null</code>.
         */
        public void cloneTo(
            @Nonnull
            VCARDType.N ret) {
            if (family == null) {
                ret.family = null;
            } else {
                List<SimpleElement> retFamily = new ArrayList<SimpleElement>();
                for (SimpleElement aItem: getFamily()) {
                    retFamily.add(((aItem == null)?null:aItem.clone()));
                }
                ret.family = retFamily;
            }
            if (given == null) {
                ret.given = null;
            } else {
                List<SimpleElement> retGiven = new ArrayList<SimpleElement>();
                for (SimpleElement aItem: getGiven()) {
                    retGiven.add(((aItem == null)?null:aItem.clone()));
                }
                ret.given = retGiven;
            }
            ret.lang = lang;
            if (other == null) {
                ret.other = null;
            } else {
                List<SimpleElement> retOther = new ArrayList<SimpleElement>();
                for (SimpleElement aItem: getOther()) {
                    retOther.add(((aItem == null)?null:aItem.clone()));
                }
                ret.other = retOther;
            }
            if (prefix == null) {
                ret.prefix = null;
            } else {
                List<SimpleElement> retPrefix = new ArrayList<SimpleElement>();
                for (SimpleElement aItem: getPrefix()) {
                    retPrefix.add(((aItem == null)?null:aItem.clone()));
                }
                ret.prefix = retPrefix;
            }
            if (suffix == null) {
                ret.suffix = null;
            } else {
                List<SimpleElement> retSuffix = new ArrayList<SimpleElement>();
                for (SimpleElement aItem: getSuffix()) {
                    retSuffix.add(((aItem == null)?null:aItem.clone()));
                }
                ret.suffix = retSuffix;
            }
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never <code>null</code>.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public VCARDType.N clone() {
            VCARDType.N ret = new VCARDType.N();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;element name="Orgname" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
     *         &lt;element name="Orgunit" type="{http://www.w3.org/2001/vcard-rdf/3.0#}simpleElement" maxOccurs="unbounded" minOccurs="0"/&gt;
     *       &lt;/sequence&gt;
     *       &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "orgname",
        "orgunit"
    })
    @CodingStyleguideUnaware
    public static class ORG implements Serializable, IExplicitlyCloneable
    {

        @XmlElement(name = "Orgname")
        private List<SimpleElement> orgname;
        @XmlElement(name = "Orgunit")
        private List<SimpleElement> orgunit;
        @XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
        private String lang;

        /**
         * Default constructor<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public ORG() {
        }

        /**
         * Gets the value of the orgname property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the orgname property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getOrgname().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link SimpleElement }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<SimpleElement> getOrgname() {
            if (orgname == null) {
                orgname = new ArrayList<SimpleElement>();
            }
            return this.orgname;
        }

        /**
         * Gets the value of the orgunit property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the orgunit property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getOrgunit().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link SimpleElement }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<SimpleElement> getOrgunit() {
            if (orgunit == null) {
                orgunit = new ArrayList<SimpleElement>();
            }
            return this.orgunit;
        }

        /**
         * Gets the value of the lang property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getLang() {
            return lang;
        }

        /**
         * Sets the value of the lang property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setLang(
            @Nullable
            String value) {
            this.lang = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if ((o == null)||(!getClass().equals(o.getClass()))) {
                return false;
            }
            final VCARDType.ORG rhs = ((VCARDType.ORG) o);
            if (!EqualsHelper.equals(lang, rhs.lang)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(orgname, rhs.orgname)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(orgunit, rhs.orgunit)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return new HashCodeGenerator(this).append(lang).append(orgname).append(orgunit).getHashCode();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return new ToStringGenerator(this).append("lang", lang).append("orgname", orgname).append("orgunit", orgunit).getToString();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setOrgname(
            @Nullable
            final List<SimpleElement> aList) {
            orgname = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setOrgunit(
            @Nullable
            final List<SimpleElement> aList) {
            orgunit = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasOrgnameEntries() {
            return (!getOrgname().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoOrgnameEntries() {
            return getOrgname().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getOrgnameCount() {
            return getOrgname().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public SimpleElement getOrgnameAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getOrgname().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addOrgname(
            @Nonnull
            final SimpleElement elem) {
            getOrgname().add(elem);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasOrgunitEntries() {
            return (!getOrgunit().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoOrgunitEntries() {
            return getOrgunit().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getOrgunitCount() {
            return getOrgunit().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public SimpleElement getOrgunitAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getOrgunit().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addOrgunit(
            @Nonnull
            final SimpleElement elem) {
            getOrgunit().add(elem);
        }

        /**
         * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be <code>null</code>.
         */
        public void cloneTo(
            @Nonnull
            VCARDType.ORG ret) {
            ret.lang = lang;
            if (orgname == null) {
                ret.orgname = null;
            } else {
                List<SimpleElement> retOrgname = new ArrayList<SimpleElement>();
                for (SimpleElement aItem: getOrgname()) {
                    retOrgname.add(((aItem == null)?null:aItem.clone()));
                }
                ret.orgname = retOrgname;
            }
            if (orgunit == null) {
                ret.orgunit = null;
            } else {
                List<SimpleElement> retOrgunit = new ArrayList<SimpleElement>();
                for (SimpleElement aItem: getOrgunit()) {
                    retOrgunit.add(((aItem == null)?null:aItem.clone()));
                }
                ret.orgunit = retOrgunit;
            }
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never <code>null</code>.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public VCARDType.ORG clone() {
            VCARDType.ORG ret = new VCARDType.ORG();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType&gt;
     *   &lt;simpleContent&gt;
     *     &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema&gt;string"&gt;
     *       &lt;attribute name="TYPE" default="voice"&gt;
     *         &lt;simpleType&gt;
     *           &lt;list&gt;
     *             &lt;simpleType&gt;
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
     *                 &lt;enumeration value="home"/&gt;
     *                 &lt;enumeration value="msg"/&gt;
     *                 &lt;enumeration value="work"/&gt;
     *                 &lt;enumeration value="pref"/&gt;
     *                 &lt;enumeration value="voice"/&gt;
     *                 &lt;enumeration value="fax"/&gt;
     *                 &lt;enumeration value="cell"/&gt;
     *                 &lt;enumeration value="video"/&gt;
     *                 &lt;enumeration value="pager"/&gt;
     *                 &lt;enumeration value="bbs"/&gt;
     *                 &lt;enumeration value="modem"/&gt;
     *                 &lt;enumeration value="car"/&gt;
     *                 &lt;enumeration value="isdn"/&gt;
     *                 &lt;enumeration value="pcs"/&gt;
     *               &lt;/restriction&gt;
     *             &lt;/simpleType&gt;
     *           &lt;/list&gt;
     *         &lt;/simpleType&gt;
     *       &lt;/attribute&gt;
     *       &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
     *     &lt;/extension&gt;
     *   &lt;/simpleContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    @CodingStyleguideUnaware
    public static class TEL implements Serializable, IExplicitlyCloneable
    {

        @XmlValue
        private String value;
        @XmlAttribute(name = "TYPE", namespace = "http://www.w3.org/2001/vcard-rdf/3.0#")
        private List<String> type;
        @XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
        private String lang;

        /**
         * Default constructor<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public TEL() {
        }

        /**
         * Constructor for value of type String<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         * @param valueParam
         *     The value to be set. May be <code>null</code>.
         */
        public TEL(
            @Nullable
            final String valueParam) {
            setValue(valueParam);
        }

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setValue(
            @Nullable
            String value) {
            this.value = value;
        }

        /**
         * Gets the value of the type property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the type property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getTYPE().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link String }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<String> getTYPE() {
            if (type == null) {
                type = new ArrayList<String>();
            }
            return this.type;
        }

        /**
         * Gets the value of the lang property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getLang() {
            return lang;
        }

        /**
         * Sets the value of the lang property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setLang(
            @Nullable
            String value) {
            this.lang = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if ((o == null)||(!getClass().equals(o.getClass()))) {
                return false;
            }
            final VCARDType.TEL rhs = ((VCARDType.TEL) o);
            if (!EqualsHelper.equals(lang, rhs.lang)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(type, rhs.type)) {
                return false;
            }
            if (!EqualsHelper.equals(value, rhs.value)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return new HashCodeGenerator(this).append(lang).append(type).append(value).getHashCode();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return new ToStringGenerator(this).append("lang", lang).append("type", type).append("value", value).getToString();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setTYPE(
            @Nullable
            final List<String> aList) {
            type = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasTYPEEntries() {
            return (!getTYPE().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoTYPEEntries() {
            return getTYPE().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getTYPECount() {
            return getTYPE().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public String getTYPEAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getTYPE().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addTYPE(
            @Nonnull
            final String elem) {
            getTYPE().add(elem);
        }

        /**
         * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be <code>null</code>.
         */
        public void cloneTo(
            @Nonnull
            VCARDType.TEL ret) {
            ret.lang = lang;
            if (type == null) {
                ret.type = null;
            } else {
                List<String> retTYPE = new ArrayList<String>();
                for (String aItem: getTYPE()) {
                    retTYPE.add(aItem);
                }
                ret.type = retTYPE;
            }
            ret.value = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never <code>null</code>.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public VCARDType.TEL clone() {
            VCARDType.TEL ret = new VCARDType.TEL();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType&gt;
     *   &lt;simpleContent&gt;
     *     &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema&gt;string"&gt;
     *       &lt;attribute name="TYPE"&gt;
     *         &lt;simpleType&gt;
     *           &lt;list&gt;
     *             &lt;simpleType&gt;
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
     *                 &lt;enumeration value="text"/&gt;
     *               &lt;/restriction&gt;
     *             &lt;/simpleType&gt;
     *           &lt;/list&gt;
     *         &lt;/simpleType&gt;
     *       &lt;/attribute&gt;
     *       &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
     *     &lt;/extension&gt;
     *   &lt;/simpleContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    @CodingStyleguideUnaware
    public static class TZ implements Serializable, IExplicitlyCloneable
    {

        @XmlValue
        private String value;
        @XmlAttribute(name = "TYPE", namespace = "http://www.w3.org/2001/vcard-rdf/3.0#")
        private List<String> type;
        @XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
        private String lang;

        /**
         * Default constructor<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public TZ() {
        }

        /**
         * Constructor for value of type String<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         * @param valueParam
         *     The value to be set. May be <code>null</code>.
         */
        public TZ(
            @Nullable
            final String valueParam) {
            setValue(valueParam);
        }

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setValue(
            @Nullable
            String value) {
            this.value = value;
        }

        /**
         * Gets the value of the type property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the type property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getTYPE().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link String }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<String> getTYPE() {
            if (type == null) {
                type = new ArrayList<String>();
            }
            return this.type;
        }

        /**
         * Gets the value of the lang property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getLang() {
            return lang;
        }

        /**
         * Sets the value of the lang property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setLang(
            @Nullable
            String value) {
            this.lang = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if ((o == null)||(!getClass().equals(o.getClass()))) {
                return false;
            }
            final VCARDType.TZ rhs = ((VCARDType.TZ) o);
            if (!EqualsHelper.equals(lang, rhs.lang)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(type, rhs.type)) {
                return false;
            }
            if (!EqualsHelper.equals(value, rhs.value)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return new HashCodeGenerator(this).append(lang).append(type).append(value).getHashCode();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return new ToStringGenerator(this).append("lang", lang).append("type", type).append("value", value).getToString();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setTYPE(
            @Nullable
            final List<String> aList) {
            type = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasTYPEEntries() {
            return (!getTYPE().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoTYPEEntries() {
            return getTYPE().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getTYPECount() {
            return getTYPE().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public String getTYPEAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getTYPE().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addTYPE(
            @Nonnull
            final String elem) {
            getTYPE().add(elem);
        }

        /**
         * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be <code>null</code>.
         */
        public void cloneTo(
            @Nonnull
            VCARDType.TZ ret) {
            ret.lang = lang;
            if (type == null) {
                ret.type = null;
            } else {
                List<String> retTYPE = new ArrayList<String>();
                for (String aItem: getTYPE()) {
                    retTYPE.add(aItem);
                }
                ret.type = retTYPE;
            }
            ret.value = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never <code>null</code>.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public VCARDType.TZ clone() {
            VCARDType.TZ ret = new VCARDType.TZ();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType&gt;
     *   &lt;simpleContent&gt;
     *     &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema&gt;string"&gt;
     *       &lt;attribute name="TYPE" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
     *       &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
     *     &lt;/extension&gt;
     *   &lt;/simpleContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    @CodingStyleguideUnaware
    public static class UID implements Serializable, IExplicitlyCloneable
    {

        @XmlValue
        private String value;
        @XmlAttribute(name = "TYPE", namespace = "http://www.w3.org/2001/vcard-rdf/3.0#")
        private String type;
        @XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
        private String lang;

        /**
         * Default constructor<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public UID() {
        }

        /**
         * Constructor for value of type String<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         * @param valueParam
         *     The value to be set. May be <code>null</code>.
         */
        public UID(
            @Nullable
            final String valueParam) {
            setValue(valueParam);
        }

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setValue(
            @Nullable
            String value) {
            this.value = value;
        }

        /**
         * Gets the value of the type property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getTYPE() {
            return type;
        }

        /**
         * Sets the value of the type property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setTYPE(
            @Nullable
            String value) {
            this.type = value;
        }

        /**
         * Gets the value of the lang property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getLang() {
            return lang;
        }

        /**
         * Sets the value of the lang property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setLang(
            @Nullable
            String value) {
            this.lang = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if ((o == null)||(!getClass().equals(o.getClass()))) {
                return false;
            }
            final VCARDType.UID rhs = ((VCARDType.UID) o);
            if (!EqualsHelper.equals(lang, rhs.lang)) {
                return false;
            }
            if (!EqualsHelper.equals(type, rhs.type)) {
                return false;
            }
            if (!EqualsHelper.equals(value, rhs.value)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return new HashCodeGenerator(this).append(lang).append(type).append(value).getHashCode();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return new ToStringGenerator(this).append("lang", lang).append("type", type).append("value", value).getToString();
        }

        /**
         * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be <code>null</code>.
         */
        public void cloneTo(
            @Nonnull
            VCARDType.UID ret) {
            ret.lang = lang;
            ret.type = type;
            ret.value = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never <code>null</code>.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public VCARDType.UID clone() {
            VCARDType.UID ret = new VCARDType.UID();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;attGroup ref="{http://www.w3.org/1999/xlink}simpleAttrs"/&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    @CodingStyleguideUnaware
    public static class URL implements Serializable, IExplicitlyCloneable
    {

        @XmlAttribute(name = "type", namespace = "http://www.w3.org/1999/xlink")
        private XLinkTypeType type;
        @XmlAttribute(name = "href", namespace = "http://www.w3.org/1999/xlink")
        private String href;
        @XmlAttribute(name = "role", namespace = "http://www.w3.org/1999/xlink")
        private String role;
        @XmlAttribute(name = "arcrole", namespace = "http://www.w3.org/1999/xlink")
        private String arcrole;
        @XmlAttribute(name = "title", namespace = "http://www.w3.org/1999/xlink")
        private String title;
        @XmlAttribute(name = "show", namespace = "http://www.w3.org/1999/xlink")
        private XLinkShowType show;
        @XmlAttribute(name = "actuate", namespace = "http://www.w3.org/1999/xlink")
        private XLinkActuateType actuate;

        /**
         * Default constructor<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public URL() {
        }

        /**
         * Gets the value of the type property.
         * 
         * @return
         *     possible object is
         *     {@link XLinkTypeType }
         *     
         */
        @Nullable
        public XLinkTypeType getTYPE() {
            return type;
        }

        /**
         * Sets the value of the type property.
         * 
         * @param value
         *     allowed object is
         *     {@link XLinkTypeType }
         *     
         */
        public void setTYPE(
            @Nullable
            XLinkTypeType value) {
            this.type = value;
        }

        /**
         * Gets the value of the href property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getHref() {
            return href;
        }

        /**
         * Sets the value of the href property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setHref(
            @Nullable
            String value) {
            this.href = value;
        }

        /**
         * Gets the value of the role property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getRole() {
            return role;
        }

        /**
         * Sets the value of the role property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setRole(
            @Nullable
            String value) {
            this.role = value;
        }

        /**
         * Gets the value of the arcrole property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getArcrole() {
            return arcrole;
        }

        /**
         * Sets the value of the arcrole property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setArcrole(
            @Nullable
            String value) {
            this.arcrole = value;
        }

        /**
         * Gets the value of the title property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getTitle() {
            return title;
        }

        /**
         * Sets the value of the title property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setTitle(
            @Nullable
            String value) {
            this.title = value;
        }

        /**
         * Gets the value of the show property.
         * 
         * @return
         *     possible object is
         *     {@link XLinkShowType }
         *     
         */
        @Nullable
        public XLinkShowType getShow() {
            return show;
        }

        /**
         * Sets the value of the show property.
         * 
         * @param value
         *     allowed object is
         *     {@link XLinkShowType }
         *     
         */
        public void setShow(
            @Nullable
            XLinkShowType value) {
            this.show = value;
        }

        /**
         * Gets the value of the actuate property.
         * 
         * @return
         *     possible object is
         *     {@link XLinkActuateType }
         *     
         */
        @Nullable
        public XLinkActuateType getActuate() {
            return actuate;
        }

        /**
         * Sets the value of the actuate property.
         * 
         * @param value
         *     allowed object is
         *     {@link XLinkActuateType }
         *     
         */
        public void setActuate(
            @Nullable
            XLinkActuateType value) {
            this.actuate = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if ((o == null)||(!getClass().equals(o.getClass()))) {
                return false;
            }
            final VCARDType.URL rhs = ((VCARDType.URL) o);
            if (!EqualsHelper.equals(actuate, rhs.actuate)) {
                return false;
            }
            if (!EqualsHelper.equals(arcrole, rhs.arcrole)) {
                return false;
            }
            if (!EqualsHelper.equals(href, rhs.href)) {
                return false;
            }
            if (!EqualsHelper.equals(role, rhs.role)) {
                return false;
            }
            if (!EqualsHelper.equals(show, rhs.show)) {
                return false;
            }
            if (!EqualsHelper.equals(title, rhs.title)) {
                return false;
            }
            if (!EqualsHelper.equals(type, rhs.type)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return new HashCodeGenerator(this).append(actuate).append(arcrole).append(href).append(role).append(show).append(title).append(type).getHashCode();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return new ToStringGenerator(this).append("actuate", actuate).append("arcrole", arcrole).append("href", href).append("role", role).append("show", show).append("title", title).append("type", type).getToString();
        }

        /**
         * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be <code>null</code>.
         */
        public void cloneTo(
            @Nonnull
            VCARDType.URL ret) {
            ret.actuate = actuate;
            ret.arcrole = arcrole;
            ret.href = href;
            ret.role = role;
            ret.show = show;
            ret.title = title;
            ret.type = type;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never <code>null</code>.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public VCARDType.URL clone() {
            VCARDType.URL ret = new VCARDType.URL();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;any namespace='http://www.w3.org/2001/vcard-rdf/3.0#' maxOccurs="unbounded" minOccurs="0"/&gt;
     *       &lt;/sequence&gt;
     *       &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "any"
    })
    @CodingStyleguideUnaware
    public static class VCARD implements Serializable, IExplicitlyCloneable
    {

        @XmlAnyElement(lax = true)
        private List<Object> any;
        @XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
        private String lang;

        /**
         * Default constructor<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public VCARD() {
        }

        /**
         * Gets the value of the any property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the any property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getAny().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link Object }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<Object> getAny() {
            if (any == null) {
                any = new ArrayList<Object>();
            }
            return this.any;
        }

        /**
         * Gets the value of the lang property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getLang() {
            return lang;
        }

        /**
         * Sets the value of the lang property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setLang(
            @Nullable
            String value) {
            this.lang = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if ((o == null)||(!getClass().equals(o.getClass()))) {
                return false;
            }
            final VCARDType.VCARD rhs = ((VCARDType.VCARD) o);
            if (!EqualsHelper.equalsCollection(any, rhs.any)) {
                return false;
            }
            if (!EqualsHelper.equals(lang, rhs.lang)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return new HashCodeGenerator(this).append(any).append(lang).getHashCode();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return new ToStringGenerator(this).append("any", any).append("lang", lang).getToString();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setAny(
            @Nullable
            final List<Object> aList) {
            any = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasAnyEntries() {
            return (!getAny().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoAnyEntries() {
            return getAny().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getAnyCount() {
            return getAny().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public Object getAnyAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getAny().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addAny(
            @Nonnull
            final Object elem) {
            getAny().add(elem);
        }

        /**
         * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be <code>null</code>.
         */
        public void cloneTo(
            @Nonnull
            VCARDType.VCARD ret) {
            if (any == null) {
                ret.any = null;
            } else {
                List<Object> retAny = new ArrayList<Object>();
                for (Object aItem: getAny()) {
                    retAny.add(aItem);
                }
                ret.any = retAny;
            }
            ret.lang = lang;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never <code>null</code>.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public VCARDType.VCARD clone() {
            VCARDType.VCARD ret = new VCARDType.VCARD();
            cloneTo(ret);
            return ret;
        }

    }

}
