
package eu.toop.edm.jaxb.cv.cac;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cv.cbc.CodeType;
import eu.toop.edm.jaxb.cv.cbc.DescriptionType;
import eu.toop.edm.jaxb.cv.cbc.IDType;
import eu.toop.edm.jaxb.cv.cbc.NumericType;
import eu.toop.edm.jaxb.cv.cbc.TextType;


/**
 * <p>Java class for AddressType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="AddressType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{http://www.w3.org/ns/locn#}AddressType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cbc-2.0.0#}id" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}addressTypeCode" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}addressFormatCode" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}postbox" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}floor" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}room" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}streetName" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}additionalStreetName" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}blockName" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}buildingName" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}buildingNumber" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}description" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}inhouseMail" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}department" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}markAttention" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}markCare" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}plotIdentification" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}citySubdivisionName" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}cityName" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}postalZone" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}countrySubentity" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}hasCountrySubentityCode" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}region" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}district" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}timezoneOffset" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}addressLine" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cac-2.0.0#}countryCode" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AddressType", propOrder = {
    "id",
    "addressTypeCode",
    "addressFormatCode",
    "postbox",
    "floor",
    "room",
    "streetName",
    "additionalStreetName",
    "blockName",
    "buildingName",
    "buildingNumber",
    "description",
    "inhouseMail",
    "department",
    "markAttention",
    "markCare",
    "plotIdentification",
    "citySubdivisionName",
    "cityName",
    "postalZone",
    "countrySubentity",
    "hasCountrySubentityCode",
    "region",
    "district",
    "timezoneOffset",
    "addressLine",
    "countryCode"
})
@CodingStyleguideUnaware
public class AddressType
    extends eu.toop.edm.jaxb.w3.locn.AddressType
{

    @XmlElement(namespace = "https://semic.org/sa/cv/common/cbc-2.0.0#")
    private IDType id;
    private CodeType addressTypeCode;
    private CodeType addressFormatCode;
    private TextType postbox;
    private TextType floor;
    private TextType room;
    private TextType streetName;
    private TextType additionalStreetName;
    private TextType blockName;
    private TextType buildingName;
    private TextType buildingNumber;
    private List<DescriptionType> description;
    private TextType inhouseMail;
    private TextType department;
    private TextType markAttention;
    private TextType markCare;
    private TextType plotIdentification;
    private TextType citySubdivisionName;
    private TextType cityName;
    private TextType postalZone;
    private TextType countrySubentity;
    private CodeType hasCountrySubentityCode;
    private TextType region;
    private TextType district;
    private NumericType timezoneOffset;
    private List<TextType> addressLine;
    private CodeType countryCode;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public AddressType() {
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setId(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the addressTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getAddressTypeCode() {
        return addressTypeCode;
    }

    /**
     * Sets the value of the addressTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setAddressTypeCode(
        @Nullable
        CodeType value) {
        this.addressTypeCode = value;
    }

    /**
     * Gets the value of the addressFormatCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getAddressFormatCode() {
        return addressFormatCode;
    }

    /**
     * Sets the value of the addressFormatCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setAddressFormatCode(
        @Nullable
        CodeType value) {
        this.addressFormatCode = value;
    }

    /**
     * Gets the value of the postbox property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getPostbox() {
        return postbox;
    }

    /**
     * Sets the value of the postbox property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setPostbox(
        @Nullable
        TextType value) {
        this.postbox = value;
    }

    /**
     * Gets the value of the floor property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getFloor() {
        return floor;
    }

    /**
     * Sets the value of the floor property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setFloor(
        @Nullable
        TextType value) {
        this.floor = value;
    }

    /**
     * Gets the value of the room property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getRoom() {
        return room;
    }

    /**
     * Sets the value of the room property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setRoom(
        @Nullable
        TextType value) {
        this.room = value;
    }

    /**
     * Gets the value of the streetName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getStreetName() {
        return streetName;
    }

    /**
     * Sets the value of the streetName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setStreetName(
        @Nullable
        TextType value) {
        this.streetName = value;
    }

    /**
     * Gets the value of the additionalStreetName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getAdditionalStreetName() {
        return additionalStreetName;
    }

    /**
     * Sets the value of the additionalStreetName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setAdditionalStreetName(
        @Nullable
        TextType value) {
        this.additionalStreetName = value;
    }

    /**
     * Gets the value of the blockName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getBlockName() {
        return blockName;
    }

    /**
     * Sets the value of the blockName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setBlockName(
        @Nullable
        TextType value) {
        this.blockName = value;
    }

    /**
     * Gets the value of the buildingName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getBuildingName() {
        return buildingName;
    }

    /**
     * Sets the value of the buildingName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setBuildingName(
        @Nullable
        TextType value) {
        this.buildingName = value;
    }

    /**
     * Gets the value of the buildingNumber property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getBuildingNumber() {
        return buildingNumber;
    }

    /**
     * Sets the value of the buildingNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setBuildingNumber(
        @Nullable
        TextType value) {
        this.buildingNumber = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<DescriptionType>();
        }
        return this.description;
    }

    /**
     * Gets the value of the inhouseMail property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getInhouseMail() {
        return inhouseMail;
    }

    /**
     * Sets the value of the inhouseMail property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setInhouseMail(
        @Nullable
        TextType value) {
        this.inhouseMail = value;
    }

    /**
     * Gets the value of the department property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getDepartment() {
        return department;
    }

    /**
     * Sets the value of the department property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setDepartment(
        @Nullable
        TextType value) {
        this.department = value;
    }

    /**
     * Gets the value of the markAttention property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getMarkAttention() {
        return markAttention;
    }

    /**
     * Sets the value of the markAttention property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setMarkAttention(
        @Nullable
        TextType value) {
        this.markAttention = value;
    }

    /**
     * Gets the value of the markCare property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getMarkCare() {
        return markCare;
    }

    /**
     * Sets the value of the markCare property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setMarkCare(
        @Nullable
        TextType value) {
        this.markCare = value;
    }

    /**
     * Gets the value of the plotIdentification property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getPlotIdentification() {
        return plotIdentification;
    }

    /**
     * Sets the value of the plotIdentification property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setPlotIdentification(
        @Nullable
        TextType value) {
        this.plotIdentification = value;
    }

    /**
     * Gets the value of the citySubdivisionName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getCitySubdivisionName() {
        return citySubdivisionName;
    }

    /**
     * Sets the value of the citySubdivisionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setCitySubdivisionName(
        @Nullable
        TextType value) {
        this.citySubdivisionName = value;
    }

    /**
     * Gets the value of the cityName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getCityName() {
        return cityName;
    }

    /**
     * Sets the value of the cityName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setCityName(
        @Nullable
        TextType value) {
        this.cityName = value;
    }

    /**
     * Gets the value of the postalZone property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getPostalZone() {
        return postalZone;
    }

    /**
     * Sets the value of the postalZone property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setPostalZone(
        @Nullable
        TextType value) {
        this.postalZone = value;
    }

    /**
     * Gets the value of the countrySubentity property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getCountrySubentity() {
        return countrySubentity;
    }

    /**
     * Sets the value of the countrySubentity property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setCountrySubentity(
        @Nullable
        TextType value) {
        this.countrySubentity = value;
    }

    /**
     * Gets the value of the hasCountrySubentityCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getHasCountrySubentityCode() {
        return hasCountrySubentityCode;
    }

    /**
     * Sets the value of the hasCountrySubentityCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setHasCountrySubentityCode(
        @Nullable
        CodeType value) {
        this.hasCountrySubentityCode = value;
    }

    /**
     * Gets the value of the region property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getRegion() {
        return region;
    }

    /**
     * Sets the value of the region property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setRegion(
        @Nullable
        TextType value) {
        this.region = value;
    }

    /**
     * Gets the value of the district property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getDistrict() {
        return district;
    }

    /**
     * Sets the value of the district property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setDistrict(
        @Nullable
        TextType value) {
        this.district = value;
    }

    /**
     * Gets the value of the timezoneOffset property.
     * 
     * @return
     *     possible object is
     *     {@link NumericType }
     *     
     */
    @Nullable
    public NumericType getTimezoneOffset() {
        return timezoneOffset;
    }

    /**
     * Sets the value of the timezoneOffset property.
     * 
     * @param value
     *     allowed object is
     *     {@link NumericType }
     *     
     */
    public void setTimezoneOffset(
        @Nullable
        NumericType value) {
        this.timezoneOffset = value;
    }

    /**
     * Gets the value of the addressLine property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the addressLine property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAddressLine().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getAddressLine() {
        if (addressLine == null) {
            addressLine = new ArrayList<TextType>();
        }
        return this.addressLine;
    }

    /**
     * Gets the value of the countryCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getCountryCode() {
        return countryCode;
    }

    /**
     * Sets the value of the countryCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setCountryCode(
        @Nullable
        CodeType value) {
        this.countryCode = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final AddressType rhs = ((AddressType) o);
        if (!EqualsHelper.equals(additionalStreetName, rhs.additionalStreetName)) {
            return false;
        }
        if (!EqualsHelper.equals(addressFormatCode, rhs.addressFormatCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(addressLine, rhs.addressLine)) {
            return false;
        }
        if (!EqualsHelper.equals(addressTypeCode, rhs.addressTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(blockName, rhs.blockName)) {
            return false;
        }
        if (!EqualsHelper.equals(buildingName, rhs.buildingName)) {
            return false;
        }
        if (!EqualsHelper.equals(buildingNumber, rhs.buildingNumber)) {
            return false;
        }
        if (!EqualsHelper.equals(cityName, rhs.cityName)) {
            return false;
        }
        if (!EqualsHelper.equals(citySubdivisionName, rhs.citySubdivisionName)) {
            return false;
        }
        if (!EqualsHelper.equals(countryCode, rhs.countryCode)) {
            return false;
        }
        if (!EqualsHelper.equals(countrySubentity, rhs.countrySubentity)) {
            return false;
        }
        if (!EqualsHelper.equals(department, rhs.department)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(district, rhs.district)) {
            return false;
        }
        if (!EqualsHelper.equals(floor, rhs.floor)) {
            return false;
        }
        if (!EqualsHelper.equals(hasCountrySubentityCode, rhs.hasCountrySubentityCode)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(inhouseMail, rhs.inhouseMail)) {
            return false;
        }
        if (!EqualsHelper.equals(markAttention, rhs.markAttention)) {
            return false;
        }
        if (!EqualsHelper.equals(markCare, rhs.markCare)) {
            return false;
        }
        if (!EqualsHelper.equals(plotIdentification, rhs.plotIdentification)) {
            return false;
        }
        if (!EqualsHelper.equals(postalZone, rhs.postalZone)) {
            return false;
        }
        if (!EqualsHelper.equals(postbox, rhs.postbox)) {
            return false;
        }
        if (!EqualsHelper.equals(region, rhs.region)) {
            return false;
        }
        if (!EqualsHelper.equals(room, rhs.room)) {
            return false;
        }
        if (!EqualsHelper.equals(streetName, rhs.streetName)) {
            return false;
        }
        if (!EqualsHelper.equals(timezoneOffset, rhs.timezoneOffset)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(additionalStreetName).append(addressFormatCode).append(addressLine).append(addressTypeCode).append(blockName).append(buildingName).append(buildingNumber).append(cityName).append(citySubdivisionName).append(countryCode).append(countrySubentity).append(department).append(description).append(district).append(floor).append(hasCountrySubentityCode).append(id).append(inhouseMail).append(markAttention).append(markCare).append(plotIdentification).append(postalZone).append(postbox).append(region).append(room).append(streetName).append(timezoneOffset).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("additionalStreetName", additionalStreetName).append("addressFormatCode", addressFormatCode).append("addressLine", addressLine).append("addressTypeCode", addressTypeCode).append("blockName", blockName).append("buildingName", buildingName).append("buildingNumber", buildingNumber).append("cityName", cityName).append("citySubdivisionName", citySubdivisionName).append("countryCode", countryCode).append("countrySubentity", countrySubentity).append("department", department).append("description", description).append("district", district).append("floor", floor).append("hasCountrySubentityCode", hasCountrySubentityCode).append("id", id).append("inhouseMail", inhouseMail).append("markAttention", markAttention).append("markCare", markCare).append("plotIdentification", plotIdentification).append("postalZone", postalZone).append("postbox", postbox).append("region", region).append("room", room).append("streetName", streetName).append("timezoneOffset", timezoneOffset).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAddressLine(
        @Nullable
        final List<TextType> aList) {
        addressLine = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAddressLineEntries() {
        return (!getAddressLine().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAddressLineEntries() {
        return getAddressLine().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAddressLineCount() {
        return getAddressLine().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getAddressLineAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAddressLine().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAddressLine(
        @Nonnull
        final TextType elem) {
        getAddressLine().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        AddressType ret) {
        super.cloneTo(ret);
        ret.additionalStreetName = ((additionalStreetName == null)?null:additionalStreetName.clone());
        ret.addressFormatCode = ((addressFormatCode == null)?null:addressFormatCode.clone());
        if (addressLine == null) {
            ret.addressLine = null;
        } else {
            List<TextType> retAddressLine = new ArrayList<TextType>();
            for (TextType aItem: getAddressLine()) {
                retAddressLine.add(((aItem == null)?null:aItem.clone()));
            }
            ret.addressLine = retAddressLine;
        }
        ret.addressTypeCode = ((addressTypeCode == null)?null:addressTypeCode.clone());
        ret.blockName = ((blockName == null)?null:blockName.clone());
        ret.buildingName = ((buildingName == null)?null:buildingName.clone());
        ret.buildingNumber = ((buildingNumber == null)?null:buildingNumber.clone());
        ret.cityName = ((cityName == null)?null:cityName.clone());
        ret.citySubdivisionName = ((citySubdivisionName == null)?null:citySubdivisionName.clone());
        ret.countryCode = ((countryCode == null)?null:countryCode.clone());
        ret.countrySubentity = ((countrySubentity == null)?null:countrySubentity.clone());
        ret.department = ((department == null)?null:department.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<DescriptionType>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.district = ((district == null)?null:district.clone());
        ret.floor = ((floor == null)?null:floor.clone());
        ret.hasCountrySubentityCode = ((hasCountrySubentityCode == null)?null:hasCountrySubentityCode.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.inhouseMail = ((inhouseMail == null)?null:inhouseMail.clone());
        ret.markAttention = ((markAttention == null)?null:markAttention.clone());
        ret.markCare = ((markCare == null)?null:markCare.clone());
        ret.plotIdentification = ((plotIdentification == null)?null:plotIdentification.clone());
        ret.postalZone = ((postalZone == null)?null:postalZone.clone());
        ret.postbox = ((postbox == null)?null:postbox.clone());
        ret.region = ((region == null)?null:region.clone());
        ret.room = ((room == null)?null:room.clone());
        ret.streetName = ((streetName == null)?null:streetName.clone());
        ret.timezoneOffset = ((timezoneOffset == null)?null:timezoneOffset.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public AddressType clone() {
        AddressType ret = new AddressType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setAddressTypeCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getAddressTypeCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setAddressTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setAddressFormatCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getAddressFormatCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setAddressFormatCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setHasCountrySubentityCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getHasCountrySubentityCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setHasCountrySubentityCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setCountryCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getCountryCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setCountryCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setId(
        @Nullable
        final String valueParam) {
        IDType aObj = getId();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setId(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setPostbox(
        @Nullable
        final String valueParam) {
        TextType aObj = getPostbox();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setPostbox(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setFloor(
        @Nullable
        final String valueParam) {
        TextType aObj = getFloor();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setFloor(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setRoom(
        @Nullable
        final String valueParam) {
        TextType aObj = getRoom();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setRoom(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setStreetName(
        @Nullable
        final String valueParam) {
        TextType aObj = getStreetName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setStreetName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setAdditionalStreetName(
        @Nullable
        final String valueParam) {
        TextType aObj = getAdditionalStreetName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setAdditionalStreetName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setBlockName(
        @Nullable
        final String valueParam) {
        TextType aObj = getBlockName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setBlockName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setBuildingName(
        @Nullable
        final String valueParam) {
        TextType aObj = getBuildingName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setBuildingName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setBuildingNumber(
        @Nullable
        final String valueParam) {
        TextType aObj = getBuildingNumber();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setBuildingNumber(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setInhouseMail(
        @Nullable
        final String valueParam) {
        TextType aObj = getInhouseMail();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setInhouseMail(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setDepartment(
        @Nullable
        final String valueParam) {
        TextType aObj = getDepartment();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setDepartment(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setMarkAttention(
        @Nullable
        final String valueParam) {
        TextType aObj = getMarkAttention();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setMarkAttention(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setMarkCare(
        @Nullable
        final String valueParam) {
        TextType aObj = getMarkCare();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setMarkCare(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setPlotIdentification(
        @Nullable
        final String valueParam) {
        TextType aObj = getPlotIdentification();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setPlotIdentification(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setCitySubdivisionName(
        @Nullable
        final String valueParam) {
        TextType aObj = getCitySubdivisionName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setCitySubdivisionName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setCityName(
        @Nullable
        final String valueParam) {
        TextType aObj = getCityName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setCityName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setPostalZone(
        @Nullable
        final String valueParam) {
        TextType aObj = getPostalZone();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setPostalZone(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setCountrySubentity(
        @Nullable
        final String valueParam) {
        TextType aObj = getCountrySubentity();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setCountrySubentity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setRegion(
        @Nullable
        final String valueParam) {
        TextType aObj = getRegion();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setRegion(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setDistrict(
        @Nullable
        final String valueParam) {
        TextType aObj = getDistrict();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setDistrict(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NumericType and never <code>null</code>
     */
    @Nonnull
    public NumericType setTimezoneOffset(
        @Nullable
        final BigDecimal valueParam) {
        NumericType aObj = getTimezoneOffset();
        if (aObj == null) {
            aObj = new NumericType(valueParam);
            setTimezoneOffset(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIdValue() {
        IDType aObj = getId();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getAddressTypeCodeValue() {
        CodeType aObj = getAddressTypeCode();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getAddressFormatCodeValue() {
        CodeType aObj = getAddressFormatCode();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getPostboxValue() {
        TextType aObj = getPostbox();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getFloorValue() {
        TextType aObj = getFloor();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getRoomValue() {
        TextType aObj = getRoom();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getStreetNameValue() {
        TextType aObj = getStreetName();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getAdditionalStreetNameValue() {
        TextType aObj = getAdditionalStreetName();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getBlockNameValue() {
        TextType aObj = getBlockName();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getBuildingNameValue() {
        TextType aObj = getBuildingName();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getBuildingNumberValue() {
        TextType aObj = getBuildingNumber();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getInhouseMailValue() {
        TextType aObj = getInhouseMail();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getDepartmentValue() {
        TextType aObj = getDepartment();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getMarkAttentionValue() {
        TextType aObj = getMarkAttention();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getMarkCareValue() {
        TextType aObj = getMarkCare();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getPlotIdentificationValue() {
        TextType aObj = getPlotIdentification();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getCitySubdivisionNameValue() {
        TextType aObj = getCitySubdivisionName();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getCityNameValue() {
        TextType aObj = getCityName();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getPostalZoneValue() {
        TextType aObj = getPostalZone();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getCountrySubentityValue() {
        TextType aObj = getCountrySubentity();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getHasCountrySubentityCodeValue() {
        CodeType aObj = getHasCountrySubentityCode();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getRegionValue() {
        TextType aObj = getRegion();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getDistrictValue() {
        TextType aObj = getDistrict();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained NumericType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTimezoneOffsetValue() {
        NumericType aObj = getTimezoneOffset();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getCountryCodeValue() {
        CodeType aObj = getCountryCode();
        return ((aObj == null)?null:aObj.getValue());
    }

}
