
package eu.toop.edm.jaxb.cv.agent;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cv.cbc.IDType;
import eu.toop.edm.jaxb.cv.cbc.NameType;


/**
 * <p>Java class for FormalOrganizationType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="FormalOrganizationType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{https://semic.org/sa/cv/cagv/agent-2.0.0#}OrganizationType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}taxIdentifier" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}formalName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}formalLocation" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FormalOrganizationType", propOrder = {
    "taxIdentifier",
    "formalName",
    "formalLocation"
})
@XmlSeeAlso({
    PublicOrganizationType.class
})
@CodingStyleguideUnaware
public class FormalOrganizationType
    extends OrganizationType
{

    private IDType taxIdentifier;
    private List<NameType> formalName;
    private LocationType formalLocation;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public FormalOrganizationType() {
    }

    /**
     * Gets the value of the taxIdentifier property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getTaxIdentifier() {
        return taxIdentifier;
    }

    /**
     * Sets the value of the taxIdentifier property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setTaxIdentifier(
        @Nullable
        IDType value) {
        this.taxIdentifier = value;
    }

    /**
     * Gets the value of the formalName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the formalName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFormalName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NameType> getFormalName() {
        if (formalName == null) {
            formalName = new ArrayList<NameType>();
        }
        return this.formalName;
    }

    /**
     * Gets the value of the formalLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getFormalLocation() {
        return formalLocation;
    }

    /**
     * Sets the value of the formalLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setFormalLocation(
        @Nullable
        LocationType value) {
        this.formalLocation = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final FormalOrganizationType rhs = ((FormalOrganizationType) o);
        if (!EqualsHelper.equals(formalLocation, rhs.formalLocation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(formalName, rhs.formalName)) {
            return false;
        }
        if (!EqualsHelper.equals(taxIdentifier, rhs.taxIdentifier)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(formalLocation).append(formalName).append(taxIdentifier).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("formalLocation", formalLocation).append("formalName", formalName).append("taxIdentifier", taxIdentifier).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFormalName(
        @Nullable
        final List<NameType> aList) {
        formalName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFormalNameEntries() {
        return (!getFormalName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFormalNameEntries() {
        return getFormalName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFormalNameCount() {
        return getFormalName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NameType getFormalNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFormalName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFormalName(
        @Nonnull
        final NameType elem) {
        getFormalName().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        FormalOrganizationType ret) {
        super.cloneTo(ret);
        ret.formalLocation = ((formalLocation == null)?null:formalLocation.clone());
        if (formalName == null) {
            ret.formalName = null;
        } else {
            List<NameType> retFormalName = new ArrayList<NameType>();
            for (NameType aItem: getFormalName()) {
                retFormalName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.formalName = retFormalName;
        }
        ret.taxIdentifier = ((taxIdentifier == null)?null:taxIdentifier.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public FormalOrganizationType clone() {
        FormalOrganizationType ret = new FormalOrganizationType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setTaxIdentifier(
        @Nullable
        final String valueParam) {
        IDType aObj = getTaxIdentifier();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setTaxIdentifier(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getTaxIdentifierValue() {
        IDType aObj = getTaxIdentifier();
        return ((aObj == null)?null:aObj.getValue());
    }

}
