
package eu.toop.edm.jaxb.cccev;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cv.cbc.IDType;
import eu.toop.edm.jaxb.dcatap.DCatAPDatasetType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:Class xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Class&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;ReferenceFramework. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;ReferenceFramework&lt;/ccts:ObjectClass&gt;&lt;PrimitiveClass&gt;dcat-ap:Dataset&lt;/PrimitiveClass&gt;&lt;/an:Class&gt;
 * </pre>
 * 
 * 
 * <p>Java class for ReferenceFrameworkType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ReferenceFrameworkType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{http://data.europa.eu/r5r/}DatasetType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/common/cbc-2.0.0#}id" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attGroup ref="{https://semic.org/sa/cv/common/cac-2.0.0#}ThingAttributes"/&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ReferenceFrameworkType", propOrder = {
    "id"
})
@CodingStyleguideUnaware
public class CCCEVReferenceFrameworkType
    extends DCatAPDatasetType
{

    @XmlElement(namespace = "https://semic.org/sa/cv/common/cbc-2.0.0#")
    private List<IDType> id;
    @XmlAttribute(name = "versionId")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String versionIdAttr;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CCCEVReferenceFrameworkType() {
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;ReferenceFramework. Identifier&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..*&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;cccev:ReferenceFramework&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Identifier&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Identifier&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;ID. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * Gets the value of the id property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the id property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getId().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDType> getId() {
        if (id == null) {
            id = new ArrayList<IDType>();
        }
        return this.id;
    }

    /**
     * Gets the value of the versionIdAttr property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getVersionIdAttr() {
        return versionIdAttr;
    }

    /**
     * Sets the value of the versionIdAttr property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVersionIdAttr(
        @Nullable
        String value) {
        this.versionIdAttr = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final CCCEVReferenceFrameworkType rhs = ((CCCEVReferenceFrameworkType) o);
        if (!EqualsHelper.equalsCollection(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(versionIdAttr, rhs.versionIdAttr)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(id).append(versionIdAttr).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("id", id).append("versionIdAttr", versionIdAttr).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setId(
        @Nullable
        final List<IDType> aList) {
        id = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIdEntries() {
        return (!getId().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIdEntries() {
        return getId().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIdCount() {
        return getId().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDType getIdAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getId().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addId(
        @Nonnull
        final IDType elem) {
        getId().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CCCEVReferenceFrameworkType ret) {
        super.cloneTo(ret);
        if (id == null) {
            ret.id = null;
        } else {
            List<IDType> retId = new ArrayList<IDType>();
            for (IDType aItem: getId()) {
                retId.add(((aItem == null)?null:aItem.clone()));
            }
            ret.id = retId;
        }
        ret.versionIdAttr = versionIdAttr;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CCCEVReferenceFrameworkType clone() {
        CCCEVReferenceFrameworkType ret = new CCCEVReferenceFrameworkType();
        cloneTo(ret);
        return ret;
    }

}
