
package eu.toop.edm.jaxb.cccev;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cv.cbc.CodeType;
import eu.toop.edm.jaxb.dcatap.DCatAPDatasetType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:Class xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Class&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;EvidenceType. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;EvidenceType&lt;/ccts:ObjectClass&gt;&lt;PrimitiveClass&gt;dcat-ap:Dataset&lt;/PrimitiveClass&gt;&lt;/an:Class&gt;
 * </pre>
 * 
 * 
 * <p>Java class for EvidenceTypeType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="EvidenceTypeType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{http://data.europa.eu/r5r/}DatasetType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}evidenceTypology" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}dataSetType" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}specifiedIn" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attGroup ref="{https://semic.org/sa/cv/common/cac-2.0.0#}ThingAttributes"/&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "EvidenceTypeType", propOrder = {
    "evidenceTypology",
    "dataSetType",
    "specifiedIn"
})
@CodingStyleguideUnaware
public class CCCEVEvidenceTypeType
    extends DCatAPDatasetType
{

    private CodeType evidenceTypology;
    private CodeType dataSetType;
    private List<CCCEVConceptType> specifiedIn;
    @XmlAttribute(name = "versionId")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String versionIdAttr;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CCCEVEvidenceTypeType() {
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;EvidenceType. evidence Typology&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;EvidenceType&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getEvidenceTypology() {
        return evidenceTypology;
    }

    /**
     * Sets the value of the evidenceTypology property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setEvidenceTypology(
        @Nullable
        CodeType value) {
        this.evidenceTypology = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;EvidenceType. dataset Type&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;EvidenceType&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getDataSetType() {
        return dataSetType;
    }

    /**
     * Sets the value of the dataSetType property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setDataSetType(
        @Nullable
        CodeType value) {
        this.dataSetType = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;EvidenceType. specified In&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition/&gt;&lt;ccts:ObjectClass&gt;EvidenceType&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;EvidenceType&lt;/Domain&gt;&lt;Range&gt;EvidenceTypeList&lt;/Range&gt;&lt;Predicate&gt;isSpecifiedIn&lt;/Predicate&gt;&lt;Axiom&gt;owl:inverseOf :specifiesEvidenceType&lt;/Axiom&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the specifiedIn property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the specifiedIn property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSpecifiedIn().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CCCEVConceptType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CCCEVConceptType> getSpecifiedIn() {
        if (specifiedIn == null) {
            specifiedIn = new ArrayList<CCCEVConceptType>();
        }
        return this.specifiedIn;
    }

    /**
     * Gets the value of the versionIdAttr property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getVersionIdAttr() {
        return versionIdAttr;
    }

    /**
     * Sets the value of the versionIdAttr property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVersionIdAttr(
        @Nullable
        String value) {
        this.versionIdAttr = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final CCCEVEvidenceTypeType rhs = ((CCCEVEvidenceTypeType) o);
        if (!EqualsHelper.equals(dataSetType, rhs.dataSetType)) {
            return false;
        }
        if (!EqualsHelper.equals(evidenceTypology, rhs.evidenceTypology)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(specifiedIn, rhs.specifiedIn)) {
            return false;
        }
        if (!EqualsHelper.equals(versionIdAttr, rhs.versionIdAttr)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(dataSetType).append(evidenceTypology).append(specifiedIn).append(versionIdAttr).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("dataSetType", dataSetType).append("evidenceTypology", evidenceTypology).append("specifiedIn", specifiedIn).append("versionIdAttr", versionIdAttr).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSpecifiedIn(
        @Nullable
        final List<CCCEVConceptType> aList) {
        specifiedIn = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSpecifiedInEntries() {
        return (!getSpecifiedIn().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSpecifiedInEntries() {
        return getSpecifiedIn().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSpecifiedInCount() {
        return getSpecifiedIn().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CCCEVConceptType getSpecifiedInAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSpecifiedIn().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSpecifiedIn(
        @Nonnull
        final CCCEVConceptType elem) {
        getSpecifiedIn().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CCCEVEvidenceTypeType ret) {
        super.cloneTo(ret);
        ret.dataSetType = ((dataSetType == null)?null:dataSetType.clone());
        ret.evidenceTypology = ((evidenceTypology == null)?null:evidenceTypology.clone());
        if (specifiedIn == null) {
            ret.specifiedIn = null;
        } else {
            List<CCCEVConceptType> retSpecifiedIn = new ArrayList<CCCEVConceptType>();
            for (CCCEVConceptType aItem: getSpecifiedIn()) {
                retSpecifiedIn.add(((aItem == null)?null:aItem.clone()));
            }
            ret.specifiedIn = retSpecifiedIn;
        }
        ret.versionIdAttr = versionIdAttr;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CCCEVEvidenceTypeType clone() {
        CCCEVEvidenceTypeType ret = new CCCEVEvidenceTypeType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setEvidenceTypology(
        @Nullable
        final String valueParam) {
        CodeType aObj = getEvidenceTypology();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setEvidenceTypology(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setDataSetType(
        @Nullable
        final String valueParam) {
        CodeType aObj = getDataSetType();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setDataSetType(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getEvidenceTypologyValue() {
        CodeType aObj = getEvidenceTypology();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getDataSetTypeValue() {
        CodeType aObj = getDataSetType();
        return ((aObj == null)?null:aObj.getValue());
    }

}
