
package eu.toop.edm.jaxb.cccev;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cv.cbc.CodeType;
import eu.toop.edm.jaxb.cv.cbc.IDReferenceType;
import eu.toop.edm.jaxb.dcatap.DCatAPDatasetType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:Class xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Class&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Evidence. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Evidence&lt;/ccts:ObjectClass&gt;&lt;PrimitiveClass&gt;dcat-ap:Dataset&lt;/PrimitiveClass&gt;&lt;/an:Class&gt;
 * </pre>
 * 
 * 
 * <p>Java class for EvidenceType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="EvidenceType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{http://data.europa.eu/r5r/}DatasetType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}confidentialityLevel" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}error" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}conformantTo" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}supportsRequirement" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}supportsConcept" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}providedBy" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attGroup ref="{https://semic.org/sa/cv/common/cac-2.0.0#}ThingAttributes"/&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "EvidenceType", propOrder = {
    "confidentialityLevel",
    "error",
    "conformantTo",
    "supportsRequirement",
    "supportsConcept",
    "providedBy"
})
@CodingStyleguideUnaware
public class CCCEVEvidenceType
    extends DCatAPDatasetType
{

    private CodeType confidentialityLevel;
    private List<CodeType> error;
    private List<IDReferenceType> conformantTo;
    private List<IDReferenceType> supportsRequirement;
    private List<IDReferenceType> supportsConcept;
    private List<IDReferenceType> providedBy;
    @XmlAttribute(name = "versionId")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String versionIdAttr;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CCCEVEvidenceType() {
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Evidence. confidentiality Level&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Evidence&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getConfidentialityLevel() {
        return confidentialityLevel;
    }

    /**
     * Sets the value of the confidentialityLevel property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setConfidentialityLevel(
        @Nullable
        CodeType value) {
        this.confidentialityLevel = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Evidence. error&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..*&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Evidence&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * Gets the value of the error property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the error property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getError().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getError() {
        if (error == null) {
            error = new ArrayList<CodeType>();
        }
        return this.error;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Evidence. conformant To&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition/&gt;&lt;ccts:ObjectClass&gt;Evidence&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;Evidence&lt;/Domain&gt;&lt;Range&gt;EvidenceType&lt;/Range&gt;&lt;Predicate&gt;isConformantTo&lt;/Predicate&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the conformantTo property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the conformantTo property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getConformantTo().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDReferenceType> getConformantTo() {
        if (conformantTo == null) {
            conformantTo = new ArrayList<IDReferenceType>();
        }
        return this.conformantTo;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Evidence. supports Requirement&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition/&gt;&lt;ccts:ObjectClass&gt;Evidence&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;Evidence&lt;/Domain&gt;&lt;Range&gt;Requirement&lt;/Range&gt;&lt;Predicate&gt;supportsRequirement&lt;/Predicate&gt;&lt;Axiom&gt;owl:inverseOf :hasSupportingEvidence&lt;/Axiom&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the supportsRequirement property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supportsRequirement property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSupportsRequirement().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDReferenceType> getSupportsRequirement() {
        if (supportsRequirement == null) {
            supportsRequirement = new ArrayList<IDReferenceType>();
        }
        return this.supportsRequirement;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Evidence. supports Concept&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition/&gt;&lt;ccts:ObjectClass&gt;Evidence&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;Evidence&lt;/Domain&gt;&lt;Range&gt;Concept&lt;/Range&gt;&lt;Predicate&gt;supportsConcept&lt;/Predicate&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the supportsConcept property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supportsConcept property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSupportsConcept().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDReferenceType> getSupportsConcept() {
        if (supportsConcept == null) {
            supportsConcept = new ArrayList<IDReferenceType>();
        }
        return this.supportsConcept;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Evidence. provided By&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition/&gt;&lt;ccts:ObjectClass&gt;Evidence&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;Evidence&lt;/Domain&gt;&lt;Range&gt;Agent&lt;/Range&gt;&lt;Predicate&gt;isProvidedBy&lt;/Predicate&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the providedBy property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the providedBy property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getProvidedBy().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDReferenceType> getProvidedBy() {
        if (providedBy == null) {
            providedBy = new ArrayList<IDReferenceType>();
        }
        return this.providedBy;
    }

    /**
     * Gets the value of the versionIdAttr property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getVersionIdAttr() {
        return versionIdAttr;
    }

    /**
     * Sets the value of the versionIdAttr property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVersionIdAttr(
        @Nullable
        String value) {
        this.versionIdAttr = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final CCCEVEvidenceType rhs = ((CCCEVEvidenceType) o);
        if (!EqualsHelper.equals(confidentialityLevel, rhs.confidentialityLevel)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(conformantTo, rhs.conformantTo)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(error, rhs.error)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(providedBy, rhs.providedBy)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(supportsConcept, rhs.supportsConcept)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(supportsRequirement, rhs.supportsRequirement)) {
            return false;
        }
        if (!EqualsHelper.equals(versionIdAttr, rhs.versionIdAttr)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(confidentialityLevel).append(conformantTo).append(error).append(providedBy).append(supportsConcept).append(supportsRequirement).append(versionIdAttr).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("confidentialityLevel", confidentialityLevel).append("conformantTo", conformantTo).append("error", error).append("providedBy", providedBy).append("supportsConcept", supportsConcept).append("supportsRequirement", supportsRequirement).append("versionIdAttr", versionIdAttr).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setError(
        @Nullable
        final List<CodeType> aList) {
        error = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setConformantTo(
        @Nullable
        final List<IDReferenceType> aList) {
        conformantTo = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSupportsRequirement(
        @Nullable
        final List<IDReferenceType> aList) {
        supportsRequirement = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSupportsConcept(
        @Nullable
        final List<IDReferenceType> aList) {
        supportsConcept = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setProvidedBy(
        @Nullable
        final List<IDReferenceType> aList) {
        providedBy = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasErrorEntries() {
        return (!getError().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoErrorEntries() {
        return getError().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getErrorCount() {
        return getError().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getErrorAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getError().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addError(
        @Nonnull
        final CodeType elem) {
        getError().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasConformantToEntries() {
        return (!getConformantTo().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoConformantToEntries() {
        return getConformantTo().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getConformantToCount() {
        return getConformantTo().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDReferenceType getConformantToAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getConformantTo().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addConformantTo(
        @Nonnull
        final IDReferenceType elem) {
        getConformantTo().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSupportsRequirementEntries() {
        return (!getSupportsRequirement().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSupportsRequirementEntries() {
        return getSupportsRequirement().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSupportsRequirementCount() {
        return getSupportsRequirement().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDReferenceType getSupportsRequirementAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSupportsRequirement().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSupportsRequirement(
        @Nonnull
        final IDReferenceType elem) {
        getSupportsRequirement().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSupportsConceptEntries() {
        return (!getSupportsConcept().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSupportsConceptEntries() {
        return getSupportsConcept().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSupportsConceptCount() {
        return getSupportsConcept().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDReferenceType getSupportsConceptAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSupportsConcept().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSupportsConcept(
        @Nonnull
        final IDReferenceType elem) {
        getSupportsConcept().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasProvidedByEntries() {
        return (!getProvidedBy().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoProvidedByEntries() {
        return getProvidedBy().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getProvidedByCount() {
        return getProvidedBy().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDReferenceType getProvidedByAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getProvidedBy().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addProvidedBy(
        @Nonnull
        final IDReferenceType elem) {
        getProvidedBy().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CCCEVEvidenceType ret) {
        super.cloneTo(ret);
        ret.confidentialityLevel = ((confidentialityLevel == null)?null:confidentialityLevel.clone());
        if (conformantTo == null) {
            ret.conformantTo = null;
        } else {
            List<IDReferenceType> retConformantTo = new ArrayList<IDReferenceType>();
            for (IDReferenceType aItem: getConformantTo()) {
                retConformantTo.add(((aItem == null)?null:aItem.clone()));
            }
            ret.conformantTo = retConformantTo;
        }
        if (error == null) {
            ret.error = null;
        } else {
            List<CodeType> retError = new ArrayList<CodeType>();
            for (CodeType aItem: getError()) {
                retError.add(((aItem == null)?null:aItem.clone()));
            }
            ret.error = retError;
        }
        if (providedBy == null) {
            ret.providedBy = null;
        } else {
            List<IDReferenceType> retProvidedBy = new ArrayList<IDReferenceType>();
            for (IDReferenceType aItem: getProvidedBy()) {
                retProvidedBy.add(((aItem == null)?null:aItem.clone()));
            }
            ret.providedBy = retProvidedBy;
        }
        if (supportsConcept == null) {
            ret.supportsConcept = null;
        } else {
            List<IDReferenceType> retSupportsConcept = new ArrayList<IDReferenceType>();
            for (IDReferenceType aItem: getSupportsConcept()) {
                retSupportsConcept.add(((aItem == null)?null:aItem.clone()));
            }
            ret.supportsConcept = retSupportsConcept;
        }
        if (supportsRequirement == null) {
            ret.supportsRequirement = null;
        } else {
            List<IDReferenceType> retSupportsRequirement = new ArrayList<IDReferenceType>();
            for (IDReferenceType aItem: getSupportsRequirement()) {
                retSupportsRequirement.add(((aItem == null)?null:aItem.clone()));
            }
            ret.supportsRequirement = retSupportsRequirement;
        }
        ret.versionIdAttr = versionIdAttr;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CCCEVEvidenceType clone() {
        CCCEVEvidenceType ret = new CCCEVEvidenceType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setConfidentialityLevel(
        @Nullable
        final String valueParam) {
        CodeType aObj = getConfidentialityLevel();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setConfidentialityLevel(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getConfidentialityLevelValue() {
        CodeType aObj = getConfidentialityLevel();
        return ((aObj == null)?null:aObj.getValue());
    }

}
