
package eu.toop.edm.jaxb.cccev;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cv.cbc.CodeType;
import eu.toop.edm.jaxb.cv.cbc.DescriptionType;
import eu.toop.edm.jaxb.cv.cbc.NumericType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:Class xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Class&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Criterion. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Criterion&lt;/ccts:ObjectClass&gt;&lt;PrimitiveClass&gt;RequirementType&lt;/PrimitiveClass&gt;&lt;/an:Class&gt;
 * </pre>
 * 
 * 
 * <p>Java class for CriterionType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="CriterionType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{https://semic.org/sa/cv/cccev-2.0.0#}RequirementType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}weight" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}weightingConsiderationDescription" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}weightingType" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}bias" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CriterionType", propOrder = {
    "weight",
    "weightingConsiderationDescription",
    "weightingType",
    "bias"
})
@CodingStyleguideUnaware
public class CCCEVCriterionType
    extends CCCEVRequirementType
{

    private NumericType weight;
    private List<DescriptionType> weightingConsiderationDescription;
    private CodeType weightingType;
    private List<NumericType> bias;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CCCEVCriterionType() {
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Criterion. weight&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Criterion&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Numeric&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Numeric&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Numeric. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link NumericType }
     *     
     */
    @Nullable
    public NumericType getWeight() {
        return weight;
    }

    /**
     * Sets the value of the weight property.
     * 
     * @param value
     *     allowed object is
     *     {@link NumericType }
     *     
     */
    public void setWeight(
        @Nullable
        NumericType value) {
        this.weight = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Criterion. weighting Consideration Description&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..*&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Criterion&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Text&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Description. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * Gets the value of the weightingConsiderationDescription property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the weightingConsiderationDescription property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWeightingConsiderationDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getWeightingConsiderationDescription() {
        if (weightingConsiderationDescription == null) {
            weightingConsiderationDescription = new ArrayList<DescriptionType>();
        }
        return this.weightingConsiderationDescription;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Criterion. weighting Type&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Criterion&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getWeightingType() {
        return weightingType;
    }

    /**
     * Sets the value of the weightingType property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setWeightingType(
        @Nullable
        CodeType value) {
        this.weightingType = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Criterion. bias&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..*&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Concept&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;NumericType&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;NumericType&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Numeric. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * Gets the value of the bias property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the bias property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBias().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NumericType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NumericType> getBias() {
        if (bias == null) {
            bias = new ArrayList<NumericType>();
        }
        return this.bias;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final CCCEVCriterionType rhs = ((CCCEVCriterionType) o);
        if (!EqualsHelper.equalsCollection(bias, rhs.bias)) {
            return false;
        }
        if (!EqualsHelper.equals(weight, rhs.weight)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(weightingConsiderationDescription, rhs.weightingConsiderationDescription)) {
            return false;
        }
        if (!EqualsHelper.equals(weightingType, rhs.weightingType)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(bias).append(weight).append(weightingConsiderationDescription).append(weightingType).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("bias", bias).append("weight", weight).append("weightingConsiderationDescription", weightingConsiderationDescription).append("weightingType", weightingType).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setWeightingConsiderationDescription(
        @Nullable
        final List<DescriptionType> aList) {
        weightingConsiderationDescription = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setBias(
        @Nullable
        final List<NumericType> aList) {
        bias = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasWeightingConsiderationDescriptionEntries() {
        return (!getWeightingConsiderationDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoWeightingConsiderationDescriptionEntries() {
        return getWeightingConsiderationDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getWeightingConsiderationDescriptionCount() {
        return getWeightingConsiderationDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getWeightingConsiderationDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getWeightingConsiderationDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addWeightingConsiderationDescription(
        @Nonnull
        final DescriptionType elem) {
        getWeightingConsiderationDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasBiasEntries() {
        return (!getBias().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoBiasEntries() {
        return getBias().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getBiasCount() {
        return getBias().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NumericType getBiasAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getBias().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addBias(
        @Nonnull
        final NumericType elem) {
        getBias().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CCCEVCriterionType ret) {
        super.cloneTo(ret);
        if (bias == null) {
            ret.bias = null;
        } else {
            List<NumericType> retBias = new ArrayList<NumericType>();
            for (NumericType aItem: getBias()) {
                retBias.add(((aItem == null)?null:aItem.clone()));
            }
            ret.bias = retBias;
        }
        ret.weight = ((weight == null)?null:weight.clone());
        if (weightingConsiderationDescription == null) {
            ret.weightingConsiderationDescription = null;
        } else {
            List<DescriptionType> retWeightingConsiderationDescription = new ArrayList<DescriptionType>();
            for (DescriptionType aItem: getWeightingConsiderationDescription()) {
                retWeightingConsiderationDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.weightingConsiderationDescription = retWeightingConsiderationDescription;
        }
        ret.weightingType = ((weightingType == null)?null:weightingType.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CCCEVCriterionType clone() {
        CCCEVCriterionType ret = new CCCEVCriterionType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setWeightingType(
        @Nullable
        final String valueParam) {
        CodeType aObj = getWeightingType();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setWeightingType(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NumericType and never <code>null</code>
     */
    @Nonnull
    public NumericType setWeight(
        @Nullable
        final BigDecimal valueParam) {
        NumericType aObj = getWeight();
        if (aObj == null) {
            aObj = new NumericType(valueParam);
            setWeight(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained NumericType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getWeightValue() {
        NumericType aObj = getWeight();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getWeightingTypeValue() {
        CodeType aObj = getWeightingType();
        return ((aObj == null)?null:aObj.getValue());
    }

}
