/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.tools;

import java.util.Iterator;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Zone;

public class primary {
    private static void usage() {
        System.out.println("usage: primary [-t] [-a | -i] origin file");
        System.exit(1);
    }

    public static void main(String[] args2) throws Exception {
        boolean time = false;
        boolean axfr = false;
        boolean iterator2 = false;
        int arg = 0;
        if (args2.length < 2) {
            primary.usage();
        }
        while (args2.length - arg > 2) {
            switch (args2[0]) {
                case "-t": {
                    time = true;
                    break;
                }
                case "-a": {
                    axfr = true;
                    break;
                }
                case "-i": {
                    iterator2 = true;
                }
            }
            ++arg;
        }
        Name origin = Name.fromString(args2[arg++], Name.root);
        String file = args2[arg++];
        long start2 = System.currentTimeMillis();
        Zone zone = new Zone(origin, file);
        long end = System.currentTimeMillis();
        if (axfr) {
            Iterator<RRset> it = zone.AXFR();
            while (it.hasNext()) {
                System.out.println(it.next());
            }
        } else if (iterator2) {
            Iterator<RRset> it = zone.iterator();
            while (it.hasNext()) {
                System.out.println(it.next());
            }
        } else {
            System.out.println(zone);
        }
        if (time) {
            System.out.println("; Load time: " + (end - start2) + " ms");
        }
    }
}

