/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.Tokenizer;

public class Update
extends Message {
    private Name origin;
    private int dclass;

    public Update(Name zone, int dclass) {
        if (!zone.isAbsolute()) {
            throw new RelativeNameException(zone);
        }
        DClass.check(dclass);
        this.getHeader().setOpcode(5);
        Record soa = Record.newRecord(zone, 6, 1);
        this.addRecord(soa, 0);
        this.origin = zone;
        this.dclass = dclass;
    }

    public Update(Name zone) {
        this(zone, 1);
    }

    private void newPrereq(Record rec) {
        this.addRecord(rec, 1);
    }

    private void newUpdate(Record rec) {
        this.addRecord(rec, 2);
    }

    public void present(Name name) {
        this.newPrereq(Record.newRecord(name, 255, 255, 0L));
    }

    public void present(Name name, int type2) {
        this.newPrereq(Record.newRecord(name, type2, 255, 0L));
    }

    public void present(Name name, int type2, String record) throws IOException {
        this.newPrereq(Record.fromString(name, type2, this.dclass, 0L, record, this.origin));
    }

    public void present(Name name, int type2, Tokenizer tokenizer) throws IOException {
        this.newPrereq(Record.fromString(name, type2, this.dclass, 0L, tokenizer, this.origin));
    }

    public void present(Record record) {
        this.newPrereq(record);
    }

    public void absent(Name name) {
        this.newPrereq(Record.newRecord(name, 255, 254, 0L));
    }

    public void absent(Name name, int type2) {
        this.newPrereq(Record.newRecord(name, type2, 254, 0L));
    }

    public void add(Name name, int type2, long ttl, String record) throws IOException {
        this.newUpdate(Record.fromString(name, type2, this.dclass, ttl, record, this.origin));
    }

    public void add(Name name, int type2, long ttl, Tokenizer tokenizer) throws IOException {
        this.newUpdate(Record.fromString(name, type2, this.dclass, ttl, tokenizer, this.origin));
    }

    public void add(Record record) {
        this.newUpdate(record);
    }

    public void add(Record[] records) {
        for (Record record : records) {
            this.add(record);
        }
    }

    public <T extends Record> void add(RRset rrset) {
        rrset.rrs().forEach(this::add);
    }

    public void delete(Name name) {
        this.newUpdate(Record.newRecord(name, 255, 255, 0L));
    }

    public void delete(Name name, int type2) {
        this.newUpdate(Record.newRecord(name, type2, 255, 0L));
    }

    public void delete(Name name, int type2, String record) throws IOException {
        this.newUpdate(Record.fromString(name, type2, 254, 0L, record, this.origin));
    }

    public void delete(Name name, int type2, Tokenizer tokenizer) throws IOException {
        this.newUpdate(Record.fromString(name, type2, 254, 0L, tokenizer, this.origin));
    }

    public void delete(Record record) {
        this.newUpdate(record.withDClass(254, 0L));
    }

    public void delete(Record[] records) {
        for (Record record : records) {
            this.delete(record);
        }
    }

    public <T extends Record> void delete(RRset rrset) {
        rrset.rrs().forEach(this::delete);
    }

    public void replace(Name name, int type2, long ttl, String record) throws IOException {
        this.delete(name, type2);
        this.add(name, type2, ttl, record);
    }

    public void replace(Name name, int type2, long ttl, Tokenizer tokenizer) throws IOException {
        this.delete(name, type2);
        this.add(name, type2, ttl, tokenizer);
    }

    public void replace(Record record) {
        this.delete(record.getName(), record.getType());
        this.add(record);
    }

    public void replace(Record[] records) {
        for (Record record : records) {
            this.replace(record);
        }
    }

    public <T extends Record> void replace(RRset rrset) {
        this.delete(rrset.getName(), rrset.getType());
        rrset.rrs().forEach(this::add);
    }
}

