/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.runtime.parser.node.MathUtils;

public class DuckType {
    protected static final Object NO_METHOD = new Object();

    public static void clearCache() {
        for (Types type2 : Types.values()) {
            type2.cache.clear();
        }
    }

    public static String asString(Object value) {
        return DuckType.asString(value, true);
    }

    public static String asString(Object value, boolean coerceType) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (coerceType && value.getClass().isArray()) {
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(DuckType.asString(Array.get(value, i)));
            }
            builder.append(']');
            return builder.toString();
        }
        Object got = DuckType.get(value, Types.STRING);
        if (got == NO_METHOD) {
            return coerceType ? value.toString() : null;
        }
        return (String)got;
    }

    public static boolean asNull(Object value) {
        return value == null || DuckType.get(value, Types.STRING) == null || DuckType.get(value, Types.NUMBER) == null;
    }

    public static boolean asBoolean(Object value, boolean coerceType) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        Object got = DuckType.get(value, Types.BOOLEAN);
        if (got != NO_METHOD) {
            return (Boolean)got;
        }
        if (coerceType) {
            return !DuckType.asEmpty(value);
        }
        return true;
    }

    public static boolean asEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        Object isEmpty = DuckType.get(value, Types.EMPTY);
        if (isEmpty != NO_METHOD) {
            return (Boolean)isEmpty;
        }
        Object length = DuckType.get(value, Types.LENGTH);
        if (length != NO_METHOD && length instanceof Number) {
            return MathUtils.isZero((Number)length);
        }
        Object size = DuckType.get(value, Types.SIZE);
        if (size != NO_METHOD && size instanceof Number) {
            return MathUtils.isZero((Number)size);
        }
        if (value instanceof Number) {
            return MathUtils.isZero((Number)value);
        }
        Object asString2 = DuckType.get(value, Types.STRING);
        if (asString2 == null) {
            return true;
        }
        if (asString2 != NO_METHOD) {
            return ((String)asString2).length() == 0;
        }
        Object asNumber = DuckType.get(value, Types.NUMBER);
        if (asNumber == null) {
            return true;
        }
        if (asNumber != NO_METHOD && asNumber instanceof Number) {
            return MathUtils.isZero((Number)asNumber);
        }
        return false;
    }

    public static Number asNumber(Object value) {
        return DuckType.asNumber(value, true);
    }

    public static Number asNumber(Object value, boolean coerceType) {
        String string;
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        Object got = DuckType.get(value, Types.NUMBER);
        if (got != NO_METHOD) {
            return (Number)got;
        }
        if (coerceType && (string = DuckType.asString(value)) != null) {
            return new BigDecimal(string);
        }
        return null;
    }

    protected static Object get(Object value, Types type2) {
        try {
            Class<?> c = value.getClass();
            Object cached = type2.get(c);
            if (cached == NO_METHOD) {
                return cached;
            }
            if (cached != null) {
                return ((Method)cached).invoke(value, new Object[0]);
            }
            Method method = DuckType.findMethod(c, type2);
            if (method == null) {
                type2.set(c, NO_METHOD);
                return NO_METHOD;
            }
            type2.set(c, method);
            return method.invoke(value, new Object[0]);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static Method findMethod(Class c, Types type2) {
        if (c == null || c == Object.class) {
            return null;
        }
        Method m = DuckType.getMethod(c, type2.name);
        if (m != null) {
            return m;
        }
        for (Class<?> i : c.getInterfaces()) {
            m = DuckType.findMethod(i, type2);
            if (m == null) continue;
            return m;
        }
        m = DuckType.findMethod(c.getSuperclass(), type2);
        if (m != null) {
            return m;
        }
        return null;
    }

    private static Method getMethod(Class c, String name) {
        if (Modifier.isPublic(c.getModifiers())) {
            try {
                Method m = c.getDeclaredMethod(name, new Class[0]);
                if (Modifier.isPublic(m.getModifiers())) {
                    return m;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static enum Types {
        STRING("getAsString"),
        NUMBER("getAsNumber"),
        BOOLEAN("getAsBoolean"),
        EMPTY("isEmpty"),
        LENGTH("length"),
        SIZE("size");

        final String name;
        final Map<Class, Object> cache = new HashMap<Class, Object>();

        private Types(String name) {
            this.name = name;
        }

        void set(Class c, Object o) {
            this.cache.put(c, o);
        }

        Object get(Class c) {
            return this.cache.get(c);
        }
    }
}

