/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.ws.spi;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.ws.WebServiceException;

class FactoryFinder {
    private static final String OSGI_SERVICE_LOADER_CLASS_NAME = "org.glassfish.hk2.osgiresourcelocator.ServiceLoader";

    FactoryFinder() {
    }

    private static Object newInstance(String className, ClassLoader classLoader) {
        try {
            Class spiClass = FactoryFinder.safeLoadClass(className, classLoader);
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new WebServiceException("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new WebServiceException("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static Object find(String factoryId, String fallbackClassName) {
        FileInputStream inStream;
        ClassLoader classLoader;
        block16: {
            Object object;
            BufferedReader rd;
            block15: {
                Object object2;
                if (FactoryFinder.isOsgi()) {
                    return FactoryFinder.lookupUsingOSGiServiceLoader(factoryId);
                }
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (Exception x) {
                    throw new WebServiceException(x.toString(), x);
                }
                String serviceId = "META-INF/services/" + factoryId;
                rd = null;
                try {
                    String factoryClassName;
                    InputStream is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
                    if (is == null || (factoryClassName = (rd = new BufferedReader(new InputStreamReader(is, "UTF-8"))).readLine()) == null || "".equals(factoryClassName)) break block15;
                    object2 = FactoryFinder.newInstance(factoryClassName, classLoader);
                }
                catch (Exception ignored) {
                    FactoryFinder.close(rd);
                    catch (Throwable throwable) {
                        FactoryFinder.close(rd);
                        throw throwable;
                    }
                }
                FactoryFinder.close(rd);
                return object2;
            }
            FactoryFinder.close(rd);
            inStream = null;
            try {
                String javah = System.getProperty("java.home");
                String configFile = javah + File.separator + "lib" + File.separator + "jaxws.properties";
                File f = new File(configFile);
                if (!f.exists()) break block16;
                Properties props = new Properties();
                inStream = new FileInputStream(f);
                props.load(inStream);
                String factoryClassName = props.getProperty(factoryId);
                object = FactoryFinder.newInstance(factoryClassName, classLoader);
            }
            catch (Exception ignored) {
                FactoryFinder.close(inStream);
                catch (Throwable throwable) {
                    FactoryFinder.close(inStream);
                    throw throwable;
                }
            }
            FactoryFinder.close(inStream);
            return object;
        }
        FactoryFinder.close(inStream);
        try {
            String systemProp = System.getProperty(factoryId);
            if (systemProp != null) {
                return FactoryFinder.newInstance(systemProp, classLoader);
            }
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        if (fallbackClassName == null) {
            throw new WebServiceException("Provider for " + factoryId + " cannot be found", null);
        }
        return FactoryFinder.newInstance(fallbackClassName, classLoader);
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static Class safeLoadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            int i;
            SecurityManager s = System.getSecurityManager();
            if (s != null && (i = className.lastIndexOf(46)) != -1) {
                s.checkPackageAccess(className.substring(0, i));
            }
            if (classLoader == null) {
                return Class.forName(className);
            }
            return classLoader.loadClass(className);
        }
        catch (SecurityException se) {
            if ("com.sun.xml.internal.ws.spi.ProviderImpl".equals(className)) {
                return Class.forName(className);
            }
            throw se;
        }
    }

    private static boolean isOsgi() {
        try {
            Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static Object lookupUsingOSGiServiceLoader(String factoryId) {
        try {
            Class<?> serviceClass = Class.forName(factoryId);
            Class[] args2 = new Class[]{serviceClass};
            Class<?> target = Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            Method m = target.getMethod("lookupProviderInstances", Class.class);
            Iterator iter = ((Iterable)m.invoke(null, (Object[])args2)).iterator();
            return iter.hasNext() ? iter.next() : null;
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

