/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.plugin.rendering;

import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.plugin.rendering.FileRenderer;
import io.javalin.plugin.rendering.markdown.JavalinCommonmark;
import io.javalin.plugin.rendering.template.JavalinFreemarker;
import io.javalin.plugin.rendering.template.JavalinJtwig;
import io.javalin.plugin.rendering.template.JavalinMustache;
import io.javalin.plugin.rendering.template.JavalinPebble;
import io.javalin.plugin.rendering.template.JavalinThymeleaf;
import io.javalin.plugin.rendering.template.JavalinVelocity;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0014\"\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u0015J,\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\u0005*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u0005*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0018\u0010\f\u001a\u00020\r*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lio/javalin/plugin/rendering/JavalinRenderer;", "", "()V", "extensions", "", "", "Lio/javalin/plugin/rendering/FileRenderer;", "doubleExtension", "getDoubleExtension", "(Ljava/lang/String;)Ljava/lang/String;", "extension", "getExtension", "hasTwoDots", "", "getHasTwoDots", "(Ljava/lang/String;)Z", "register", "", "fileRenderer", "ext", "", "(Lio/javalin/plugin/rendering/FileRenderer;[Ljava/lang/String;)V", "renderBasedOnExtension", "filePath", "model", "", "ctx", "Lio/javalin/http/Context;", "javalin"})
public final class JavalinRenderer {
    private static final Map<String, FileRenderer> extensions;
    public static final JavalinRenderer INSTANCE;

    @NotNull
    public final String renderBasedOnExtension(@NotNull String filePath, @NotNull Map<String, ? extends Object> model, @NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull(filePath, "filePath");
        Intrinsics.checkParameterIsNotNull(model, "model");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        String extension = this.getHasTwoDots(filePath) ? this.getDoubleExtension(filePath) : this.getExtension(filePath);
        FileRenderer fileRenderer = extensions.get(extension);
        if (fileRenderer == null) {
            fileRenderer = extensions.get(this.getExtension(filePath));
        }
        if (fileRenderer == null) {
            throw (Throwable)new IllegalArgumentException("No Renderer registered for extension '" + this.getExtension(filePath) + "'.");
        }
        FileRenderer renderer = fileRenderer;
        String string = renderer.render(filePath, model, ctx);
        Intrinsics.checkExpressionValueIsNotNull(string, "renderer.render(filePath, model, ctx)");
        return string;
    }

    @JvmStatic
    public static final void register(@NotNull FileRenderer fileRenderer, String ... ext) {
        Intrinsics.checkParameterIsNotNull(fileRenderer, "fileRenderer");
        Intrinsics.checkParameterIsNotNull(ext, "ext");
        String[] $this$forEach$iv = ext;
        boolean $i$f$forEach = false;
        String[] stringArray = $this$forEach$iv;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = stringArray[i];
            boolean bl = false;
            if (extensions.get(it) != null) {
                Logger logger = Javalin.log;
                if (logger != null) {
                    StringBuilder stringBuilder = new StringBuilder().append('\'').append(it).append("' is already registered to ");
                    FileRenderer fileRenderer2 = extensions.get(it);
                    if (fileRenderer2 == null) {
                        Intrinsics.throwNpe();
                    }
                    logger.info(stringBuilder.append(fileRenderer2.getClass()).append(". Overriding.").toString());
                }
            }
            extensions.put(it, fileRenderer);
        }
    }

    private final String getExtension(@NotNull String $this$extension) {
        return StringsKt.replaceBeforeLast$default($this$extension, ".", "", null, 4, null);
    }

    private final String getDoubleExtension(@NotNull String $this$doubleExtension) {
        return this.getExtension(StringsKt.substringBeforeLast($this$doubleExtension, ".", "")) + this.getExtension($this$doubleExtension);
    }

    private final boolean getHasTwoDots(@NotNull String $this$hasTwoDots) {
        CharSequence $this$count$iv = $this$hasTwoDots;
        boolean $i$f$count = false;
        int count$iv = 0;
        CharSequence charSequence = $this$count$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv;
            char it = element$iv = charSequence.charAt(i);
            boolean bl = false;
            if (!(it == '.')) continue;
            ++count$iv;
        }
        return count$iv > 1;
    }

    private JavalinRenderer() {
    }

    static {
        JavalinRenderer javalinRenderer;
        INSTANCE = javalinRenderer = new JavalinRenderer();
        boolean bl = false;
        extensions = new LinkedHashMap();
        JavalinRenderer.register(JavalinVelocity.INSTANCE, ".vm", ".vtl");
        JavalinRenderer.register(JavalinFreemarker.INSTANCE, ".ftl");
        JavalinRenderer.register(JavalinMustache.INSTANCE, ".mustache");
        JavalinRenderer.register(JavalinJtwig.INSTANCE, ".jtwig", ".twig", ".html.twig");
        JavalinRenderer.register(JavalinPebble.INSTANCE, ".peb", ".pebble");
        JavalinRenderer.register(JavalinThymeleaf.INSTANCE, ".html", ".tl", ".thyme", ".thymeleaf");
        JavalinRenderer.register(JavalinCommonmark.INSTANCE, ".md", ".markdown");
    }
}

