/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.plugin.openapi.dsl;

import io.javalin.Javalin;
import io.javalin.core.event.HandlerMetaInfo;
import io.javalin.core.util.OptionalDependency;
import io.javalin.core.util.ReflectionUtilKt;
import io.javalin.core.util.Util;
import io.javalin.plugin.openapi.CreateSchemaOptions;
import io.javalin.plugin.openapi.DefaultDocumentation;
import io.javalin.plugin.openapi.annotations.AnnotationApiKt;
import io.javalin.plugin.openapi.annotations.AnnotationApiMappingKt;
import io.javalin.plugin.openapi.annotations.OpenApi;
import io.javalin.plugin.openapi.annotations.PathInfo;
import io.javalin.plugin.openapi.annotations.ScanForAnnotationsKt;
import io.javalin.plugin.openapi.dsl.DocumentedHandler;
import io.javalin.plugin.openapi.dsl.OpenApiBuilder;
import io.javalin.plugin.openapi.dsl.OpenApiBuilderDslKt;
import io.javalin.plugin.openapi.dsl.OpenApiDocumentation;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u0004\u0018\u00010\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u001a!\u0010\f\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0001\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0011*\u00020\u0002H\u0002\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0011*\u00020\u0002H\u0002\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u0015"}, d2={"methodReferenceOfHandler", "Ljava/lang/reflect/Method;", "Lio/javalin/core/event/HandlerMetaInfo;", "getMethodReferenceOfHandler", "(Lio/javalin/core/event/HandlerMetaInfo;)Ljava/lang/reflect/Method;", "methodReferenceOfNonStaticJavaHandler", "getMethodReferenceOfNonStaticJavaHandler", "extractDocumentation", "Lio/javalin/plugin/openapi/dsl/OpenApiDocumentation;", "options", "Lio/javalin/plugin/openapi/CreateSchemaOptions;", "extractDocumentationWithPathScanning", "findMethodByOpenApiAnnotation", "methods", "", "(Lio/javalin/core/event/HandlerMetaInfo;[Ljava/lang/reflect/Method;)Ljava/lang/reflect/Method;", "getOpenApiAnnotation", "Lio/javalin/plugin/openapi/annotations/OpenApi;", "Ljava/lang/reflect/Field;", "getOpenApiAnnotationFromHandler", "getOpenApiAnnotationFromReference", "javalin"})
public final class ExtractDocumentationKt {
    @NotNull
    public static final OpenApiDocumentation extractDocumentation(@NotNull HandlerMetaInfo $this$extractDocumentation, @NotNull CreateSchemaOptions options) {
        Object object;
        Intrinsics.checkParameterIsNotNull($this$extractDocumentation, "$this$extractDocumentation");
        Intrinsics.checkParameterIsNotNull(options, "options");
        OpenApiDocumentation documentation = OpenApiBuilder.document();
        DefaultDocumentation defaultDocumentation = options.getDefault();
        if (defaultDocumentation != null) {
            defaultDocumentation.apply(documentation);
        }
        if ($this$extractDocumentation.getHandler() instanceof DocumentedHandler) {
            object = ((DocumentedHandler)$this$extractDocumentation.getHandler()).getDocumentation();
        } else {
            OpenApi openApiAnnotation;
            Object object2;
            OpenApi openApi = ExtractDocumentationKt.getOpenApiAnnotationFromReference($this$extractDocumentation);
            if (openApi == null) {
                openApi = ExtractDocumentationKt.getOpenApiAnnotationFromHandler($this$extractDocumentation);
            }
            if ((object2 = (openApiAnnotation = openApi)) == null || (object2 = AnnotationApiMappingKt.asOpenApiDocumentation((OpenApi)object2)) == null) {
                object2 = object = ExtractDocumentationKt.extractDocumentationWithPathScanning($this$extractDocumentation, options);
            }
            if (object2 == null) {
                object = OpenApiBuilder.document();
            }
        }
        OpenApiDocumentation userDocumentation = object;
        documentation.apply(userDocumentation);
        return documentation;
    }

    private static final OpenApiDocumentation extractDocumentationWithPathScanning(@NotNull HandlerMetaInfo $this$extractDocumentationWithPathScanning, CreateSchemaOptions options) {
        OpenApiDocumentation openApiDocumentation;
        if (options.getPackagePrefixesToScan().isEmpty()) {
            return null;
        }
        Util.ensureDependencyPresent$default(Util.INSTANCE, OptionalDependency.CLASS_GRAPH, false, 2, null);
        PathInfo pathInfo = OpenApiBuilderDslKt.getPathInfo($this$extractDocumentationWithPathScanning);
        if (pathInfo != null) {
            PathInfo pathInfo2 = pathInfo;
            boolean bl = false;
            boolean bl2 = false;
            PathInfo pathInfo3 = pathInfo2;
            boolean bl3 = false;
            Map<PathInfo, OpenApiDocumentation> documentationFromScan = ScanForAnnotationsKt.scanForAnnotations(options.getPackagePrefixesToScan());
            openApiDocumentation = documentationFromScan.get(pathInfo3);
        } else {
            openApiDocumentation = null;
        }
        return openApiDocumentation;
    }

    private static final OpenApi getOpenApiAnnotationFromReference(@NotNull HandlerMetaInfo $this$getOpenApiAnnotationFromReference) {
        Object object;
        try {
            Object object2 = ExtractDocumentationKt.getMethodReferenceOfHandler($this$getOpenApiAnnotationFromReference);
            if (object2 == null || (object2 = ExtractDocumentationKt.getOpenApiAnnotation((Method)object2)) == null) {
                Field field = ReflectionUtilKt.getLambdaField($this$getOpenApiAnnotationFromReference.getHandler());
                object2 = field != null ? ExtractDocumentationKt.getOpenApiAnnotation(field) : null;
            }
            object = object2;
        }
        catch (NoSuchFieldException e) {
            object = null;
        }
        catch (Error e) {
            if (!Intrinsics.areEqual(Reflection.getOrCreateKotlinClass(e.getClass()).getQualifiedName(), "kotlin.reflect.jvm.internal.KotlinReflectionInternalError")) {
                throw (Throwable)e;
            }
            Logger.getGlobal().warning("Local functions, lambdas, anonymous functions and local variables with @OpenApi annotations are currently not supported. " + "The annotation of the handler for \"" + (Object)((Object)$this$getOpenApiAnnotationFromReference.getHttpMethod()) + ' ' + $this$getOpenApiAnnotationFromReference.getPath() + "\" will be ignored. To fix this, move the handler into a global function.");
            return null;
        }
        return object;
    }

    private static final OpenApi getOpenApiAnnotationFromHandler(@NotNull HandlerMetaInfo $this$getOpenApiAnnotationFromHandler) {
        OpenApi openApi;
        try {
            Method method = ReflectionUtilKt.getMethodByName($this$getOpenApiAnnotationFromHandler.getHandler().getClass(), "handle");
            if (method == null) {
                Intrinsics.throwNpe();
            }
            Method method2 = method;
            openApi = ExtractDocumentationKt.getOpenApiAnnotation(method2);
        }
        catch (NullPointerException e) {
            openApi = null;
        }
        return openApi;
    }

    private static final Method getMethodReferenceOfHandler(@NotNull HandlerMetaInfo $this$methodReferenceOfHandler) {
        Method method;
        if (ReflectionUtilKt.isClass($this$methodReferenceOfHandler.getHandler())) {
            Object object = $this$methodReferenceOfHandler.getHandler();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
            }
            method = ((Class)object).getMethods()[0];
        } else if (ReflectionUtilKt.isKotlinMethodReference($this$methodReferenceOfHandler.getHandler())) {
            Object object = ReflectionUtilKt.getFieldValue($this$methodReferenceOfHandler.getHandler(), "function");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.reflect.KFunction<*>");
            }
            KFunction functionValue = (KFunction)object;
            method = ReflectJvmMapping.getJavaMethod((KFunction)functionValue);
        } else {
            method = ReflectionUtilKt.isKotlinAnonymousLambda($this$methodReferenceOfHandler.getHandler()) ? null : (ReflectionUtilKt.isJavaNonStaticMethodReference($this$methodReferenceOfHandler.getHandler()) ? ExtractDocumentationKt.getMethodReferenceOfNonStaticJavaHandler($this$methodReferenceOfHandler) : (ReflectionUtilKt.isJavaAnonymousLambda($this$methodReferenceOfHandler.getHandler()) ? null : null));
        }
        return method;
    }

    private static final Method getMethodReferenceOfNonStaticJavaHandler(@NotNull HandlerMetaInfo $this$methodReferenceOfNonStaticJavaHandler) {
        Method method;
        Method[] handlerParentClass;
        Object object = ReflectionUtilKt.getMethodByName($this$methodReferenceOfNonStaticJavaHandler.getHandler().getClass(), "get$Lambda");
        Method[] methodArray = handlerParentClass = (Method[])(object != null && (object = ((Executable)object).getParameters()) != null && (object = object[0]) != null ? ((Parameter)object).getParameterizedType() : null);
        if (handlerParentClass == null || (methodArray = ReflectionUtilKt.getMethodsNotDeclaredByObject(methodArray)) == null) {
            methodArray = new Method[]{};
        }
        Method[] methods = methodArray;
        Method[] methodArray2 = methods;
        boolean bl = false;
        if (methodArray2.length == 0) {
            method = null;
        } else if (methods.length == 1) {
            method = methods[0];
        } else {
            boolean hasAnyMethodTheOpenApiAnnotation;
            block8: {
                boolean bl2;
                Method methodThatMatchesHandler = ExtractDocumentationKt.findMethodByOpenApiAnnotation($this$methodReferenceOfNonStaticJavaHandler, methods);
                if (methodThatMatchesHandler != null) {
                    return methodThatMatchesHandler;
                }
                Method[] $this$any$iv = methods;
                boolean $i$f$any = false;
                Method[] methodArray3 = $this$any$iv;
                int n = methodArray3.length;
                for (int i = 0; i < n; ++i) {
                    Method element$iv;
                    Method it = element$iv = methodArray3[i];
                    boolean bl3 = false;
                    if (!(ExtractDocumentationKt.getOpenApiAnnotation(it) != null)) continue;
                    bl2 = true;
                    break block8;
                }
                bl2 = hasAnyMethodTheOpenApiAnnotation = false;
            }
            if (hasAnyMethodTheOpenApiAnnotation && handlerParentClass != null) {
                Javalin.log.warn("Unfortunately it is not possible to match the @OpenApi annotations to the handler in " + handlerParentClass.getCanonicalName() + ". " + "Please add the `path` and the `method` information to the annotation, so the handler can be matched.");
            }
            method = null;
        }
        return method;
    }

    /*
     * WARNING - void declaration
     */
    private static final Method findMethodByOpenApiAnnotation(@NotNull HandlerMetaInfo $this$findMethodByOpenApiAnnotation, Method[] methods) {
        Method method;
        OpenApi annotation;
        void $this$filterTo$iv$iv;
        Method[] $this$filter$iv = methods;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Object t = $this$filterTo$iv$iv;
        int n = ((void)t).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = t[i];
            boolean bl = false;
            boolean bl2 = ExtractDocumentationKt.getOpenApiAnnotation((Method)it) == null ? false : Intrinsics.areEqual(annotation.path(), $this$findMethodByOpenApiAnnotation.getPath());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List methodsThatMatchesPath = (List)destination$iv$iv;
        if (methodsThatMatchesPath.size() == 1) {
            method = (Method)methodsThatMatchesPath.get(0);
        } else if (methodsThatMatchesPath.size() > 1) {
            Object v3;
            block8: {
                Iterable iterable = methodsThatMatchesPath;
                boolean bl = false;
                object = iterable;
                boolean bl3 = false;
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    boolean bl4;
                    t = iterator2.next();
                    Method it = (Method)t;
                    boolean bl5 = false;
                    if (ExtractDocumentationKt.getOpenApiAnnotation(it) != null) {
                        OpenApi openApi;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        annotation = openApi;
                        boolean bl8 = false;
                        bl4 = Intrinsics.areEqual(AnnotationApiKt.getPathInfo(annotation), OpenApiBuilderDslKt.getPathInfo($this$findMethodByOpenApiAnnotation));
                    } else {
                        bl4 = false;
                    }
                    if (!bl4) continue;
                    v3 = t;
                    break block8;
                }
                v3 = null;
            }
            method = v3;
        } else {
            method = null;
        }
        return method;
    }

    @Nullable
    public static final OpenApi getOpenApiAnnotation(@NotNull Method $this$getOpenApiAnnotation) {
        Intrinsics.checkParameterIsNotNull($this$getOpenApiAnnotation, "$this$getOpenApiAnnotation");
        OpenApi openApi = $this$getOpenApiAnnotation.getAnnotation(OpenApi.class);
        if (openApi == null) {
            return null;
        }
        OpenApi result = openApi;
        Class<?> clazz = $this$getOpenApiAnnotation.getDeclaringClass();
        Intrinsics.checkExpressionValueIsNotNull(clazz, "this.declaringClass");
        AnnotationApiKt.warnUserAboutPotentialBugs(result, clazz);
        return result;
    }

    @Nullable
    public static final OpenApi getOpenApiAnnotation(@NotNull Field $this$getOpenApiAnnotation) {
        Intrinsics.checkParameterIsNotNull($this$getOpenApiAnnotation, "$this$getOpenApiAnnotation");
        OpenApi openApi = $this$getOpenApiAnnotation.getAnnotation(OpenApi.class);
        if (openApi == null) {
            return null;
        }
        OpenApi result = openApi;
        Class<?> clazz = $this$getOpenApiAnnotation.getDeclaringClass();
        Intrinsics.checkExpressionValueIsNotNull(clazz, "this.declaringClass");
        AnnotationApiKt.warnUserAboutPotentialBugs(result, clazz);
        return result;
    }
}

