/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http.staticfiles;

import io.javalin.Javalin;
import io.javalin.core.util.Util;
import io.javalin.http.JavalinResponseWrapper;
import io.javalin.http.staticfiles.Location;
import io.javalin.http.staticfiles.ResourceHandler;
import io.javalin.http.staticfiles.StaticFileConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0017\u001a\u00020\u0012*\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u000e\u0010\u001b\u001a\u00020\u0012*\u0004\u0018\u00010\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lio/javalin/http/staticfiles/JettyResourceHandler;", "Lio/javalin/http/staticfiles/ResourceHandler;", "()V", "dummyServer", "Lorg/eclipse/jetty/server/Server;", "handlers", "", "Lorg/eclipse/jetty/server/handler/ResourceHandler;", "getHandlers", "()Ljava/util/List;", "addStaticFileConfig", "", "config", "Lio/javalin/http/staticfiles/StaticFileConfig;", "getResourcePath", "", "staticFileConfig", "handle", "", "httpRequest", "Ljavax/servlet/http/HttpServletRequest;", "httpResponse", "Ljavax/servlet/http/HttpServletResponse;", "isDirectoryWithWelcomeFile", "Lorg/eclipse/jetty/util/resource/Resource;", "handler", "target", "isFile", "WebjarHandler", "javalin"})
public final class JettyResourceHandler
implements ResourceHandler {
    @NotNull
    private final List<org.eclipse.jetty.server.handler.ResourceHandler> handlers;
    private final Server dummyServer;

    @NotNull
    public final List<org.eclipse.jetty.server.handler.ResourceHandler> getHandlers() {
        return this.handlers;
    }

    @Override
    public void addStaticFileConfig(@NotNull StaticFileConfig config) {
        org.eclipse.jetty.server.handler.ResourceHandler handler;
        org.eclipse.jetty.server.handler.ResourceHandler $this$apply;
        boolean bl;
        boolean bl2;
        org.eclipse.jetty.server.handler.ResourceHandler resourceHandler;
        org.eclipse.jetty.server.handler.ResourceHandler resourceHandler2;
        Intrinsics.checkParameterIsNotNull(config, "config");
        if (Intrinsics.areEqual(config.getPath(), "/webjars")) {
            resourceHandler2 = new WebjarHandler();
        } else {
            resourceHandler = new org.eclipse.jetty.server.handler.ResourceHandler();
            bl2 = false;
            bl = false;
            $this$apply = resourceHandler;
            boolean bl3 = false;
            $this$apply.setResourceBase(this.getResourcePath(config));
            $this$apply.setDirAllowed(false);
            $this$apply.setEtags(true);
            Logger logger = Javalin.log;
            if (logger != null) {
                logger.info("Static file handler added with path=" + config.getPath() + " and location=" + (Object)((Object)config.getLocation()) + ". Absolute path: '" + this.getResourcePath(config) + "'.");
            }
            resourceHandler2 = resourceHandler;
        }
        resourceHandler = handler = resourceHandler2;
        List<org.eclipse.jetty.server.handler.ResourceHandler> list = this.handlers;
        bl2 = false;
        bl = false;
        $this$apply = resourceHandler;
        boolean bl4 = false;
        $this$apply.setServer(this.dummyServer);
        $this$apply.start();
        org.eclipse.jetty.server.handler.ResourceHandler resourceHandler3 = resourceHandler;
        list.add(resourceHandler3);
    }

    @NotNull
    public final String getResourcePath(@NotNull StaticFileConfig staticFileConfig) {
        Intrinsics.checkParameterIsNotNull(staticFileConfig, "staticFileConfig");
        String nosuchdir = "Static resource directory with path: '" + staticFileConfig.getPath() + "' does not exist.";
        if (staticFileConfig.getLocation() == Location.CLASSPATH) {
            Resource classPathResource = Resource.newClassPathResource(staticFileConfig.getPath());
            if (classPathResource == null) {
                throw (Throwable)new RuntimeException(nosuchdir + " Depending on your setup, empty folders might not get copied to classpath.");
            }
            return classPathResource.toString();
        }
        if (!new File(staticFileConfig.getPath()).exists()) {
            throw (Throwable)new RuntimeException(nosuchdir);
        }
        return staticFileConfig.getPath();
    }

    @Override
    public boolean handle(@NotNull HttpServletRequest httpRequest, @NotNull HttpServletResponse httpResponse) {
        Intrinsics.checkParameterIsNotNull(httpRequest, "httpRequest");
        Intrinsics.checkParameterIsNotNull(httpResponse, "httpResponse");
        Object object = httpRequest.getAttribute("jetty-target");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String target = (String)object;
        Object object2 = httpRequest.getAttribute("jetty-request");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.eclipse.jetty.server.Request");
        }
        Request baseRequest = (Request)object2;
        for (org.eclipse.jetty.server.handler.ResourceHandler handler : this.handlers) {
            try {
                Resource resource = handler.getResource(target);
                if (!this.isFile(resource) && !this.isDirectoryWithWelcomeFile(resource, handler, target)) continue;
                int maxAge = StringsKt.startsWith$default(target, "/immutable/", false, 2, null) || handler instanceof WebjarHandler ? 31622400 : 0;
                httpResponse.setHeader("Cache-Control", "max-age=" + maxAge);
                httpResponse.setContentType(null);
                handler.handle(target, baseRequest, httpRequest, httpResponse);
                httpRequest.setAttribute("handled-as-static-file", true);
                HttpServletResponse httpServletResponse = httpResponse;
                if (httpServletResponse == null) {
                    throw new TypeCastException("null cannot be cast to non-null type io.javalin.http.JavalinResponseWrapper");
                }
                ((JavalinResponseWrapper)httpServletResponse).getOutputStream().finalize();
                return true;
            }
            catch (Exception e) {
                if (Util.INSTANCE.isClientAbortException(e)) continue;
                Logger logger = Javalin.log;
                if (logger == null) continue;
                logger.error("Exception occurred while handling static resource", e);
            }
        }
        return false;
    }

    private final boolean isFile(@Nullable Resource $this$isFile) {
        return $this$isFile != null && $this$isFile.exists() && !$this$isFile.isDirectory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDirectoryWithWelcomeFile(@Nullable Resource $this$isDirectoryWithWelcomeFile, org.eclipse.jetty.server.handler.ResourceHandler handler, String target) {
        if ($this$isDirectoryWithWelcomeFile == null) return false;
        if (!$this$isDirectoryWithWelcomeFile.isDirectory()) return false;
        Resource resource = handler.getResource(StringsKt.removeSuffix(target, (CharSequence)"/") + "/index.html");
        if (resource == null) return false;
        if (!resource.exists()) return false;
        return true;
    }

    public JettyResourceHandler() {
        List list;
        JettyResourceHandler jettyResourceHandler = this;
        boolean bl = false;
        jettyResourceHandler.handlers = list = (List)new ArrayList();
        this.dummyServer = new Server();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lio/javalin/http/staticfiles/JettyResourceHandler$WebjarHandler;", "Lorg/eclipse/jetty/server/handler/ResourceHandler;", "(Lio/javalin/http/staticfiles/JettyResourceHandler;)V", "getResource", "Lorg/eclipse/jetty/util/resource/Resource;", "kotlin.jvm.PlatformType", "path", "", "javalin"})
    public final class WebjarHandler
    extends org.eclipse.jetty.server.handler.ResourceHandler {
        @Override
        public Resource getResource(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull(path, "path");
            Resource resource = Resource.newClassPathResource("META-INF/resources" + path);
            if (resource == null) {
                resource = super.getResource(path);
            }
            return resource;
        }
    }
}

