/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http;

import io.javalin.core.util.Util;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.javalin.http.SinglePageHandler$WhenMappings;
import io.javalin.http.staticfiles.Location;
import io.javalin.http.util.ContextUtil;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0006J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/javalin/http/SinglePageHandler;", "", "()V", "pathCustomHandlerMap", "", "", "Lio/javalin/http/Handler;", "pathPageMap", "pathUrlMap", "Ljava/net/URL;", "add", "", "path", "customHandler", "filePath", "location", "Lio/javalin/http/staticfiles/Location;", "handle", "", "ctx", "Lio/javalin/http/Context;", "javalin"})
public final class SinglePageHandler {
    private final Map<String, URL> pathUrlMap;
    private final Map<String, String> pathPageMap;
    private final Map<String, Handler> pathCustomHandlerMap;

    public final void add(@NotNull String path, @NotNull String filePath, @NotNull Location location) {
        URL uRL;
        Intrinsics.checkParameterIsNotNull(path, "path");
        Intrinsics.checkParameterIsNotNull(filePath, "filePath");
        Intrinsics.checkParameterIsNotNull((Object)location, "location");
        switch (SinglePageHandler$WhenMappings.$EnumSwitchMapping$0[location.ordinal()]) {
            case 1: {
                uRL = Util.getResourceUrl(StringsKt.removePrefix(filePath, (CharSequence)"/"));
                if (uRL != null) break;
                throw (Throwable)new IllegalArgumentException("File at '" + filePath + "' not found. Path should be relative to resource folder.");
            }
            case 2: {
                uRL = Util.INSTANCE.getFileUrl(filePath);
                if (uRL != null) break;
                throw (Throwable)new IllegalArgumentException("External file at '" + filePath + "' not found.");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.pathUrlMap.put(path, uRL);
        URL uRL2 = this.pathUrlMap.get(path);
        if (uRL2 == null) {
            Intrinsics.throwNpe();
        }
        URL uRL3 = uRL2;
        String string = path;
        Map<String, String> map = this.pathPageMap;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = TextStreamsKt.readBytes(uRL3);
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = new String(byArray, charset);
        map.put(string, string2);
    }

    public final void add(@NotNull String path, @NotNull Handler customHandler) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        Intrinsics.checkParameterIsNotNull(customHandler, "customHandler");
        this.pathCustomHandlerMap.put(path, customHandler);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean handle(@NotNull Context ctx) {
        String accepts;
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        String string = ctx.header("Accept");
        if (string == null) {
            string = accepts = "";
        }
        if (StringsKt.contains$default((CharSequence)accepts, "text/html", false, 2, null) || Intrinsics.areEqual(accepts, "*/*") || Intrinsics.areEqual(accepts, "")) {
            for (String path : this.pathPageMap.keySet()) {
                String string2;
                if (!StringsKt.startsWith$default(ctx.path(), path, false, 2, null)) continue;
                Context context = ctx;
                boolean bl = ContextUtil.INSTANCE.isLocalhost(ctx);
                if (bl) {
                    URL uRL = this.pathUrlMap.get(path);
                    if (uRL == null) {
                        Intrinsics.throwNpe();
                    }
                    URL uRL2 = uRL;
                    Context context2 = context;
                    Charset charset = Charsets.UTF_8;
                    boolean bl2 = false;
                    byte[] byArray = TextStreamsKt.readBytes(uRL2);
                    boolean bl3 = false;
                    boolean bl4 = false;
                    String string3 = new String(byArray, charset);
                    context = context2;
                    string2 = string3;
                } else if (!bl) {
                    String string4 = this.pathPageMap.get(path);
                    if (string4 == null) {
                        Intrinsics.throwNpe();
                    }
                    string2 = string4;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                context.html(string2);
                return true;
            }
            Object object = this.pathCustomHandlerMap;
            boolean bl = false;
            Iterator<Object> iterator2 = object.entrySet().iterator();
            while (iterator2.hasNext()) {
                void path;
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)iterator2.next();
                boolean bl5 = false;
                object = (String)entry2.getKey();
                entry2 = entry;
                bl5 = false;
                Handler customHandler = (Handler)entry2.getValue();
                if (!StringsKt.startsWith$default(ctx.path(), (String)path, false, 2, null)) continue;
                customHandler.handle(ctx);
                return true;
            }
        }
        return false;
    }

    public SinglePageHandler() {
        Map map;
        SinglePageHandler singlePageHandler = this;
        boolean bl = false;
        singlePageHandler.pathUrlMap = map = (Map)new LinkedHashMap();
        singlePageHandler = this;
        bl = false;
        singlePageHandler.pathPageMap = map = (Map)new LinkedHashMap();
        singlePageHandler = this;
        bl = false;
        singlePageHandler.pathCustomHandlerMap = map = (Map)new LinkedHashMap();
    }
}

