/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.regrep.slot;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.text.IMultilingualText;
import eu.toop.regrep.helper.VocabularyTerm;
import eu.toop.regrep.rim.AnyValueType;
import eu.toop.regrep.rim.BooleanValueType;
import eu.toop.regrep.rim.CollectionValueType;
import eu.toop.regrep.rim.DateTimeValueType;
import eu.toop.regrep.rim.EntryType;
import eu.toop.regrep.rim.FloatValueType;
import eu.toop.regrep.rim.IntegerValueType;
import eu.toop.regrep.rim.InternationalStringType;
import eu.toop.regrep.rim.InternationalStringValueType;
import eu.toop.regrep.rim.LocalizedStringType;
import eu.toop.regrep.rim.MapType;
import eu.toop.regrep.rim.MapValueType;
import eu.toop.regrep.rim.SlotType;
import eu.toop.regrep.rim.SlotValueType;
import eu.toop.regrep.rim.StringValueType;
import eu.toop.regrep.rim.ValueType;
import eu.toop.regrep.rim.VocabularyTermType;
import eu.toop.regrep.rim.VocabularyTermValueType;
import eu.toop.regrep.slot.ERegRepCollectionType;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.w3c.dom.Element;

@Immutable
public final class SlotHelper {
    private SlotHelper() {
    }

    @Nonnull
    public static LocalizedStringType createLocalizedString(@Nonnull Locale locale, @Nonnull String string) {
        ValueEnforcer.notNull(locale, "Locale");
        ValueEnforcer.notNull(string, "Text");
        return SlotHelper.createLocalizedString(locale.getLanguage(), string);
    }

    @Nonnull
    public static LocalizedStringType createLocalizedString(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty(string, "Language");
        ValueEnforcer.notNull(string2, "Text");
        LocalizedStringType localizedStringType = new LocalizedStringType();
        localizedStringType.setLang(string);
        localizedStringType.setValue(string2);
        return localizedStringType;
    }

    @Nonnull
    public static InternationalStringType createInternationalStringType(@Nullable Map<String, String> map) {
        ValueEnforcer.noNullValue(map, "Map");
        InternationalStringType internationalStringType = new InternationalStringType();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                internationalStringType.addLocalizedString(SlotHelper.createLocalizedString(entry.getKey(), entry.getValue()));
            }
        }
        return internationalStringType;
    }

    @Nonnull
    public static InternationalStringType createInternationalStringType(@Nullable IMultilingualText iMultilingualText) {
        InternationalStringType internationalStringType = new InternationalStringType();
        if (iMultilingualText != null) {
            for (Map.Entry entry : iMultilingualText.texts().entrySet()) {
                internationalStringType.addLocalizedString(SlotHelper.createLocalizedString((Locale)entry.getKey(), (String)entry.getValue()));
            }
        }
        return internationalStringType;
    }

    @Nonnull
    public static InternationalStringType createInternationalStringType(LocalizedStringType ... localizedStringTypeArray) {
        ValueEnforcer.noNullValue(localizedStringTypeArray, "Array");
        InternationalStringType internationalStringType = new InternationalStringType();
        if (localizedStringTypeArray != null) {
            for (LocalizedStringType localizedStringType : localizedStringTypeArray) {
                internationalStringType.addLocalizedString(localizedStringType);
            }
        }
        return internationalStringType;
    }

    @Nonnull
    public static MapType createMap(@Nullable Map<? extends ValueType, ? extends ValueType> map) {
        ValueEnforcer.notNull(map, "Value");
        MapType mapType = new MapType();
        if (map != null) {
            for (Map.Entry<? extends ValueType, ? extends ValueType> entry : map.entrySet()) {
                EntryType entryType = new EntryType();
                entryType.setEntryKey(entry.getKey());
                entryType.setEntryValue(entry.getValue());
                mapType.addEntry(entryType);
            }
        }
        return mapType;
    }

    @Nonnull
    public static VocabularyTermType createVocabularyTerm(@Nonnull VocabularyTerm vocabularyTerm) {
        ValueEnforcer.notNull(vocabularyTerm, "Term");
        return SlotHelper.createVocabularyTerm(vocabularyTerm.getVocabulary(), vocabularyTerm.getTerm());
    }

    @Nonnull
    public static VocabularyTermType createVocabularyTerm(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull(string, "Vocabulary");
        ValueEnforcer.notNull(string2, "Term");
        VocabularyTermType vocabularyTermType = new VocabularyTermType();
        vocabularyTermType.setVocabulary(string);
        vocabularyTermType.setTerm(string2);
        return vocabularyTermType;
    }

    @Nonnull
    public static AnyValueType createSlotValue(@Nonnull Element element) {
        ValueEnforcer.notNull(element, "Value");
        AnyValueType anyValueType = new AnyValueType();
        anyValueType.setAny(element);
        return anyValueType;
    }

    @Nonnull
    public static BooleanValueType createSlotValue(boolean bl) {
        return new BooleanValueType(bl);
    }

    @Nonnull
    public static CollectionValueType createSlotValue(ValueType ... valueTypeArray) {
        return SlotHelper.createSlotValue((ERegRepCollectionType)null, valueTypeArray);
    }

    @Nonnull
    public static CollectionValueType createSlotValue(@Nullable ERegRepCollectionType eRegRepCollectionType, ValueType ... valueTypeArray) {
        ValueEnforcer.noNullValue(valueTypeArray, "Value");
        CollectionValueType collectionValueType = new CollectionValueType();
        if (eRegRepCollectionType != null) {
            collectionValueType.setCollectionType(eRegRepCollectionType.getID());
        }
        if (valueTypeArray != null) {
            for (ValueType valueType : valueTypeArray) {
                collectionValueType.addElement(valueType);
            }
        }
        return collectionValueType;
    }

    @Nonnull
    public static CollectionValueType createSlotValue(@Nullable ERegRepCollectionType eRegRepCollectionType, @Nullable Iterable<? extends ValueType> iterable) {
        ValueEnforcer.noNullValue(iterable, "Value");
        CollectionValueType collectionValueType = new CollectionValueType();
        if (eRegRepCollectionType != null) {
            collectionValueType.setCollectionType(eRegRepCollectionType.getID());
        }
        if (iterable != null) {
            for (ValueType valueType : iterable) {
                collectionValueType.addElement(valueType);
            }
        }
        return collectionValueType;
    }

    @Nonnull
    public static DateTimeValueType createSlotValue(@Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull(localDateTime, "Value");
        return new DateTimeValueType(localDateTime);
    }

    @Nonnull
    public static FloatValueType createSlotValue(float f) {
        return new FloatValueType(Float.valueOf(f));
    }

    @Nonnull
    public static IntegerValueType createSlotValue(@Nonnull BigInteger bigInteger) {
        ValueEnforcer.notNull(bigInteger, "Value");
        return new IntegerValueType(bigInteger);
    }

    @Nonnull
    public static InternationalStringValueType createSlotValue(@Nonnull InternationalStringType internationalStringType) {
        ValueEnforcer.notNull(internationalStringType, "Value");
        return new InternationalStringValueType(internationalStringType);
    }

    @Nonnull
    public static MapValueType createSlotValue(@Nonnull MapType mapType) {
        ValueEnforcer.notNull(mapType, "Value");
        MapValueType mapValueType = new MapValueType();
        mapValueType.setMap(mapType);
        return mapValueType;
    }

    @Nonnull
    public static SlotValueType createSlotValue(@Nonnull SlotType slotType) {
        ValueEnforcer.notNull(slotType, "Value");
        SlotValueType slotValueType = new SlotValueType();
        slotValueType.setSlot(slotType);
        return slotValueType;
    }

    @Nonnull
    public static StringValueType createSlotValue(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Value");
        return new StringValueType(string);
    }

    @Nonnull
    public static VocabularyTermValueType createSlotValue(@Nonnull VocabularyTermType vocabularyTermType) {
        ValueEnforcer.notNull(vocabularyTermType, "Value");
        return new VocabularyTermValueType(vocabularyTermType);
    }

    @Nonnull
    public static SlotType createSlot(@Nonnull @Nonempty String string, @Nonnull ValueType valueType) {
        ValueEnforcer.notEmpty(string, "Name");
        ValueEnforcer.notNull(valueType, "Value");
        SlotType slotType = new SlotType();
        slotType.setName(string);
        slotType.setSlotValue(valueType);
        return slotType;
    }
}

