/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dp.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import eu.toop.edm.model.ConceptPojo;
import eu.toop.playground.dp.model.Dataset;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class GBMDataset
extends Dataset {
    private List<Concept> concepts;

    public GBMDataset() {
    }

    public GBMDataset(List<Concept> list, String string, String string2, String string3) {
        this.concepts = list;
        this.naturalPersonID = string;
        this.legalPersonID = string2;
        this.legalRepresentativeID = string3;
    }

    public List<Concept> getConcepts() {
        return this.concepts;
    }

    @JsonIgnore
    public List<ConceptPojo> getConceptPojoList() {
        ArrayList<ConceptPojo> arrayList = new ArrayList<ConceptPojo>(this.concepts.size());
        for (Concept concept : this.concepts) {
            arrayList.add(ConceptPojo.builder().randomID().name("http://toop.eu/registered-organization", concept.getName()).children(this.getAsConceptPojoList(concept.getConcepts())).build());
        }
        return arrayList;
    }

    @JsonIgnore
    private List<ConceptPojo> getAsConceptPojoList(List<Concept> list) {
        return list.stream().map(concept -> {
            ConceptPojo.Builder builder = ConceptPojo.builder().randomID().name("http://toop.eu/registered-organization", concept.getName());
            if (concept.getAmountValue() != null && concept.getAmountCurrency() != null) {
                builder.valueAmount(concept.getAmountValue(), concept.getAmountCurrency());
            }
            if (concept.getTextValue() != null) {
                builder.valueText(concept.getTextValue());
            }
            if (concept.getCodeValue() != null) {
                builder.valueCode(concept.getCodeValue());
            }
            if (concept.getDateValue() != null) {
                builder.valueDate(concept.getDateValue());
            }
            if (concept.getIndicatorValue() != null) {
                builder.valueIndicator(concept.getIndicatorValue());
            }
            if (concept.getMeasureValue() != null && concept.getMeasureUnit() != null) {
                builder.valueMeasure(concept.getMeasureValue(), concept.getMeasureUnit());
            }
            if (concept.getQuantityValue() != null) {
                builder.valueQuantity(concept.getQuantityValue(), concept.getQuantityUnit());
            }
            if (concept.getNumericValue() != null) {
                builder.valueNumeric(concept.getNumericValue());
            }
            if (concept.getTimeValue() != null) {
                builder.valueTime(concept.getTimeValue());
            }
            if (concept.getUriValue() != null) {
                builder.valueURI(concept.getUriValue());
            }
            if (concept.getPeriodStartValue() != null && concept.getPeriodEndValue() != null) {
                builder.valuePeriod(concept.getPeriodStartValue(), concept.getPeriodEndValue());
            }
            return builder.children(concept.getConcepts() == null ? null : this.getAsConceptPojoList(concept.getConcepts())).build();
        }).collect(Collectors.toList());
    }

    public String toString() {
        return "GBMDataset{concepts=" + this.concepts + ", naturalPersonID='" + this.naturalPersonID + "'\n, legalPersonID='" + this.legalPersonID + "'\n, legalRepresentativeID='" + this.legalRepresentativeID + "'\n" + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GBMDataset gBMDataset = (GBMDataset)object;
        return Objects.equals(this.concepts, gBMDataset.concepts) && Objects.equals(this.naturalPersonID, gBMDataset.naturalPersonID) && Objects.equals(this.legalPersonID, gBMDataset.legalPersonID) && Objects.equals(this.legalRepresentativeID, gBMDataset.legalRepresentativeID);
    }

    public int hashCode() {
        return Objects.hash(this.concepts, this.naturalPersonID, this.legalPersonID, this.legalRepresentativeID);
    }

    public static class Concept {
        private String name;
        private List<Concept> concepts;
        private String textValue;
        private String amountCurrency;
        private BigDecimal amountValue;
        private String codeValue;
        private LocalDate dateValue;
        private Boolean indicatorValue;
        private String measureUnit;
        private BigDecimal measureValue;
        private BigDecimal numericValue;
        private LocalDateTime periodStartValue;
        private LocalDateTime periodEndValue;
        private BigDecimal quantityValue;
        private String quantityUnit;
        private LocalTime timeValue;
        private String uriValue;
        private String errorCode;
        private String idValue;

        public String getIdValue() {
            return this.idValue;
        }

        public void setIdValue(String string) {
            this.idValue = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public List<Concept> getConcepts() {
            return this.concepts;
        }

        public void setConcepts(List<Concept> list) {
            this.concepts = list;
        }

        public String getTextValue() {
            return this.textValue;
        }

        public void setTextValue(String string) {
            this.textValue = string;
        }

        public String getAmountCurrency() {
            return this.amountCurrency;
        }

        public void setAmountCurrency(String string) {
            this.amountCurrency = string;
        }

        public BigDecimal getAmountValue() {
            return this.amountValue;
        }

        public void setAmountValue(BigDecimal bigDecimal) {
            this.amountValue = bigDecimal;
        }

        public String getCodeValue() {
            return this.codeValue;
        }

        public void setCodeValue(String string) {
            this.codeValue = string;
        }

        public LocalDate getDateValue() {
            return this.dateValue;
        }

        public void setDateValue(LocalDate localDate) {
            this.dateValue = localDate;
        }

        public Boolean getIndicatorValue() {
            return this.indicatorValue;
        }

        public void setIndicatorValue(Boolean bl) {
            this.indicatorValue = bl;
        }

        public String getMeasureUnit() {
            return this.measureUnit;
        }

        public void setMeasureUnit(String string) {
            this.measureUnit = string;
        }

        public BigDecimal getMeasureValue() {
            return this.measureValue;
        }

        public void setMeasureValue(BigDecimal bigDecimal) {
            this.measureValue = bigDecimal;
        }

        public BigDecimal getNumericValue() {
            return this.numericValue;
        }

        public void setNumericValue(BigDecimal bigDecimal) {
            this.numericValue = bigDecimal;
        }

        public LocalDateTime getPeriodStartValue() {
            return this.periodStartValue;
        }

        public void setPeriodStartValue(LocalDateTime localDateTime) {
            this.periodStartValue = localDateTime;
        }

        public LocalDateTime getPeriodEndValue() {
            return this.periodEndValue;
        }

        public void setPeriodEndValue(LocalDateTime localDateTime) {
            this.periodEndValue = localDateTime;
        }

        public BigDecimal getQuantityValue() {
            return this.quantityValue;
        }

        public void setQuantityValue(BigDecimal bigDecimal) {
            this.quantityValue = bigDecimal;
        }

        public String getQuantityUnit() {
            return this.quantityUnit;
        }

        public void setQuantityUnit(String string) {
            this.quantityUnit = string;
        }

        public LocalTime getTimeValue() {
            return this.timeValue;
        }

        public void setTimeValue(LocalTime localTime) {
            this.timeValue = localTime;
        }

        public String getUriValue() {
            return this.uriValue;
        }

        public void setUriValue(String string) {
            this.uriValue = string;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String string) {
            this.errorCode = string;
        }

        public String toString() {
            Concept concept = this;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Concept{name='").append(this.name).append("'\n").append(", concepts=").append(this.concepts).append('\n');
            if (concept.getAmountValue() != null) {
                stringBuilder.append(", amountCurrency='").append(this.amountCurrency).append("'\n").append(", amountValue=").append(this.amountValue).append('\n');
            }
            if (concept.getTextValue() != null) {
                stringBuilder.append(", textValue='").append(this.textValue).append("'\n");
            }
            if (concept.getCodeValue() != null) {
                stringBuilder.append(", codeValue='").append(this.codeValue).append("'\n");
            }
            if (concept.getDateValue() != null) {
                stringBuilder.append(", dateValue=").append(this.dateValue).append('\n');
            }
            if (concept.getIndicatorValue() != null) {
                stringBuilder.append(", indicatorValue=").append(this.indicatorValue).append('\n');
            }
            if (concept.getMeasureValue() != null && concept.getMeasureUnit() != null) {
                stringBuilder.append(", measureUnit='").append(this.measureUnit).append("'\n").append(", measureValue='").append(this.measureValue).append("'\n");
            }
            if (concept.getQuantityValue() != null) {
                stringBuilder.append(", quantityValue=").append(this.quantityValue).append('\n').append(", quantityUnit='").append(this.quantityUnit).append("'\n");
            }
            if (concept.getNumericValue() != null) {
                stringBuilder.append(", numericValue=").append(this.numericValue).append('\n');
            }
            if (concept.getTimeValue() != null) {
                stringBuilder.append(", timeValue=").append(this.timeValue).append('\n');
            }
            if (concept.getUriValue() != null) {
                stringBuilder.append(", uriValue='").append(this.uriValue).append("'\n");
            }
            if (concept.getPeriodStartValue() != null && concept.getPeriodEndValue() != null) {
                stringBuilder.append(", periodStartValue=").append(this.periodStartValue).append('\n').append(", periodEndValue=").append(this.periodEndValue).append('\n');
            }
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Concept concept = (Concept)object;
            return Objects.equals(this.name, concept.name) && Objects.equals(this.concepts, concept.concepts) && Objects.equals(this.textValue, concept.textValue) && Objects.equals(this.amountCurrency, concept.amountCurrency) && Objects.equals(this.amountValue, concept.amountValue) && Objects.equals(this.codeValue, concept.codeValue) && Objects.equals(this.dateValue, concept.dateValue) && Objects.equals(this.indicatorValue, concept.indicatorValue) && Objects.equals(this.measureUnit, concept.measureUnit) && Objects.equals(this.measureValue, concept.measureValue) && Objects.equals(this.numericValue, concept.numericValue) && Objects.equals(this.periodStartValue, concept.periodStartValue) && Objects.equals(this.periodEndValue, concept.periodEndValue) && Objects.equals(this.quantityValue, concept.quantityValue) && Objects.equals(this.quantityUnit, concept.quantityUnit) && Objects.equals(this.timeValue, concept.timeValue) && Objects.equals(this.uriValue, concept.uriValue) && Objects.equals(this.errorCode, concept.errorCode);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.concepts, this.textValue, this.amountCurrency, this.amountValue, this.codeValue, this.dateValue, this.indicatorValue, this.measureUnit, this.measureValue, this.numericValue, this.periodStartValue, this.periodEndValue, this.quantityValue, this.quantityUnit, this.timeValue, this.uriValue, this.errorCode);
        }
    }
}

