/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dp.model;

import eu.toop.edm.model.AddressPojo;
import eu.toop.edm.model.AgentPojo;
import eu.toop.edm.model.DatasetPojo;
import eu.toop.edm.model.DocumentReferencePojo;
import eu.toop.edm.model.QualifiedRelationPojo;
import eu.toop.edm.model.RepositoryItemRefPojo;
import eu.toop.playground.dp.model.Dataset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DocumentDataset
extends Dataset {
    private String description;
    private String title;
    private DocumentReference distribution;
    private List<String> IDs = new ArrayList<String>();
    private LocalDateTime issued;
    private String language;
    private LocalDateTime lastModified;
    private LocalDate validFrom;
    private LocalDate validTo;
    private Creator creator;
    private List<QualifiedRelation> qualifiedRelation = new ArrayList<QualifiedRelation>();
    private RepositoryItemRef repositoryItemRef;
    private String attachmentLocation;
    private String attachmentCid;

    public String getAttachmentCid() {
        return this.attachmentCid;
    }

    public void setAttachmentCid(String string) {
        this.attachmentCid = string;
    }

    public String getAttachmentLocation() {
        return this.attachmentLocation;
    }

    public void setAttachmentLocation(String string) {
        this.attachmentLocation = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public DocumentReference getDistribution() {
        return this.distribution;
    }

    public void setDistribution(DocumentReference documentReference) {
        this.distribution = documentReference;
    }

    public List<String> getIDs() {
        return this.IDs;
    }

    public void setIDs(List<String> list) {
        this.IDs = list;
    }

    public LocalDateTime getIssued() {
        return this.issued;
    }

    public void setIssued(LocalDateTime localDateTime) {
        this.issued = localDateTime;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public LocalDateTime getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(LocalDateTime localDateTime) {
        this.lastModified = localDateTime;
    }

    public LocalDate getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(LocalDate localDate) {
        this.validFrom = localDate;
    }

    public LocalDate getValidTo() {
        return this.validTo;
    }

    public void setValidTo(LocalDate localDate) {
        this.validTo = localDate;
    }

    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    public List<QualifiedRelation> getQualifiedRelation() {
        return this.qualifiedRelation;
    }

    public void setQualifiedRelation(List<QualifiedRelation> list) {
        this.qualifiedRelation = list;
    }

    public RepositoryItemRef getRepositoryItemRef() {
        return this.repositoryItemRef;
    }

    public void setRepositoryItemRef(RepositoryItemRef repositoryItemRef) {
        this.repositoryItemRef = repositoryItemRef;
    }

    public String toString() {
        return "DocumentDataset{naturalPersonID='" + this.naturalPersonID + "'\n, legalPersonID='" + this.legalPersonID + "'\n, legalRepresentativeID='" + this.legalRepresentativeID + "'\n, description='" + this.description + "'\n, title='" + this.title + "'\n, distribution=" + this.distribution + ", IDs=" + this.IDs + ", issued=" + this.issued + ", language='" + this.language + "'\n, lastModified=" + this.lastModified + ", validFrom=" + this.validFrom + ", validTo=" + this.validTo + ", creator=" + this.creator + ", qualifiedRelation=" + this.qualifiedRelation + ", repositoryItemRef=" + this.repositoryItemRef + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DocumentDataset documentDataset = (DocumentDataset)object;
        return Objects.equals(this.naturalPersonID, documentDataset.naturalPersonID) && Objects.equals(this.legalPersonID, documentDataset.legalPersonID) && Objects.equals(this.legalRepresentativeID, documentDataset.legalRepresentativeID) && Objects.equals(this.description, documentDataset.description) && Objects.equals(this.title, documentDataset.title) && Objects.equals(this.distribution, documentDataset.distribution) && Objects.equals(this.IDs, documentDataset.IDs) && Objects.equals(this.issued, documentDataset.issued) && Objects.equals(this.language, documentDataset.language) && Objects.equals(this.lastModified, documentDataset.lastModified) && Objects.equals(this.validFrom, documentDataset.validFrom) && Objects.equals(this.validTo, documentDataset.validTo) && Objects.equals(this.creator, documentDataset.creator) && Objects.equals(this.qualifiedRelation, documentDataset.qualifiedRelation) && Objects.equals(this.repositoryItemRef, documentDataset.repositoryItemRef);
    }

    public int hashCode() {
        return Objects.hash(this.naturalPersonID, this.legalPersonID, this.legalRepresentativeID, this.description, this.title, this.distribution, this.IDs, this.issued, this.language, this.lastModified, this.validFrom, this.validTo, this.creator, this.qualifiedRelation, this.repositoryItemRef);
    }

    public DatasetPojo getAsDatasetPojo() {
        return DatasetPojo.builder().addDescription(this.description).ids(this.IDs).issued(this.issued).addTitle(this.title).language(this.language).lastModified(this.lastModified).validFrom(this.validFrom).validTo(this.validTo).distribution(DocumentReferencePojo.builder().addDocumentDescription(this.distribution.documentDescription).documentType(this.distribution.documentType).documentURI(this.distribution.documentURI).localeCode(this.distribution.localeCode).build()).qualifiedRelations(this.qualifiedRelation.stream().map(qualifiedRelation -> QualifiedRelationPojo.builder().description(((QualifiedRelation)qualifiedRelation).description).id(((QualifiedRelation)qualifiedRelation).id).title(((QualifiedRelation)qualifiedRelation).title).build()).collect(Collectors.toList())).creator(AgentPojo.builder().address(AddressPojo.builder().streetName(this.creator.postName)).id(this.creator.id).name(this.creator.name).idSchemeID(this.creator.idScheme).build()).build();
    }

    public static class Creator {
        private String id;
        private String name;
        private String postName;
        private String idScheme;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getPostName() {
            return this.postName;
        }

        public String getIdScheme() {
            return this.idScheme;
        }

        public void setId(String string) {
            this.id = string;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setPostName(String string) {
            this.postName = string;
        }

        public void setIdScheme(String string) {
            this.idScheme = string;
        }

        public String toString() {
            return "Creator{id='" + this.id + "'\n, name='" + this.name + "'\n, postName='" + this.postName + "'\n, idScheme='" + this.idScheme + "'\n" + '}';
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Creator creator = (Creator)object;
            return Objects.equals(this.id, creator.id) && Objects.equals(this.name, creator.name) && Objects.equals(this.postName, creator.postName) && Objects.equals(this.idScheme, creator.idScheme);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.postName, this.idScheme);
        }
    }

    public static class QualifiedRelation {
        private String description;
        private String title;
        private String id;

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public String getID() {
            return this.id;
        }

        public void setID(String string) {
            this.id = string;
        }

        public String toString() {
            return "QualifiedRelation{description='" + this.description + "'\n, title='" + this.title + "'\n, id='" + this.id + "'\n" + '}';
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            QualifiedRelation qualifiedRelation = (QualifiedRelation)object;
            return Objects.equals(this.description, qualifiedRelation.description) && Objects.equals(this.title, qualifiedRelation.title) && Objects.equals(this.id, qualifiedRelation.id);
        }

        public int hashCode() {
            return Objects.hash(this.description, this.title, this.id);
        }
    }

    public static class DocumentReference {
        private String documentURI;
        private String documentDescription;
        private String documentType;
        private String localeCode;

        public String getDocumentURI() {
            return this.documentURI;
        }

        public void setDocumentURI(String string) {
            this.documentURI = string;
        }

        public String getDocumentDescription() {
            return this.documentDescription;
        }

        public void setDocumentDescription(String string) {
            this.documentDescription = string;
        }

        public String getDocumentType() {
            return this.documentType;
        }

        public void setDocumentType(String string) {
            this.documentType = string;
        }

        public String getLocaleCode() {
            return this.localeCode;
        }

        public void setLocaleCode(String string) {
            this.localeCode = string;
        }

        public String toString() {
            return "DocumentReference{documentURI='" + this.documentURI + "'\n, documentDescription='" + this.documentDescription + "'\n, documentType='" + this.documentType + "'\n, localeCode='" + this.localeCode + "'\n" + '}';
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DocumentReference documentReference = (DocumentReference)object;
            return Objects.equals(this.documentURI, documentReference.documentURI) && Objects.equals(this.documentDescription, documentReference.documentDescription) && Objects.equals(this.documentType, documentReference.documentType) && Objects.equals(this.localeCode, documentReference.localeCode);
        }

        public int hashCode() {
            return Objects.hash(this.documentURI, this.documentDescription, this.documentType, this.localeCode);
        }
    }

    public static class RepositoryItemRef {
        private String link;
        private String title;

        public String getLink() {
            return this.link;
        }

        public void setLink(String string) {
            this.link = string;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public RepositoryItemRefPojo getAsRepositoryItemRefPojo() {
            return RepositoryItemRefPojo.builder().link(this.link).title(this.title).build();
        }

        public String toString() {
            return "RepositoryItemRef{link='" + this.link + "'\n, title='" + this.title + "'\n" + '}';
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RepositoryItemRef repositoryItemRef = (RepositoryItemRef)object;
            return Objects.equals(this.link, repositoryItemRef.link) && Objects.equals(this.title, repositoryItemRef.title);
        }

        public int hashCode() {
            return Objects.hash(this.link, this.title);
        }
    }
}

