/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dp.datasource;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import eu.toop.playground.dp.datasource.Datasource;
import eu.toop.playground.dp.model.Dataset;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YAMLDataSource<X extends Dataset>
implements Datasource<X> {
    private static final Logger LOGGER = LoggerFactory.getLogger(YAMLDataSource.class);
    protected final Map<Path, X> datasets;
    protected X targetClass;

    public YAMLDataSource(String string, X x) {
        this.targetClass = x;
        ObjectMapper objectMapper2 = new ObjectMapper(new YAMLFactory()).registerModules(new JavaTimeModule()).findAndRegisterModules();
        LOGGER.info("Initializing datasource for {}s with location {} ", (Object)x.getClass().getSimpleName(), (Object)string);
        this.datasets = new HashMap<Path, X>();
        Path path2 = Paths.get(string, new String[0]);
        if (Files.exists(path2, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(path2, new FileVisitOption[0]);){
                stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> path.toFile().getName().endsWith(".yaml")).forEach(path -> {
                    try {
                        LOGGER.info("Adding {} from {} ", (Object)x.getClass().getSimpleName(), (Object)path.toFile().getAbsolutePath());
                        JavaType javaType = objectMapper2.getTypeFactory().constructType(x.getClass());
                        this.datasets.put((Path)path, (X)objectMapper2.readValue(path.toFile(), javaType));
                    }
                    catch (IOException iOException) {
                        LOGGER.warn("Failed to read {}", (Object)path.toFile().getAbsolutePath());
                        LOGGER.warn(iOException.getMessage());
                    }
                });
            }
            catch (IOException iOException) {
                LOGGER.error("Failed to read {}", (Object)string);
            }
        } else {
            LOGGER.error("Path does not exist {}", (Object)string);
        }
        if (this.datasets.size() == 0) {
            LOGGER.warn("WARNING: No {}s have been loaded", (Object)x.getClass().getSimpleName());
        }
    }

    @Override
    public Map<Path, X> getDatasets() {
        return this.datasets;
    }
}

