/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.demoui.dpweb;

import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.MimeTypeDeterminator;
import com.typesafe.config.ConfigFactory;
import eu.toop.connector.api.me.EMEProtocol;
import eu.toop.connector.api.me.incoming.IIncomingEDMResponse;
import eu.toop.connector.api.me.incoming.IMEIncomingTransportMetadata;
import eu.toop.connector.api.me.incoming.IncomingEDMErrorResponse;
import eu.toop.connector.api.me.incoming.IncomingEDMResponse;
import eu.toop.connector.api.me.incoming.MEIncomingTransportMetadata;
import eu.toop.connector.api.me.model.MEPayload;
import eu.toop.connector.api.rest.TCIncomingMessage;
import eu.toop.connector.api.rest.TCIncomingMetadata;
import eu.toop.connector.api.rest.TCOutgoingMessage;
import eu.toop.connector.api.rest.TCOutgoingMetadata;
import eu.toop.connector.api.rest.TCPayload;
import eu.toop.connector.api.rest.TCRestJAXB;
import eu.toop.edm.EDMErrorResponse;
import eu.toop.edm.EDMRequest;
import eu.toop.edm.EDMResponse;
import eu.toop.edm.IEDMTopLevelObject;
import eu.toop.edm.xml.EDMPayloadDeterminator;
import eu.toop.kafkaclient.ToopKafkaClient;
import eu.toop.kafkaclient.ToopKafkaSettings;
import eu.toop.playground.demoui.dpweb.DpConfig;
import eu.toop.playground.demoui.dpweb.StatusType;
import eu.toop.playground.dp.DPException;
import eu.toop.playground.dp.model.EDMResponseWithAttachment;
import eu.toop.playground.dp.service.ToopDP;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.plugin.rendering.template.TemplateUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DpApp {
    public static final DpConfig APPCONFIG = new DpConfig(ConfigFactory.load().withFallback(ConfigFactory.parseFile(Paths.get("demoui-dp.conf", new String[0]).toFile())).withFallback(ConfigFactory.parseResources("demoui-dp.conf")).resolve());
    private static final Logger LOGGER = LoggerFactory.getLogger(DpApp.class);
    private static ToopDP miniDP = new ToopDP(APPCONFIG.getDp().getDatasetGBM(), APPCONFIG.getDp().getDatasetDocument());

    public static void main(String[] stringArray) throws IOException {
        if (DpApp.APPCONFIG.getDp().getKafka().enabled) {
            ToopKafkaSettings.setKafkaEnabled(true);
            ToopKafkaSettings.defaultProperties().put("bootstrap.servers", DpApp.APPCONFIG.getDp().getKafka().url);
            ToopKafkaSettings.setKafkaTopic(DpApp.APPCONFIG.getDp().getKafka().topic);
        } else {
            ToopKafkaSettings.setKafkaEnabled(false);
        }
        Javalin.create(javalinConfig -> {
            if (DpApp.APPCONFIG.getServer().cors) {
                javalinConfig.enableCorsForAllOrigins();
            }
        }).start(APPCONFIG.getServer().getPort()).get("/", DpApp::index).post(APPCONFIG.getDp().getDirect().getReceive(), context -> {
            byte[] byArray;
            context.contentType(CMimeType.APPLICATION_XML.getAsString());
            try {
                byArray = miniDP.createXMLResponseFromRequest(context.bodyAsBytes());
            }
            catch (DPException dPException) {
                byArray = dPException.getEdmErrorResponse().getWriter().getAsBytes();
            }
            LOGGER.info("Sent response with status {}", (Object)DpApp.sendResponse(byArray, APPCONFIG.getDp().getDirect().getSubmit()));
        }).post(APPCONFIG.getDp().getToop().getReceive(), context -> {
            String string = context.body();
            TCIncomingMessage tCIncomingMessage = (TCIncomingMessage)TCRestJAXB.incomingMessage().read(string);
            LOGGER.info("Sent response with status {}", (Object)DpApp.createAndSendTCOutgoingMessageFromIncoming(tCIncomingMessage).name());
        }).get("/datasets", DpApp::displayDatasets).get("/reload", context -> {
            miniDP = new ToopDP(APPCONFIG.getDp().getDatasetGBM(), APPCONFIG.getDp().getDatasetDocument());
            DpApp.displayDatasets(context);
        });
    }

    private static void index(Context context) {
        context.render("/templates/index.vm", TemplateUtil.model("config", APPCONFIG));
    }

    private static void displayDatasets(Context context) {
        context.render("/templates/datasets.vm", TemplateUtil.model("conceptDatasets", miniDP.getRegisteredOrganizationDatasource().getDatasets().values(), "documentDatasets", miniDP.getDocumentDatasource().getDatasets().values()));
    }

    private static StatusType createAndSendTCOutgoingMessageFromIncoming(TCIncomingMessage tCIncomingMessage) throws IOException {
        TCIncomingMetadata tCIncomingMetadata = tCIncomingMessage.getMetadata();
        if (tCIncomingMetadata == null) {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, "Elonia DP Received Incoming message with no metadata");
            throw new IllegalStateException("Elonia DP Received Incoming message with no metadata");
        }
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, "Elonia DP Received Incoming message with sender " + tCIncomingMetadata.getSenderID());
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, "Elonia DP Received Incoming message with receiver " + tCIncomingMetadata.getReceiverID());
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, "Elonia DP Received Incoming message with docTypeID " + tCIncomingMetadata.getDocTypeID());
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, "Elonia DP Received Incoming message with payloadType " + (Object)((Object)tCIncomingMetadata.getPayloadType()));
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, "Elonia DP Received Incoming message with processID " + tCIncomingMetadata.getProcessID());
        TCPayload tCPayload = tCIncomingMessage.getPayloadAtIndex(0);
        LOGGER.info("DP Received Payload Content ID: " + tCPayload.getContentID());
        LOGGER.info("DP Received Payload Mime Type: " + tCPayload.getMimeType());
        if (tCPayload.getValue() != null) {
            IEDMTopLevelObject iEDMTopLevelObject = EDMPayloadDeterminator.parseAndFind(new ByteArrayInputStream(tCPayload.getValue()));
            if (iEDMTopLevelObject instanceof EDMResponse) {
                EDMResponse eDMResponse = (EDMResponse)iEDMTopLevelObject;
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.WARN, "Elonia DP Received an unexpected EDMResponse");
                LOGGER.info("DP Received Payload:\n {}", (Object)eDMResponse.getWriter().getAsString());
                LOGGER.info("Sent no response.");
                return StatusType.NOT_OK;
            }
            if (iEDMTopLevelObject instanceof EDMErrorResponse) {
                EDMErrorResponse eDMErrorResponse = (EDMErrorResponse)iEDMTopLevelObject;
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, "Elonia DP Received an unexpected EDMErrorResponse");
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, "DP Received Payload:\n" + eDMErrorResponse.getWriter().getAsString());
                LOGGER.info("Sent no response.");
                return StatusType.NOT_OK;
            }
            if (iEDMTopLevelObject instanceof EDMRequest) {
                EDMRequest eDMRequest = (EDMRequest)iEDMTopLevelObject;
                String string = "[" + eDMRequest.getRequestID() + "] ";
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, string + "Elonia DP Received an EDMRequest");
                LOGGER.info("DP Received Payload:\n" + eDMRequest.getWriter().getAsString());
                MEIncomingTransportMetadata mEIncomingTransportMetadata = MEIncomingTransportMetadata.create(tCIncomingMetadata);
                MEIncomingTransportMetadata mEIncomingTransportMetadata2 = new MEIncomingTransportMetadata(mEIncomingTransportMetadata.getReceiverID(), mEIncomingTransportMetadata.getSenderID(), mEIncomingTransportMetadata.getDocumentTypeID(), mEIncomingTransportMetadata.getProcessID());
                try {
                    EDMResponseWithAttachment eDMResponseWithAttachment = miniDP.createEDMResponseWithAttachmentsFromRequest(eDMRequest);
                    ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, string + "DP created an EDMResponse successfully");
                    List<Object> list = !eDMResponseWithAttachment.getAllAttachments().isEmpty() ? eDMResponseWithAttachment.getAllAttachments().stream().map(attachment -> {
                        byte[] byArray = new byte[]{};
                        try {
                            byArray = Files.readAllBytes(attachment.getAttachedFile().toPath());
                        }
                        catch (IOException iOException) {
                            ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, string + "DP encountered an error while attaching the documents: " + iOException.getMessage());
                        }
                        return MEPayload.builder().data(byArray).mimeType(MimeTypeDeterminator.getInstance().getMimeTypeFromBytes(byArray)).contentID(attachment.getAttachedFileCid()).build();
                    }).collect(Collectors.toList()) : new ArrayList();
                    IncomingEDMResponse incomingEDMResponse = new IncomingEDMResponse(eDMResponseWithAttachment.getEdmResponse(), tCPayload.getContentID(), list, mEIncomingTransportMetadata2);
                    TCOutgoingMessage tCOutgoingMessage = DpApp.createTCOutgoingMessageFromIncomingResponse(incomingEDMResponse.getMetadata(), incomingEDMResponse);
                    ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, string + "DP created an OutgoingMessage successfully");
                    StatusType statusType = DpApp.sendResponse(TCRestJAXB.outgoingMessage().getAsBytes(tCOutgoingMessage), APPCONFIG.getDp().getToop().getSubmit() + "/response");
                    EErrorLevel eErrorLevel = statusType.getErrorLevel();
                    ToopKafkaClient.send((IErrorLevel)eErrorLevel, string + "Elonia DP pushed response to connector with status " + statusType.name());
                    return statusType;
                }
                catch (DPException dPException) {
                    EDMErrorResponse eDMErrorResponse = dPException.getEdmErrorResponse();
                    ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, string + "Elonia DP failed to create an EDMResponse, sending back an EDMErrorResponse to DC");
                    ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, string + "Error was: \"" + dPException.getMessage() + "\"");
                    IncomingEDMErrorResponse incomingEDMErrorResponse = new IncomingEDMErrorResponse(eDMErrorResponse, tCPayload.getContentID(), mEIncomingTransportMetadata2);
                    TCOutgoingMessage tCOutgoingMessage = DpApp.createTCOutgoingMessageFromIncomingResponse(incomingEDMErrorResponse.getMetadata(), incomingEDMErrorResponse);
                    ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, string + "Elonia DP created an OutgoingMessage successfully");
                    StatusType statusType = DpApp.sendResponse(TCRestJAXB.outgoingMessage().getAsBytes(tCOutgoingMessage), APPCONFIG.getDp().getToop().getSubmit() + "/error");
                    EErrorLevel eErrorLevel = statusType.getErrorLevel();
                    ToopKafkaClient.send((IErrorLevel)eErrorLevel, string + "Elonia DP pushed response to connector with status " + statusType.name());
                    return statusType;
                }
            }
        }
        return StatusType.NOT_OK;
    }

    private static TCOutgoingMessage createTCOutgoingMessageFromIncomingResponse(IMEIncomingTransportMetadata iMEIncomingTransportMetadata, IIncomingEDMResponse iIncomingEDMResponse) {
        TCOutgoingMessage tCOutgoingMessage = new TCOutgoingMessage();
        IExplicitlyCloneable iExplicitlyCloneable = new TCOutgoingMetadata();
        ((TCOutgoingMetadata)iExplicitlyCloneable).setReceiverID(TCRestJAXB.createTCID(iMEIncomingTransportMetadata.getReceiverID().getScheme(), iMEIncomingTransportMetadata.getReceiverID().getValue()));
        ((TCOutgoingMetadata)iExplicitlyCloneable).setSenderID(TCRestJAXB.createTCID(iMEIncomingTransportMetadata.getSenderID().getScheme(), iMEIncomingTransportMetadata.getSenderID().getValue()));
        ((TCOutgoingMetadata)iExplicitlyCloneable).setDocTypeID(TCRestJAXB.createTCID("toop-doctypeid-qns", "QueryResponse::toop-edm:v2.0"));
        ((TCOutgoingMetadata)iExplicitlyCloneable).setProcessID(TCRestJAXB.createTCID(iMEIncomingTransportMetadata.getProcessID().getScheme(), iMEIncomingTransportMetadata.getProcessID().getValue()));
        ((TCOutgoingMetadata)iExplicitlyCloneable).setTransportProtocol(EMEProtocol.AS4.getTransportProfileID());
        tCOutgoingMessage.setMetadata((TCOutgoingMetadata)iExplicitlyCloneable);
        iExplicitlyCloneable = new TCPayload();
        ArrayList arrayList = new ArrayList();
        byte[] byArray = null;
        if (iIncomingEDMResponse instanceof IncomingEDMResponse) {
            byArray = ((IncomingEDMResponse)iIncomingEDMResponse).getResponse().getWriter().getAsBytes();
            arrayList.addAll(((IncomingEDMResponse)iIncomingEDMResponse).attachments().values().stream().map(mEPayload -> {
                TCPayload tCPayload = new TCPayload();
                tCPayload.setContentID(mEPayload.getContentID());
                tCPayload.setMimeType(mEPayload.getMimeTypeString());
                tCPayload.setValue(mEPayload.getData().bytes());
                return tCPayload;
            }).collect(Collectors.toList()));
            ((TCPayload)iExplicitlyCloneable).setContentID(((IncomingEDMResponse)iIncomingEDMResponse).getResponse().getRequestID() + "@elonia-dev");
        }
        if (iIncomingEDMResponse instanceof IncomingEDMErrorResponse) {
            byArray = ((IncomingEDMErrorResponse)iIncomingEDMResponse).getErrorResponse().getWriter().getAsBytes();
            ((TCPayload)iExplicitlyCloneable).setContentID(((IncomingEDMErrorResponse)iIncomingEDMResponse).getErrorResponse().getRequestID() + "@elonia-dev");
        }
        ((TCPayload)iExplicitlyCloneable).setValue(byArray);
        ((TCPayload)iExplicitlyCloneable).setMimeType(CMimeType.APPLICATION_XML.getAsString());
        tCOutgoingMessage.addPayload((TCPayload)iExplicitlyCloneable);
        if (!arrayList.isEmpty()) {
            arrayList.forEach(tCOutgoingMessage::addPayload);
        }
        return tCOutgoingMessage;
    }

    private static StatusType sendResponse(byte[] byArray, String string) throws IOException {
        Objects.requireNonNull(byArray, "The supplied Response must not be null!");
        try (CloseableHttpClient closeableHttpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(string);
            httpPost.setHeader("Content-Type", CMimeType.APPLICATION_XML.getAsString());
            ByteArrayEntity byteArrayEntity = new ByteArrayEntity(byArray);
            httpPost.setEntity(byteArrayEntity);
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute(httpPost);
            String string2 = ((Stream)new BufferedReader(new InputStreamReader(closeableHttpResponse.getEntity().getContent())).lines().parallel()).collect(Collectors.joining("\n"));
            int n = closeableHttpResponse.getStatusLine().getStatusCode();
            LOGGER.info("DP got response when sending message:\n {}", (Object)string2);
            if (n != 200) {
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, "Response code connector:\n " + n);
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, "Response from connector:\n " + string2);
                StatusType statusType = StatusType.NOT_OK;
                return statusType;
            }
            StatusType statusType = StatusType.OK;
            return statusType;
        }
    }
}

