/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.kafkaclient;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import eu.toop.kafkaclient.ToopKafkaSettings;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ToopKafkaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToopKafkaManager.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static KafkaProducer<String, String> s_aProducer;
    private static final ICommonsMap<String, String> s_aDefaultProps;

    @Nonnull
    @ReturnsMutableObject
    public static ICommonsMap<String, String> defaultProperties() {
        return s_aDefaultProps;
    }

    private ToopKafkaManager() {
    }

    @Nonnull
    @ReturnsMutableObject
    private static ICommonsMap<String, Object> _getCreationProperties() {
        CommonsHashMap<String, Object> commonsHashMap = new CommonsHashMap<String, Object>();
        commonsHashMap.putAll(s_aDefaultProps);
        return commonsHashMap;
    }

    @Nonnull
    public static KafkaProducer<String, String> getOrCreateProducer() {
        KafkaProducer<String, String> kafkaProducer = s_aRWLock.readLockedGet(() -> s_aProducer);
        if (kafkaProducer == null) {
            s_aRWLock.writeLock().lock();
            try {
                kafkaProducer = s_aProducer;
                if (kafkaProducer == null) {
                    s_aProducer = kafkaProducer = new KafkaProducer<String, String>(ToopKafkaManager._getCreationProperties(), new StringSerializer(), new StringSerializer());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Successfully created new KafkaProducer");
                    }
                }
            }
            finally {
                s_aRWLock.writeLock().unlock();
            }
        }
        return kafkaProducer;
    }

    public static void shutdown() {
        s_aRWLock.writeLocked(() -> {
            if (s_aProducer != null) {
                s_aProducer.close();
                s_aProducer = null;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Successfully closed KafkaProducer");
                }
            }
        });
    }

    @Nonnull
    public static Future<RecordMetadata> send(@Nullable String string, @Nonnull String string2, @Nullable Callback callback) {
        ValueEnforcer.notNull(string2, "Value");
        ProducerRecord<String, String> producerRecord = new ProducerRecord<String, String>(ToopKafkaSettings.getKafkaTopic(), string, string2);
        return ToopKafkaManager.getOrCreateProducer().send(producerRecord, callback);
    }

    static {
        s_aDefaultProps = new CommonsHashMap<String, String>();
        s_aDefaultProps.put("max.block.ms", "5000");
    }
}

