/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.kafkaclient;

import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.log.LogHelper;
import eu.toop.kafkaclient.ToopKafkaManager;
import eu.toop.kafkaclient.ToopKafkaSettings;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToopKafkaClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToopKafkaClient.class);

    private ToopKafkaClient() {
    }

    private static void _sendIfKafkaEnabled(@Nullable IErrorLevel iErrorLevel, @Nonnull String string) {
        String string2 = string;
        if (iErrorLevel != null) {
            string2 = "[" + ((String)iErrorLevel.getID()).toUpperCase(Locale.US) + "] " + string2;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending to Kafka: '" + string2 + "'");
        }
        ToopKafkaManager.send(null, string2, null);
    }

    public static void send(@Nullable IErrorLevel iErrorLevel, @Nonnull String string) {
        if (iErrorLevel != null && ToopKafkaSettings.isLoggingEnabled()) {
            LogHelper.log(ToopKafkaClient.class, iErrorLevel, string);
        }
        if (ToopKafkaSettings.isKafkaEnabled()) {
            ToopKafkaClient._sendIfKafkaEnabled(iErrorLevel, string);
        }
    }

    public static void send(@Nullable IErrorLevel iErrorLevel, @Nonnull Supplier<String> supplier) {
        ToopKafkaClient.send(iErrorLevel, supplier, null);
    }

    public static void send(@Nullable IErrorLevel iErrorLevel, @Nonnull Supplier<String> supplier, @Nullable Throwable throwable) {
        String string = null;
        if (iErrorLevel != null && ToopKafkaSettings.isLoggingEnabled()) {
            string = supplier.get();
            LogHelper.log(ToopKafkaClient.class, iErrorLevel, string, throwable);
        }
        if (ToopKafkaSettings.isKafkaEnabled()) {
            if (string == null) {
                string = supplier.get();
            }
            if (throwable != null) {
                string = string + " -- " + ClassHelper.getClassLocalName(throwable.getClass()) + ": " + throwable.getMessage();
            }
            ToopKafkaClient._sendIfKafkaEnabled(iErrorLevel, string);
        }
    }

    public static void close() {
        if (ToopKafkaSettings.isKafkaEnabled()) {
            ToopKafkaManager.shutdown();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Successfully shutdown Kafka client");
            }
        }
    }
}

