/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.xml.cccev;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.math.MathHelper;
import eu.toop.edm.jaxb.cccev.CCCEVValueType;
import eu.toop.edm.jaxb.cv.cac.PeriodType;
import eu.toop.edm.jaxb.cv.cbc.AmountType;
import eu.toop.edm.jaxb.cv.cbc.CodeType;
import eu.toop.edm.jaxb.cv.cbc.DateType;
import eu.toop.edm.jaxb.cv.cbc.IDType;
import eu.toop.edm.jaxb.cv.cbc.IndicatorType;
import eu.toop.edm.jaxb.cv.cbc.MeasureType;
import eu.toop.edm.jaxb.cv.cbc.NumericType;
import eu.toop.edm.jaxb.cv.cbc.QuantityType;
import eu.toop.edm.jaxb.cv.cbc.TextType;
import eu.toop.edm.jaxb.cv.cbc.TimeType;
import eu.toop.edm.jaxb.cv.cbc.URIType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CCCEVValueHelper {
    private CCCEVValueHelper() {
    }

    @Nonnull
    public static CCCEVValueType createID(@Nonnull String string) {
        return CCCEVValueHelper.create(new IDType(string));
    }

    @Nonnull
    public static CCCEVValueType create(@Nonnull IDType iDType) {
        CCCEVValueType cCCEVValueType = new CCCEVValueType();
        cCCEVValueType.setIdentifierValue(iDType);
        return cCCEVValueType;
    }

    @Nonnull
    public static CCCEVValueType createAmount(@Nullable BigDecimal bigDecimal, @Nullable String string) {
        AmountType amountType = new AmountType();
        amountType.setValue(bigDecimal);
        amountType.setCurrencyID(string);
        return CCCEVValueHelper.create(amountType);
    }

    @Nonnull
    public static CCCEVValueType create(@Nullable AmountType amountType) {
        CCCEVValueType cCCEVValueType = new CCCEVValueType();
        cCCEVValueType.setAmountValue(amountType);
        return cCCEVValueType;
    }

    @Nonnull
    public static CCCEVValueType createCode(@Nullable String string) {
        return CCCEVValueHelper.create(new CodeType(string));
    }

    @Nonnull
    public static CCCEVValueType create(@Nullable CodeType codeType) {
        CCCEVValueType cCCEVValueType = new CCCEVValueType();
        cCCEVValueType.setCodeValue(codeType);
        return cCCEVValueType;
    }

    @Nonnull
    public static CCCEVValueType create(@Nullable LocalDate localDate) {
        return CCCEVValueHelper.create(localDate == null ? null : new DateType(localDate));
    }

    @Nonnull
    public static CCCEVValueType create(@Nullable DateType dateType) {
        CCCEVValueType cCCEVValueType = new CCCEVValueType();
        cCCEVValueType.setDateValue(dateType);
        return cCCEVValueType;
    }

    @Nonnull
    public static CCCEVValueType create(@Nullable Boolean bl) {
        return CCCEVValueHelper.createIndicator(bl == null ? null : bl.toString());
    }

    @Nonnull
    public static CCCEVValueType create(boolean bl) {
        return CCCEVValueHelper.createIndicator(Boolean.toString(bl));
    }

    @Nonnull
    public static CCCEVValueType createIndicator(@Nullable String string) {
        IndicatorType indicatorType = new IndicatorType();
        indicatorType.setValue(string);
        return CCCEVValueHelper.create(indicatorType);
    }

    @Nonnull
    public static CCCEVValueType create(@Nullable IndicatorType indicatorType) {
        CCCEVValueType cCCEVValueType = new CCCEVValueType();
        cCCEVValueType.setIndicatorValue(indicatorType);
        return cCCEVValueType;
    }

    @Nonnull
    public static CCCEVValueType createMeasure(@Nullable BigDecimal bigDecimal, @Nullable String string) {
        MeasureType measureType = new MeasureType();
        measureType.setValue(bigDecimal);
        measureType.setUnitCode(string);
        return CCCEVValueHelper.create(measureType);
    }

    @Nonnull
    public static CCCEVValueType create(@Nullable MeasureType measureType) {
        CCCEVValueType cCCEVValueType = new CCCEVValueType();
        cCCEVValueType.setMeasureValue(measureType);
        return cCCEVValueType;
    }

    @Nonnull
    public static CCCEVValueType create(long l) {
        return CCCEVValueHelper.create(MathHelper.toBigDecimal(l));
    }

    @Nonnull
    public static CCCEVValueType create(double d) {
        return CCCEVValueHelper.create(MathHelper.toBigDecimal(d));
    }

    @Nonnull
    public static CCCEVValueType create(@Nullable BigDecimal bigDecimal) {
        return CCCEVValueHelper.create(new NumericType(bigDecimal));
    }

    @Nonnull
    public static CCCEVValueType create(@Nonnull NumericType numericType) {
        CCCEVValueType cCCEVValueType = new CCCEVValueType();
        cCCEVValueType.setNumericValue(numericType);
        return cCCEVValueType;
    }

    @Nonnull
    public static CCCEVValueType createQuantity(@Nullable BigDecimal bigDecimal, @Nullable String string) {
        QuantityType quantityType = new QuantityType();
        quantityType.setValue(bigDecimal);
        quantityType.setUnitCode(string);
        return CCCEVValueHelper.create(quantityType);
    }

    @Nonnull
    public static CCCEVValueType create(@Nullable QuantityType quantityType) {
        CCCEVValueType cCCEVValueType = new CCCEVValueType();
        cCCEVValueType.setQuantityValue(quantityType);
        return cCCEVValueType;
    }

    @Nonnull
    public static CCCEVValueType createText(String ... stringArray) {
        return CCCEVValueHelper.create(new CommonsArrayList<TextType>((SRCTYPE[])stringArray, TextType::new));
    }

    @Nonnull
    public static CCCEVValueType createText(@Nullable Collection<String> collection) {
        return CCCEVValueHelper.create(new CommonsArrayList<TextType>(collection, TextType::new));
    }

    @Nonnull
    public static CCCEVValueType create(TextType ... textTypeArray) {
        CCCEVValueType cCCEVValueType = new CCCEVValueType();
        if (textTypeArray != null) {
            for (TextType textType : textTypeArray) {
                cCCEVValueType.addTextValue(textType);
            }
        }
        return cCCEVValueType;
    }

    @Nonnull
    public static CCCEVValueType create(@Nullable Collection<TextType> collection) {
        CCCEVValueType cCCEVValueType = new CCCEVValueType();
        if (collection != null) {
            cCCEVValueType.getTextValue().addAll(collection);
        }
        return cCCEVValueType;
    }

    @Nonnull
    public static CCCEVValueType create(@Nullable LocalTime localTime) {
        return CCCEVValueHelper.create(localTime == null ? null : new TimeType(localTime));
    }

    @Nonnull
    public static CCCEVValueType create(@Nullable TimeType timeType) {
        CCCEVValueType cCCEVValueType = new CCCEVValueType();
        cCCEVValueType.setTimeValue(timeType);
        return cCCEVValueType;
    }

    @Nonnull
    public static CCCEVValueType createURI(@Nullable String string) {
        return CCCEVValueHelper.create(new URIType(string));
    }

    @Nonnull
    public static CCCEVValueType create(@Nullable URIType uRIType) {
        CCCEVValueType cCCEVValueType = new CCCEVValueType();
        cCCEVValueType.setUriValue(uRIType);
        return cCCEVValueType;
    }

    @Nonnull
    public static CCCEVValueType create(@Nullable PeriodType periodType) {
        CCCEVValueType cCCEVValueType = new CCCEVValueType();
        cCCEVValueType.setPeriodValue(periodType);
        return cCCEVValueType;
    }

    @Nonnull
    public static CCCEVValueType createError(@Nullable String string) {
        return CCCEVValueHelper.createError(new CodeType(string));
    }

    @Nonnull
    public static CCCEVValueType createError(@Nullable CodeType codeType) {
        CCCEVValueType cCCEVValueType = new CCCEVValueType();
        cCCEVValueType.setError(codeType);
        return cCCEVValueType;
    }
}

