/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.schematron;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.schematron.ISchematronResource;
import com.helger.schematron.svrl.AbstractSVRLMessage;
import com.helger.schematron.svrl.SVRLHelper;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.schematron.xslt.SchematronResourceXSLT;
import com.helger.xml.serialize.read.DOMReader;
import javax.annotation.Nonnull;
import org.w3c.dom.Document;

public abstract class AbstractSchematronValidator {
    protected AbstractSchematronValidator() {
    }

    @Nonnull
    protected abstract IReadableResource getSchematronXSLTResource();

    @Nonnull
    public final ISchematronResource createSchematronResource() {
        IReadableResource iReadableResource = this.getSchematronXSLTResource();
        SchematronResourceXSLT schematronResourceXSLT = new SchematronResourceXSLT(iReadableResource);
        if (!schematronResourceXSLT.isValidSchematron()) {
            throw new IllegalStateException("Failed to compile Schematron/XSLT " + iReadableResource.getPath());
        }
        return schematronResourceXSLT;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<AbstractSVRLMessage> validateResource(@Nonnull IReadableResource iReadableResource) {
        Document document = DOMReader.readXMLDOM(iReadableResource);
        if (document == null) {
            throw new IllegalStateException("Failed to read the provided XML");
        }
        return this.validateDocument(document);
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<AbstractSVRLMessage> validateDocument(@Nonnull Document document) {
        try {
            ISchematronResource iSchematronResource = this.createSchematronResource();
            SchematronOutputType schematronOutputType = iSchematronResource.applySchematronValidationToSVRL(document, null);
            return SVRLHelper.getAllFailedAssertionsAndSuccessfulReports(schematronOutputType);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error applying SCH onto XML", exception);
        }
    }
}

