/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.model;

import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.util.PDTXMLConverter;
import eu.toop.edm.jaxb.cv.cac.PeriodType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.datatype.XMLGregorianCalendar;

@Immutable
public class PeriodPojo {
    private final LocalDate m_aStartDate;
    private final LocalTime m_aStartTime;
    private final LocalDate m_aEndDate;
    private final LocalTime m_aEndTime;

    public PeriodPojo(@Nullable LocalDate localDate, @Nullable LocalTime localTime, @Nullable LocalDate localDate2, @Nullable LocalTime localTime2) {
        this.m_aStartDate = localDate;
        this.m_aStartTime = localTime;
        this.m_aEndDate = localDate2;
        this.m_aEndTime = localTime2;
    }

    @Nullable
    public final LocalDate getStartDate() {
        return this.m_aStartDate;
    }

    @Nullable
    public final LocalTime getStartTime() {
        return this.m_aStartTime;
    }

    @Nullable
    public final LocalDate getEndDate() {
        return this.m_aEndDate;
    }

    @Nullable
    public final LocalTime getEndTime() {
        return this.m_aEndTime;
    }

    @Nonnull
    public PeriodType getAsPeriod() {
        PeriodType periodType = new PeriodType();
        if (this.m_aStartDate != null) {
            periodType.setStartDate(this.m_aStartDate);
        }
        if (this.m_aStartTime != null) {
            periodType.setStartTime(this.m_aStartTime);
        }
        if (this.m_aEndDate != null) {
            periodType.setEndDate(this.m_aEndDate);
        }
        if (this.m_aEndTime != null) {
            periodType.setEndTime(this.m_aEndTime);
        }
        return periodType;
    }

    @Nullable
    private static String _getAsString(@Nullable LocalDate localDate, @Nullable LocalTime localTime) {
        if (localDate != null) {
            if (localTime != null) {
                return "[" + localDate.atTime(localTime).toString() + "]";
            }
            return "[" + localDate.toString() + "]";
        }
        if (localTime != null) {
            return "[" + localTime.toString() + "]";
        }
        return null;
    }

    @Nullable
    public String getAsString() {
        return StringHelper.getConcatenatedOnDemand(PeriodPojo._getAsString(this.m_aStartDate, this.m_aStartTime), "-", PeriodPojo._getAsString(this.m_aEndDate, this.m_aEndTime));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PeriodPojo periodPojo = (PeriodPojo)object;
        return EqualsHelper.equals(this.m_aStartDate, periodPojo.m_aStartDate) && EqualsHelper.equals(this.m_aStartTime, periodPojo.m_aStartTime) && EqualsHelper.equals(this.m_aEndDate, periodPojo.m_aEndDate) && EqualsHelper.equals(this.m_aEndTime, periodPojo.m_aEndTime);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aStartDate).append(this.m_aStartTime).append(this.m_aEndDate).append(this.m_aEndTime).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("StartDate", this.m_aStartDate).append("StartTime", this.m_aStartDate).append("EndDate", this.m_aEndDate).append("EndTime", this.m_aEndTime).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable PeriodType periodType) {
        Builder builder = new Builder();
        if (periodType != null) {
            builder.startDate(periodType.getStartDateValue()).startTime(periodType.getStartTimeValue()).endDate(periodType.getEndDateValue()).endTime(periodType.getEndTimeValue());
        }
        return builder;
    }

    @NotThreadSafe
    public static class Builder {
        private LocalDate m_aStartDate;
        private LocalTime m_aStartTime;
        private LocalDate m_aEndDate;
        private LocalTime m_aEndTime;

        @Nonnull
        public Builder startDateTimeNow() {
            return this.startDateTime(PDTFactory.getCurrentLocalDateTime());
        }

        @Nonnull
        public Builder startDateTime(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.startDateTime(PDTXMLConverter.getLocalDateTime(xMLGregorianCalendar));
        }

        @Nonnull
        public Builder startDateTime(@Nullable LocalDateTime localDateTime) {
            return this.startDate(localDateTime == null ? null : localDateTime.toLocalDate()).startTime(localDateTime == null ? null : localDateTime.toLocalTime());
        }

        @Nonnull
        public Builder startDateNow() {
            return this.startDate(PDTFactory.getCurrentLocalDate());
        }

        @Nonnull
        public Builder startDate(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.startDate(PDTXMLConverter.getLocalDate(xMLGregorianCalendar));
        }

        @Nonnull
        public Builder startDate(@Nullable LocalDate localDate) {
            this.m_aStartDate = localDate;
            return this;
        }

        @Nonnull
        public Builder startTimeNow() {
            return this.startTime(PDTFactory.getCurrentLocalTime());
        }

        @Nonnull
        public Builder startTime(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.startTime(PDTXMLConverter.getLocalTime(xMLGregorianCalendar));
        }

        @Nonnull
        public Builder startTime(@Nullable LocalTime localTime) {
            this.m_aStartTime = localTime == null ? null : localTime.truncatedTo(ChronoUnit.MILLIS);
            return this;
        }

        @Nonnull
        public Builder endDateTimeNow() {
            return this.endDateTime(PDTFactory.getCurrentLocalDateTime());
        }

        @Nonnull
        public Builder endDateTime(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.endDateTime(PDTXMLConverter.getLocalDateTime(xMLGregorianCalendar));
        }

        @Nonnull
        public Builder endDateTime(@Nullable LocalDateTime localDateTime) {
            return this.endDate(localDateTime == null ? null : localDateTime.toLocalDate()).endTime(localDateTime == null ? null : localDateTime.toLocalTime());
        }

        @Nonnull
        public Builder endDateNow() {
            return this.endDate(PDTFactory.getCurrentLocalDate());
        }

        @Nonnull
        public Builder endDate(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.endDate(PDTXMLConverter.getLocalDate(xMLGregorianCalendar));
        }

        @Nonnull
        public Builder endDate(@Nullable LocalDate localDate) {
            this.m_aEndDate = localDate;
            return this;
        }

        @Nonnull
        public Builder endTimeNow() {
            return this.endTime(PDTFactory.getCurrentLocalTime());
        }

        @Nonnull
        public Builder endTime(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.endTime(PDTXMLConverter.getLocalTime(xMLGregorianCalendar));
        }

        @Nonnull
        public Builder endTime(@Nullable LocalTime localTime) {
            this.m_aEndTime = localTime == null ? null : localTime.truncatedTo(ChronoUnit.MILLIS);
            return this;
        }

        @Nonnull
        public PeriodPojo build() {
            return new PeriodPojo(this.m_aStartDate, this.m_aStartTime, this.m_aEndDate, this.m_aEndTime);
        }
    }
}

