/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.model;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xsds.ccts.cct.schemamodule.TextType;
import eu.toop.edm.jaxb.w3.cv.ac.CoreBusinessType;
import eu.toop.edm.jaxb.w3.cv.bc.LegalEntityIDType;
import eu.toop.edm.jaxb.w3.cv.bc.LegalEntityLegalIDType;
import eu.toop.edm.jaxb.w3.cv.bc.LegalEntityLegalNameType;
import eu.toop.edm.model.AddressPojo;
import eu.toop.edm.model.EToopIdentifierType;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import oasis.names.specification.ubl.schema.xsd.unqualifieddatatypes_21.IdentifierType;

@Immutable
public class BusinessPojo {
    private final String m_sLegalID;
    private final String m_sLegalIDSchemeID;
    private final String m_sID;
    private final String m_sIDSchemeID;
    private final String m_sLegalName;
    private final AddressPojo m_aAddress;

    public BusinessPojo(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable AddressPojo addressPojo) {
        this.m_sLegalID = string;
        this.m_sLegalIDSchemeID = string2;
        this.m_sID = string3;
        this.m_sIDSchemeID = string4;
        this.m_sLegalName = string5;
        this.m_aAddress = addressPojo;
    }

    @Nullable
    public final String getLegalID() {
        return this.m_sLegalID;
    }

    @Nullable
    public final String getLegalIDSchemeID() {
        return this.m_sLegalIDSchemeID;
    }

    @Nullable
    public final String getID() {
        return this.m_sID;
    }

    @Nullable
    public final String getIDSchemeID() {
        return this.m_sIDSchemeID;
    }

    @Nullable
    public final String getLegalName() {
        return this.m_sLegalName;
    }

    @Nullable
    public final AddressPojo getAddress() {
        return this.m_aAddress;
    }

    @Nonnull
    public CoreBusinessType getAsCoreBusiness() {
        IExplicitlyCloneable iExplicitlyCloneable;
        CoreBusinessType coreBusinessType = new CoreBusinessType();
        if (StringHelper.hasText(this.m_sLegalID)) {
            iExplicitlyCloneable = new LegalEntityLegalIDType();
            ((com.helger.xsds.ccts.cct.schemamodule.IdentifierType)iExplicitlyCloneable).setValue(this.m_sLegalID);
            ((com.helger.xsds.ccts.cct.schemamodule.IdentifierType)iExplicitlyCloneable).setSchemeID(this.m_sLegalIDSchemeID);
            coreBusinessType.addLegalEntityLegalID((LegalEntityLegalIDType)iExplicitlyCloneable);
        }
        if (StringHelper.hasText(this.m_sID)) {
            iExplicitlyCloneable = new LegalEntityIDType();
            ((com.helger.xsds.ccts.cct.schemamodule.IdentifierType)iExplicitlyCloneable).setValue(this.m_sID);
            ((com.helger.xsds.ccts.cct.schemamodule.IdentifierType)iExplicitlyCloneable).setSchemeID(this.m_sIDSchemeID);
            coreBusinessType.addLegalEntityID((LegalEntityIDType)iExplicitlyCloneable);
        }
        if (StringHelper.hasText(this.m_sLegalName)) {
            iExplicitlyCloneable = new LegalEntityLegalNameType();
            ((TextType)iExplicitlyCloneable).setValue(this.m_sLegalName);
            coreBusinessType.addLegalEntityLegalName((LegalEntityLegalNameType)iExplicitlyCloneable);
        }
        if (this.m_aAddress != null) {
            coreBusinessType.setLegalEntityCoreAddress(this.m_aAddress.getAsCoreAddress());
        }
        return coreBusinessType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BusinessPojo businessPojo = (BusinessPojo)object;
        return EqualsHelper.equals(this.m_sLegalID, businessPojo.m_sLegalID) && EqualsHelper.equals(this.m_sLegalIDSchemeID, businessPojo.m_sLegalIDSchemeID) && EqualsHelper.equals(this.m_sID, businessPojo.m_sID) && EqualsHelper.equals(this.m_sIDSchemeID, businessPojo.m_sIDSchemeID) && EqualsHelper.equals(this.m_sLegalName, businessPojo.m_sLegalName) && EqualsHelper.equals(this.m_aAddress, businessPojo.m_aAddress);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sLegalID).append(this.m_sLegalIDSchemeID).append(this.m_sID).append(this.m_sIDSchemeID).append(this.m_sLegalName).append(this.m_aAddress).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("LegalID", this.m_sLegalID).append("LegalIDSchemeID", this.m_sLegalIDSchemeID).append("sID", this.m_sID).append("IDSchemeID", this.m_sIDSchemeID).append("LegalName", this.m_sLegalName).append("Address", this.m_aAddress).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable CoreBusinessType coreBusinessType) {
        Builder builder = new Builder();
        if (coreBusinessType != null) {
            IdentifierType identifierType;
            if (coreBusinessType.hasLegalEntityLegalIDEntries()) {
                identifierType = coreBusinessType.getLegalEntityLegalIDAtIndex(0);
                builder.legalID(identifierType.getValue()).legalIDSchemeID(identifierType.getSchemeID());
            }
            if (coreBusinessType.hasLegalEntityIDEntries()) {
                identifierType = coreBusinessType.getLegalEntityIDAtIndex(0);
                builder.id(identifierType.getValue()).idSchemeID(identifierType.getSchemeID());
            }
            if (coreBusinessType.hasLegalEntityLegalNameEntries()) {
                builder.legalName(coreBusinessType.getLegalEntityLegalNameAtIndex(0).getValue());
            }
            if (coreBusinessType.getLegalEntityCoreAddress() != null) {
                builder.address(AddressPojo.builder(coreBusinessType.getLegalEntityCoreAddress()));
            }
        }
        return builder;
    }

    @NotThreadSafe
    public static class Builder {
        private String m_sLegalID;
        private String m_sLegalIDSchemeID;
        private String m_sID;
        private String m_sIDSchemeID;
        private String m_sLegalName;
        private AddressPojo m_aAddress;

        @Nonnull
        public Builder legalID(@Nullable String string) {
            this.m_sLegalID = string;
            return this;
        }

        @Nonnull
        public Builder legalIDSchemeID(@Nullable EToopIdentifierType eToopIdentifierType) {
            return this.legalIDSchemeID(eToopIdentifierType == null ? null : eToopIdentifierType.getID());
        }

        @Nonnull
        public Builder legalIDSchemeID(@Nullable String string) {
            this.m_sLegalIDSchemeID = string;
            return this;
        }

        @Nonnull
        public Builder id(@Nullable String string) {
            this.m_sID = string;
            return this;
        }

        @Nonnull
        public Builder idSchemeID(@Nullable EToopIdentifierType eToopIdentifierType) {
            return this.idSchemeID(eToopIdentifierType == null ? null : eToopIdentifierType.getID());
        }

        @Nonnull
        public Builder idSchemeID(@Nullable String string) {
            this.m_sIDSchemeID = string;
            return this;
        }

        @Nonnull
        public Builder legalName(@Nullable String string) {
            this.m_sLegalName = string;
            return this;
        }

        @Nonnull
        public Builder address(@Nullable Consumer<? super AddressPojo.Builder> consumer) {
            if (consumer != null) {
                AddressPojo.Builder builder = AddressPojo.builder();
                consumer.accept(builder);
                this.address(builder);
            }
            return this;
        }

        @Nonnull
        public Builder address(@Nullable AddressPojo.Builder builder) {
            return this.address(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder address(@Nullable AddressPojo addressPojo) {
            this.m_aAddress = addressPojo;
            return this;
        }

        @Nonnull
        public BusinessPojo build() {
            return new BusinessPojo(this.m_sLegalID, this.m_sLegalIDSchemeID, this.m_sID, this.m_sIDSchemeID, this.m_sLegalName, this.m_aAddress);
        }
    }
}

