/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.model;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cv.cac.AddressType;
import eu.toop.edm.jaxb.w3.cv.ac.CoreAddressType;
import eu.toop.edm.jaxb.w3.cv.bc.AddressAdminUnitLocationOneType;
import eu.toop.edm.jaxb.w3.cv.bc.AddressFullAddressType;
import eu.toop.edm.jaxb.w3.cv.bc.AddressLocatorDesignatorType;
import eu.toop.edm.jaxb.w3.cv.bc.AddressPostCodeType;
import eu.toop.edm.jaxb.w3.cv.bc.AddressPostNameType;
import eu.toop.edm.jaxb.w3.cv.bc.AddressThoroughfareType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import oasis.names.specification.ubl.schema.xsd.unqualifieddatatypes_21.TextType;

@Immutable
public class AddressPojo {
    private final String m_sFullAddress;
    private final String m_sStreetName;
    private final String m_sBuildingNumber;
    private final String m_sTown;
    private final String m_sPostalCode;
    private final String m_sCountryCode;

    public AddressPojo(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6) {
        this.m_sFullAddress = string;
        this.m_sStreetName = string2;
        this.m_sBuildingNumber = string3;
        this.m_sTown = string4;
        this.m_sPostalCode = string5;
        this.m_sCountryCode = string6;
    }

    @Nullable
    public final String getFullAddress() {
        return this.m_sFullAddress;
    }

    @Nullable
    public final String getStreetName() {
        return this.m_sStreetName;
    }

    @Nullable
    public final String getBuildingNumber() {
        return this.m_sBuildingNumber;
    }

    @Nullable
    public final String getTown() {
        return this.m_sTown;
    }

    @Nullable
    public final String getPostalCode() {
        return this.m_sPostalCode;
    }

    @Nullable
    public final String getCountryCode() {
        return this.m_sCountryCode;
    }

    @Nullable
    public CoreAddressType getAsCoreAddress() {
        TextType textType;
        boolean bl = false;
        CoreAddressType coreAddressType = new CoreAddressType();
        if (StringHelper.hasText(this.m_sFullAddress)) {
            textType = new AddressFullAddressType();
            textType.setValue(this.m_sFullAddress);
            coreAddressType.addAddressFullAddress((AddressFullAddressType)textType);
            bl = true;
        }
        if (StringHelper.hasText(this.m_sStreetName)) {
            textType = new AddressThoroughfareType();
            textType.setValue(this.m_sStreetName);
            coreAddressType.addAddressThoroughfare((AddressThoroughfareType)textType);
            bl = true;
        }
        if (StringHelper.hasText(this.m_sBuildingNumber)) {
            textType = new AddressLocatorDesignatorType();
            textType.setValue(this.m_sBuildingNumber);
            coreAddressType.addAddressLocatorDesignator((AddressLocatorDesignatorType)textType);
            bl = true;
        }
        if (StringHelper.hasText(this.m_sTown)) {
            textType = new AddressPostNameType();
            textType.setValue(this.m_sTown);
            coreAddressType.addAddressPostName((AddressPostNameType)textType);
            bl = true;
        }
        if (StringHelper.hasText(this.m_sPostalCode)) {
            textType = new AddressPostCodeType();
            textType.setValue(this.m_sPostalCode);
            coreAddressType.addAddressPostCode((AddressPostCodeType)textType);
            bl = true;
        }
        if (StringHelper.hasText(this.m_sCountryCode)) {
            textType = new AddressAdminUnitLocationOneType();
            textType.setValue(this.m_sCountryCode);
            coreAddressType.addAddressAdminUnitLocationOne((AddressAdminUnitLocationOneType)textType);
            bl = true;
        }
        return bl ? coreAddressType : null;
    }

    @Nullable
    public AddressType getAsAgentAddress() {
        boolean bl = false;
        AddressType addressType = new AddressType();
        if (StringHelper.hasText(this.m_sFullAddress)) {
            addressType.setFullAddress(this.m_sFullAddress);
            bl = true;
        }
        if (StringHelper.hasText(this.m_sStreetName)) {
            addressType.setThoroughfare(this.m_sStreetName);
            bl = true;
        }
        if (StringHelper.hasText(this.m_sBuildingNumber)) {
            addressType.setLocatorDesignator(this.m_sBuildingNumber);
            bl = true;
        }
        if (StringHelper.hasText(this.m_sTown)) {
            addressType.setPostName(this.m_sTown);
            bl = true;
        }
        if (StringHelper.hasText(this.m_sPostalCode)) {
            addressType.setPostCode(this.m_sPostalCode);
            bl = true;
        }
        if (StringHelper.hasText(this.m_sCountryCode)) {
            addressType.setAdminUnitLevel1(this.m_sCountryCode);
            bl = true;
        }
        return bl ? addressType : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AddressPojo addressPojo = (AddressPojo)object;
        return EqualsHelper.equals(this.m_sFullAddress, addressPojo.m_sFullAddress) && EqualsHelper.equals(this.m_sStreetName, addressPojo.m_sStreetName) && EqualsHelper.equals(this.m_sBuildingNumber, addressPojo.m_sBuildingNumber) && EqualsHelper.equals(this.m_sTown, addressPojo.m_sTown) && EqualsHelper.equals(this.m_sPostalCode, addressPojo.m_sPostalCode) && EqualsHelper.equals(this.m_sCountryCode, addressPojo.m_sCountryCode);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sFullAddress).append(this.m_sStreetName).append(this.m_sBuildingNumber).append(this.m_sTown).append(this.m_sPostalCode).append(this.m_sCountryCode).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("FullAddress", this.m_sFullAddress).append("StreetName", this.m_sStreetName).append("BuildingNumber", this.m_sBuildingNumber).append("Town", this.m_sTown).append("PostalCode", this.m_sPostalCode).append("CountryCode", this.m_sCountryCode).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable CoreAddressType coreAddressType) {
        Builder builder = new Builder();
        if (coreAddressType != null) {
            if (coreAddressType.hasAddressFullAddressEntries()) {
                builder.fullAddress(coreAddressType.getAddressFullAddressAtIndex(0).getValue());
            }
            if (coreAddressType.hasAddressThoroughfareEntries()) {
                builder.streetName(coreAddressType.getAddressThoroughfareAtIndex(0).getValue());
            }
            if (coreAddressType.hasAddressLocatorDesignatorEntries()) {
                builder.buildingNumber(coreAddressType.getAddressLocatorDesignatorAtIndex(0).getValue());
            }
            if (coreAddressType.hasAddressPostNameEntries()) {
                builder.town(coreAddressType.getAddressPostNameAtIndex(0).getValue());
            }
            if (coreAddressType.hasAddressPostCodeEntries()) {
                builder.postalCode(coreAddressType.getAddressPostCodeAtIndex(0).getValue());
            }
            if (coreAddressType.hasAddressAdminUnitLocationOneEntries()) {
                builder.countryCode(coreAddressType.getAddressAdminUnitLocationOneAtIndex(0).getValue());
            }
        }
        return builder;
    }

    @Nonnull
    public static Builder builder(@Nullable eu.toop.edm.jaxb.w3.locn.AddressType addressType) {
        Builder builder = new Builder();
        if (addressType != null) {
            builder.fullAddress(addressType.getFullAddress()).streetName(addressType.getThoroughfare()).buildingNumber(addressType.getLocatorDesignator()).town(addressType.getPostName()).postalCode(addressType.getPostCode()).countryCode(addressType.getAdminUnitLevel1());
        }
        return builder;
    }

    @NotThreadSafe
    public static class Builder {
        private String m_sFullAddress;
        private String m_sStreetName;
        private String m_sBuildingNumber;
        private String m_sTown;
        private String m_sPostalCode;
        private String m_sCountryCode;

        @Nonnull
        public Builder fullAddress(@Nullable String string) {
            this.m_sFullAddress = string;
            return this;
        }

        @Nonnull
        public Builder streetName(@Nullable String string) {
            this.m_sStreetName = string;
            return this;
        }

        @Nonnull
        public Builder buildingNumber(@Nullable String string) {
            this.m_sBuildingNumber = string;
            return this;
        }

        @Nonnull
        public Builder town(@Nullable String string) {
            this.m_sTown = string;
            return this;
        }

        @Nonnull
        public Builder postalCode(@Nullable String string) {
            this.m_sPostalCode = string;
            return this;
        }

        @Nonnull
        public Builder countryCode(@Nullable String string) {
            this.m_sCountryCode = string;
            return this;
        }

        @Nonnull
        public AddressPojo build() {
            return new AddressPojo(this.m_sFullAddress, this.m_sStreetName, this.m_sBuildingNumber, this.m_sTown, this.m_sPostalCode, this.m_sCountryCode);
        }
    }
}

