/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.jaxb.IJAXBWriter;
import eu.toop.edm.IEDMTopLevelObject;
import eu.toop.edm.jaxb.cccev.CCCEVConceptType;
import eu.toop.edm.jaxb.cv.agent.AgentType;
import eu.toop.edm.model.AgentPojo;
import eu.toop.edm.model.ConceptPojo;
import eu.toop.edm.model.EToopResponseOptionType;
import eu.toop.edm.response.EDMResponsePayloadConcepts;
import eu.toop.edm.response.IEDMResponsePayloadProvider;
import eu.toop.edm.response.ResponseDocumentPojo;
import eu.toop.edm.response.ResponseDocumentReferencePojo;
import eu.toop.edm.slot.SlotDataProvider;
import eu.toop.edm.slot.SlotIssueDateTime;
import eu.toop.edm.slot.SlotSpecificationIdentifier;
import eu.toop.edm.xml.IJAXBVersatileReader;
import eu.toop.edm.xml.IVersatileWriter;
import eu.toop.edm.xml.JAXBVersatileReader;
import eu.toop.edm.xml.JAXBVersatileWriter;
import eu.toop.edm.xml.cagv.AgentMarshaller;
import eu.toop.edm.xml.cccev.CCCEV;
import eu.toop.edm.xml.cccev.ConceptMarshaller;
import eu.toop.regrep.ERegRepResponseStatus;
import eu.toop.regrep.RegRep4Reader;
import eu.toop.regrep.RegRep4Writer;
import eu.toop.regrep.RegRepHelper;
import eu.toop.regrep.query.QueryResponse;
import eu.toop.regrep.rim.AnyValueType;
import eu.toop.regrep.rim.CollectionValueType;
import eu.toop.regrep.rim.DateTimeValueType;
import eu.toop.regrep.rim.ExtrinsicObjectType;
import eu.toop.regrep.rim.ObjectRefListType;
import eu.toop.regrep.rim.ObjectRefType;
import eu.toop.regrep.rim.RegistryObjectListType;
import eu.toop.regrep.rim.RegistryObjectType;
import eu.toop.regrep.rim.SlotType;
import eu.toop.regrep.rim.StringValueType;
import eu.toop.regrep.rim.ValueType;
import eu.toop.regrep.slot.ISlotProvider;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.w3c.dom.Node;

public class EDMResponse
implements IEDMTopLevelObject {
    private static final ICommonsOrderedSet<String> TOP_LEVEL_SLOTS = new CommonsLinkedHashSet<String>("SpecificationIdentifier", "IssueDateTime", "DataProvider");
    private final EToopResponseOptionType m_eResponseOption;
    private final ERegRepResponseStatus m_eResponseStatus;
    private final String m_sRequestID;
    private final String m_sSpecificationIdentifier;
    private final LocalDateTime m_aIssueDateTime;
    private final AgentPojo m_aDataProvider;
    private final ICommonsList<IEDMResponsePayloadProvider> m_aPayloadProviders = new CommonsArrayList<IEDMResponsePayloadProvider>();

    protected EDMResponse(@Nonnull EToopResponseOptionType eToopResponseOptionType, @Nonnull ERegRepResponseStatus eRegRepResponseStatus, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull LocalDateTime localDateTime, @Nonnull AgentPojo agentPojo, @Nonnull @Nonempty ICommonsList<? extends IEDMResponsePayloadProvider> iCommonsList) {
        ValueEnforcer.notNull(eToopResponseOptionType, "ResponseOption");
        ValueEnforcer.notNull(eRegRepResponseStatus, "ResponseStatus");
        ValueEnforcer.isTrue(eRegRepResponseStatus == ERegRepResponseStatus.SUCCESS || eRegRepResponseStatus == ERegRepResponseStatus.FAILURE, "Only SUCCESS and FAILURE are supported");
        ValueEnforcer.notEmpty(string, "RequestID");
        ValueEnforcer.notEmpty(string2, "SpecificationIdentifier");
        ValueEnforcer.notNull(localDateTime, "IssueDateTime");
        ValueEnforcer.notNull(agentPojo, "DataProvider");
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, "PayloadProviders");
        this.m_eResponseOption = eToopResponseOptionType;
        this.m_eResponseStatus = eRegRepResponseStatus;
        this.m_sRequestID = string;
        this.m_sSpecificationIdentifier = string2;
        this.m_aIssueDateTime = localDateTime;
        this.m_aDataProvider = agentPojo;
        this.m_aPayloadProviders.addAll(iCommonsList);
    }

    @Nonnull
    public final EToopResponseOptionType getResponseOption() {
        return this.m_eResponseOption;
    }

    @Nonnull
    public final ERegRepResponseStatus getResponseStatus() {
        return this.m_eResponseStatus;
    }

    @Nonnull
    @Nonempty
    public final String getRequestID() {
        return this.m_sRequestID;
    }

    @Nonnull
    @Nonempty
    public final String getSpecificationIdentifier() {
        return this.m_sSpecificationIdentifier;
    }

    @Nonnull
    public final LocalDateTime getIssueDateTime() {
        return this.m_aIssueDateTime;
    }

    @Nonnull
    public final AgentPojo getDataProvider() {
        return this.m_aDataProvider;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableObject
    public final List<IEDMResponsePayloadProvider> payloadProviders() {
        return this.m_aPayloadProviders;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public final List<IEDMResponsePayloadProvider> getAllPayloadProviders() {
        return (List)this.m_aPayloadProviders.getClone();
    }

    @Nonnull
    private QueryResponse _createQueryResponse(@Nonnull ICommonsList<ISlotProvider> iCommonsList) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (ISlotProvider object2 : iCommonsList) {
            String string = object2.getName();
            if (commonsLinkedHashMap.containsKey(string)) {
                throw new IllegalArgumentException("A slot provider for name '" + string + "' is already present");
            }
            commonsLinkedHashMap.put(string, object2);
        }
        QueryResponse queryResponse = RegRepHelper.createEmptyQueryResponse(this.m_eResponseStatus);
        queryResponse.setRequestId(this.m_sRequestID);
        for (String string : TOP_LEVEL_SLOTS) {
            ISlotProvider iSlotProvider = (ISlotProvider)commonsLinkedHashMap.get(string);
            if (iSlotProvider == null) continue;
            queryResponse.addSlot(iSlotProvider.createSlot());
        }
        switch (this.m_eResponseOption) {
            case INLINE: {
                RegistryObjectListType registryObjectListType = new RegistryObjectListType();
                for (IEDMResponsePayloadProvider iEDMResponsePayloadProvider : this.m_aPayloadProviders) {
                    registryObjectListType.addRegistryObject(iEDMResponsePayloadProvider.getAsRegistryObject());
                }
                queryResponse.setRegistryObjectList(registryObjectListType);
                break;
            }
            case REFERENCE: {
                ObjectRefListType objectRefListType = new ObjectRefListType();
                for (IEDMResponsePayloadProvider iEDMResponsePayloadProvider : this.m_aPayloadProviders) {
                    objectRefListType.addObjectRef(iEDMResponsePayloadProvider.getAsObjectRef());
                }
                queryResponse.setObjectRefList(objectRefListType);
                break;
            }
            default: {
                throw new IllegalStateException("Found unsupported ResponseOption " + this.m_eResponseOption);
            }
        }
        return queryResponse;
    }

    @Nonnull
    public QueryResponse getAsQueryResponse() {
        CommonsArrayList<ISlotProvider> commonsArrayList = new CommonsArrayList<ISlotProvider>();
        if (this.m_sSpecificationIdentifier != null) {
            commonsArrayList.add(new SlotSpecificationIdentifier(this.m_sSpecificationIdentifier));
        }
        if (this.m_aIssueDateTime != null) {
            commonsArrayList.add(new SlotIssueDateTime(this.m_aIssueDateTime));
        }
        if (this.m_aDataProvider != null) {
            commonsArrayList.add(new SlotDataProvider(this.m_aDataProvider));
        }
        return this._createQueryResponse(commonsArrayList);
    }

    @Nonnull
    public IVersatileWriter<QueryResponse> getWriter() {
        return new JAXBVersatileWriter<QueryResponse>(this.getAsQueryResponse(), (IJAXBWriter<QueryResponse>)RegRep4Writer.queryResponse(CCCEV.XSDS).setFormattedOutput(true));
    }

    @Nonnull
    public static IJAXBVersatileReader<EDMResponse> reader() {
        return new JAXBVersatileReader<QueryResponse, EDMResponse>(RegRep4Reader.queryResponse(CCCEV.XSDS), EDMResponse::create);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EDMResponse eDMResponse = (EDMResponse)object;
        return EqualsHelper.equals(this.m_eResponseOption, eDMResponse.m_eResponseOption) && EqualsHelper.equals(this.m_eResponseStatus, eDMResponse.m_eResponseStatus) && EqualsHelper.equals(this.m_sRequestID, eDMResponse.m_sRequestID) && EqualsHelper.equals(this.m_sSpecificationIdentifier, eDMResponse.m_sSpecificationIdentifier) && EqualsHelper.equals(this.m_aIssueDateTime, eDMResponse.m_aIssueDateTime) && EqualsHelper.equals(this.m_aDataProvider, eDMResponse.m_aDataProvider) && EqualsHelper.equals(this.m_aPayloadProviders, eDMResponse.m_aPayloadProviders);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eResponseOption)).append((Enum)this.m_eResponseStatus)).append(this.m_sRequestID).append(this.m_sSpecificationIdentifier).append(this.m_aIssueDateTime).append(this.m_aDataProvider).append(this.m_aPayloadProviders)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ResponseOption", this.m_eResponseOption).append("RequestID", this.m_sRequestID).append("ResponseStatus", this.m_eResponseStatus).append("SpecificationIdentifier", this.m_sSpecificationIdentifier).append("IssueDateTime", this.m_aIssueDateTime).append("DataProvider", this.m_aDataProvider).append("ResponseObjects", this.m_aPayloadProviders).getToString();
    }

    @Nonnull
    public static BuilderConcept builderConcept() {
        return ((BuilderConcept)new BuilderConcept().specificationIdentifier("toop-edm:v2.0")).randomRegistryObjectID();
    }

    @Nonnull
    public static BuilderDocument builderDocument() {
        return (BuilderDocument)new BuilderDocument().specificationIdentifier("toop-edm:v2.0");
    }

    @Nonnull
    public static BuilderDocumentReference builderDocumentReference() {
        return (BuilderDocumentReference)new BuilderDocumentReference().specificationIdentifier("toop-edm:v2.0");
    }

    private static void _applySlots(@Nonnull SlotType slotType, @Nonnull AbstractBuilder<?> abstractBuilder) {
        String string = slotType.getName();
        ValueType valueType = slotType.getSlotValue();
        switch (string) {
            case "SpecificationIdentifier": {
                if (!(valueType instanceof StringValueType)) break;
                String string2 = ((StringValueType)valueType).getValue();
                abstractBuilder.specificationIdentifier(string2);
                break;
            }
            case "IssueDateTime": {
                if (!(valueType instanceof DateTimeValueType)) break;
                LocalDateTime localDateTime = ((DateTimeValueType)valueType).getValue();
                abstractBuilder.issueDateTime(localDateTime);
                break;
            }
            case "DataProvider": {
                if (!(valueType instanceof AnyValueType)) break;
                Node node = (Node)((AnyValueType)valueType).getAny();
                abstractBuilder.dataProvider(AgentPojo.builder((AgentType)new AgentMarshaller().read(node)));
                break;
            }
            default: {
                throw new IllegalStateException("Found unsupported slot '" + string + "'");
            }
        }
    }

    private static void _applyConceptSlots(@Nonnull SlotType slotType, @Nonnull BuilderConcept builderConcept) {
        String string = slotType.getName();
        ValueType valueType = slotType.getSlotValue();
        switch (string) {
            case "ConceptValues": {
                if (!(valueType instanceof CollectionValueType)) break;
                List<ValueType> list = ((CollectionValueType)valueType).getElement();
                for (ValueType valueType2 : list) {
                    Object object;
                    if (!(valueType2 instanceof AnyValueType) || !((object = ((AnyValueType)valueType2).getAny()) instanceof Node)) continue;
                    builderConcept.addConcept((CCCEVConceptType)new ConceptMarshaller().read((Node)object));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Found unsupported slot '" + string + "'");
            }
        }
    }

    @Nonnull
    public static EDMResponse create(@Nonnull QueryResponse queryResponse) {
        ValueEnforcer.notNull(queryResponse, "QueryResponse");
        ERegRepResponseStatus eRegRepResponseStatus = ERegRepResponseStatus.getFromIDOrNull(queryResponse.getStatus());
        if (eRegRepResponseStatus == null) {
            throw new IllegalStateException("Unsupported query response status '" + queryResponse.getStatus() + "' present.");
        }
        String string = queryResponse.getRequestId();
        ObjectRefListType objectRefListType = queryResponse.getObjectRefList();
        if (objectRefListType != null && objectRefListType.hasObjectRefEntries()) {
            BuilderDocumentReference builderDocumentReference = (BuilderDocumentReference)((BuilderDocumentReference)EDMResponse.builderDocumentReference().responseStatus(eRegRepResponseStatus)).requestID(string);
            for (SlotType extensibleObjectType : queryResponse.getSlot()) {
                EDMResponse._applySlots(extensibleObjectType, builderDocumentReference);
            }
            for (ObjectRefType objectRefType : objectRefListType.getObjectRef()) {
                builderDocumentReference.addResponseObject(objectRefType);
            }
            return builderDocumentReference.build();
        }
        RegistryObjectListType registryObjectListType = queryResponse.getRegistryObjectList();
        if (registryObjectListType != null && registryObjectListType.hasRegistryObjectEntries()) {
            if (registryObjectListType.getRegistryObject().size() == 1 && registryObjectListType.getRegistryObjectAtIndex(0).getSlotCount() == 1 && "ConceptValues".equals(registryObjectListType.getRegistryObjectAtIndex(0).getSlotAtIndex(0).getName())) {
                RegistryObjectType registryObjectType = registryObjectListType.getRegistryObject().get(0);
                BuilderConcept builderConcept = ((BuilderConcept)((BuilderConcept)EDMResponse.builderConcept().responseStatus(eRegRepResponseStatus)).requestID(string)).registryObjectID(registryObjectType.getId());
                for (SlotType slotType : queryResponse.getSlot()) {
                    EDMResponse._applySlots(slotType, builderConcept);
                }
                for (SlotType slotType : registryObjectType.getSlot()) {
                    EDMResponse._applyConceptSlots(slotType, builderConcept);
                }
                return builderConcept.build();
            }
            BuilderDocument builderDocument = (BuilderDocument)((BuilderDocument)EDMResponse.builderDocument().responseStatus(eRegRepResponseStatus)).requestID(string);
            for (SlotType slotType : queryResponse.getSlot()) {
                EDMResponse._applySlots(slotType, builderDocument);
            }
            for (RegistryObjectType registryObjectType : registryObjectListType.getRegistryObject()) {
                if (!(registryObjectType instanceof ExtrinsicObjectType)) continue;
                builderDocument.addResponseObject((ExtrinsicObjectType)registryObjectType);
            }
            return builderDocument.build();
        }
        throw new IllegalStateException("Found neither inline nor reference content in the response. Is it eventually an Error Response?");
    }

    public static class BuilderDocumentReference
    extends AbstractBuilder<BuilderDocumentReference> {
        private final ICommonsList<ResponseDocumentReferencePojo> m_aResponseObjects = new CommonsArrayList<ResponseDocumentReferencePojo>();

        protected BuilderDocumentReference() {
            super(EToopResponseOptionType.REFERENCE);
        }

        @Nonnull
        public BuilderDocumentReference addResponseObject(@Nullable Consumer<? super ResponseDocumentReferencePojo.Builder> consumer) {
            if (consumer != null) {
                ResponseDocumentReferencePojo.Builder builder = ResponseDocumentReferencePojo.builder();
                consumer.accept(builder);
                this.addResponseObject(builder);
            }
            return this;
        }

        @Nonnull
        public BuilderDocumentReference addResponseObject(@Nullable ObjectRefType objectRefType) {
            return this.addResponseObject(objectRefType == null ? null : ResponseDocumentReferencePojo.builder(objectRefType));
        }

        @Nonnull
        public BuilderDocumentReference addResponseObject(@Nullable ResponseDocumentReferencePojo.Builder builder) {
            return this.addResponseObject(builder == null ? null : builder.build());
        }

        @Nonnull
        public BuilderDocumentReference addResponseObject(@Nullable ResponseDocumentReferencePojo responseDocumentReferencePojo) {
            if (responseDocumentReferencePojo != null) {
                this.m_aResponseObjects.add(responseDocumentReferencePojo);
            }
            return this;
        }

        @Nonnull
        public BuilderDocumentReference responseObject(@Nullable Consumer<? super ResponseDocumentReferencePojo.Builder> consumer) {
            if (consumer != null) {
                ResponseDocumentReferencePojo.Builder builder = ResponseDocumentReferencePojo.builder();
                consumer.accept(builder);
                this.responseObject(builder);
            }
            return this;
        }

        @Nonnull
        public BuilderDocumentReference responseObject(@Nullable ObjectRefType objectRefType) {
            return this.responseObject(objectRefType == null ? null : ResponseDocumentReferencePojo.builder(objectRefType));
        }

        @Nonnull
        public BuilderDocumentReference responseObject(@Nullable ResponseDocumentReferencePojo.Builder builder) {
            return this.responseObject(builder == null ? null : builder.build());
        }

        @Nonnull
        public BuilderDocumentReference responseObject(@Nullable ResponseDocumentReferencePojo responseDocumentReferencePojo) {
            if (responseDocumentReferencePojo != null) {
                this.m_aResponseObjects.set(responseDocumentReferencePojo);
            } else {
                this.m_aResponseObjects.clear();
            }
            return this;
        }

        @Nonnull
        public BuilderDocumentReference responseObjects(ResponseDocumentReferencePojo ... responseDocumentReferencePojoArray) {
            this.m_aResponseObjects.setAll((ResponseDocumentReferencePojo[])responseDocumentReferencePojoArray);
            return this;
        }

        @Nonnull
        public BuilderDocumentReference responseObjects(@Nullable Iterable<? extends ResponseDocumentReferencePojo> iterable) {
            this.m_aResponseObjects.setAll(iterable);
            return this;
        }

        @Nonnull
        public <T> BuilderDocumentReference responseObjects(@Nullable Iterable<? extends T> iterable, @Nonnull Function<? super T, ResponseDocumentReferencePojo> function) {
            this.m_aResponseObjects.setAllMapped(iterable, function);
            return this;
        }

        @Override
        public void checkConsistency() {
            super.checkConsistency();
            if (this.m_aResponseObjects.isEmpty()) {
                throw new IllegalStateException("Response Object MUST be present");
            }
        }

        @Override
        @Nonnull
        public EDMResponse build() {
            this.checkConsistency();
            return new EDMResponse(this.m_eResponseOption, this.m_eResponseStatus, this.m_sRequestID, this.m_sSpecificationIdentifier, this.m_aIssueDateTime, this.m_aDataProvider, this.m_aResponseObjects);
        }
    }

    public static class BuilderDocument
    extends AbstractBuilder<BuilderDocument> {
        private final ICommonsList<ResponseDocumentPojo> m_aResponseObjects = new CommonsArrayList<ResponseDocumentPojo>();

        protected BuilderDocument() {
            super(EToopResponseOptionType.INLINE);
        }

        @Nonnull
        public BuilderDocument addResponseObject(@Nullable Consumer<? super ResponseDocumentPojo.Builder> consumer) {
            if (consumer != null) {
                ResponseDocumentPojo.Builder builder = ResponseDocumentPojo.builder().randomRegistryObjectID();
                consumer.accept(builder);
                this.addResponseObject(builder);
            }
            return this;
        }

        @Nonnull
        public BuilderDocument addResponseObject(@Nullable ExtrinsicObjectType extrinsicObjectType) {
            return this.addResponseObject(extrinsicObjectType == null ? null : ResponseDocumentPojo.builder(extrinsicObjectType));
        }

        @Nonnull
        public BuilderDocument addResponseObject(@Nullable ResponseDocumentPojo.Builder builder) {
            return this.addResponseObject(builder == null ? null : builder.build());
        }

        @Nonnull
        public BuilderDocument addResponseObject(@Nullable ResponseDocumentPojo responseDocumentPojo) {
            if (responseDocumentPojo != null) {
                this.m_aResponseObjects.add(responseDocumentPojo);
            }
            return this;
        }

        @Nonnull
        public BuilderDocument responseObject(@Nullable Consumer<? super ResponseDocumentPojo.Builder> consumer) {
            if (consumer != null) {
                ResponseDocumentPojo.Builder builder = ResponseDocumentPojo.builder().randomRegistryObjectID();
                consumer.accept(builder);
                this.responseObject(builder);
            }
            return this;
        }

        @Nonnull
        public BuilderDocument responseObject(@Nullable ExtrinsicObjectType extrinsicObjectType) {
            return this.responseObject(extrinsicObjectType == null ? null : ResponseDocumentPojo.builder(extrinsicObjectType));
        }

        @Nonnull
        public BuilderDocument responseObject(@Nullable ResponseDocumentPojo.Builder builder) {
            return this.responseObject(builder == null ? null : builder.build());
        }

        @Nonnull
        public BuilderDocument responseObject(@Nullable ResponseDocumentPojo responseDocumentPojo) {
            if (responseDocumentPojo != null) {
                this.m_aResponseObjects.set(responseDocumentPojo);
            } else {
                this.m_aResponseObjects.clear();
            }
            return this;
        }

        @Nonnull
        public BuilderDocument responseObjects(ResponseDocumentPojo ... responseDocumentPojoArray) {
            this.m_aResponseObjects.setAll((ResponseDocumentPojo[])responseDocumentPojoArray);
            return this;
        }

        @Nonnull
        public BuilderDocument responseObjects(@Nullable Iterable<? extends ResponseDocumentPojo> iterable) {
            this.m_aResponseObjects.setAll(iterable);
            return this;
        }

        @Nonnull
        public <T> BuilderDocument responseObjects(@Nullable Iterable<? extends T> iterable, @Nonnull Function<? super T, ResponseDocumentPojo> function) {
            this.m_aResponseObjects.setAllMapped(iterable, function);
            return this;
        }

        @Override
        public void checkConsistency() {
            super.checkConsistency();
            if (this.m_aResponseObjects.isEmpty()) {
                throw new IllegalStateException("Response Object MUST be present");
            }
        }

        @Override
        @Nonnull
        public EDMResponse build() {
            this.checkConsistency();
            return new EDMResponse(this.m_eResponseOption, this.m_eResponseStatus, this.m_sRequestID, this.m_sSpecificationIdentifier, this.m_aIssueDateTime, this.m_aDataProvider, this.m_aResponseObjects);
        }
    }

    public static class BuilderConcept
    extends AbstractBuilder<BuilderConcept> {
        private String m_sRegistryObjectID;
        private final ICommonsList<ConceptPojo> m_aConcepts = new CommonsArrayList<ConceptPojo>();

        protected BuilderConcept() {
            super(EToopResponseOptionType.INLINE);
        }

        @Nonnull
        public BuilderConcept registryObjectID(@Nullable String string) {
            this.m_sRegistryObjectID = string;
            return this;
        }

        @Nonnull
        public BuilderConcept randomRegistryObjectID() {
            return this.registryObjectID(UUID.randomUUID().toString());
        }

        @Nonnull
        public BuilderConcept addConcept(@Nullable Consumer<? super ConceptPojo.Builder> consumer) {
            if (consumer != null) {
                ConceptPojo.Builder builder = ConceptPojo.builder();
                consumer.accept(builder);
                this.addConcept(builder.build());
            }
            return this;
        }

        @Nonnull
        public BuilderConcept addConcept(@Nullable CCCEVConceptType cCCEVConceptType) {
            return this.addConcept(cCCEVConceptType == null ? null : ConceptPojo.builder(cCCEVConceptType));
        }

        @Nonnull
        public BuilderConcept addConcept(@Nullable ConceptPojo.Builder builder) {
            return this.addConcept(builder == null ? null : builder.build());
        }

        @Nonnull
        public BuilderConcept addConcept(@Nullable ConceptPojo conceptPojo) {
            if (conceptPojo != null) {
                this.m_aConcepts.add(conceptPojo);
            }
            return this;
        }

        @Nonnull
        public BuilderConcept concept(@Nullable Consumer<? super ConceptPojo.Builder> consumer) {
            if (consumer != null) {
                ConceptPojo.Builder builder = ConceptPojo.builder();
                consumer.accept(builder);
                this.concept(builder.build());
            }
            return this;
        }

        @Nonnull
        public BuilderConcept concept(@Nullable CCCEVConceptType cCCEVConceptType) {
            return this.concept(cCCEVConceptType == null ? null : ConceptPojo.builder(cCCEVConceptType));
        }

        @Nonnull
        public BuilderConcept concept(@Nullable ConceptPojo.Builder builder) {
            return this.concept(builder == null ? null : builder.build());
        }

        @Nonnull
        public BuilderConcept concept(@Nullable ConceptPojo conceptPojo) {
            if (conceptPojo != null) {
                this.m_aConcepts.set(conceptPojo);
            } else {
                this.m_aConcepts.clear();
            }
            return this;
        }

        @Nonnull
        public BuilderConcept concepts(ConceptPojo ... conceptPojoArray) {
            this.m_aConcepts.setAll((ConceptPojo[])conceptPojoArray);
            return this;
        }

        @Nonnull
        public BuilderConcept concepts(@Nullable Iterable<? extends ConceptPojo> iterable) {
            this.m_aConcepts.setAll(iterable);
            return this;
        }

        @Nonnull
        public <T> BuilderConcept concepts(@Nullable Iterable<? extends T> iterable, @Nonnull Function<? super T, ConceptPojo> function) {
            this.m_aConcepts.setAllMapped(iterable, function);
            return (BuilderConcept)this.thisAsT();
        }

        @Override
        public void checkConsistency() {
            super.checkConsistency();
            if (StringHelper.hasNoText(this.m_sRegistryObjectID)) {
                throw new IllegalStateException("RegistryObjectID MUST be present");
            }
            if (this.m_aConcepts.isEmpty()) {
                throw new IllegalStateException("At least one Concept MUST be contained");
            }
        }

        @Override
        @Nonnull
        public EDMResponse build() {
            this.checkConsistency();
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            commonsArrayList.add(new EDMResponsePayloadConcepts(this.m_sRegistryObjectID, this.m_aConcepts));
            return new EDMResponse(this.m_eResponseOption, this.m_eResponseStatus, this.m_sRequestID, this.m_sSpecificationIdentifier, this.m_aIssueDateTime, this.m_aDataProvider, commonsArrayList);
        }
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
    implements IGenericImplTrait<T> {
        protected EToopResponseOptionType m_eResponseOption;
        protected ERegRepResponseStatus m_eResponseStatus;
        protected String m_sRequestID;
        protected String m_sSpecificationIdentifier;
        protected LocalDateTime m_aIssueDateTime;
        protected AgentPojo m_aDataProvider;

        protected AbstractBuilder(@Nonnull EToopResponseOptionType eToopResponseOptionType) {
            ValueEnforcer.notNull(eToopResponseOptionType, "ResponseOption");
            this.m_eResponseOption = eToopResponseOptionType;
        }

        @Nonnull
        public final T responseStatus(@Nullable ERegRepResponseStatus eRegRepResponseStatus) {
            this.m_eResponseStatus = eRegRepResponseStatus;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T requestID(@Nullable UUID uUID) {
            return this.requestID(uUID == null ? null : uUID.toString());
        }

        @Nonnull
        public final T requestID(@Nullable String string) {
            this.m_sRequestID = string;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T specificationIdentifier(@Nullable String string) {
            this.m_sSpecificationIdentifier = string;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T issueDateTimeNow() {
            return this.issueDateTime(PDTFactory.getCurrentLocalDateTime());
        }

        @Nonnull
        public final T issueDateTime(@Nullable LocalDateTime localDateTime) {
            this.m_aIssueDateTime = localDateTime == null ? null : localDateTime.truncatedTo(ChronoUnit.MILLIS);
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T dataProvider(@Nullable Consumer<? super AgentPojo.Builder> consumer) {
            if (consumer != null) {
                AgentPojo.Builder builder = AgentPojo.builder();
                consumer.accept(builder);
                this.dataProvider(builder.build());
            }
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T dataProvider(@Nullable AgentPojo.Builder builder) {
            return this.dataProvider(builder == null ? null : builder.build());
        }

        @Nonnull
        public final T dataProvider(@Nullable AgentPojo agentPojo) {
            this.m_aDataProvider = agentPojo;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T dataProvider(@Nullable AgentType agentType) {
            return this.dataProvider(agentType == null ? null : AgentPojo.builder(agentType));
        }

        @OverridingMethodsMustInvokeSuper
        public void checkConsistency() {
            if (this.m_eResponseOption == null) {
                throw new IllegalStateException("Response Layout MUST must be present");
            }
            if (this.m_eResponseStatus == null) {
                throw new IllegalStateException("Response Status MUST be present");
            }
            if (this.m_eResponseStatus != ERegRepResponseStatus.SUCCESS && this.m_eResponseStatus != ERegRepResponseStatus.FAILURE) {
                throw new IllegalStateException("Response Status MUST be SUCCESS or FAILURE");
            }
            if (StringHelper.hasNoText(this.m_sRequestID)) {
                throw new IllegalStateException("Request ID MUST be present");
            }
            if (StringHelper.hasNoText(this.m_sSpecificationIdentifier)) {
                throw new IllegalStateException("SpecificationIdentifier MUST be present");
            }
            if (this.m_aIssueDateTime == null) {
                throw new IllegalStateException("Issue Date Time MUST be present");
            }
            if (this.m_aDataProvider == null) {
                throw new IllegalStateException("Data Provider MUST be present");
            }
        }

        @Nonnull
        public abstract EDMResponse build();
    }
}

