/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.api;

import com.helger.bdve.api.executorset.VESID;
import com.helger.bdve.api.result.ValidationResultList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.collection.impl.ICommonsSortedMap;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.xsds.bdxr.smp1.EndpointType;
import com.helger.xsds.bdxr.smp1.ServiceMetadataType;
import eu.toop.connector.api.dsd.DSDDatasetResponse;
import eu.toop.connector.api.error.ITCErrorHandler;
import eu.toop.connector.api.error.LoggingTCErrorHandler;
import eu.toop.connector.api.me.IMessageExchangeSPI;
import eu.toop.connector.api.me.MessageExchangeManager;
import eu.toop.connector.api.me.model.MEMessage;
import eu.toop.connector.api.me.outgoing.IMERoutingInformation;
import eu.toop.connector.api.me.outgoing.MEOutgoingException;
import eu.toop.connector.app.api.TCAPIConfig;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TCAPIHelper {
    public static final Locale DEFAULT_LOCALE = Locale.US;

    private TCAPIHelper() {
    }

    public static ICommonsSet<DSDDatasetResponse> getDSDDatasets(@Nonnull String string, @Nullable String string2, @Nonnull ITCErrorHandler iTCErrorHandler) {
        return TCAPIConfig.getDSDDatasetResponseProvider().getAllDatasetResponses("[dsd-by-country]", string, string2, iTCErrorHandler);
    }

    @Nonnull
    public static ICommonsSortedMap<String, String> querySMPServiceGroups(IParticipantIdentifier iParticipantIdentifier) {
        return TCAPIConfig.getDDServiceGroupHrefProvider().getAllServiceGroupHrefs(iParticipantIdentifier, LoggingTCErrorHandler.INSTANCE);
    }

    @Nullable
    public static ServiceMetadataType querySMPServiceMetadata(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        return TCAPIConfig.getDDServiceMetadataProvider().getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier);
    }

    @Nullable
    public static EndpointType querySMPEndpoint(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull String string) {
        return TCAPIConfig.getDDServiceMetadataProvider().getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, string);
    }

    @Nonnull
    public static ValidationResultList validateBusinessDocument(@Nonnull VESID vESID, @Nonnull byte[] byArray) {
        return TCAPIConfig.getVSValidator().validate(vESID, byArray, DEFAULT_LOCALE);
    }

    public static void sendAS4Message(@Nonnull IMERoutingInformation iMERoutingInformation, @Nonnull MEMessage mEMessage) throws MEOutgoingException {
        IMessageExchangeSPI iMessageExchangeSPI = MessageExchangeManager.getConfiguredImplementation();
        iMessageExchangeSPI.sendOutgoing(iMERoutingInformation, mEMessage);
    }
}

