/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.api;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import eu.toop.connector.api.dd.IDDServiceGroupHrefProvider;
import eu.toop.connector.api.dd.IDDServiceMetadataProvider;
import eu.toop.connector.api.dsd.IDSDDatasetResponseProvider;
import eu.toop.connector.api.validation.IVSValidator;
import eu.toop.connector.app.dsd.DSDDatasetResponseProviderRemote;
import eu.toop.connector.app.smp.DDServiceGroupHrefProviderSMP;
import eu.toop.connector.app.smp.DDServiceMetadataProviderSMP;
import eu.toop.connector.app.validation.TCValidator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;

public final class TCAPIConfig {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static IDSDDatasetResponseProvider s_aDSDPartyIDProvider = new DSDDatasetResponseProviderRemote();
    @GuardedBy(value="s_aRWLock")
    private static IDDServiceGroupHrefProvider s_aDDSGHrefProvider = new DDServiceGroupHrefProviderSMP();
    @GuardedBy(value="s_aRWLock")
    private static IDDServiceMetadataProvider s_aDDSMProvider = new DDServiceMetadataProviderSMP();
    @GuardedBy(value="s_aRWLock")
    private static IVSValidator s_aValidator = new TCValidator();

    private TCAPIConfig() {
    }

    @Nonnull
    public static IDSDDatasetResponseProvider getDSDDatasetResponseProvider() {
        return s_aRWLock.readLockedGet(() -> s_aDSDPartyIDProvider);
    }

    public static void setDSDDatasetResponseProvider(@Nonnull IDSDDatasetResponseProvider iDSDDatasetResponseProvider) {
        ValueEnforcer.notNull(iDSDDatasetResponseProvider, "IDSDDatasetResponseProvider");
        s_aRWLock.writeLockedGet(() -> {
            s_aDSDPartyIDProvider = iDSDDatasetResponseProvider;
            return s_aDSDPartyIDProvider;
        });
    }

    @Nonnull
    public static IDDServiceGroupHrefProvider getDDServiceGroupHrefProvider() {
        return s_aRWLock.readLockedGet(() -> s_aDDSGHrefProvider);
    }

    public static void setDDServiceGroupHrefProvider(@Nonnull IDDServiceGroupHrefProvider iDDServiceGroupHrefProvider) {
        ValueEnforcer.notNull(iDDServiceGroupHrefProvider, "IDDServiceGroupHrefProvider");
        s_aRWLock.writeLockedGet(() -> {
            s_aDDSGHrefProvider = iDDServiceGroupHrefProvider;
            return s_aDDSGHrefProvider;
        });
    }

    @Nonnull
    public static IDDServiceMetadataProvider getDDServiceMetadataProvider() {
        return s_aRWLock.readLockedGet(() -> s_aDDSMProvider);
    }

    public static void setDDServiceMetadataProvider(@Nonnull IDDServiceMetadataProvider iDDServiceMetadataProvider) {
        ValueEnforcer.notNull(iDDServiceMetadataProvider, "IDDServiceMetadataProvider");
        s_aRWLock.writeLockedGet(() -> {
            s_aDDSMProvider = iDDServiceMetadataProvider;
            return s_aDDSMProvider;
        });
    }

    @Nonnull
    public static IVSValidator getVSValidator() {
        return s_aRWLock.readLockedGet(() -> s_aValidator);
    }

    public static void setVSValidator(@Nonnull IVSValidator iVSValidator) {
        ValueEnforcer.notNull(iVSValidator, "IVSValidator");
        s_aRWLock.writeLockedGet(() -> {
            s_aValidator = iVSValidator;
            return s_aValidator;
        });
    }
}

