/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app;

import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.id.factory.StringIDFromGlobalPersistentLongIDFactory;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.URLProtocolRegistry;
import com.helger.xservlet.requesttrack.RequestTracker;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.me.MessageExchangeManager;
import eu.toop.connector.api.me.incoming.IMEIncomingHandler;
import eu.toop.connector.app.CTC;
import eu.toop.connector.app.TCIncomingHandlerViaHttp;
import eu.toop.kafkaclient.ToopKafkaClient;
import eu.toop.kafkaclient.ToopKafkaSettings;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.ServletContext;

@NotThreadSafe
public class TCInit {
    private static final AtomicBoolean INITED = new AtomicBoolean(false);
    private static String s_sLogPrefix;

    private TCInit() {
    }

    @Deprecated
    public static void initGlobally(@Nonnull ServletContext servletContext) {
        TCInit.initGlobally(servletContext, null);
    }

    public static void initGlobally(@Nonnull ServletContext servletContext, @Nullable IMEIncomingHandler iMEIncomingHandler) {
        Serializable serializable;
        Object object;
        if (!INITED.compareAndSet(false, true)) {
            throw new IllegalStateException("TOOP Connector NG is already initialized");
        }
        GlobalIDFactory.setPersistentStringIDFactory(new StringIDFromGlobalPersistentLongIDFactory("toop-tc-"));
        GlobalDebug.setDebugModeDirect(TCConfig.Global.isGlobalDebug());
        GlobalDebug.setProductionModeDirect(TCConfig.Global.isGlobalProduction());
        String string = TCConfig.Global.getToopInstanceName();
        if (StringHelper.hasNoText(string)) {
            try {
                string = "[" + InetAddress.getLocalHost().getHostAddress() + "] ";
            }
            catch (UnknownHostException unknownHostException) {
                string = "";
            }
        } else {
            if (!string.startsWith("[")) {
                string = "[" + string + "]";
            }
            string = string + " ";
        }
        s_sLogPrefix = string;
        RequestTracker.getInstance().getRequestTrackingMgr().setLongRunningCheckEnabled(false);
        RequestTracker.getInstance().getRequestTrackingMgr().setParallelRunningRequestCheckEnabled(false);
        ToopKafkaSettings.setKafkaEnabled(TCConfig.Tracker.isToopTrackerEnabled());
        if (TCConfig.Tracker.isToopTrackerEnabled()) {
            object = TCConfig.Tracker.getToopTrackerUrl();
            if (StringHelper.hasNoText((String)object)) {
                throw new InitializationException("If the tracker is enabled, the tracker URL MUST be provided in the configuration file!");
            }
            serializable = URLProtocolRegistry.getInstance().getProtocol((String)object);
            if (serializable != null) {
                throw new InitializationException("The tracker URL MUST NOT start with a protocol like '" + serializable.getProtocol() + "'!");
            }
            ToopKafkaSettings.defaultProperties().put("bootstrap.servers", object);
            String string2 = TCConfig.Tracker.getToopTrackerTopic();
            ToopKafkaSettings.setKafkaTopic(string2);
        }
        if (StringHelper.hasNoText((String)(object = TCConfig.DSD.getDSDBaseUrl()))) {
            throw new InitializationException("The URL of the DSD Service is missing in the configuration file!");
        }
        if (!TCConfig.R2D2.isR2D2UseDNS() && (serializable = TCConfig.R2D2.getR2D2SMPUrl()) == null) {
            throw new InitializationException("Since the usage of SML/DNS is disabled, the fixed URL of the SMP to be used must be provided in the configuration file!");
        }
        object = iMEIncomingHandler != null ? iMEIncomingHandler : new TCIncomingHandlerViaHttp(s_sLogPrefix);
        MessageExchangeManager.getConfiguredImplementation().registerIncomingHandler(servletContext, (IMEIncomingHandler)object);
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> s_sLogPrefix + "TOOP Connector NG WebApp " + CTC.getVersionNumber() + " started");
    }

    public static boolean isInitialized() {
        return INITED.get();
    }

    public static void shutdownGlobally(@Nonnull ServletContext servletContext) {
        if (!TCInit.isInitialized()) {
            throw new IllegalStateException("TOOP Connector NG is not initialized");
        }
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> s_sLogPrefix + "TOOP Connector NG shutting down");
        MessageExchangeManager.getConfiguredImplementation().shutdown(servletContext);
        ToopKafkaClient.close();
        s_sLogPrefix = null;
        if (!INITED.compareAndSet(true, false)) {
            throw new IllegalStateException("TOOP Connector NG is already shutdown");
        }
    }
}

