/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import eu.toop.connector.api.me.incoming.IMEIncomingHandler;
import eu.toop.connector.api.me.incoming.IncomingEDMErrorResponse;
import eu.toop.connector.api.me.incoming.IncomingEDMRequest;
import eu.toop.connector.api.me.incoming.IncomingEDMResponse;
import eu.toop.connector.api.me.incoming.MEIncomingException;
import eu.toop.connector.app.incoming.DC_DP_TriggerViaHttp;
import eu.toop.kafkaclient.ToopKafkaClient;
import javax.annotation.Nonnull;

public class TCIncomingHandlerViaHttp
implements IMEIncomingHandler {
    private final String m_sLogPrefix;

    public TCIncomingHandlerViaHttp(@Nonnull String string) {
        this.m_sLogPrefix = ValueEnforcer.notNull(string, "LogPrefix");
    }

    @Override
    public void handleIncomingRequest(@Nonnull IncomingEDMRequest incomingEDMRequest) throws MEIncomingException {
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> this.m_sLogPrefix + "TC got DP incoming MEM request (2/4)");
        DC_DP_TriggerViaHttp.forwardMessage(incomingEDMRequest);
    }

    @Override
    public void handleIncomingResponse(@Nonnull IncomingEDMResponse incomingEDMResponse) throws MEIncomingException {
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> this.m_sLogPrefix + "TC got DC incoming MEM response (4/4) with " + incomingEDMResponse.attachments().size() + " attachments");
        DC_DP_TriggerViaHttp.forwardMessage(incomingEDMResponse);
    }

    @Override
    public void handleIncomingErrorResponse(@Nonnull IncomingEDMErrorResponse incomingEDMErrorResponse) throws MEIncomingException {
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> this.m_sLogPrefix + "TC got DC incoming MEM response (4/4) with ERRORs");
        DC_DP_TriggerViaHttp.forwardMessage(incomingEDMErrorResponse);
    }
}

