/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.api.me.incoming;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.me.incoming.IMEIncomingTransportMetadata;
import eu.toop.connector.api.rest.TCIncomingMetadata;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MEIncomingTransportMetadata
implements IMEIncomingTransportMetadata {
    private final IParticipantIdentifier m_aSenderID;
    private final IParticipantIdentifier m_aReceiverID;
    private final IDocumentTypeIdentifier m_aDocTypeID;
    private final IProcessIdentifier m_aProcessID;

    public MEIncomingTransportMetadata(@Nullable IParticipantIdentifier iParticipantIdentifier, @Nullable IParticipantIdentifier iParticipantIdentifier2, @Nullable IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nullable IProcessIdentifier iProcessIdentifier) {
        this.m_aSenderID = iParticipantIdentifier;
        this.m_aReceiverID = iParticipantIdentifier2;
        this.m_aDocTypeID = iDocumentTypeIdentifier;
        this.m_aProcessID = iProcessIdentifier;
    }

    @Override
    @Nullable
    public IParticipantIdentifier getSenderID() {
        return this.m_aSenderID;
    }

    @Override
    @Nullable
    public IParticipantIdentifier getReceiverID() {
        return this.m_aReceiverID;
    }

    @Override
    @Nullable
    public IDocumentTypeIdentifier getDocumentTypeID() {
        return this.m_aDocTypeID;
    }

    @Override
    @Nullable
    public IProcessIdentifier getProcessID() {
        return this.m_aProcessID;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MEIncomingTransportMetadata mEIncomingTransportMetadata = (MEIncomingTransportMetadata)object;
        return EqualsHelper.equalsCustom(this.m_aSenderID, mEIncomingTransportMetadata.m_aSenderID, IParticipantIdentifier::hasSameContent) && EqualsHelper.equalsCustom(this.m_aReceiverID, mEIncomingTransportMetadata.m_aReceiverID, IParticipantIdentifier::hasSameContent) && EqualsHelper.equalsCustom(this.m_aDocTypeID, mEIncomingTransportMetadata.m_aDocTypeID, IDocumentTypeIdentifier::hasSameContent) && EqualsHelper.equalsCustom(this.m_aProcessID, mEIncomingTransportMetadata.m_aProcessID, IProcessIdentifier::hasSameContent);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aSenderID).append(this.m_aReceiverID).append(this.m_aDocTypeID).append(this.m_aProcessID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("SenderID", this.m_aSenderID).append("ReceiverID", this.m_aReceiverID).append("DocumentTypeID", this.m_aDocTypeID).append("ProcessID", this.m_aProcessID).getToString();
    }

    @Nonnull
    public static MEIncomingTransportMetadata create(@Nonnull TCIncomingMetadata tCIncomingMetadata) {
        IIdentifierFactory iIdentifierFactory = TCConfig.getIdentifierFactory();
        IParticipantIdentifier iParticipantIdentifier = iIdentifierFactory.createParticipantIdentifier(tCIncomingMetadata.getSenderID().getScheme(), tCIncomingMetadata.getSenderID().getValue());
        IParticipantIdentifier iParticipantIdentifier2 = iIdentifierFactory.createParticipantIdentifier(tCIncomingMetadata.getReceiverID().getScheme(), tCIncomingMetadata.getReceiverID().getValue());
        IDocumentTypeIdentifier iDocumentTypeIdentifier = iIdentifierFactory.createDocumentTypeIdentifier(tCIncomingMetadata.getDocTypeID().getScheme(), tCIncomingMetadata.getDocTypeID().getValue());
        IProcessIdentifier iProcessIdentifier = iIdentifierFactory.createProcessIdentifier(tCIncomingMetadata.getProcessID().getScheme(), tCIncomingMetadata.getProcessID().getValue());
        return new MEIncomingTransportMetadata(iParticipantIdentifier, iParticipantIdentifier2, iDocumentTypeIdentifier, iProcessIdentifier);
    }
}

