/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.api.me.incoming;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.connector.api.me.incoming.IIncomingEDMResponse;
import eu.toop.connector.api.me.incoming.IMEIncomingTransportMetadata;
import eu.toop.connector.api.me.model.MEPayload;
import eu.toop.edm.EDMResponse;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class IncomingEDMResponse
implements IIncomingEDMResponse {
    private final EDMResponse m_aResponse;
    private final String m_sTopLevelContentID;
    private final ICommonsOrderedMap<String, MEPayload> m_aAttachments = new CommonsLinkedHashMap<String, MEPayload>();
    private final IMEIncomingTransportMetadata m_aMetadata;

    public IncomingEDMResponse(@Nonnull EDMResponse eDMResponse, @Nonnull @Nonempty String string, @Nullable List<MEPayload> list, @Nonnull IMEIncomingTransportMetadata iMEIncomingTransportMetadata) {
        ValueEnforcer.notNull(eDMResponse, "Response");
        ValueEnforcer.notEmpty(string, "TopLevelContentID");
        ValueEnforcer.notNull(iMEIncomingTransportMetadata, "Metadata");
        this.m_aResponse = eDMResponse;
        this.m_sTopLevelContentID = string;
        if (list != null) {
            for (MEPayload mEPayload : list) {
                this.m_aAttachments.put(mEPayload.getContentID(), mEPayload);
            }
        }
        this.m_aMetadata = iMEIncomingTransportMetadata;
    }

    @Nonnull
    public EDMResponse getResponse() {
        return this.m_aResponse;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getTopLevelContentID() {
        return this.m_sTopLevelContentID;
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsOrderedMap<String, MEPayload> attachments() {
        return this.m_aAttachments;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, MEPayload> getAllAttachments() {
        return this.m_aAttachments.getClone();
    }

    @Override
    @Nonnull
    public IMEIncomingTransportMetadata getMetadata() {
        return this.m_aMetadata;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        IncomingEDMResponse incomingEDMResponse = (IncomingEDMResponse)object;
        return this.m_aResponse.equals(incomingEDMResponse.m_aResponse) && this.m_aAttachments.equals(incomingEDMResponse.m_aAttachments) && this.m_aMetadata.equals(incomingEDMResponse.m_aMetadata);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aResponse).append(this.m_aAttachments)).append(this.m_aMetadata).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("Response", this.m_aResponse).append("TopLevelContentID", this.m_sTopLevelContentID).append("Attachments", this.m_aAttachments).append("Metadata", this.m_aMetadata).getToString();
    }
}

