/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.api.me;

import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.lang.ServiceLoaderHelper;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.me.IMessageExchangeSPI;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class MessageExchangeManager {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static ICommonsMap<String, IMessageExchangeSPI> s_aMap = new CommonsLinkedHashMap<String, IMessageExchangeSPI>();

    public static void reinitialize() {
        s_aRWLock.writeLocked(() -> {
            s_aMap.clear();
            for (IMessageExchangeSPI iMessageExchangeSPI : ServiceLoaderHelper.getAllSPIImplementations(IMessageExchangeSPI.class)) {
                String string = iMessageExchangeSPI.getID();
                if (s_aMap.containsKey(string)) {
                    throw new InitializationException("The IMessageExchangeSPI ID '" + string + "' is already in use - please provide a different one!");
                }
                s_aMap.put(string, iMessageExchangeSPI);
            }
            if (s_aMap.isEmpty()) {
                throw new InitializationException("No IMessageExchangeSPI implementation is registered!");
            }
        });
    }

    private MessageExchangeManager() {
    }

    @Nullable
    public static IMessageExchangeSPI getImplementationOfID(@Nullable String string) {
        return s_aRWLock.readLockedGet(() -> (IMessageExchangeSPI)s_aMap.get(string));
    }

    @Nonnull
    public static IMessageExchangeSPI getConfiguredImplementation() {
        String string = TCConfig.MEM.getMEMImplementationID();
        IMessageExchangeSPI iMessageExchangeSPI = MessageExchangeManager.getImplementationOfID(string);
        if (iMessageExchangeSPI == null) {
            throw new IllegalStateException("Failed to resolve MEM implementation with ID '" + string + "'");
        }
        return iMessageExchangeSPI;
    }

    @Nonnegative
    public static ICommonsMap<String, IMessageExchangeSPI> getAll() {
        return s_aRWLock.readLockedGet(() -> (ICommonsMap)s_aMap.getClone());
    }

    static {
        MessageExchangeManager.reinitialize();
    }
}

