/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.privateutil;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

class MethodUtil {
    private static final Logger LOGGER;
    private static final Method INVOKE_METHOD;

    MethodUtil() {
    }

    static Object invoke(Object target, Method method, Object[] args2) throws IllegalAccessException, InvocationTargetException {
        if (INVOKE_METHOD != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Invoking method using sun.reflect.misc.MethodUtil");
            }
            try {
                return INVOKE_METHOD.invoke(null, method, target, args2);
            }
            catch (InvocationTargetException ite) {
                throw MethodUtil.unwrapException(ite);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Invoking method directly, probably non-Oracle JVM");
        }
        return method.invoke(target, args2);
    }

    private static InvocationTargetException unwrapException(InvocationTargetException ite) {
        Throwable targetException = ite.getTargetException();
        if (targetException != null && targetException instanceof InvocationTargetException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unwrapping invocation target exception");
            }
            return (InvocationTargetException)targetException;
        }
        return ite;
    }

    static {
        Method method;
        block3: {
            LOGGER = Logger.getLogger(MethodUtil.class.getName());
            try {
                Class<?> clazz = Class.forName("sun.reflect.misc.MethodUtil");
                method = clazz.getMethod("invoke", Method.class, Object.class, Object[].class);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Class sun.reflect.misc.MethodUtil found; it will be used to invoke methods.");
                }
            }
            catch (Throwable t) {
                method = null;
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, "Class sun.reflect.misc.MethodUtil not found, probably non-Oracle JVM");
            }
        }
        INVOKE_METHOD = method;
    }
}

