/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.handler;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.attr.IAttributeContainer;
import com.helger.commons.collection.attr.IAttributeContainerAny;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.string.ToStringGenerator;
import com.helger.http.EHttpVersion;
import com.helger.servlet.async.AsyncServletRunnerDefault;
import com.helger.servlet.async.ExtAsyncContext;
import com.helger.servlet.async.IAsyncServletRunner;
import com.helger.servlet.async.ServletAsyncSpec;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.mgr.WebScoped;
import com.helger.xservlet.handler.IXServletHandler;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XServletAsyncHandler
implements IXServletHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(XServletAsyncHandler.class);
    private static IAsyncServletRunner s_aAsyncServletRunner = new AsyncServletRunnerDefault();
    private final ServletAsyncSpec m_aAsyncSpec;
    private final IXServletHandler m_aNestedHandler;

    public static void setAsyncServletRunner(@Nonnull IAsyncServletRunner iAsyncServletRunner) {
        ValueEnforcer.notNull(iAsyncServletRunner, "AsyncServletRunner");
        s_aAsyncServletRunner = iAsyncServletRunner;
    }

    @Nonnull
    public static IAsyncServletRunner getAsyncServletRunner() {
        return s_aAsyncServletRunner;
    }

    public XServletAsyncHandler(@Nonnull ServletAsyncSpec servletAsyncSpec, @Nonnull IXServletHandler iXServletHandler) {
        this.m_aAsyncSpec = ValueEnforcer.notNull(servletAsyncSpec, "AsyncSpec");
        this.m_aNestedHandler = ValueEnforcer.notNull(iXServletHandler, "NestedHandler");
    }

    @Override
    public void onServletInit(@Nonnull ICommonsMap<String, String> iCommonsMap) throws ServletException {
        this.m_aNestedHandler.onServletInit(iCommonsMap);
    }

    @Override
    public void onServletDestroy() {
        this.m_aNestedHandler.onServletDestroy();
    }

    private void _handleAsync(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull IRequestWebScope iRequestWebScope) {
        ExtAsyncContext extAsyncContext = ExtAsyncContext.create(httpServletRequest, httpServletResponse, eHttpVersion, eHttpMethod, this.m_aAsyncSpec);
        IAttributeContainer iAttributeContainer = iRequestWebScope.attrs().getClone();
        IAttributeContainer iAttributeContainer2 = iRequestWebScope.params().getClone();
        s_aAsyncServletRunner.runAsync(httpServletRequest, httpServletResponse, extAsyncContext, () -> this.lambda$_handleAsync$0(httpServletRequest, httpServletResponse, (IAttributeContainerAny)iAttributeContainer, (IAttributeContainerAny)iAttributeContainer2, extAsyncContext));
    }

    @Override
    public void onRequest(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull IRequestWebScope iRequestWebScope) throws ServletException, IOException {
        if (this.m_aAsyncSpec.isAsynchronous() && httpServletRequest.isAsyncSupported()) {
            iRequestWebScope.attrs().putIn("$ph-request-is-async", true);
            this._handleAsync(httpServletRequest, httpServletResponse, eHttpVersion, eHttpMethod, iRequestWebScope);
        } else {
            this.m_aNestedHandler.onRequest(httpServletRequest, httpServletResponse, eHttpVersion, eHttpMethod, iRequestWebScope);
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("AsyncSpec", this.m_aAsyncSpec).append("OriginalHandler", this.m_aNestedHandler).getToString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$_handleAsync$0(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, IAttributeContainerAny iAttributeContainerAny, IAttributeContainerAny iAttributeContainerAny2, ExtAsyncContext extAsyncContext) {
        try (WebScoped webScoped = new WebScoped(httpServletRequest, httpServletResponse);){
            webScoped.getRequestScope().attrs().putAllIn(iAttributeContainerAny);
            webScoped.getRequestScope().params().putAllIn(iAttributeContainerAny2);
            this.m_aNestedHandler.onRequest(extAsyncContext.getRequest(), extAsyncContext.getResponse(), extAsyncContext.getHTTPVersion(), extAsyncContext.getHTTPMethod(), webScoped.getRequestScope());
        }
        catch (Exception exception) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Error processing async request " + extAsyncContext.getRequest(), exception);
            }
            try {
                String string = "Internal error processing your request. Please try again later. Technical details: " + exception.getClass().getName() + ":" + exception.getMessage();
                extAsyncContext.getResponse().getWriter().write(string);
            }
            catch (Exception exception2) {
                LOGGER.error("Error writing first exception to response", exception2);
            }
        }
        finally {
            try {
                extAsyncContext.complete();
            }
            catch (Exception exception) {
                LOGGER.error("Error completing async context", exception);
            }
        }
    }
}

