/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.state.EContinue;
import com.helger.commons.url.ISimpleURL;
import com.helger.http.EHttpVersion;
import com.helger.servlet.response.EXFrameOptionType;
import com.helger.xservlet.filter.IXServletLowLevelFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class XServletFilterSecurityXFrameOptions
implements IXServletLowLevelFilter {
    private final EXFrameOptionType m_eType;
    private final ISimpleURL m_aDomain;
    private final String m_sHeaderValue;

    public XServletFilterSecurityXFrameOptions(@Nonnull EXFrameOptionType eXFrameOptionType, @Nullable ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull(eXFrameOptionType, "Type");
        if (eXFrameOptionType.isURLRequired()) {
            ValueEnforcer.notNull(iSimpleURL, "Domain");
        }
        this.m_eType = eXFrameOptionType;
        this.m_aDomain = iSimpleURL;
        this.m_sHeaderValue = eXFrameOptionType.isURLRequired() ? eXFrameOptionType.getID() + " " + iSimpleURL.getAsStringWithEncodedParameters() : eXFrameOptionType.getID();
    }

    @Nonnull
    public final EXFrameOptionType getXFrameOptionsType() {
        return this.m_eType;
    }

    @Nullable
    public final ISimpleURL getDomain() {
        return this.m_aDomain;
    }

    @Nonnull
    @Nonempty
    public final String getHeaderValue() {
        return this.m_sHeaderValue;
    }

    @Override
    @Nonnull
    public EContinue beforeRequest(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod) {
        httpServletResponse.addHeader("X-Frame-Options", this.m_sHeaderValue);
        return EContinue.CONTINUE;
    }
}

