/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.commons.CGlobal;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.callback.exception.LoggingExceptionCallback;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.xml.sax.AbstractSAXErrorHandler;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLLoggingExceptionCallback
extends LoggingExceptionCallback {
    public XMLLoggingExceptionCallback() {
    }

    public XMLLoggingExceptionCallback(@Nonnull IErrorLevel iErrorLevel) {
        this.setErrorLevel(iErrorLevel);
    }

    @Override
    @Nonnull
    @Nonempty
    @OverrideOnDemand
    protected String getLogMessage(@Nullable Throwable throwable) {
        if (throwable instanceof SAXParseException) {
            SAXParseException sAXParseException = (SAXParseException)throwable;
            return AbstractSAXErrorHandler.getSaxParseError(EErrorLevel.ERROR, sAXParseException).getAsString(CGlobal.DEFAULT_LOCALE);
        }
        if (throwable instanceof SAXException) {
            return "Error parsing XML document";
        }
        if (throwable instanceof UnknownHostException) {
            return "Failed to resolve entity host: " + throwable.getMessage();
        }
        if (throwable instanceof IOException) {
            return "Error reading XML document: " + throwable.getMessage();
        }
        return super.getLogMessage(throwable);
    }

    @Override
    protected boolean isLogException(@Nullable Throwable throwable) {
        if (throwable instanceof UnknownHostException) {
            return false;
        }
        return super.isLogException(throwable);
    }
}

