/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.sax;

import com.helger.commons.CGlobal;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.log.LogHelper;
import com.helger.xml.sax.AbstractSAXErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

@Immutable
public class LoggingSAXErrorHandler
extends AbstractSAXErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingSAXErrorHandler.class);

    @Nonnull
    @Nonempty
    @OverrideOnDemand
    protected String getErrorMessage(@Nonnull IErrorLevel iErrorLevel, SAXParseException sAXParseException) {
        return LoggingSAXErrorHandler.getSaxParseError(iErrorLevel, sAXParseException).getAsString(CGlobal.DEFAULT_LOCALE);
    }

    @Override
    protected void internalLog(@Nonnull IErrorLevel iErrorLevel, SAXParseException sAXParseException) {
        LogHelper.log(LOGGER, iErrorLevel, this.getErrorMessage(iErrorLevel, sAXParseException));
    }
}

