/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.convert;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsWeakHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.ClassHierarchyCache;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.IMicroTypeConverterCallback;
import com.helger.xml.microdom.convert.IMicroTypeConverterRegistrarSPI;
import com.helger.xml.microdom.convert.IMicroTypeConverterRegistry;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MicroTypeConverterRegistry
implements IMicroTypeConverterRegistry {
    public static final boolean DEFAULT_USE_CLASS_HIERARCHY = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroTypeConverterRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final ICommonsMap<Class<?>, IMicroTypeConverter<?>> m_aMap = new CommonsWeakHashMap();
    private boolean m_bUseClassHierarchy = false;

    private MicroTypeConverterRegistry() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static MicroTypeConverterRegistry getInstance() {
        MicroTypeConverterRegistry microTypeConverterRegistry = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return microTypeConverterRegistry;
    }

    public boolean isUseClassHierarchy() {
        return this.m_bUseClassHierarchy;
    }

    public void setUseClassHierarchy(boolean bl) {
        if (this.m_bUseClassHierarchy != bl) {
            this.m_bUseClassHierarchy = bl;
            this.reinitialize();
        }
    }

    @Override
    public <T> void registerMicroElementTypeConverter(@Nonnull Class<T> clazz, @Nonnull IMicroTypeConverter<T> iMicroTypeConverter) {
        this._registerMicroElementTypeConverter(clazz, iMicroTypeConverter);
    }

    private <T> void _registerMicroElementTypeConverter(@Nonnull Class<T> clazz, @Nonnull IMicroTypeConverter<T> iMicroTypeConverter) {
        ValueEnforcer.notNull(clazz, "Class");
        ValueEnforcer.notNull(iMicroTypeConverter, "Converter");
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aMap.containsKey(clazz)) {
                throw new IllegalArgumentException("A micro type converter for class " + clazz + " is already registered!");
            }
            if (this.m_bUseClassHierarchy) {
                for (WeakReference weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz)) {
                    Class clazz2 = (Class)weakReference.get();
                    if (clazz2 == null || this.m_aMap.containsKey(clazz2)) continue;
                    this.m_aMap.put(clazz2, iMicroTypeConverter);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Registered micro type converter for '" + clazz2.toString() + "'");
                }
            } else {
                this.m_aMap.put(clazz, iMicroTypeConverter);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Registered micro type converter for '" + clazz.toString() + "'");
                }
            }
        });
    }

    @Nullable
    public <T> IMicroTypeConverter<T> getConverterToMicroElement(@Nullable Class<T> clazz) {
        return (IMicroTypeConverter)GenericReflection.uncheckedCast(this.m_aRWLock.readLockedGet(() -> (IMicroTypeConverter)this.m_aMap.get(clazz)));
    }

    @Nullable
    public <T> IMicroTypeConverter<T> getConverterToNative(@Nonnull Class<T> clazz) {
        ValueEnforcer.notNull(clazz, "DestClass");
        IMicroTypeConverter iMicroTypeConverter = this.m_aRWLock.readLockedGet(() -> {
            IMicroTypeConverter iMicroTypeConverter;
            block3: {
                block2: {
                    iMicroTypeConverter = (IMicroTypeConverter)this.m_aMap.get(clazz);
                    if (iMicroTypeConverter == null) break block2;
                    if (!LOGGER.isTraceEnabled()) break block3;
                    LOGGER.trace("Using micro type converter " + iMicroTypeConverter + " for class " + clazz + " based on direct match");
                    break block3;
                }
                if (this.m_bUseClassHierarchy) {
                    for (WeakReference weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz)) {
                        Class clazz2 = (Class)weakReference.get();
                        if (clazz2 == null || (iMicroTypeConverter = (IMicroTypeConverter)this.m_aMap.get(clazz2)) == null) continue;
                        if (!LOGGER.isTraceEnabled()) break;
                        LOGGER.trace("Using micro type converter " + iMicroTypeConverter + " for class " + clazz + " based on " + clazz2);
                        break;
                    }
                }
            }
            return iMicroTypeConverter;
        });
        return (IMicroTypeConverter)GenericReflection.uncheckedCast(iMicroTypeConverter);
    }

    public void iterateAllRegisteredMicroTypeConverters(@Nonnull IMicroTypeConverterCallback iMicroTypeConverterCallback) {
        ICommonsMap iCommonsMap = this.m_aRWLock.readLockedGet(this.m_aMap::getClone);
        for (Map.Entry entry : iCommonsMap.entrySet()) {
            if (iMicroTypeConverterCallback.call((Class)entry.getKey(), (IMicroTypeConverter)entry.getValue()).isBreak()) break;
        }
    }

    @Nonnegative
    public int getRegisteredMicroTypeConverterCount() {
        return this.m_aRWLock.readLockedInt(this.m_aMap::size);
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aMap.clear();
            for (IMicroTypeConverterRegistrarSPI iMicroTypeConverterRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(IMicroTypeConverterRegistrarSPI.class)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Calling registerMicroTypeConverter on " + iMicroTypeConverterRegistrarSPI.getClass().getName());
                }
                iMicroTypeConverterRegistrarSPI.registerMicroTypeConverter(this);
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.getRegisteredMicroTypeConverterCount() + " micro type converters registered");
        }
    }

    private static final class SingletonHolder {
        private static final MicroTypeConverterRegistry s_aInstance = new MicroTypeConverterRegistry();

        private SingletonHolder() {
        }
    }
}

