/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.servlets.filter;

import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.http.AcceptEncodingList;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.filter.AbstractHttpServletFilter;
import com.helger.servlet.request.RequestHelper;
import com.helger.servlet.response.ResponseHelperSettings;
import com.helger.servlet.response.gzip.AbstractCompressedResponseWrapper;
import com.helger.servlet.response.gzip.CompressFilterSettings;
import com.helger.servlet.response.gzip.DeflateResponse;
import com.helger.servlet.response.gzip.GZIPResponse;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CompressFilter
extends AbstractHttpServletFilter {
    private static final String REQUEST_ATTR = "$ph-" + CompressFilter.class.getName();
    private static final IMutableStatisticsHandlerCounter s_aStatsNone = StatisticsManager.getCounterHandler(CompressFilter.class.getName() + "$none");

    @Override
    @OverridingMethodsMustInvokeSuper
    public void init() throws ServletException {
        super.init();
        CompressFilterSettings.markFilterLoaded();
        ResponseHelperSettings.setResponseCompressionEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _performCompressed(@Nonnull HttpServletRequest httpServletRequest, @Nonnull FilterChain filterChain, @Nonnull HttpServletResponse httpServletResponse, @Nonnull AbstractCompressedResponseWrapper abstractCompressedResponseWrapper) throws IOException, ServletException {
        boolean bl = true;
        try {
            filterChain.doFilter(httpServletRequest, abstractCompressedResponseWrapper);
            bl = false;
        }
        finally {
            if (bl && !httpServletResponse.isCommitted()) {
                abstractCompressedResponseWrapper.resetBuffer();
                abstractCompressedResponseWrapper.setNoCompression();
            } else {
                abstractCompressedResponseWrapper.finish();
            }
        }
    }

    @Override
    public void doHttpFilter(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull FilterChain filterChain) throws IOException, ServletException {
        if (CompressFilterSettings.isResponseCompressionEnabled() && httpServletRequest.getAttribute(REQUEST_ATTR) == null) {
            ServletHelper.setRequestAttribute(httpServletRequest, REQUEST_ATTR, Boolean.TRUE);
            httpServletResponse.setHeader("Vary", "Accept-Encoding");
            AcceptEncodingList acceptEncodingList = RequestHelper.getAcceptEncodings(httpServletRequest);
            AbstractCompressedResponseWrapper abstractCompressedResponseWrapper = null;
            String string = acceptEncodingList.getUsedGZIPEncoding();
            if (string != null && CompressFilterSettings.isResponseGzipEnabled()) {
                abstractCompressedResponseWrapper = new GZIPResponse(httpServletRequest, httpServletResponse, string);
            } else {
                String string2 = acceptEncodingList.getUsedDeflateEncoding();
                if (string2 != null && CompressFilterSettings.isResponseDeflateEnabled()) {
                    abstractCompressedResponseWrapper = new DeflateResponse(httpServletRequest, httpServletResponse, string2);
                }
            }
            if (abstractCompressedResponseWrapper != null) {
                CompressFilter._performCompressed(httpServletRequest, filterChain, httpServletResponse, abstractCompressedResponseWrapper);
                return;
            }
            s_aStatsNone.increment();
        }
        filterChain.doFilter(httpServletRequest, httpServletResponse);
    }
}

