/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.session;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.lang.ClassHelper;
import com.helger.scope.ScopeHelper;
import com.helger.web.scope.ISessionWebScope;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.web.scope.session.ISessionWebScopeActivationHandler;
import com.helger.web.scope.session.ISessionWebScopeDontPassivate;
import com.helger.web.scope.session.ISessionWebScopePassivationHandler;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionWebScopeActivator
implements Serializable,
HttpSessionActivationListener,
ISessionWebScopeDontPassivate {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionWebScopeActivator.class);
    private ISessionWebScope m_aSessionWebScope;
    private ICommonsMap<String, Object> m_aAttrs;

    @Deprecated
    @DevelopersNote(value="For reading only")
    public SessionWebScopeActivator() {
    }

    public SessionWebScopeActivator(@Nonnull ISessionWebScope iSessionWebScope) {
        this.m_aSessionWebScope = ValueEnforcer.notNull(iSessionWebScope, "SessionWebScope");
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        if (this.m_aSessionWebScope == null) {
            throw new IllegalStateException("No SessionWebScope is present!");
        }
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        for (Map.Entry entry : this.m_aSessionWebScope.attrs().entrySet()) {
            Object v = entry.getValue();
            if (v instanceof ISessionWebScopeDontPassivate) continue;
            commonsHashMap.put(entry.getKey(), v);
        }
        objectOutputStream.writeObject(commonsHashMap);
        if (ScopeHelper.isDebugSessionScopeLifeCycle(LOGGER) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Wrote info on session web scope '" + this.m_aSessionWebScope.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (this.m_aSessionWebScope != null) {
            throw new IllegalStateException("Another SessionWebScope is already present: " + this.m_aSessionWebScope.toString());
        }
        this.m_aAttrs = (ICommonsMap)objectInputStream.readObject();
        if (ScopeHelper.isDebugSessionScopeLifeCycle(LOGGER) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Read info on session scope: " + this.m_aAttrs.size() + " attrs of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    public void sessionWillPassivate(@Nonnull HttpSessionEvent httpSessionEvent) {
        if (this.m_aSessionWebScope != null) {
            for (Object v : this.m_aSessionWebScope.attrs().values()) {
                if (!(v instanceof ISessionWebScopePassivationHandler)) continue;
                ((ISessionWebScopePassivationHandler)v).onSessionWillPassivate(this.m_aSessionWebScope);
            }
            if (ScopeHelper.isDebugSessionScopeLifeCycle(LOGGER) && LOGGER.isInfoEnabled()) {
                LOGGER.info("Successfully passivated session web scope '" + this.m_aSessionWebScope.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
            }
        }
    }

    @Override
    public void sessionDidActivate(@Nonnull HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession = httpSessionEvent.getSession();
        ISessionWebScope iSessionWebScope = WebScopeManager.internalGetOrCreateSessionScope(httpSession, true, true);
        if (this.m_aAttrs != null) {
            iSessionWebScope.attrs().putAllIn(this.m_aAttrs);
            this.m_aAttrs.clear();
        }
        this.m_aSessionWebScope = iSessionWebScope;
        for (Object v : iSessionWebScope.attrs().values()) {
            if (!(v instanceof ISessionWebScopeActivationHandler)) continue;
            ((ISessionWebScopeActivationHandler)v).onSessionDidActivate(iSessionWebScope);
        }
        if (ScopeHelper.isDebugSessionScopeLifeCycle(LOGGER) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Successfully activated session web scope '" + iSessionWebScope.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }
}

