/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.multipart;

import com.helger.collection.multimap.MultiHashMapArrayListBased;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.state.EChange;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.mock.MockHttpServletRequest;
import com.helger.servlet.request.RequestHelper;
import com.helger.web.CWeb;
import com.helger.web.fileupload.IFileItem;
import com.helger.web.fileupload.IFileItemFactoryProviderSPI;
import com.helger.web.fileupload.exception.FileUploadException;
import com.helger.web.fileupload.servlet.ServletFileUpload;
import com.helger.web.progress.IProgressListener;
import com.helger.web.progress.ProgressListenerProvider;
import com.helger.web.scope.multipart.GlobalDiskFileItemFactory;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestMultipartHelper {
    public static final long MAX_REQUEST_SIZE = 0x140000000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestMultipartHelper.class);
    private static final IFileItemFactoryProviderSPI s_aFIFP;

    private RequestMultipartHelper() {
    }

    @Nonnull
    public static EChange handleMultipartFormData(@Nonnull HttpServletRequest httpServletRequest, @Nonnull BiConsumer<String, Object> biConsumer) {
        if (httpServletRequest instanceof MockHttpServletRequest) {
            return EChange.UNCHANGED;
        }
        if (!RequestHelper.isMultipartFormDataContent(httpServletRequest)) {
            return EChange.UNCHANGED;
        }
        boolean bl = false;
        try {
            Object object;
            ICommonsList iCommonsList;
            ServletFileUpload servletFileUpload = new ServletFileUpload(s_aFIFP.getFileItemFactory());
            servletFileUpload.setSizeMax(0x140000000L);
            servletFileUpload.setHeaderEncoding(CWeb.CHARSET_REQUEST_OBJ.name());
            IProgressListener iProgressListener = ProgressListenerProvider.getProgressListener();
            if (iProgressListener != null) {
                servletFileUpload.setProgressListener(iProgressListener);
            }
            ServletHelper.setRequestCharacterEncoding(httpServletRequest, CWeb.CHARSET_REQUEST_OBJ);
            MultiHashMapArrayListBased<String, String> multiHashMapArrayListBased = new MultiHashMapArrayListBased<String, String>();
            MultiHashMapArrayListBased<String, IFileItem> multiHashMapArrayListBased2 = new MultiHashMapArrayListBased<String, IFileItem>();
            ICommonsList<IFileItem> iCommonsList2 = servletFileUpload.parseRequest(httpServletRequest);
            for (IFileItem object2 : iCommonsList2) {
                if (object2.isFormField()) {
                    multiHashMapArrayListBased.putSingle(object2.getFieldName(), object2.getString(CWeb.CHARSET_REQUEST_OBJ));
                    continue;
                }
                multiHashMapArrayListBased2.putSingle(object2.getFieldName(), object2);
            }
            for (Map.Entry entry : multiHashMapArrayListBased.entrySet()) {
                iCommonsList = (ICommonsList)entry.getValue();
                object = iCommonsList.size() == 1 ? iCommonsList.getFirst() : ArrayHelper.newArray(iCommonsList, String.class);
                biConsumer.accept((String)entry.getKey(), object);
            }
            for (Map.Entry entry : multiHashMapArrayListBased2.entrySet()) {
                iCommonsList = (ICommonsList)entry.getValue();
                object = iCommonsList.size() == 1 ? iCommonsList.getFirst() : ArrayHelper.newArray(iCommonsList, IFileItem.class);
                biConsumer.accept((String)entry.getKey(), object);
            }
            bl = true;
        }
        catch (FileUploadException fileUploadException) {
            if (!StreamHelper.isKnownEOFException(fileUploadException.getCause())) {
                LOGGER.error("Error parsing multipart request content", fileUploadException);
            }
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("Error parsing multipart request content", runtimeException);
        }
        return EChange.valueOf(bl);
    }

    static {
        IFileItemFactoryProviderSPI iFileItemFactoryProviderSPI = ServiceLoaderHelper.getFirstSPIImplementation(IFileItemFactoryProviderSPI.class);
        if (iFileItemFactoryProviderSPI != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Using custom IFileItemFactoryProviderSPI " + iFileItemFactoryProviderSPI);
            }
        } else {
            iFileItemFactoryProviderSPI = GlobalDiskFileItemFactory::getInstance;
        }
        s_aFIFP = iFileItemFactoryProviderSPI;
    }
}

